const fs = require('original-fs');
const path = require('path');
const AdmZip = require('adm-zip');
const ExtractZip = require('extract-zip');
const DownloadFile = require('download-file');
const log4js = require('log4js');
const log = log4js.getLogger("updater-service");
//const md5 = require('md5');
const md5_File = require('md5-file');

var NEW_VERSION_DIR = path.resolve('../update');
var TMP_DIR = path.resolve('../download');
const SERVER_VERSION_FILE = 'version.txt';
const SERVER_UPDATE_ARCHIVE_FILE = 'Anketa-XBRL-last.zip';

const SERVER_UPDATE_ARCHIVE_FILE_MD5 = 'md5';

const Config = require('electron-config');
const config = new Config();

var IS_ENV_PROD;
var IS_ACTION_CANCELLED = false;

var updateAppProgressState = '';
var downloadUpdateProgressState = null;

var downloadFileStream;
var downloadFileStreamSuccessCallback;

// todo fvg config storage read
var savedConfig = {
  updateURL: 'http://citytech-converter.wavea.cc/',
  autoUpdate: false
};

function readDynamicConfiguration() {
  log.info('readDynamicConfiguration()');
  let dynConfig;
  if (config.has('updateConfig')) {
    dynConfig = config.get('updateConfig');
  } else {
    dynConfig = savedConfig;
  }
  log.info(dynConfig.autoUpdate + ' ' + dynConfig.updateURL);
  return {updateURL: dynConfig.updateURL, autoUpdate: dynConfig.autoUpdate};

}

function saveDynamicConfiguration(newConfig) {
  savedConfig.updateURL = newConfig.updateURL;
  savedConfig.autoUpdate = newConfig.autoUpdate;
  config.set('updateConfig', newConfig);
}

function autoUpdate() {
  log.info('AUTO UPDATE START');

  clearTmpDir();
  clearUpdateDir();

  var dynConfig = readDynamicConfiguration();

  if (!dynConfig.autoUpdate) {
    log.info("AUTOUPDATE DISABLED - SKIPPING");
    return;
  }

  if (!isUpdateUrlValid(dynConfig.updateURL)) {
    log.error('UPDATE SERVER URL NOT SPECIFIED');
    // todo err dialog 'Ошибка автоматического обновления: адрес сервера обновлений не задан'
    return;
  }

  checkNewVersionExistsOnUpdateServerAsync(dynConfig.updateURL, function (updateVersion) {
    // todo fvg dialog 'Доступна новая версия. Желаете установить её сейчас?'
    downloadNewVersion(dynConfig.updateURL, function () {
      extractNewVersion(TMP_DIR + '/' + SERVER_UPDATE_ARCHIVE_FILE);
      startUpdater();
    });
  }, function () {
  }, function (e) {
    // todo fvg dialog 'Не удалось получить номер актуальной версии с сервера обновления.'
  });
}

function isUpdateUrlValid(updateURL) {
  return updateURL && updateURL.length > 10;
}

function manualHttpUpdate() {
  IS_ACTION_CANCELLED = false;
  log.info('MANUAL HTTP UPDATE START');
  clearTmpDir();
  clearUpdateDir();
  if (IS_ACTION_CANCELLED) {
    setUpdateAppProgressState('CANCELLED');
    return;
  }
  var dynConfig = readDynamicConfiguration();
  checkNewVersionExistsOnUpdateServerAsync(dynConfig.updateURL, function (updateVersion) {
    setUpdateAppProgressState('Загрузка обновления');
    if (IS_ACTION_CANCELLED) {
      setUpdateAppProgressState('CANCELLED');
      return;
    }
    downloadNewVersion(dynConfig.updateURL, function () {
      setUpdateAppProgressState('Извлечение файлов');
      if (IS_ACTION_CANCELLED) {
        setUpdateAppProgressState('CANCELLED');
        return;
      }
      extractNewVersionAsync(TMP_DIR + '/' + SERVER_UPDATE_ARCHIVE_FILE, true, function () {
        setUpdateAppProgressState('Применение обновления');
        if (IS_ACTION_CANCELLED) {
          setUpdateAppProgressState('CANCELLED');
          return;
        }
        startUpdater();
      });
    });
  }, null, function (e) {
    // todo fvg dialog 'Не удалось получить номер актуальной версии с сервера обновления.'
  });
}

function manualLocalUpdate(updateArchivePath, confirmDialogShowCallback) {
  // log.info('MANUAL LOCAL UPDATE START');
  // clearUpdateDir();
  // extractNewVersion(updateArchivePath);
  // var currentVersion = readVersionFromFile('./resources/app' + LOCAL_VERSION_FILE_NAME);
  // var updateVersion = readVersionFromFile(TMP_DIR + '/' + SERVER_VERSION_FILE);
  //
  // if (isVersionGreater(currentVersion, updateVersion)) {
  //   confirmDialogShowCallback(start());
  // } else {
  //   startUpdater();
  // }

  // ___________________________________
  IS_ACTION_CANCELLED = false;
  setUpdateAppProgressState('Извлечение файлов');
  log.info('MANUAL LOCAL UPDATE START');
  setTimeout(function () {
    if (IS_ACTION_CANCELLED) {
      setUpdateAppProgressState('CANCELLED');
      return;
    }

    clearUpdateDir();
    extractNewVersionAsync(updateArchivePath, false,
      function () {
        if (IS_ACTION_CANCELLED) {
          setUpdateAppProgressState('CANCELLED');
          return;
        }
        log.info('EXTRACTED!'); // EMFILE: too many open files

        var currentVersion = readVersionFromFile(IS_ENV_PROD ? './resources/app/ver' : './electron/ver');
        var updateVersion = readVersionFromFile(NEW_VERSION_DIR + '/resources/app/ver');
        log.info('CURRENT VERSION ' + currentVersion);
        log.info('UPDATE VERSION -------' + updateVersion);

        var versionGreater = isVersionGreater(currentVersion, updateVersion);
        log.info(currentVersion + ' > ' + updateVersion + ' ' + versionGreater);

        if (versionGreater) {

          log.info('CURRENT VERSION IS GREATER, NEED CONFIRM');

          setUpdateAppProgressState('CURRENT_VERSION_IS_GREATER_CONFIRM');

        } else if (currentVersion === updateVersion) {
          log.info('CURRENT VERSION = UPDATE VERSION, NEED CONFIRM');

          setUpdateAppProgressState('CURRENT_EQ_UPDATE_CONFIRM');
        } else {
          startUpdater();
        }
      });
  }, 300);
}

function checkNewVersionExistsOnUpdateServerAsync(updateURL, existsCallback, notExistsCallback, errCallback) {
  try {
    if (!isUpdateUrlValid(updateURL)) {
      throw new Error('UPDATE SERVER URL NOT SPECIFIED');
    }
    if (updateURL.charAt(updateURL.length - 1) !== '/') {
      updateURL += '/';
    }
    log.info('DOWNLOAD VERSION FILE');
    downloadFile(updateURL + SERVER_VERSION_FILE, TMP_DIR, SERVER_VERSION_FILE,
      function () {
        log.info('DOWNLOAD VERSION FILE - FINISHED');

        var currentVersion = readVersionFromFile(IS_ENV_PROD ? './resources/app/ver' : './electron/ver');
        var updateVersion = readVersionFromFile(TMP_DIR + '/' + SERVER_VERSION_FILE);

        if (isVersionGreater(updateVersion, currentVersion)) {
          log.info('UPDATE AVAILABLE ' + updateVersion);
          existsCallback(updateVersion);
        } else {
          log.info("PROGRAM VERSION IS ACTUAL");
          if (notExistsCallback) {
            notExistsCallback();
          }
        }
      },
      function (e) {
        log.error('FAILED TO DOWNLOAD VERSION FILE', e);
        if (errCallback) {
          errCallback(e)
        }
      });
  } catch (e) {
    log.error('FAILED TO CHECK VERSION ON SERVER', e);
    if (errCallback) {
      errCallback(e)
    }
  }
}

function downloadNewVersion(updateURL, successCallback) {
  try {
    if (updateURL.charAt(updateURL.length - 1) !== '/') {
      updateURL += '/';
    }
    log.info('DOWNLOAD NEW VERSION ARCHIVE');
    downloadFile(updateURL + SERVER_UPDATE_ARCHIVE_FILE_MD5, TMP_DIR, SERVER_UPDATE_ARCHIVE_FILE_MD5,
      function () {
        log.info('DOWNLOAD NEW VERSION ARCHIVE MD5 - FINISHED');
        if (IS_ACTION_CANCELLED) {
          setUpdateAppProgressState('CANCELLED');
          return;
        }
        downloadFile(updateURL + SERVER_UPDATE_ARCHIVE_FILE, TMP_DIR, SERVER_UPDATE_ARCHIVE_FILE,
          function () {
            log.info('DOWNLOAD NEW VERSION ARCHIVE - FINISHED');
            successCallback();
          },
          function (e) {
            log.error('FAILED TO DOWNLOAD NEW VERSION ARCHIVE', e);
            // todo fvg dialog 'Не удалось скачать архив обновления.'
          });
      },
      function (e) {
        log.error('FAILED TO DOWNLOAD NEW VERSION ARCHIVE', e);
        // todo fvg dialog 'Не удалось скачать архив обновления.'
      });
  } catch (e) {
    log.error('FAILED TO DOWNLOAD NEW VERSION ARCHIVE:', e);
    // todo fvg dialog 'Ошибка обновления.'
  }
}

function extractNewVersion(newVersionArchivePath) {
  log.info('EXTRACT NEW VERSION ' + newVersionArchivePath + ' TO ' + NEW_VERSION_DIR);
  var noAsar = process.noAsar;
  try {

    // hack for problem with asar files which are treated as directories by node.js fs module
    process.noAsar = true;

    // ExtractZip(newVersionArchivePath, {dir: NEW_VERSION_DIR},
    //   function (e) {
    //     // todo fvg wait for async code to finish outside callback
    //     process.noAsar = noAsar;
    //     if (e) {
    //       log.error('FAILED TO EXTRACT NEW VERSION', e);
    //       //todo fvg
    //       //throw new Error('Не удалось распаковать новую версию.');
    //     } else {
    //       log.info('EXTRACT NEW VERSION - FINISHED');
    //       successCallback();
    //     }
    //   });

    var zip = new AdmZip(newVersionArchivePath);

    zip.extractAllTo(NEW_VERSION_DIR, /*overwrite*/true);
    log.info('EXTRACT NEW VERSION - FINISHED');
    replaceUpdateJar();

  }
  catch (e) {
    log.error('FAILED TO EXTRACT NEW VERSION:', e);
    // todo fvg dialog 'Не удалось распаковать архив новой версии.'
  }
  finally {
    process.noAsar = noAsar;
  }
}

function extractNewVersionAsync(newVersionArchivePath, isFromServer, callback) {
  if (isFromServer) {
    log.info('check md5');
    var md5FromServer = readVersionFromFile(TMP_DIR + '/' + SERVER_UPDATE_ARCHIVE_FILE_MD5);
    log.info('md5 from server ' + md5FromServer);
    const md5File = md5_File.sync(newVersionArchivePath);
    log.info('md5 downloaded file ' + md5File);

    if (!md5FromServer || !md5File) {
      log.info('MD5 checksum for server zip (' + md5FromServer + ') or md5 for downloaded zip (' + md5File + ') is empty.');
      setUpdateAppProgressState('MD5_CHECK_FAILED');
      return;
    }

    if (md5FromServer.toString().trim() != md5File.toString().trim()) {
      log.info('MD5 checksum for server zip (' + md5FromServer + ') does not equal md5 for downloaded zip (' + md5File + ').');
      setUpdateAppProgressState('MD5_CHECK_FAILED');
      return;
    }
  }

  log.info('EXTRACT NEW VERSION ' + newVersionArchivePath + ' TO ' + NEW_VERSION_DIR);
  var noAsar = process.noAsar;
  try {
    // hack for problem with asar files which are treated as directories by node.js fs module
    process.noAsar = true;

    var zip = new AdmZip(newVersionArchivePath);

    zip.extractAllToAsync(NEW_VERSION_DIR, true, function (err) {
      process.noAsar = noAsar;
      if (err) {
        log.error('FAILED TO EXTRACT NEW VERSION', err);
        callback(err);
      } else {
        log.info('EXTRACT NEW VERSION - FINISHED');
        if (callback) callback();
      }
    });
  }
  catch (e) {
    process.noAsar = noAsar;
    log.error('FAILED TO EXTRACT NEW VERSION:', e);
    // todo fvg dialog 'Не удалось распаковать архив новой версии.'
  }

}

var replaceScript = function (name, callback) {
  if (!name) {
    log.info('REPLACE SCRIPT - SCRIPT NAME IS EMPTY');
    if (callback) callback(null);
  }
  var newScripRelativePath = (IS_ENV_PROD ? '/scripts/' : '/script/') + name;
  if (fs.existsSync(NEW_VERSION_DIR + newScripRelativePath)) {
    var readScriptRemoveStream = fs.createReadStream(NEW_VERSION_DIR + '/' + newScripRelativePath);
    if (fs.existsSync('../' + newScripRelativePath)) {
      fs.unlinkSync('../' + newScripRelativePath);
    }
    readScriptRemoveStream.once('error', function (err) {
      log.error('REPLACE SCRIPTS - ERROR');
      log.error(err);
      if (callback) callback(err);
    });
    readScriptRemoveStream.once('end', function () {
      log.info('REPLACE SCRIPTS - FINISHED');
      if (callback) callback(null);
    });
    readScriptRemoveStream.pipe(fs.createWriteStream('../' + newScripRelativePath));
  } else {
    if (callback) callback(null);
  }
};

function replaceUpdateJar(callback) {
  log.info('REPLACE UPDATER');
  if (fs.existsSync('../updater.jar')) {
    log.info('UPDATER STILL EXISTS. REMOVING');
    fs.unlinkSync('../updater.jar');
  }
  if (!fs.existsSync(NEW_VERSION_DIR + '/resources/app/updater.jar')){
    log.error('REPLACE UPDATER - ERROR: updater.jar');
    setUpdateAppProgressState('ERROR_INCORRECT_RAR');
    return;
  }
  var readStream = fs.createReadStream(NEW_VERSION_DIR + '/resources/app/updater.jar');
  readStream.once('error', function (err) {
    log.error('REPLACE UPDATER - ERROR');
    log.error(err);
    if (callback) callback(err);
  });
  readStream.once('end', function () {
    log.info('REPLACE UPDATER - FINISHED');
    log.info('REPLACE SCRIPTS');
    // заменяем имеющиеся скрипты при наличии новых
    var startUpdaterRelatePath = 'scripts/start_updater.cmd';
    if (fs.existsSync(NEW_VERSION_DIR + '/' + startUpdaterRelatePath)) {
      var readScriptStartStream = fs.createReadStream(NEW_VERSION_DIR + '/' + startUpdaterRelatePath);
      if (fs.existsSync('../' + startUpdaterRelatePath)) {
        fs.unlinkSync('../' + startUpdaterRelatePath);
      }
      if (!fs.existsSync('../scripts')){
        fs.mkdirSync('../scripts');
      }
      readScriptStartStream.once('error', function (err) {
        log.error('REPLACE SCRIPTS - ERROR');
        log.error(err);
        if (callback) callback(err);
      });
      readScriptStartStream.once('end', function () {
        replaceScript('remove_all_cache.cmd', callback);
      });
      readScriptStartStream.pipe(fs.createWriteStream('../' + startUpdaterRelatePath));
    } else {
      replaceScript('remove_all_cache.cmd', callback);
    }
  });
  readStream.pipe(fs.createWriteStream('../updater.jar'));
}

function readVersionFromFile(filePath) {
  if (fs.existsSync(filePath)) {
    return fs.readFileSync(filePath, "UTF-8");
  }
}

function isVersionGreater(version, other) {
  if (!version || !other || version === other) {
    return false;
  }
  var v = version.split('.');
  var o = other.split('.');
  if (parseInt(v[0]) > parseInt(o[0])) {
    log.info('' + parseInt(v[0]) + ' > ' + parseInt(o[0]));
    return true;
  }
  if (parseInt(v[0]) < parseInt(o[0])) {
    log.info('' + parseInt(v[0]) + ' < ' + parseInt(o[0]));
    return false;
  }
  if (parseInt(v[1]) > parseInt(o[1])) {
    log.info('' + parseInt(v[1]) + ' > ' + parseInt(o[1]));
    return true;
  }
  if (parseInt(v[1]) < parseInt(o[1])) {
    log.info('' + parseInt(v[1]) + ' < ' + parseInt(o[1]));
    return false;
  }
  if (parseInt(v[2]) > parseInt(o[2])) {
    log.info('' + parseInt(v[2]) + ' > ' + parseInt(o[2]));
    return true;
  }
  if (parseInt(v[2]) < parseInt(o[2])) {
    log.info('' + parseInt(v[2]) + ' < ' + parseInt(o[2]));
    return false;
  }
  log.info('we should not be here');
  return false;
}

function startUpdater() {
  replaceUpdateJar(function () {
    log.info('START UPDATER');
    const {spawn} = require('child_process');
    const script = '"' + process.env.ANKETA_XBRL_HOME + '\\scripts\\start_updater.cmd"';

    if (typeof process.env.ANKETA_XBRL_HOME == 'undefined') {
      setUpdateAppProgressState('ERROR_ENVIRONMENT');
    } else if (fs.existsSync(script.replace(/"/g,""))) {
      const subprocess = spawn('start', ['""', script], {
        shell: true
      });
      subprocess.unref();
    } else {
      setUpdateAppProgressState('ERROR_RUN_SCRIPT');
    }

    //var child = require('child_process').spawn('D:/delete_me/restart');


    // var child = require('child_process').spawn('java', ['-jar', UPDATER_JAR]);

    // child.stdout.on('data', function (data) {
    //   if (data) log.info(data.toString());
    // });
    //
    // child.stderr.on("data", function (data) {
    //   if (data) log.error(data.toString());
    // });
    log.info('START UPDATER - FINISHED');
  });
}

function downloadFile(fileUrl, dir, fileName, successCallback, failCallback) {
  if (downloadFileStream) {
    failCallback("download already started");
    return;
  }

  log.info('DOWNLOAD FILE ' + fileUrl + ' TO ' + dir + '/' + fileName);

  if (fs.existsSync(dir + '/' + fileName)) {
    fs.unlinkSync(dir + '/' + fileName);
  }

  var http = require('http');
  var mkdirp = require('mkdirp');
  var dest = dir + '\\' + fileName;
  mkdirp(dir, function (err) {
    if (err) throw err;
    // var file = fs.createWriteStream(dest);
    downloadFileStream = fs.createWriteStream(dest);
    downloadFileStreamSuccessCallback = successCallback;
    var request = http.get(fileUrl, function (response) {
      // response.pipe(file);
      // file.on('finish', function () {
      //   file.close(successCallback);
      // });
      var len = parseInt(response.headers['content-length'], 10);
      var cur = 0;
      var total = len / 1048576; //1048576 - bytes in  1Megabyte
      response.on('data', function (chunk) {
        if (IS_ACTION_CANCELLED) {
          if (downloadFileStream) {
            downloadFileStream.close();
          }
          downloadFileStream = null;
          setDownloadUpdateProgressState(null);
          request.abort();
          request.end();
          setUpdateAppProgressState('CANCELLED');
          log.info('CANCEL DOWNLOAD FILE')
          return;
        }
        cur += chunk.length;
        if (getUpdateAppProgressState() === 'Загрузка обновления') {
          setDownloadUpdateProgressState({
            progress: (100.0 * cur / len).toFixed(),
            loadingText: '('+(cur / 1048576).toFixed()+' Мб из '+total.toFixed()+' Мб)'
          });
        }
      });
      response.pipe(downloadFileStream);
      downloadFileStream.on('finish', function () {
        if (downloadFileStream) {
          downloadFileStream.close(downloadFileStreamSuccessCallback);
        }
        setDownloadUpdateProgressState(null);
        clearDownloadFileStreamAndSuccessCallback();
      });
    }).on('error', function (e) {
      if (downloadFileStream) {
        downloadFileStream.close();
      }
      setDownloadUpdateProgressState(null);
      clearDownloadFileStreamAndSuccessCallback();
      if (failCallback) failCallback(e);
    });
  });
}

function clearUpdateDir() {
  log.info('CLEAN NEW VERSION DIRECTORY');
  if (fs.existsSync(NEW_VERSION_DIR)) {
    rmDir(NEW_VERSION_DIR);
  } else {
    fs.mkdirSync(NEW_VERSION_DIR);
  }
  if (fs.existsSync('../updater.jar')) {
    fs.unlinkSync('../updater.jar');
    log.info('CURRENT UPDATER DELETED');
  }
  log.info('CLEAN NEW VERSION DIRECTORY - FINISHED');
}

function clearTmpDir() {
  log.info('CLEAN TMP DIRECTORY');
  if (fs.existsSync(TMP_DIR)) {
    rmDir(TMP_DIR);
  } else {
    fs.mkdirSync(TMP_DIR);
  }
  log.info('CLEAN TMP DIRECTORY - FINISHED');
}

function getLastUpdateDate() {
  var path = IS_ENV_PROD ? './resources/app/ver' : './electron/ver';
  var stats = fs.statSync(path);
  var d = new Date(stats.mtime);
  var date = d.getDate();
  if (date && date.toString().length == 1) {
    date = '0' + date.toString();
  }
  var month = d.getMonth() + 1;
  if (month && month.toString().length == 1) {
    month = '0' + month.toString();
  }
  return date + "." + month + "." + d.getFullYear();
}

function setProdEnv(value) {
  if (value != null && value != undefined) {
    IS_ENV_PROD = value;
    log.info('IS_PROD IS SET TO ' + IS_ENV_PROD);
  }
}

function setActionCancelled(value) {
  if (value != null && value != undefined) {
    IS_ACTION_CANCELLED = value;
    if (value === false) {
      setUpdateAppProgressState('Соединение с сервером обновлений');
    }
  }
}

function rmDir(dirPath) {
  try {
    var files = fs.readdirSync(dirPath);
    if (files.length > 0)
      for (var i = 0; i < files.length; i++) {
        var filePath = dirPath + '/' + files[i];
        if (fs.statSync(filePath).isFile())
          fs.unlinkSync(filePath);
        else
          rmDir(filePath);
      }
    fs.rmdirSync(dirPath);
  }
  catch (e) {
    // todo fvg may be...
    throw e;
  }
}

function setUpdateAppProgressState(state) {
  updateAppProgressState = state;
}

function getUpdateAppProgressState() {
  return updateAppProgressState;
}

function onHttpUpdateConnectionLost() {
  if (downloadFileStream) {
    downloadFileStream.close(downloadFileStreamSuccessCallback);
    clearDownloadFileStreamAndSuccessCallback()
  }
}

function clearDownloadFileStreamAndSuccessCallback() {
  downloadFileStreamSuccessCallback = null;
  downloadFileStream = null;
}

function setDownloadUpdateProgressState(state) {
  downloadUpdateProgressState = state;
}

function getDownloadUpdateProgressState() {
  return downloadUpdateProgressState;
}

function logInfo(msg) {
  log.info('STOMP_SERVICE: ' + msg)
}

module.exports = {
  readDynamicConfiguration, saveDynamicConfiguration, getLastUpdateDate, readVersionFromFile,
  autoUpdate, manualHttpUpdate, checkNewVersionExistsOnUpdateServerAsync, manualLocalUpdate, onHttpUpdateConnectionLost,
  clearUpdateDir, extractNewVersionAsync, isVersionGreater, startUpdater, setProdEnv, getUpdateAppProgressState, setActionCancelled, setUpdateAppProgressState,
  getDownloadUpdateProgressState, logInfo
};
