/**
 * DevExtreme (viz/polar_chart.js)
 * Version: 17.1.6
 * Build date: Tue Sep 05 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
var noop = require("../core/utils/common").noop,
    registerComponent = require("../core/component_registrator"),
    extend = require("../core/utils/extend").extend,
    vizUtils = require("./core/utils"),
    AdvancedChart = require("./chart_components/advanced_chart").AdvancedChart,
    _noop = noop,
    DEFAULT_PANE_NAME = "default";
var dxPolarChart = AdvancedChart.inherit({
    _chartType: "polar",
    _createPanes: function() {
        return [{
            name: DEFAULT_PANE_NAME
        }]
    },
    _checkPaneName: function() {
        return true
    },
    _getAxisRenderingOptions: function(typeSelector) {
        var isArgumentAxis = "argumentAxis" === typeSelector,
            type = isArgumentAxis ? "circular" : "linear",
            useSpiderWeb = this.option("useSpiderWeb");
        if (useSpiderWeb) {
            type += "Spider"
        }
        return {
            axisType: "polarAxes",
            drawingType: type
        }
    },
    _prepareAxisOptions: function(typeSelector, axisOptions) {
        var isArgumentAxis = "argumentAxis" === typeSelector,
            themeManager = this._themeManager,
            axisUserOptions = this.option("argumentAxis"),
            argumentAxisOptions = themeManager.getOptions("argumentAxis", axisUserOptions) || {},
            startAngle = isFinite(argumentAxisOptions.startAngle) ? vizUtils.normalizeAngle(argumentAxisOptions.startAngle) : 0;
        return {
            type: this.option("useSpiderWeb") && isArgumentAxis ? "discrete" : axisOptions.type,
            isHorizontal: true,
            showCustomBoundaryTicks: isArgumentAxis,
            startAngle: startAngle,
            endAngle: startAngle + 360
        }
    },
    _optionChangesMap: {
        useSpiderWeb: "REINIT"
    },
    _getExtraOptions: function() {
        return {
            spiderWidget: this.option("useSpiderWeb")
        }
    },
    _prepareToRender: function() {
        this._appendAxesGroups();
        return {}
    },
    _renderAxes: function(drawOptions) {
        this._drawAxes(drawOptions)
    },
    _getValueAxis: function() {
        return this._valueAxes[0]
    },
    _prepareAxesAndDraw: function(drawOptions, panesBorderOptions) {
        var that = this,
            valueAxis = that._getValueAxis(),
            argumentAxis = that._getArgumentAxis();
        var canvas = that._calcCanvas(argumentAxis.measureLabels(true));
        argumentAxis.draw(canvas);
        valueAxis.setSpiderTicks(argumentAxis.getSpiderTicks());
        valueAxis.draw(canvas)
    },
    _shrinkAxes: function(drawOptions, sizeShortage) {
        var valueAxis = this._getValueAxis(),
            argumentAxis = this._getArgumentAxis();
        if (sizeShortage.width || sizeShortage.height) {
            argumentAxis.hideOuterElements();
            argumentAxis.updateSize(this._canvas);
            valueAxis.updateSize(this._canvas)
        }
    },
    _calcCanvas: function(measure) {
        var canvas = extend({}, this._canvas);
        canvas.left += measure.width;
        canvas.right += measure.width;
        canvas.top += measure.height;
        canvas.bottom += measure.height;
        return canvas
    },
    _getLayoutTargets: function() {
        return [{
            canvas: this._canvas
        }]
    },
    _getSeriesForPane: function() {
        return this.series
    },
    _applyExtraSettings: _noop,
    _updateLegendPosition: _noop,
    _createScrollBar: _noop,
    _applyClipRects: _noop,
    _isRotated: _noop,
    _getCrosshairOptions: _noop,
    _isLegendInside: _noop,
    _processSingleSeries: _noop
});
registerComponent("dxPolarChart", dxPolarChart);
module.exports = dxPolarChart;
module.exports.default = module.exports;
