/**
 * DevExtreme (ui/grid_core/ui.grid_core.sorting_mixin.js)
 * Version: 17.1.6
 * Build date: Tue Sep 05 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
var commonUtils = require("../../core/utils/common");
var SORT_CLASS = "dx-sort",
    SORT_NONE_CLASS = "dx-sort-none",
    SORTUP_CLASS = "dx-sort-up",
    SORTDOWN_CLASS = "dx-sort-down",
    HEADERS_ACTION_CLASS = "action";
module.exports = {
    _applyColumnState: function(options) {
        var side, ariaSortState, $sortIndicator, that = this,
            sortingMode = that.option("sorting.mode"),
            rootElement = options.rootElement,
            column = options.column,
            $indicatorsContainer = that._getIndicatorContainer(rootElement);
        if ("sort" === options.name) {
            side = that.option("rtlEnabled") ? "right" : "left";
            rootElement.find("." + SORT_CLASS).remove();
            !$indicatorsContainer.children().length && $indicatorsContainer.remove();
            if (("single" === sortingMode || "multiple" === sortingMode) && column.allowSorting || commonUtils.isDefined(column.sortOrder)) {
                ariaSortState = "asc" === column.sortOrder ? "ascending" : "descending";
                $sortIndicator = that.callBase(options).toggleClass(SORTUP_CLASS, "asc" === column.sortOrder).toggleClass(SORTDOWN_CLASS, "desc" === column.sortOrder);
                options.rootElement.addClass(that.addWidgetPrefix(HEADERS_ACTION_CLASS))
            }
            if (!commonUtils.isDefined(column.sortOrder)) {
                that.setAria("sort", "none", rootElement)
            } else {
                that.setAria("sort", ariaSortState, rootElement)
            }
            return $sortIndicator
        } else {
            return that.callBase(options)
        }
    },
    _getIndicatorClassName: function(name) {
        if ("sort" === name) {
            return SORT_CLASS
        }
        return this.callBase(name)
    },
    _renderIndicator: function(options) {
        var rtlEnabled, column = options.column,
            $container = options.container,
            $indicator = options.indicator;
        if ("sort" === options.name) {
            rtlEnabled = this.option("rtlEnabled");
            if (!commonUtils.isDefined(column.sortOrder)) {
                $indicator && $indicator.addClass(SORT_NONE_CLASS)
            }
            if ($container.children().length && (!rtlEnabled && "left" === options.columnAlignment || rtlEnabled && "right" === options.columnAlignment)) {
                $container.prepend($indicator);
                return
            }
        }
        this.callBase(options)
    },
    _updateIndicator: function($cell, column, indicatorName) {
        if ("sort" === indicatorName && commonUtils.isDefined(column.groupIndex)) {
            return
        }
        return this.callBase.apply(this, arguments)
    },
    _getIndicatorElements: function($cell, returnAll) {
        var $indicatorElements = this.callBase($cell);
        return returnAll ? $indicatorElements : $indicatorElements && $indicatorElements.not("." + SORT_NONE_CLASS)
    }
};
