/**
 * DevExtreme (core/utils/console.js)
 * Version: 17.1.6
 * Build date: Tue Sep 05 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
var isFunction = require("./common").isFunction;
var logger = function() {
    var console = window.console;

    function info(text) {
        if (!console || !isFunction(console.info)) {
            return
        }
        console.info(text)
    }

    function warn(text) {
        if (!console || !isFunction(console.warn)) {
            return
        }
        console.warn(text)
    }

    function error(text) {
        if (!console || !isFunction(console.error)) {
            return
        }
        console.error(text)
    }
    return {
        info: info,
        warn: warn,
        error: error
    }
}();
var debug = function() {
    function assert(condition, message) {
        if (!condition) {
            throw new Error(message)
        }
    }

    function assertParam(parameter, message) {
        assert(null !== parameter && void 0 !== parameter, message)
    }
    return {
        assert: assert,
        assertParam: assertParam
    }
}();
exports.logger = logger;
exports.debug = debug;
