/**
 * DevExtreme (core/polyfills/weak_map.js)
 * Version: 17.1.6
 * Build date: Tue Sep 05 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
var inArray = require("../../core/utils/array").inArray,
    WeakMap = window.WeakMap;
if (!WeakMap) {
    WeakMap = function() {
        var keys = [],
            values = [];
        this.set = function(key, value) {
            var index = inArray(key, keys);
            if (index === -1) {
                keys.push(key);
                values.push(value)
            } else {
                values[index] = value
            }
        };
        this.get = function(key) {
            var index = inArray(key, keys);
            if (index === -1) {
                return
            }
            return values[index]
        };
        this.has = function(key) {
            var index = inArray(key, keys);
            if (index === -1) {
                return false
            }
            return true
        }
    }
}
module.exports = WeakMap;
