/*!
 * devextreme-angular
 * Version: 17.1.6
 * Build date: Wed Sep 06 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
import { ElementRef, NgZone, OnDestroy, AfterContentInit, OnChanges, DoCheck, SimpleChanges, QueryList } from '@angular/core';
import DxRadioGroup from 'devextreme/ui/radio_group';
import { DxValidatorComponent } from './validator';
import { ControlValueAccessor } from '@angular/forms';
import { DxComponent } from '../core/component';
import { DxTemplateHost } from '../core/template-host';
import { NestedOptionHost } from '../core/nested-option';
import { WatcherHelper } from '../core/watcher-helper';
import { IterableDifferHelper } from '../core/iterable-differ-helper';
import { DxiItemComponent } from './nested/item-dxi';
export declare class DxRadioGroupComponent extends DxComponent implements OnDestroy, AfterContentInit, ControlValueAccessor, OnChanges, DoCheck {
    private _watcherHelper;
    private _idh;
    instance: DxRadioGroup;
    validator: DxValidatorComponent;
    accessKey: any;
    activeStateEnabled: any;
    dataSource: any;
    disabled: any;
    displayExpr: any;
    elementAttr: any;
    focusStateEnabled: any;
    height: any;
    hint: any;
    hoverStateEnabled: any;
    isValid: any;
    items: any;
    itemTemplate: any;
    layout: any;
    name: any;
    readOnly: any;
    rtlEnabled: any;
    tabIndex: any;
    validationError: any;
    validationMessageMode: any;
    value: any;
    valueExpr: any;
    visible: any;
    width: any;
    onDisposing: any;
    onInitialized: any;
    onOptionChanged: any;
    onValueChanged: any;
    accessKeyChange: any;
    activeStateEnabledChange: any;
    dataSourceChange: any;
    disabledChange: any;
    displayExprChange: any;
    elementAttrChange: any;
    focusStateEnabledChange: any;
    heightChange: any;
    hintChange: any;
    hoverStateEnabledChange: any;
    isValidChange: any;
    itemsChange: any;
    itemTemplateChange: any;
    layoutChange: any;
    nameChange: any;
    readOnlyChange: any;
    rtlEnabledChange: any;
    tabIndexChange: any;
    validationErrorChange: any;
    validationMessageModeChange: any;
    valueChange: any;
    valueExprChange: any;
    visibleChange: any;
    widthChange: any;
    change(_: any): void;
    touched: () => void;
    itemsChildren: QueryList<DxiItemComponent>;
    constructor(elementRef: ElementRef, ngZone: NgZone, templateHost: DxTemplateHost, _watcherHelper: WatcherHelper, _idh: IterableDifferHelper, optionHost: NestedOptionHost);
    protected _createInstance(element: any, options: any): DxRadioGroup;
    writeValue(value: any): void;
    setDisabledState(isDisabled: boolean): void;
    registerOnChange(fn: (_: any) => void): void;
    registerOnTouched(fn: () => void): void;
    ngOnDestroy(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngDoCheck(): void;
    _setOption(name: string, value: any): void;
    ngAfterContentInit(): void;
}
export declare class DxRadioGroupModule {
}
