/*!
 * devextreme-angular
 * Version: 17.1.6
 * Build date: Wed Sep 06 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
import { ElementRef, NgZone, OnDestroy, AfterContentInit, OnChanges, DoCheck, SimpleChanges, QueryList } from '@angular/core';
import DxAutocomplete from 'devextreme/ui/autocomplete';
import { DxValidatorComponent } from './validator';
import { ControlValueAccessor } from '@angular/forms';
import { DxComponent } from '../core/component';
import { DxTemplateHost } from '../core/template-host';
import { NestedOptionHost } from '../core/nested-option';
import { WatcherHelper } from '../core/watcher-helper';
import { IterableDifferHelper } from '../core/iterable-differ-helper';
import { DxiItemComponent } from './nested/item-dxi';
export declare class DxAutocompleteComponent extends DxComponent implements OnDestroy, AfterContentInit, ControlValueAccessor, OnChanges, DoCheck {
    private _watcherHelper;
    private _idh;
    instance: DxAutocomplete;
    validator: DxValidatorComponent;
    accessKey: any;
    activeStateEnabled: any;
    attr: any;
    dataSource: any;
    deferRendering: any;
    disabled: any;
    displayExpr: any;
    displayValue: any;
    dropDownButtonTemplate: any;
    elementAttr: any;
    focusStateEnabled: any;
    grouped: any;
    groupTemplate: any;
    height: any;
    hint: any;
    hoverStateEnabled: any;
    inputAttr: any;
    isValid: any;
    items: any;
    itemTemplate: any;
    maxItemCount: any;
    maxLength: any;
    minSearchLength: any;
    name: any;
    opened: any;
    placeholder: any;
    readOnly: any;
    rtlEnabled: any;
    searchExpr: any;
    searchMode: any;
    searchTimeout: any;
    selectedItem: any;
    showClearButton: any;
    spellcheck: any;
    tabIndex: any;
    text: any;
    validationError: any;
    validationMessageMode: any;
    value: any;
    valueChangeEvent: any;
    valueExpr: any;
    visible: any;
    width: any;
    onChange: any;
    onClosed: any;
    onContentReady: any;
    onCopy: any;
    onCut: any;
    onDisposing: any;
    onEnterKey: any;
    onFocusIn: any;
    onFocusOut: any;
    onInitialized: any;
    onInput: any;
    onItemClick: any;
    onKeyDown: any;
    onKeyPress: any;
    onKeyUp: any;
    onOpened: any;
    onOptionChanged: any;
    onPaste: any;
    onSelectionChanged: any;
    onValueChanged: any;
    accessKeyChange: any;
    activeStateEnabledChange: any;
    attrChange: any;
    dataSourceChange: any;
    deferRenderingChange: any;
    disabledChange: any;
    displayExprChange: any;
    displayValueChange: any;
    dropDownButtonTemplateChange: any;
    elementAttrChange: any;
    focusStateEnabledChange: any;
    groupedChange: any;
    groupTemplateChange: any;
    heightChange: any;
    hintChange: any;
    hoverStateEnabledChange: any;
    inputAttrChange: any;
    isValidChange: any;
    itemsChange: any;
    itemTemplateChange: any;
    maxItemCountChange: any;
    maxLengthChange: any;
    minSearchLengthChange: any;
    nameChange: any;
    openedChange: any;
    placeholderChange: any;
    readOnlyChange: any;
    rtlEnabledChange: any;
    searchExprChange: any;
    searchModeChange: any;
    searchTimeoutChange: any;
    selectedItemChange: any;
    showClearButtonChange: any;
    spellcheckChange: any;
    tabIndexChange: any;
    textChange: any;
    validationErrorChange: any;
    validationMessageModeChange: any;
    valueChange: any;
    valueChangeEventChange: any;
    valueExprChange: any;
    visibleChange: any;
    widthChange: any;
    change(_: any): void;
    touched: () => void;
    itemsChildren: QueryList<DxiItemComponent>;
    constructor(elementRef: ElementRef, ngZone: NgZone, templateHost: DxTemplateHost, _watcherHelper: WatcherHelper, _idh: IterableDifferHelper, optionHost: NestedOptionHost);
    protected _createInstance(element: any, options: any): DxAutocomplete;
    writeValue(value: any): void;
    setDisabledState(isDisabled: boolean): void;
    registerOnChange(fn: (_: any) => void): void;
    registerOnTouched(fn: () => void): void;
    ngOnDestroy(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngDoCheck(): void;
    _setOption(name: string, value: any): void;
    ngAfterContentInit(): void;
}
export declare class DxAutocompleteModule {
}
