import { ElementRef, Renderer2, OnInit, EventEmitter, OnChanges, SimpleChanges } from '@angular/core';
export interface IPosition {
    x: number;
    y: number;
}
export declare class AngularDraggableDirective implements OnInit, OnChanges {
    private el;
    private renderer;
    private allowDrag;
    private moving;
    private orignal;
    private oldTrans;
    private tempTrans;
    private oldZIndex;
    private oldPosition;
    private _zIndex;
    private needTransform;
    started: EventEmitter<any>;
    stopped: EventEmitter<any>;
    edge: EventEmitter<any>;
    /** Make the handle HTMLElement draggable */
    handle: HTMLElement;
    /** Set the bounds HTMLElement */
    bounds: HTMLElement;
    /** List of allowed out of bounds edges **/
    outOfBounds: {
        top: boolean;
        right: boolean;
        bottom: boolean;
        left: boolean;
    };
    /** Round the position to nearest grid */
    gridSize: number;
    /** Set z-index when dragging */
    zIndexMoving: string;
    /** Set z-index when not dragging */
    zIndex: string;
    /** Whether to limit the element stay in the bounds */
    inBounds: boolean;
    /** Whether the element should use it's previous drag position on a new drag event. */
    trackPosition: boolean;
    /** Input css scale transform of element so translations are correct */
    scale: number;
    /** Whether to prevent default event */
    preventDefaultEvent: boolean;
    /** Set initial position by offsets */
    position: IPosition;
    /** Emit position offsets when moving */
    movingOffset: EventEmitter<IPosition>;
    /** Emit position offsets when put back */
    endOffset: EventEmitter<IPosition>;
    ngDraggable: any;
    constructor(el: ElementRef, renderer: Renderer2);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    resetPosition(): void;
    private moveTo(p);
    private transform();
    private pickUp();
    boundsCheck(): {
        'top': boolean;
        'right': boolean;
        'bottom': boolean;
        'left': boolean;
    };
    private putBack();
    checkHandleTarget(target: EventTarget, element: Element): boolean;
    onMouseDown(event: MouseEvent | TouchEvent): void;
    onMouseLeave(): void;
    onMouseMove(event: MouseEvent | TouchEvent): void;
}
