require('./init-logger');
const {app, BrowserWindow, dialog} = require('electron');

let mainWindow = null;
const isSecondInstance = app.makeSingleInstance(function () {
  if (mainWindow) {
    if (mainWindow.isMinimized()) mainWindow.restore();
    mainWindow.focus();
  }
});

if (isSecondInstance) {
  app.on('ready', function () {
    dialog.showMessageBox({
      type: 'error',
      title: 'Ошибка!',
      message: 'Приложение "Анкета-редактор XBRL" уже запущено'
    });
  });
  app.quit();
  return;
}

const path = require('path');
const url = require('url');
const request = require('request');
const log4js = require('log4js');
const log = log4js.getLogger("application-main");

const config = require('./app-config');
const backendStartup = require('./backend-startup');

const updaterService = require('./updater-service');
const gaService = require('./ga-service');
global.updaterService = updaterService;
global.gaService = gaService;
global.isStartAppBlocked = backendStartup.isStartAppBlocked;

let win = null;

app.on('window-all-closed', function (event) {
  if (process.platform != 'darwin') {
    event.preventDefault();
    log.info('Port: ' + global.appConfig.backend.port);

    request.post(
      'http://localhost:' + global.appConfig.backend.port + '/shutdown',
      function (error, response, body) {
        log.info('Error: ' + error);
        log.info('Status: ' + response.statusCode);
        if (error || (response && response.statusCode != 200)) {
          if (!backendStartup.isStartAppBlocked) {
            backendStartup.childProcess.kill('SIGINT');
          }
        }
        setTimeout(function () {
          log.info('Exiting!');
          app.quit();
        }, 3000);
      }
    );
  }
});

app.on('ready', function () {

    // Initialize the window to our specified dimensions
    win = new BrowserWindow({ minWidth: 1280, minHeight: 700, backgroundColor: '#e7eff5',show: false });
    win.maximize();
    win.setMenu(null);

    win.once('ready-to-show', () => {
        win.show();
    });

    //Specify entry point
    win.loadURL(url.format({
        pathname: path.join(__dirname, 'index.html'),
        protocol: 'file:',
        slashes: true
    }));

    // Remove window once app is closed
    win.on('closed', function () {
      console.log('window close event');
      win = null;
    });

});
