const log4js = require('log4js');
const path = require('path');

const LOG_FILE_NAME = path.join(process.env.appdata, 'AnketaXBRL', 'electronapp', 'logs', 'application.log');
global.LOG_FILE_NAME = LOG_FILE_NAME;
const MAX_LOG_SIZE = 1024 * 1024 * 10;
const BACKUPS = 10;

log4js.configure({
  appenders: {
    out: { type: 'stdout' },
    app: { type: 'file', filename: LOG_FILE_NAME , maxLogSize: MAX_LOG_SIZE, backups: BACKUPS}
  },
  categories: {
    default: { appenders: [ 'out', 'app' ], level: 'debug' }
  }
});

