/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.IncompatibleSchemaRefException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlFootnote;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlUnit;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.xbrl.import_export.XbrlParser;
import ru.cbr.xbrl.converter.xbrl.import_export.scenario.XbrlContextScenarioParser;
import ru.cbr.xbrl.converter.xbrl.import_export.xml.enums.XbrlXmlTags;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class XbrlXmlParser
implements XbrlParser {
    private static final Logger log = LoggerFactory.getLogger(XbrlXmlParser.class);
    public static final String XBRL_INSTANCE_URI = "http://www.xbrl.org/2003/instance";
    public static final String DEFAULT_XBRL_INSTANCE_PREFIX = "xbrli";
    public static final String IXBRL_INSTANCE_URI = "http://www.w3.org/1999/xhtml";
    public static final String ISO4217_URI = "http://www.xbrl.org/2003/iso4217";
    public static final String DEFAULT_ISO4217_PREFIX = "iso4217";
    public static final String MEM_INT_URI = "http://www.cbr.ru/xbrl/udr/dom/mem-int";
    public static final String DEFAULT_MEM_INT_PREFIX = "mem-int";
    public static final String DIM_INT_URI = "http://www.cbr.ru/xbrl/udr/dim/dim-int";
    public static final String DEFAULT_DIM_INT_PREFIX = "dim-int";
    public static final String QNAME_DIVIDER = ":";
    private final String xbrlFilePath;
    private Consumer<String> eventMessageConsumer;
    private String expectedEntryPoint;
    private ConfigProperties.Xbrl configPropertiesXbrl;
    private QName currentElement;
    private LinkedList<QName> parentElements = new LinkedList();
    private XbrlContext currentXbrlContext;
    private XbrlUnit currentXbrlUnit;
    private XbrlValue currentXbrlValue;
    private XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private StringWriter scenarioStringWriter = new StringWriter();
    private XMLEventWriter scenarioXmlEventWriter = null;
    private boolean isProcessingScenario = false;
    private StringWriter segmentStringWriter = new StringWriter();
    private XMLEventWriter segmentXmlEventWriter = null;
    private boolean isProcessingSegment = false;
    private Map<String, List<XbrlFootnote>> footnoteMap = new HashMap();
    private Map<String, String> footnoteIdMap = new HashMap();
    private Map<String, String> footnoteValueMap = new HashMap();
    private Map<String, Map<String, String>> footnoteArcMap = new HashMap();
    private boolean isProcessingFootnotes = false;
    private boolean processingFootnoteLabel = false;
    private String cuurentFootnoteValueLabel;
    private String cuurentFootnoteValueLang;
    private boolean skipCurrentUnit = false;
    private boolean checkOnlyEntryPoint = false;
    private boolean isCheckedEntryPoint = false;
    private DateTimeFormatter periodDateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private String entryPoint;
    private NamespaceContext namespaceContext;
    private int indent = 0;
    private int counter = 0;
    private int scenarioEventCounter = 0;
    private int segmentEventCounter = 0;
    private Set<Namespace> namespaces = new HashSet();
    private Map<String, String> defaultNamespacePrefixes = new HashMap();
    private String currentValueContextId;
    private String currentValueUnitId;

    public XbrlXmlParser(ConfigProperties.Xbrl configPropetiesXbrl, String xbrlFilePath) throws IncompatibleSchemaRefException {
        this.configPropertiesXbrl = configPropetiesXbrl;
        this.xbrlFilePath = xbrlFilePath;
        try {
            this.parseXml((InputStream)new FileInputStream(xbrlFilePath));
        }
        catch (FileNotFoundException e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public XbrlXmlParser(ConfigProperties.Xbrl configPropetiesXbrl, InputStream inputStream, String expectedEntryPoint) throws IncompatibleSchemaRefException {
        this.configPropertiesXbrl = configPropetiesXbrl;
        this.expectedEntryPoint = expectedEntryPoint;
        this.xbrlFilePath = null;
        this.parseXml(inputStream);
    }

    public XbrlXmlParser(ConfigProperties.Xbrl configPropetiesXbrl, InputStream inputStream, String expectedEntryPoint, boolean checkOnlyEntryPoint) throws IncompatibleSchemaRefException {
        this.configPropertiesXbrl = configPropetiesXbrl;
        this.expectedEntryPoint = expectedEntryPoint;
        this.checkOnlyEntryPoint = checkOnlyEntryPoint;
        this.xbrlFilePath = null;
        this.parseXml(inputStream);
    }

    public XbrlXmlParser(ConfigProperties.Xbrl configPropetiesXbrl, InputStream inputStream, Map<String, String> defaultNamespacePrefixes, String expectedEntryPoint, Consumer<String> eventMessageConsumer) throws IncompatibleSchemaRefException {
        this.configPropertiesXbrl = configPropetiesXbrl;
        this.expectedEntryPoint = expectedEntryPoint;
        this.defaultNamespacePrefixes = defaultNamespacePrefixes;
        this.xbrlFilePath = null;
        this.eventMessageConsumer = eventMessageConsumer;
        this.parseXml(inputStream);
    }

    private void parseXml(InputStream inputStream) throws IncompatibleSchemaRefException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try {
            XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(new InputStreamReader((InputStream)new BOMInputStream(inputStream), "UTF-8"));
            while (xmlEventReader.hasNext() && !this.isCheckedEntryPoint) {
                XMLEvent xmlEvent = xmlEventReader.peek();
                this.processEvent(xmlEvent);
                ++this.counter;
                xmlEventReader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (FileNotFoundException e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (XbrlImportException e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void processEvent(XMLEvent xmlEvent) throws IOException, XMLStreamException, XbrlImportException, IncompatibleSchemaRefException {
        try {
            if (xmlEvent.toString().contains("purcb-dictionary")) {
                boolean bl = false;
            }
            if (!xmlEvent.isStartDocument()) {
                if (xmlEvent.isStartElement()) {
                    QName elementQName;
                    ++this.indent;
                    this.namespaceContext = xmlEvent.asStartElement().getNamespaceContext();
                    StartElement startElement = xmlEvent.asStartElement();
                    Iterator<Namespace> it = startElement.getNamespaces();
                    while (it.hasNext()) {
                        Namespace ns = it.next();
                        this.namespaces.add(ns);
                    }
                    this.currentElement = elementQName = startElement.getName();
                    this.logTreeItem(this.indent, "startElement " + elementQName.getLocalPart());
                    this.parseSchemRefStartEvents(xmlEvent, startElement);
                    if (!this.isCheckedEntryPoint) {
                        this.parseContextStartEvents(xmlEvent, startElement);
                        this.parseUnitStartEvents(xmlEvent, startElement);
                        this.parseValueStartEvents(xmlEvent, startElement);
                        this.parseFootnoteStartEvents(xmlEvent, startElement);
                        this.parentElements.push(elementQName);
                    }
                } else if (xmlEvent.isCharacters()) {
                    Characters characters = xmlEvent.asCharacters();
                    if (StringUtils.isNotBlank((CharSequence)characters.getData())) {
                        this.logTreeItem(this.indent + 1, "characters " + characters.getData() + "///  of " + this.currentElement.getLocalPart());
                    }
                    this.parseContextCharacters(xmlEvent, characters);
                    this.parseUnitCharacters(xmlEvent, characters);
                    this.parseValueCharacters(xmlEvent, characters);
                    this.parseFootnoteCharacters(xmlEvent, characters);
                    if (this.processingFootnoteLabel) {
                        this.parseFootnoteCharacters(xmlEvent, characters);
                    }
                } else if (xmlEvent.isEndElement()) {
                    this.parentElements.poll();
                    --this.indent;
                    EndElement endElement = xmlEvent.asEndElement();
                    QName elementQName = endElement.getName();
                    this.currentElement = null;
                    this.logTreeItem(this.indent, "endElement " + elementQName.getLocalPart());
                    this.parseContextEndEvents(xmlEvent, endElement);
                    this.parseUnitEndEvents(xmlEvent, endElement);
                    this.parseValueEndEvents(xmlEvent, endElement);
                    this.parseFootnoteEndEvents(xmlEvent, endElement);
                } else if (xmlEvent.isEndDocument()) {
                    if (this.scenarioXmlEventWriter != null) {
                        this.scenarioXmlEventWriter.close();
                    }
                    if (this.segmentXmlEventWriter != null) {
                        this.segmentXmlEventWriter.close();
                    }
                }
            }
            this.processScenarioChildren(xmlEvent);
            this.processSegmentChildren(xmlEvent);
        }
        catch (Exception e) {
            if (e instanceof IncompatibleSchemaRefException) {
                throw (IncompatibleSchemaRefException)((Object)e);
            }
            log.info("Parsing error: " + xmlEvent.getLocation());
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlImportException();
        }
        finally {
            if (this.scenarioStringWriter != null) {
                this.scenarioStringWriter.close();
            }
            if (this.segmentStringWriter != null) {
                this.segmentStringWriter.close();
            }
        }
    }

    private void parseUnitStartEvents(XMLEvent xmlEvent, StartElement startElement) {
        QName elementQName = startElement.getName();
        if (Objects.equals(elementQName, XbrlXmlTags.UNIT)) {
            this.skipCurrentUnit = false;
            this.currentXbrlUnit = new XbrlUnit();
            Attribute unitIdAttr = startElement.getAttributeByName(XbrlXmlTags.UNIT_ID_ATTR);
            this.currentXbrlUnit.getXbrlUnitId().setUnitId(unitIdAttr.getValue());
        }
    }

    private void parseUnitEndEvents(XMLEvent xmlEvent, EndElement endElement) {
        QName elementQName = endElement.getName();
        if (Objects.equals(elementQName, XbrlXmlTags.UNIT)) {
            if (!this.skipCurrentUnit) {
                this.processXbrlUnit(this.currentXbrlUnit, this.xbrlFilePath, Integer.valueOf(0));
            }
        } else if (Objects.equals(elementQName, XbrlXmlTags.UNIT_MEASURE)) {
            // empty if block
        }
    }

    private void parseUnitCharacters(XMLEvent xmlEvent, Characters characters) throws Exception {
        String instancePrefix = this.namespaceContext.getPrefix("http://www.xbrl.org/2003/instance");
        String inlinePrefix = this.namespaceContext.getPrefix("http://www.w3.org/1999/xhtml");
        String iso4217Prefix = this.namespaceContext.getPrefix("http://www.xbrl.org/2003/iso4217");
        if (Objects.equals(this.currentElement, XbrlXmlTags.UNIT_MEASURE)) {
            QName parentElementQName = (QName)this.parentElements.get(1);
            String charactersData = characters.getData();
            if (Objects.equals(parentElementQName, XbrlXmlTags.UNIT)) {
                String xmlSuffix;
                String xmlPrefix = charactersData.contains(":") ? charactersData.split(":")[0] : "";
                String string = xmlSuffix = charactersData.contains(":") ? charactersData.split(":")[1] : charactersData;
                if (!(xmlPrefix.equals(instancePrefix) || xmlPrefix.equals(iso4217Prefix) || xmlPrefix.equals(inlinePrefix))) {
                    if (this.eventMessageConsumer != null) {
                        this.eventMessageConsumer.accept("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d namespace \u0434\u043b\u044f \u043f\u0440\u0435\u0444\u0438\u043a\u0441\u0430: '" + xmlPrefix + "'");
                        this.skipCurrentUnit = true;
                    }
                } else {
                    String[] nonCurrensyUnits = new String[]{"pure", "shares"};
                    String unit = Arrays.asList(nonCurrensyUnits).contains(xmlSuffix.toLowerCase()) ? "xbrli:" + xmlSuffix : "iso4217:" + xmlSuffix;
                    this.currentXbrlUnit.setMeasure(unit);
                }
            } else if (Objects.equals(parentElementQName, XbrlXmlTags.UNIT_NUMERATOR)) {
                this.currentXbrlUnit.setNumeratorMeasure(charactersData);
            } else if (Objects.equals(parentElementQName, XbrlXmlTags.UNIT_DENOMINATOR)) {
                this.currentXbrlUnit.setDenominatorMeasure(charactersData);
            }
        }
    }

    private void parseFootnoteStartEvents(XMLEvent xmlEvent, StartElement startElement) {
        QName elementQName = startElement.getName();
        if (Objects.equals(elementQName, XbrlXmlTags.FOOTNOTE_LINK)) {
            this.isProcessingFootnotes = true;
            return;
        }
        if (Objects.equals(elementQName, XbrlXmlTags.FOOTNOTE_LOC)) {
            Attribute label;
            Attribute href = startElement.getAttributeByName(XbrlXmlTags.FOOTNOTE_HREF_ATTR);
            if (href == null || !StringUtils.startsWith((CharSequence)href.getValue(), (CharSequence)"#")) {
                return;
            }
            String hrefStr = StringUtils.substringAfter((String)href.getValue(), (String)"#");
            if (this.footnoteMap.get(hrefStr) == null) {
                this.footnoteMap.put(hrefStr, new ArrayList());
            }
            if ((label = startElement.getAttributeByName(XbrlXmlTags.FOOTNOTE_LABEL_ATTR)) == null) {
                return;
            }
            String labelStr = label.getValue();
            if (StringUtils.isBlank((CharSequence)labelStr)) {
                return;
            }
            this.footnoteIdMap.put(labelStr, hrefStr);
            return;
        }
        if (Objects.equals(elementQName, XbrlXmlTags.FOOTNOTE)) {
            Attribute label = startElement.getAttributeByName(XbrlXmlTags.FOOTNOTE_LABEL_ATTR);
            if (label == null) {
                return;
            }
            String labelStr = label.getValue();
            if (StringUtils.isBlank((CharSequence)labelStr)) {
                return;
            }
            Attribute lang = startElement.getAttributeByName(XbrlXmlTags.FOOTNOTE_LANG_ATTR);
            if (lang != null) {
                this.cuurentFootnoteValueLang = lang.getValue();
            }
            this.cuurentFootnoteValueLabel = labelStr;
            this.processingFootnoteLabel = true;
        }
        if (Objects.equals(elementQName, XbrlXmlTags.FOOTNOTE_ARC)) {
            Attribute from = startElement.getAttributeByName(XbrlXmlTags.FOOTNOTE_FROM_ATTR);
            Attribute to = startElement.getAttributeByName(XbrlXmlTags.FOOTNOTE_TO_ATTR);
            Attribute order = startElement.getAttributeByName(XbrlXmlTags.FOOTNOTE_ORDER_ATTR);
            if (from == null || to == null) {
                return;
            }
            String fromStr = from.getValue();
            String toStr = to.getValue();
            String orderStr = null;
            if (order != null) {
                orderStr = order.getValue();
            }
            if (StringUtils.isBlank((CharSequence)fromStr) || StringUtils.isBlank((CharSequence)toStr)) {
                return;
            }
            HashMap<String, String> currentFootnoteArcMap = (HashMap<String, String>)this.footnoteArcMap.get(fromStr);
            if (currentFootnoteArcMap == null) {
                currentFootnoteArcMap = new HashMap<String, String>();
                currentFootnoteArcMap.put("1.0", toStr);
                this.footnoteArcMap.put(fromStr, currentFootnoteArcMap);
            } else if (StringUtils.isBlank((CharSequence)orderStr)) {
                Set orderSet = currentFootnoteArcMap.keySet();
                Integer maxOrder = 0;
                for (String currentOrder : orderSet) {
                    Integer currentOrderInt;
                    if (StringUtils.isBlank((CharSequence)currentOrder)) continue;
                    if (StringUtils.contains((CharSequence)currentOrder, (CharSequence)".")) {
                        currentOrder = StringUtils.split((String)currentOrder, (String)".")[0];
                    }
                    try {
                        currentOrderInt = Integer.parseInt(currentOrder);
                    }
                    catch (NumberFormatException e) {
                        log.warn("\u041f\u0430\u0440\u0441\u0438\u043d\u0433 xml, \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438. \u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 order");
                        continue;
                    }
                    if (currentOrderInt <= maxOrder) continue;
                    maxOrder = currentOrderInt;
                }
                currentFootnoteArcMap.put(maxOrder + 1 + ".0", toStr);
            } else {
                currentFootnoteArcMap.put(orderStr, toStr);
            }
        }
    }

    private void parseFootnoteCharacters(XMLEvent xmlEvent, Characters characters) {
        if (characters == null) {
            return;
        }
        this.processingFootnoteLabel = false;
        if (StringUtils.isBlank((CharSequence)this.cuurentFootnoteValueLabel)) {
            return;
        }
        this.footnoteValueMap.put(this.cuurentFootnoteValueLabel, characters.getData());
        this.cuurentFootnoteValueLabel = "";
    }

    private void parseFootnoteEndEvents(XMLEvent xmlEvent, EndElement endElement) {
        QName elementQName = endElement.getName();
        if (Objects.equals(elementQName, XbrlXmlTags.FOOTNOTE_LINK)) {
            for (Map.Entry currentFootnoteArcEntry : this.footnoteArcMap.entrySet()) {
                Map currentFootnoteArcMap;
                String currentFactLabel = (String)currentFootnoteArcEntry.getKey();
                String footnoteFactHref = (String)this.footnoteIdMap.get(currentFactLabel);
                if (StringUtils.isBlank((CharSequence)footnoteFactHref)) continue;
                ArrayList<XbrlFootnote> currentXbrlFootnoteList = (ArrayList<XbrlFootnote>)this.footnoteMap.get(footnoteFactHref);
                if (currentXbrlFootnoteList == null) {
                    currentXbrlFootnoteList = new ArrayList<XbrlFootnote>();
                    this.footnoteMap.put(footnoteFactHref, currentXbrlFootnoteList);
                }
                if (CollectionUtils.isEmpty((Map)(currentFootnoteArcMap = (Map)currentFootnoteArcEntry.getValue()))) continue;
                for (Map.Entry currentFootnote : currentFootnoteArcMap.entrySet()) {
                    if (currentFootnote == null) continue;
                    String order = (String)currentFootnote.getKey();
                    String value = (String)currentFootnote.getValue();
                    if (StringUtils.isBlank((CharSequence)order) || StringUtils.isBlank((CharSequence)value)) continue;
                    XbrlFootnote currentXbrlFootnote = new XbrlFootnote();
                    currentXbrlFootnote.setFootnoteFactId(footnoteFactHref);
                    currentXbrlFootnote.setContent(StringUtils.trim((String)((String)this.footnoteValueMap.get(value))));
                    currentXbrlFootnote.setLanguage("ru");
                    currentXbrlFootnote.setFootnoteNo(order);
                    currentXbrlFootnoteList.add(currentXbrlFootnote);
                }
            }
            for (Map.Entry stringXbrlFootnoteEntry : this.footnoteMap.entrySet()) {
                List xbrlFootnoteList = (List)stringXbrlFootnoteEntry.getValue();
                if (CollectionUtils.isEmpty((Collection)xbrlFootnoteList)) continue;
                for (XbrlFootnote xbrlFootnote : xbrlFootnoteList) {
                    this.processXbrlFootnote(xbrlFootnote, this.xbrlFilePath, Integer.valueOf(0));
                }
            }
        }
    }

    private boolean isFacts(QName elementName) {
        ConfigProperties.Namespace[] factNamespaces = this.configPropertiesXbrl.getFactsNamespaces();
        return Arrays.stream(factNamespaces).anyMatch(n -> n.getUri().equals(elementName.getNamespaceURI()));
    }

    private void parseValueStartEvents(XMLEvent xmlEvent, StartElement startElement) {
        QName elementQName = startElement.getName();
        if (this.isFacts(elementQName)) {
            Attribute footnoteId;
            Attribute precisionAttr;
            Attribute contextRefAttr = startElement.getAttributeByName(XbrlXmlTags.VALUE_CONTEXT_REF_ATTR);
            this.currentValueContextId = contextRefAttr.getValue();
            this.currentXbrlValue = new XbrlValue();
            this.currentXbrlValue.setElementName(elementQName.getLocalPart());
            String elementLabel = elementQName.getPrefix() + ":" + elementQName.getLocalPart();
            this.currentXbrlValue.getXbrlValueId().setElementLabel(elementLabel);
            this.currentXbrlValue.setElementUri(elementQName.getNamespaceURI());
            Attribute unitRefAttr = startElement.getAttributeByName(XbrlXmlTags.VALUE_UNIT_REF_ATTR);
            this.currentValueUnitId = unitRefAttr != null ? unitRefAttr.getValue() : null;
            Attribute decimalsAttr = startElement.getAttributeByName(XbrlXmlTags.VALUE_DECIMALS_ATTR);
            if (decimalsAttr != null) {
                this.currentXbrlValue.setDecimals(XbrlXmlParser.safeParseInt((String)decimalsAttr.getValue()));
            }
            if ((precisionAttr = startElement.getAttributeByName(XbrlXmlTags.VALUE_PRECISION_ATTR)) != null) {
                this.currentXbrlValue.setPrecision(XbrlXmlParser.safeParseInt((String)precisionAttr.getValue()));
            }
            if ((footnoteId = startElement.getAttributeByName(XbrlXmlTags.VALUE_FOOTNOTE_ID_ATTR)) != null) {
                String id = footnoteId.getValue();
                this.currentXbrlValue.setId(id);
                this.footnoteMap.put(id, new ArrayList());
            }
        }
    }

    public static Integer safeParseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void parseValueCharacters(XMLEvent xmlEvent, Characters characters) throws Exception {
        QName parentElementQName;
        if (this.parentElements.size() == 2 && this.isFacts(parentElementQName = (QName)this.parentElements.get(0))) {
            String value = this.normalizePrefix(characters.getData(), "mem-int");
            if (this.currentXbrlValue != null) {
                if (this.currentXbrlValue.getValue() == null) {
                    this.currentXbrlValue.setValue("");
                }
                String currentValue = this.currentXbrlValue.getValue() + value;
                this.currentXbrlValue.setValue(currentValue);
            }
        }
    }

    private String normalizePrefix(String parsedQname, String normalizedPrefix) {
        boolean hasNamespacePrefix = parsedQname.contains(":") && this.namespaces.stream().anyMatch(namespace -> namespace.getPrefix().equals(parsedQname.split(":")[0]));
        return hasNamespacePrefix ? normalizedPrefix + ":" + parsedQname.split(":")[1] : parsedQname;
    }

    private void parseValueEndEvents(XMLEvent xmlEvent, EndElement endElement) throws NotFoundException {
        QName elementQName = endElement.getName();
        if (this.isFacts(elementQName)) {
            this.processXbrlValue(this.currentValueContextId, this.currentValueUnitId, this.currentXbrlValue, this.xbrlFilePath, Integer.valueOf(0));
        }
    }

    private void processScenarioChildren(XMLEvent xmlEvent) throws XMLStreamException {
        boolean isEmptyCharactersEvent;
        boolean isScenarioStartEvent = xmlEvent.isStartElement() && xmlEvent.asStartElement().getName().equals(XbrlXmlTags.CONTEXT_SCENARIO);
        boolean bl = isEmptyCharactersEvent = xmlEvent.isCharacters() && StringUtils.isBlank((CharSequence)xmlEvent.asCharacters().getData());
        if (this.isProcessingScenario && !isScenarioStartEvent && !isEmptyCharactersEvent) {
            this.scenarioXmlEventWriter.add(xmlEvent);
            ++this.scenarioEventCounter;
        }
    }

    private void processSegmentChildren(XMLEvent xmlEvent) throws XMLStreamException {
        boolean isEmptyCharactersEvent;
        boolean isSegmentStartEvent = xmlEvent.isStartElement() && xmlEvent.asStartElement().getName().equals(XbrlXmlTags.CONTEXT_SEGMENT);
        boolean bl = isEmptyCharactersEvent = xmlEvent.isCharacters() && StringUtils.isBlank((CharSequence)xmlEvent.asCharacters().getData());
        if (this.isProcessingSegment && !isSegmentStartEvent && !isEmptyCharactersEvent) {
            this.segmentXmlEventWriter.add(xmlEvent);
            ++this.segmentEventCounter;
        }
    }

    private void parseContextCharacters(XMLEvent xmlEvent, Characters characters) throws Exception {
        if (Objects.equals(this.currentElement, XbrlXmlTags.CONTEXT_PERIOD_INSTANT)) {
            this.currentXbrlContext.setInstantDate(this.parseDate(characters.getData()));
        } else if (Objects.equals(this.currentElement, XbrlXmlTags.CONTEXT_PERIOD_STARTDATE)) {
            this.currentXbrlContext.setStartDate(this.parseDate(characters.getData()));
        } else if (Objects.equals(this.currentElement, XbrlXmlTags.CONTEXT_PERIOD_ENDDATE)) {
            this.currentXbrlContext.setEndDate(this.parseDate(characters.getData()));
        } else if (Objects.equals(this.currentElement, XbrlXmlTags.CONTEXT_IDENTIFIER)) {
            this.currentXbrlContext.setIdentifier(characters.getData());
        } else if (Objects.equals(this.currentElement, XbrlXmlTags.CONTEXT_SCENARIO)) {
            // empty if block
        }
    }

    private void parseSchemRefStartEvents(XMLEvent xmlEvent, StartElement startElement) throws IncompatibleSchemaRefException {
        QName elementQName = startElement.getName();
        if (Objects.equals(elementQName, XbrlXmlTags.SCHEMA_REF)) {
            Attribute hrefAttr = startElement.getAttributeByName(XbrlXmlTags.SCHEMA_REF_HREF_ATTR);
            this.entryPoint = hrefAttr.getValue();
            if (this.checkOnlyEntryPoint) {
                this.isCheckedEntryPoint = true;
            }
        }
    }

    private void checkEntryPoint(String ep) throws IncompatibleSchemaRefException {
        String parsedXmlSchema;
        String expectedSchema = FilenameUtils.getBaseName((String)this.expectedEntryPoint);
        if (!Objects.equals(expectedSchema, parsedXmlSchema = FilenameUtils.getBaseName((String)ep))) {
            log.warn("Incompatible schemaRefs, expected {}, current {}", (Object)expectedSchema, (Object)parsedXmlSchema);
            throw new IncompatibleSchemaRefException();
        }
    }

    private void parseContextStartEvents(XMLEvent xmlEvent, StartElement startElement) throws XMLStreamException {
        QName elementQName = startElement.getName();
        if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT)) {
            this.currentXbrlContext = new XbrlContext();
            Attribute contextIdAttr = startElement.getAttributeByName(XbrlXmlTags.CONTEXT_ID_ATTR);
            this.currentXbrlContext.getXbrlContextId().setContextId(contextIdAttr.getValue());
        } else if (!Objects.equals(elementQName, XbrlXmlTags.CONTEXT_ENTITY) && !Objects.equals(elementQName, XbrlXmlTags.CONTEXT_PERIOD)) {
            Attribute contextSchemeAttr;
            if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_PERIOD_INSTANT)) {
                this.currentXbrlContext.setPeriodType(PeriodType.INSTANT);
            } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_PERIOD_STARTDATE)) {
                this.currentXbrlContext.setPeriodType(PeriodType.DURATION);
            } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_PERIOD_STARTDATE)) {
                this.currentXbrlContext.setPeriodType(PeriodType.DURATION);
            } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_SCENARIO)) {
                if (this.scenarioXmlEventWriter != null) {
                    this.scenarioXmlEventWriter.close();
                }
                try {
                    if (this.scenarioStringWriter != null) {
                        this.scenarioStringWriter.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.scenarioStringWriter = new StringWriter();
                this.scenarioXmlEventWriter = this.xmlOutputFactory.createXMLEventWriter(this.scenarioStringWriter);
                this.scenarioEventCounter = 0;
                this.isProcessingScenario = true;
            } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_SEGMENT)) {
                if (this.segmentXmlEventWriter != null) {
                    this.segmentXmlEventWriter.close();
                }
                try {
                    if (this.segmentStringWriter != null) {
                        this.segmentStringWriter.close();
                    }
                }
                catch (IOException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
                this.segmentStringWriter = new StringWriter();
                this.segmentXmlEventWriter = this.xmlOutputFactory.createXMLEventWriter(this.segmentStringWriter);
                this.segmentEventCounter = 0;
                this.isProcessingSegment = true;
            } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_IDENTIFIER) && (contextSchemeAttr = startElement.getAttributeByName(XbrlXmlTags.CONTEXT_SCHEME_ATTR)) != null) {
                this.currentXbrlContext.setScheme(contextSchemeAttr.getValue());
            }
        }
    }

    private void parseContextEndEvents(XMLEvent xmlEvent, EndElement endElement) throws XMLStreamException {
        QName elementQName = endElement.getName();
        if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT)) {
            String instancePrefix = this.namespaceContext.getPrefix("http://www.xbrl.org/2003/instance");
            this.processXbrlContext(this.currentXbrlContext, this.xbrlFilePath, Integer.valueOf(0));
        } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_SCENARIO)) {
            this.isProcessingScenario = false;
            String scenario = this.scenarioStringWriter.toString();
            ArrayList xbrlContextDimensions = new ArrayList();
            String instancePrefix = this.namespaceContext.getPrefix("http://www.xbrl.org/2003/instance");
            new XbrlContextScenarioParser(scenario, this.namespaces, this.defaultNamespacePrefixes, instancePrefix, xbrlContextDimension -> xbrlContextDimensions.add(xbrlContextDimension));
            String preparedScenario = XbrlContextDimension.buildScenario(xbrlContextDimensions);
            this.currentXbrlContext.setScenario(preparedScenario);
            this.scenarioXmlEventWriter.close();
        } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_SEGMENT)) {
            this.isProcessingSegment = false;
            this.currentXbrlContext.setSegment(this.segmentStringWriter.toString());
            this.segmentXmlEventWriter.close();
        }
    }

    public Date parseDate(String stringDate) throws Exception {
        if (StringUtils.isBlank((CharSequence)stringDate)) {
            throw new Exception("Date is blank");
        }
        DateTime dt = this.periodDateFormatter.parseDateTime(stringDate);
        return dt.toDate();
    }

    private void logTreeItem(int indent, String message) {
    }

    public abstract void processXbrlContext(XbrlContext var1, String var2, Integer var3);

    public abstract void processXbrlValue(String var1, String var2, XbrlValue var3, String var4, Integer var5) throws NotFoundException;

    public abstract void processXbrlUnit(XbrlUnit var1, String var2, Integer var3);

    public abstract void processXbrlFootnote(XbrlFootnote var1, String var2, Integer var3);

    public String getEntryPoint() {
        return this.entryPoint;
    }
}

