/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls.validation_log;

import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.model.validation.ValidationEvent;
import ru.cbr.xbrl.converter.service.internal.XbrlReportValidationEventCrudServiceImpl;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxUtils;

public class ValidationLogXlsxWriter {
    private static final Logger log = LoggerFactory.getLogger(ValidationLogXlsxWriter.class);
    private final XSSFSheet sheet;
    private final String sheetName;
    private CellStyle boldStyle;
    private CellStyle borderedStyle;
    private String[] headers;
    private int[] widths;

    public ValidationLogXlsxWriter(XSSFWorkbook workbook, String tab, List<ValidationEvent> validationEvents) {
        this.sheetName = XbrlReportValidationEventCrudServiceImpl.getTabLabel((String)tab);
        this.boldStyle = XlsxUtils.createBoldStyle((XSSFWorkbook)workbook);
        this.borderedStyle = XlsxUtils.createBorderedStyle((XSSFWorkbook)workbook);
        this.sheet = workbook.createSheet(this.sheetName);
        this.write(this.sheet, validationEvents, tab);
    }

    private void write(XSSFSheet sheet, List<ValidationEvent> validationEvents, String tab) {
        switch (tab) {
            case "warnings": {
                this.writeWarnings(sheet, validationEvents);
                return;
            }
            case "stop-control": {
                this.writeStopControls(sheet, validationEvents);
                return;
            }
            case "existence": {
                this.writeExistence(sheet, validationEvents);
                return;
            }
        }
    }

    private void writeWarnings(XSSFSheet sheet, List<ValidationEvent> validationEvents) {
        XSSFRow titleRow = sheet.createRow(0);
        XSSFCell titleCell = titleRow.createCell(0);
        titleCell.setCellValue(this.sheetName);
        XSSFRow headerRow = sheet.createRow(1);
        this.headers = new String[]{"\u2116", "ID", "\u0412\u0430\u043b\u0438\u0434\u0438\u0440\u0443\u0435\u043c\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f", "\u0410\u043d\u0430\u043b\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0440\u0430\u0437\u0440\u0435\u0437", "\u041f\u0435\u0440\u0438\u043e\u0434", "\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446 Table", "\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446 Presentation|Definition"};
        this.widths = new int[]{1275, 5100, 5100, 5100, 5100, 5100, 5100, 2040, 5100, 7650};
        this.drawHeader(headerRow, this.headers);
        int rowOffset = 2;
        for (int row = 0; row < validationEvents.size(); ++row) {
            ValidationEvent event = validationEvents.get(row);
            int eventHeight = 1 + event.getItemDescriptionList().size();
            XSSFRow eventRow = sheet.createRow(rowOffset);
            this.drawCell(eventRow, 0, new Integer(row + 1).toString(), eventHeight);
            this.drawCell(eventRow, 1, event.getId(), eventHeight);
            this.drawCell(eventRow, 2, event.getFormula(), eventHeight);
            this.drawCell(eventRow, 3, event.getMessage(), eventHeight);
            this.drawCell(eventRow, 4, event.getVariable(), 1);
            this.drawCell(eventRow, 5, event.getIndex(), 1);
            this.drawCell(eventRow, 6, event.getSection(), 1);
            this.drawCell(eventRow, 7, event.getPeriod(), 1);
            this.drawCell(eventRow, 8, event.getTableHeader(), 1);
            this.drawCell(eventRow, 9, event.getPreHeader(), 1);
            for (int subRow = 0; subRow < event.getItemDescriptionList().size(); ++subRow) {
                ValidationEvent subEvent = (ValidationEvent)event.getItemDescriptionList().get(subRow);
                XSSFRow subEventRow = sheet.createRow(rowOffset + subRow + 1);
                this.drawCell(subEventRow, 4, subEvent.getVariable(), 1);
                this.drawCell(subEventRow, 5, subEvent.getIndex(), 1);
                this.drawCell(subEventRow, 6, subEvent.getSection(), 1);
                this.drawCell(subEventRow, 7, subEvent.getPeriod(), 1);
                this.drawCell(subEventRow, 8, subEvent.getTableHeader(), 1);
                this.drawCell(subEventRow, 9, subEvent.getPreHeader(), 1);
            }
            rowOffset += eventHeight;
        }
    }

    private void writeExistence(XSSFSheet sheet, List<ValidationEvent> validationEvents) {
        XSSFRow titleRow = sheet.createRow(0);
        XSSFCell titleCell = titleRow.createCell(0);
        titleCell.setCellValue(this.sheetName);
        XSSFRow headerRow = sheet.createRow(1);
        this.headers = new String[]{"\u2116", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f", "\u0410\u043d\u0430\u043b\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0440\u0430\u0437\u0440\u0435\u0437", "\u041f\u0435\u0440\u0438\u043e\u0434", "\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446 Table", "\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446 Presentation|Definition", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435"};
        this.widths = new int[]{1275, 7650, 7650, 7650, 7650, 7650, 7650};
        this.drawHeader(headerRow, this.headers);
        int rowOffset = 2;
        for (int row = 0; row < validationEvents.size(); ++row) {
            ValidationEvent event = validationEvents.get(row);
            int eventHeight = 1 + event.getItemDescriptionList().size();
            XSSFRow eventRow = sheet.createRow(rowOffset);
            this.drawCell(eventRow, 0, new Integer(row + 1).toString(), eventHeight);
            this.drawCell(eventRow, 1, event.getIndex(), 1);
            this.drawCell(eventRow, 2, event.getSection(), 1);
            this.drawCell(eventRow, 3, event.getPeriod(), 1);
            this.drawCell(eventRow, 4, event.getTableHeader(), 1);
            this.drawCell(eventRow, 5, event.getPreHeader(), 1);
            this.drawCell(eventRow, 6, event.getMessage(), eventHeight);
            for (int subRow = 0; subRow < event.getItemDescriptionList().size(); ++subRow) {
                ValidationEvent subEvent = (ValidationEvent)event.getItemDescriptionList().get(subRow);
                XSSFRow subEventRow = sheet.createRow(rowOffset + subRow + 1);
                this.drawCell(subEventRow, 1, subEvent.getIndex(), 1);
                this.drawCell(subEventRow, 2, subEvent.getSection(), 1);
                this.drawCell(subEventRow, 3, subEvent.getPeriod(), 1);
                this.drawCell(subEventRow, 4, subEvent.getTableHeader(), 1);
                this.drawCell(subEventRow, 5, subEvent.getPreHeader(), 1);
                this.drawCell(subEventRow, 6, event.getMessage(), eventHeight);
            }
            rowOffset += eventHeight;
        }
    }

    private void writeStopControls(XSSFSheet sheet, List<ValidationEvent> validationEvents) {
        XSSFRow titleRow = sheet.createRow(0);
        XSSFCell titleCell = titleRow.createCell(0);
        titleCell.setCellValue(this.sheetName);
        XSSFRow headerRow = sheet.createRow(1);
        this.headers = new String[]{"\u2116", "ID", "\u0412\u0430\u043b\u0438\u0434\u0438\u0440\u0443\u0435\u043c\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f", "\u0410\u043d\u0430\u043b\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0440\u0430\u0437\u0440\u0435\u0437", "\u041f\u0435\u0440\u0438\u043e\u0434", "\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446 Table", "\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446 Presentation|Definition"};
        this.widths = new int[]{1275, 5100, 5100, 5100, 5100, 5100, 5100, 5100, 7650, 10200};
        this.drawHeader(headerRow, this.headers);
        int rowOffset = 2;
        for (int row = 0; row < validationEvents.size(); ++row) {
            ValidationEvent event = validationEvents.get(row);
            int eventHeight = 1 + event.getItemDescriptionList().size();
            XSSFRow eventRow = sheet.createRow(rowOffset);
            this.drawCell(eventRow, 0, new Integer(row + 1).toString(), eventHeight);
            this.drawCell(eventRow, 1, event.getId(), eventHeight);
            this.drawCell(eventRow, 2, event.getFormula(), eventHeight);
            this.drawCell(eventRow, 3, event.getMessage(), eventHeight);
            this.drawCell(eventRow, 4, event.getVariable(), 1);
            this.drawCell(eventRow, 5, event.getIndex(), 1);
            this.drawCell(eventRow, 6, event.getSection(), 1);
            this.drawCell(eventRow, 7, event.getPeriod(), 1);
            this.drawCell(eventRow, 8, event.getTableHeader(), 1);
            this.drawCell(eventRow, 9, event.getPreHeader(), 1);
            for (int subRow = 0; subRow < event.getItemDescriptionList().size(); ++subRow) {
                ValidationEvent subEvent = (ValidationEvent)event.getItemDescriptionList().get(subRow);
                XSSFRow subEventRow = sheet.createRow(rowOffset + subRow + 1);
                this.drawCell(subEventRow, 4, subEvent.getVariable(), 1);
                this.drawCell(subEventRow, 5, subEvent.getIndex(), 1);
                this.drawCell(subEventRow, 6, subEvent.getSection(), 1);
                this.drawCell(subEventRow, 7, subEvent.getPeriod(), 1);
                this.drawCell(subEventRow, 8, subEvent.getTableHeader(), 1);
                this.drawCell(subEventRow, 9, subEvent.getPreHeader(), 1);
            }
            rowOffset += eventHeight;
        }
    }

    private void drawCell(XSSFRow eventRow, int column, String value, int rowsMerged) {
        XSSFCell eventIndexCell = eventRow.createCell(column);
        eventIndexCell.setCellStyle(this.borderedStyle);
        eventIndexCell.setCellValue(value);
        if (rowsMerged > 1) {
            this.sheet.addMergedRegion(new CellRangeAddress(eventRow.getRowNum(), eventRow.getRowNum() + rowsMerged - 1, column, column));
        }
    }

    private void drawHeader(XSSFRow headerRow, String[] headers) {
        for (int i = 0; i < headers.length; ++i) {
            XSSFCell cell = headerRow.createCell(i);
            cell.setCellStyle(this.boldStyle);
            cell.setCellValue(headers[i]);
            this.sheet.setColumnWidth(i, this.widths[i]);
        }
    }
}

