/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls.presentation_definition;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.exception.RewritableFileOpenException;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRole;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRoleMember;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxContentSheet;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxEnumerationDataSheet;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxSheetNameGenerator;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.presentation_definition.XslxPresentationDefinitionSheet;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.presentation_definition.XslxPresentationDefinitionWriter;

/*
 * Exception performing whole class analysis ignored.
 */
public class XslxPresentationDefinitionWriter {
    private static final Logger log = LoggerFactory.getLogger(XslxPresentationDefinitionWriter.class);
    private final String xslxFileName;
    private final XbrlPackage xbrlPackage;
    private final String currency;
    private final Function<String, List<AspectCellData>> getRoleListItemsFunction;
    private final boolean multipleFiles;
    private final String path;
    private final Consumer<NotificationEvent> notificationEventConsumer;
    private final List<PresentationDefinitionRole> roles;
    private final Map<String, List<EnumerateItem>> enumerations;
    private XlsxEnumerationDataSheet xlsxEnumerationDataSheet;
    private final CellEditableCheckerFunction cellEditableCheckerFunction;

    public XslxPresentationDefinitionWriter(XbrlPackage xbrlPackage, String xslxFileName, String currency, boolean multipleFiles, String path, Function<String, List<AspectCellData>> getRoleListItemsFunction, List<PresentationDefinitionRole> roles, Consumer<NotificationEvent> notificationEventConsumer, Map<String, List<EnumerateItem>> enumerations, CellEditableCheckerFunction cellEditableCheckerFunction) throws IOException, RewritableFileOpenException {
        this.xslxFileName = xslxFileName;
        this.xbrlPackage = xbrlPackage;
        this.getRoleListItemsFunction = getRoleListItemsFunction;
        this.roles = roles;
        this.notificationEventConsumer = notificationEventConsumer;
        this.currency = currency;
        this.multipleFiles = multipleFiles;
        this.path = path;
        this.enumerations = enumerations;
        this.cellEditableCheckerFunction = cellEditableCheckerFunction;
        this.xlsxEnumerationDataSheet = new XlsxEnumerationDataSheet(xslxFileName);
        this.draw();
    }

    public void draw() throws IOException, RewritableFileOpenException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        new XlsxContentSheet(workbook, this.xbrlPackage, null, this.roles, this.currency);
        int totalRoles = this.roles.size();
        List roleNames = this.roles.stream().map(PresentationDefinitionRole::getRoledefinition).collect(Collectors.toList());
        List sheetNames = XlsxSheetNameGenerator.generateSheetNames(roleNames);
        for (int i = 0; i < totalRoles; ++i) {
            PresentationDefinitionRole role = (PresentationDefinitionRole)this.roles.get(i);
            String sheetTitle = (String)sheetNames.get(i);
            String fileName = this.xslxFileName;
            if (this.multipleFiles) {
                workbook = new XSSFWorkbook();
                fileName = FilenameUtils.concat((String)this.path, (String)(sheetTitle + ".xlsx"));
                this.xlsxEnumerationDataSheet = new XlsxEnumerationDataSheet(fileName);
            }
            List cellDatas = (List)this.getRoleListItemsFunction.apply(role.getCode());
            int currentStage = i + 1;
            this.sendNotificationEvent(totalRoles, role, currentStage);
            this.enumerations.forEach((arg_0, arg_1) -> ((XlsxEnumerationDataSheet)this.xlsxEnumerationDataSheet).add(arg_0, arg_1));
            Map memEnums = XslxPresentationDefinitionWriter.createFromMembers((PresentationDefinitionRole)role);
            memEnums.forEach((arg_0, arg_1) -> ((XlsxEnumerationDataSheet)this.xlsxEnumerationDataSheet).add(arg_0, arg_1));
            new XslxPresentationDefinitionSheet(workbook, role, cellDatas, sheetTitle, this.xlsxEnumerationDataSheet, this.cellEditableCheckerFunction, memEnums);
            if (!this.multipleFiles) continue;
            this.xlsxEnumerationDataSheet.drawEnumerationsPage(workbook);
            FileOutputStream out = new FileOutputStream(fileName);
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
        }
        if (!this.multipleFiles) {
            try {
                this.xlsxEnumerationDataSheet.drawEnumerationsPage(workbook);
                FileOutputStream out = new FileOutputStream(this.xslxFileName);
                workbook.write((OutputStream)out);
                out.flush();
                out.close();
            }
            catch (FileNotFoundException e) {
                throw new RewritableFileOpenException();
            }
        }
    }

    public static Map<String, List<EnumerateItem>> createFromMembers(PresentationDefinitionRole role) {
        HashMap<String, List<EnumerateItem>> membersEnum = new HashMap<String, List<EnumerateItem>>();
        Map members = role.getMembers();
        if (members != null) {
            members.forEach((dim, pairs) -> {
                ArrayList items = new ArrayList();
                pairs.forEach(pair -> {
                    EnumerateItem item = new EnumerateItem();
                    item.setLabel(((PresentationDefinitionRoleMember)pair.getValue()).getValue());
                    item.setMember((String)pair.getKey());
                    items.add(item);
                });
                membersEnum.put((String)dim, items);
            });
        }
        return membersEnum;
    }

    private void sendNotificationEvent(int totalRoles, PresentationDefinitionRole xbrlReportRole, int currentStage) {
        NotificationEvent notificationEvent = new NotificationEvent();
        notificationEvent.setTitle(xbrlReportRole.getTitle());
        notificationEvent.setTotalNumberOfStages(Integer.valueOf(totalRoles));
        notificationEvent.setCurrentStage(Integer.valueOf(currentStage));
        Float progress = Float.valueOf(Float.valueOf(currentStage).floatValue() / (float)totalRoles);
        notificationEvent.setProgress(progress);
        this.notificationEventConsumer.accept(notificationEvent);
    }
}

