/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls.event_log;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.event_log.EventLogXlsxWriter;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventLogXlsxWriter {
    private static final Logger log = LoggerFactory.getLogger(EventLogXlsxWriter.class);
    public static final int FIRST_ROW_OFFSET = 2;
    private final XSSFSheet sheet;
    private final String sheetName;
    private CellStyle boldStyle;
    private CellStyle borderedStyle;
    private String[] headers;
    private int[] widths;

    public EventLogXlsxWriter(String xlsxFileName, EventLog.EventLogType tab, List<EventLog> validationEvents) {
        this.sheetName = EventLogXlsxWriter.getTabLabel((EventLog.EventLogType)tab);
        XSSFWorkbook workbook = new XSSFWorkbook();
        this.boldStyle = XlsxUtils.createBoldStyle((XSSFWorkbook)workbook);
        this.borderedStyle = XlsxUtils.createBorderedStyle((XSSFWorkbook)workbook);
        this.sheet = workbook.createSheet(this.sheetName);
        try (FileOutputStream out = new FileOutputStream(xlsxFileName);){
            this.write(this.sheet, validationEvents, tab);
            workbook.write((OutputStream)out);
            out.close();
        }
        catch (FileNotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void write(XSSFSheet sheet, List<EventLog> validationEvents, EventLog.EventLogType tab) {
        switch (1.$SwitchMap$ru$cbr$xbrl$converter$model$log$EventLog$EventLogType[tab.ordinal()]) {
            case 1: {
                this.writeCsv(sheet, validationEvents);
                return;
            }
            case 2: {
                this.writeXlsx(sheet, validationEvents);
                return;
            }
            case 3: {
                this.writeXml(sheet, validationEvents);
                return;
            }
            case 4: {
                this.writeCompare(sheet, validationEvents);
                return;
            }
        }
    }

    private void writeCompare(XSSFSheet sheet, List<EventLog> validationEvents) {
        XSSFRow titleRow = sheet.createRow(0);
        XSSFCell titleCell = titleRow.createCell(0);
        titleCell.setCellValue(this.sheetName);
        XSSFRow headerRow = sheet.createRow(1);
        this.headers = new String[]{"\u2116", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f", "\u041f\u0435\u0440\u0438\u043e\u0434", "\u0410\u043d\u0430\u043b\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0440\u0430\u0437\u0440\u0435\u0437", "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0437\u0430 \u043e\u0442\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434", "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432 \u0441\u0440\u0430\u0432\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435"};
        this.widths = new int[]{1275, 5100, 2550, 5100, 5100, 5100};
        this.drawHeader(headerRow, this.headers);
        for (int row = 0; row < validationEvents.size(); ++row) {
            EventLog event = validationEvents.get(row);
            XSSFRow eventRow = sheet.createRow(row + 2);
            this.drawCell(eventRow, 0, new Integer(row + 1).toString());
            this.drawCell(eventRow, 1, event.getConceptLabel());
            this.drawCell(eventRow, 2, event.getPeriod());
            this.drawCell(eventRow, 3, event.getDimensionsLabel());
            this.drawCell(eventRow, 4, event.getCurrentValue());
            this.drawCell(eventRow, 5, event.getCompareValue());
        }
    }

    private void writeCsv(XSSFSheet sheet, List<EventLog> validationEvents) {
        XSSFRow titleRow = sheet.createRow(0);
        XSSFCell titleCell = titleRow.createCell(0);
        titleCell.setCellValue(this.sheetName);
        XSSFRow headerRow = sheet.createRow(1);
        this.headers = new String[]{"\u2116", "Value/Context/Unit", "\u041d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435"};
        this.widths = new int[]{1275, 3825, 3825, 12750};
        this.drawHeader(headerRow, this.headers);
        for (int row = 0; row < validationEvents.size(); ++row) {
            EventLog event = validationEvents.get(row);
            XSSFRow eventRow = sheet.createRow(row + 2);
            this.drawCell(eventRow, 0, new Integer(row + 1).toString());
            this.drawCell(eventRow, 1, event.getConcept());
            this.drawCell(eventRow, 2, event.getAddress());
            this.drawCell(eventRow, 3, event.getMessage());
        }
    }

    private void writeXlsx(XSSFSheet sheet, List<EventLog> validationEvents) {
        XSSFRow titleRow = sheet.createRow(0);
        XSSFCell titleCell = titleRow.createCell(0);
        titleCell.setCellValue(this.sheetName);
        XSSFRow headerRow = sheet.createRow(1);
        this.headers = new String[]{"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043b\u0438\u0441\u0442\u0430", "\u0410\u0434\u0440\u0435\u0441 \u044f\u0447\u0435\u0439\u043a\u0438 \u0441 \u043e\u0448\u0438\u0431\u043a\u043e\u0439", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435"};
        this.widths = new int[]{6375, 6375, 12750};
        this.drawHeader(headerRow, this.headers);
        for (int row = 0; row < validationEvents.size(); ++row) {
            EventLog event = validationEvents.get(row);
            XSSFRow eventRow = sheet.createRow(row + 2);
            this.drawCell(eventRow, 0, event.getRole());
            this.drawCell(eventRow, 1, event.getAddress());
            this.drawCell(eventRow, 2, event.getMessage());
        }
    }

    private void writeXml(XSSFSheet sheet, List<EventLog> validationEvents) {
        XSSFRow titleRow = sheet.createRow(0);
        XSSFCell titleCell = titleRow.createCell(0);
        titleCell.setCellValue(this.sheetName);
        XSSFRow headerRow = sheet.createRow(1);
        this.headers = new String[]{"\u2116", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435"};
        this.widths = new int[]{1275, 12750};
        this.drawHeader(headerRow, this.headers);
        for (int row = 0; row < validationEvents.size(); ++row) {
            EventLog event = validationEvents.get(row);
            XSSFRow eventRow = sheet.createRow(row + 2);
            this.drawCell(eventRow, 0, new Integer(row + 1).toString());
            this.drawCell(eventRow, 1, event.getMessage());
        }
    }

    private void drawCell(XSSFRow eventRow, int column, String value) {
        XSSFCell eventIndexCell = eventRow.createCell(column);
        eventIndexCell.setCellStyle(this.borderedStyle);
        eventIndexCell.setCellValue(value);
    }

    private void drawHeader(XSSFRow headerRow, String[] headers) {
        for (int i = 0; i < headers.length; ++i) {
            XSSFCell cell = headerRow.createCell(i);
            cell.setCellStyle(this.boldStyle);
            cell.setCellValue(headers[i]);
            this.sheet.setColumnWidth(i, this.widths[i]);
        }
    }

    public static String getTabLabel(EventLog.EventLogType eventLogType) {
        switch (1.$SwitchMap$ru$cbr$xbrl$converter$model$log$EventLog$EventLogType[eventLogType.ordinal()]) {
            case 3: {
                return "\u0416\u0443\u0440\u043d\u0430\u043b \u0438\u043c\u043f\u043e\u0440\u0442\u0430 XML";
            }
            case 1: {
                return "\u0416\u0443\u0440\u043d\u0430\u043b \u0438\u043c\u043f\u043e\u0440\u0442\u0430 CSV";
            }
            case 2: {
                return "\u0416\u0443\u0440\u043d\u0430\u043b \u0438\u043c\u043f\u043e\u0440\u0442\u0430 XLSX";
            }
        }
        return "\u0416\u0443\u0440\u043d\u0430\u043b \u0441\u043e\u0431\u044b\u0442\u0438\u0439";
    }
}

