/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.SchemaValidationException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.model.DimensionValuePair;
import ru.cbr.xbrl.converter.model.XbrlDimension;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.AspectNodeMember;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlRoleDimension;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.PeriodLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.TLBUiModel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.ZLevel;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.service.AspectNodeService;
import ru.cbr.xbrl.converter.service.log.EventLogService;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.SheetModel;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.TableLinkViewUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxParserBase;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxSheetNameGenerator;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XslxSheet;

public class XslxParser
extends XlsxParserBase {
    private static final Logger log = LoggerFactory.getLogger(XslxParser.class);
    public static final int TOC_OFFSET = 1;
    public static final int TECH_SHEETS_COUNT = 2;
    private final String xslxFileName;
    private final BiConsumer<List<AspectCellData>, NotificationEvent> aspectCelldataListConsumer;
    private final Function<XbrlReportRole, TLBUiModel> getTlbUiModelFunction;
    private final HashMap<String, Pair<String, String>> generatedSheetNamesMap;
    private final List<XbrlDimension> explicitDimensions;
    private final Map<String, String> explicitDimensionMap = new HashMap();
    private EventLogService eventLogService;
    private XbrlPackage xbrlPackage;
    private AspectNodeService aspectNodeService;
    private List<String> unsupportedRoles;
    private int currentTableHeight = 0;

    public XslxParser(String xslxFileName, XbrlPackage xbrlPackage, EventLogService eventLogService, AspectNodeService aspectNodeService, List<XbrlDimension> explicitDimensions, Function<XbrlReportRole, TLBUiModel> getTlbUiModelFunction, BiConsumer<List<AspectCellData>, NotificationEvent> aspectCelldataListConsumer, Boolean isAlternativeFormat, List<String> unsupportedRoles) throws XbrlImportException, SchemaValidationException {
        this.xslxFileName = xslxFileName;
        this.aspectCelldataListConsumer = aspectCelldataListConsumer;
        this.getTlbUiModelFunction = getTlbUiModelFunction;
        this.eventLogService = eventLogService;
        this.aspectNodeService = aspectNodeService;
        this.xbrlPackage = xbrlPackage;
        this.generatedSheetNamesMap = this.generateSheetNamesMap(xbrlPackage);
        this.explicitDimensions = explicitDimensions;
        this.unsupportedRoles = unsupportedRoles;
        explicitDimensions.stream().forEach(xbrlDimension -> this.explicitDimensionMap.put(xbrlDimension.getDimInt(), xbrlDimension.getDimIntLabel()));
        try {
            this.parse(xbrlPackage.getXbrlReport().getXbrlReportRoles(), isAlternativeFormat);
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlImportException();
        }
    }

    private HashMap<String, Pair<String, String>> generateSheetNamesMap(XbrlPackage xbrlPackage) {
        List roleNames = xbrlPackage.getXbrlReport().getXbrlReportRoles().stream().map(r -> r.getTitle()).collect(Collectors.toList());
        List generatedSheetNames = XlsxSheetNameGenerator.generateSheetNames(roleNames);
        HashMap<String, Pair<String, String>> generatedSheetNamesMap = new HashMap<String, Pair<String, String>>();
        for (int i = 0; i < roleNames.size(); ++i) {
            XbrlReportRole role = (XbrlReportRole)xbrlPackage.getXbrlReport().getXbrlReportRoles().get(i);
            generatedSheetNamesMap.putIfAbsent(role.getSystemId(), (Pair<String, String>)new ImmutablePair((Object)role.getTitle(), generatedSheetNames.get(i)));
        }
        return generatedSheetNamesMap;
    }

    private String getSheetRoleSystemId(Sheet sheet) {
        Row systemIdRow = sheet.getRow(2);
        if (systemIdRow == null) {
            return null;
        }
        Cell systemIdCell = systemIdRow.getCell(0);
        if (systemIdCell == null) {
            return null;
        }
        return systemIdCell.getStringCellValue();
    }

    private void parse(List<XbrlReportRole> xbrlReportRoles, Boolean isAlternativeFormat) throws IOException, SchemaValidationException {
        log.info("Parse XLSX workbook: " + this.xslxFileName);
        Date start = new Date();
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new FileInputStream(this.xslxFileName));
        Map<String, XbrlReportRole> rolesMap = xbrlReportRoles.stream().collect(Collectors.toMap(r -> r.getSystemId(), r -> r));
        AtomicInteger xlsxSheetIndex = new AtomicInteger();
        AtomicLong buildTlbUiDuration = new AtomicLong();
        Iterator sheetIterator = workbook.sheetIterator();
        while (sheetIterator.hasNext()) {
            XSSFSheet xlsxSheet = (XSSFSheet)sheetIterator.next();
            String roleSystemId = this.getSheetRoleSystemId((Sheet)xlsxSheet);
            if (roleSystemId == null || !rolesMap.containsKey(roleSystemId)) continue;
            XbrlReportRole xbrlReportRole = rolesMap.get(roleSystemId);
            int xlsxPageIndex = 1 + xlsxSheetIndex.getAndIncrement();
            Date startTlbuiBuild = new Date();
            log.debug("Prepare role {} ({})", (Object)xbrlReportRole.getTitle(), (Object)xbrlReportRole.getSystemId());
            TLBUiModel tlbUiModel = (TLBUiModel)this.getTlbUiModelFunction.apply(xbrlReportRole);
            buildTlbUiDuration.addAndGet(new Date().getTime() - startTlbuiBuild.getTime());
            log.debug("        Prepare role complete {} ({}) in {} msec", new Object[]{xbrlReportRole.getTitle(), xbrlReportRole.getSystemId(), new Date().getTime() - startTlbuiBuild.getTime()});
            if (tlbUiModel == null) continue;
            if (BooleanUtils.isFalse((Boolean)isAlternativeFormat) && CollectionUtils.isEmpty((Collection)xbrlReportRole.getXbrlRoleDimensionList())) {
                this.unsupportedRoles.add(xbrlReportRole.getSystemId());
                continue;
            }
            TableLinkViewUtils.calcColspans((List)tlbUiModel.getColumnList());
            SheetModel sheetModel = new SheetModel(tlbUiModel, false);
            if (!CollectionUtils.isEmpty((Collection)xbrlReportRole.getXbrlRoleDimensionList())) {
                block7: {
                    if (BooleanUtils.isFalse((Boolean)isAlternativeFormat)) {
                        try {
                            this.importOpenAxisNewFormat(xbrlReportRole, xlsxSheet, sheetModel);
                            break block7;
                        }
                        catch (Exception e) {
                            log.error("Role does not support new format", (Throwable)e);
                            this.unsupportedRoles.add(xbrlReportRole.getSystemId());
                            continue;
                        }
                    }
                    this.importOpenAxis(xbrlReportRole, xlsxSheet, sheetModel);
                }
                tlbUiModel = (TLBUiModel)this.getTlbUiModelFunction.apply(xbrlReportRole);
                sheetModel = new SheetModel(tlbUiModel, false);
            }
            List roleAspectCellDataList = this.parseRole(tlbUiModel.getRoleId(), xlsxSheet, sheetModel, xbrlReportRole, isAlternativeFormat);
            roleAspectCellDataList.forEach(aspectCellData -> {
                aspectCellData.setRoleLabel(xlsxSheet.getSheetName());
                aspectCellData.setRoleId(xbrlReportRole.getId());
            });
            NotificationEvent notificationEvent = new NotificationEvent();
            notificationEvent.setTitle(xbrlReportRole.getTitle());
            int currentStage = xlsxPageIndex;
            notificationEvent.setCurrentStage(Integer.valueOf(currentStage));
            notificationEvent.setTotalNumberOfStages(Integer.valueOf(xbrlReportRoles.size()));
            Float progress = Float.valueOf(Float.valueOf(currentStage).floatValue() / (float)xbrlReportRoles.size());
            notificationEvent.setProgress(progress);
            this.aspectCelldataListConsumer.accept(roleAspectCellDataList, notificationEvent);
        }
        if (xlsxSheetIndex.get() != 0) {
            log.info("Build TLB UI duration summary: " + buildTlbUiDuration.get() + " msec, avg: " + buildTlbUiDuration.get() / (long)xlsxSheetIndex.get());
        }
        log.info("Parse XLSX workbook completed in " + (new Date().getTime() - start.getTime()) + " msec");
    }

    private void importOpenAxisNewFormat(XbrlReportRole xbrlReportRole, XSSFSheet xlsxSheet, SheetModel sheetModel) {
        ArrayList axisList = new ArrayList(xbrlReportRole.getXbrlRoleDimensionList());
        Map dimensionTitleMap = axisList.stream().filter(a -> a.getFilterOpenAxis() != null).collect(Collectors.toMap(a -> a.getFilterOpenAxis().getTitle(), Function.identity(), (a, b) -> a));
        xbrlReportRole.getXbrlRoleDimensionList().stream().filter(d -> d.getDimensionType().equals((Object)DimensionType.EXPLICIT_MEMBER)).forEach(d -> dimensionTitleMap.put((String)this.explicitDimensionMap.get(d.getDimension()), d));
        if (axisList.isEmpty()) {
            return;
        }
        int offset = 4 + sheetModel.getTopHeaderHeight() + 1;
        XSSFRow axisRow = xlsxSheet.getRow(offset);
        LinkedList<String> axisListFromXlsx = new LinkedList<String>();
        for (int i = 0; i < axisList.size(); ++i) {
            XSSFCell cell = axisRow.getCell(i);
            if (cell == null) continue;
            axisListFromXlsx.add(cell.getStringCellValue());
        }
        LinkedList<DimensionValuePair> values = new LinkedList<DimensionValuePair>();
        Iterator rowIterator = xlsxSheet.rowIterator();
        LinkedList added = new LinkedList();
        int previousRow = 0;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (row.getRowNum() < offset + 1) continue;
            if (previousRow > 0 && row.getRowNum() - previousRow > 1) {
                this.currentTableHeight = previousRow - 4 + 1;
                break;
            }
            previousRow = row.getRowNum();
            for (int i = 0; i < axisListFromXlsx.size(); ++i) {
                String stringCellValue;
                Cell cell = row.getCell(i);
                if (cell == null || !StringUtils.isNotEmpty((CharSequence)(stringCellValue = cell.getStringCellValue()))) continue;
                String preparedValue = stringCellValue.trim();
                String axis = (String)axisListFromXlsx.get(i);
                XbrlRoleDimension dimension = (XbrlRoleDimension)dimensionTitleMap.get(axis);
                if (DimensionType.TYPED_MEMBER.equals((Object)dimension.getDimensionType())) {
                    values.add(DimensionValuePair.of((String)dimension.getFilterOpenAxis().getSystemId(), null, (String)preparedValue, null, (int)i));
                } else if (DimensionType.EXPLICIT_MEMBER.equals((Object)dimension.getDimensionType())) {
                    values.add(DimensionValuePair.of((String)dimension.getDimension(), null, (String)preparedValue, null, (int)i));
                }
                YLevel yLevel = this.getYLevelValue(sheetModel, preparedValue, added);
                if (yLevel == null) continue;
                values.add(DimensionValuePair.of(null, (String)yLevel.getTitle(), (String)stringCellValue, (String)yLevel.getHash(), (int)0));
            }
        }
        this.saveMembers(xbrlReportRole, values, sheetModel.getTlbUiModel().getYRootHash());
    }

    private void importOpenAxis(XbrlReportRole xbrlReportRole, XSSFSheet xlsxSheet, SheetModel sheetModel) {
        List axisList = xbrlReportRole.getXbrlRoleDimensionList().stream().collect(Collectors.toList());
        if (axisList.isEmpty()) {
            return;
        }
        int offset = this.getOffset(sheetModel);
        LinkedList values = new LinkedList();
        Iterator rowIterator = xlsxSheet.rowIterator();
        LinkedList added = new LinkedList();
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (row.getRowNum() < offset) continue;
            Cell cell = row.getCell(0);
            if (cell == null) {
                return;
            }
            String stringCellValue = cell.getStringCellValue();
            if (stringCellValue == null) continue;
            String preparedValue = stringCellValue.trim();
            xbrlReportRole.getXbrlRoleDimensionList().stream().filter(xbrlRoleDimension -> xbrlRoleDimension.getDimensionType() == DimensionType.TYPED_MEMBER).filter(dimension -> preparedValue.startsWith(dimension.getFilterOpenAxis().getTitle().trim())).findFirst().ifPresent(dimension -> values.add(DimensionValuePair.of((String)dimension.getFilterOpenAxis().getSystemId(), (String)dimension.getFilterOpenAxis().getTitle(), (String)stringCellValue, null, (int)0)));
            xbrlReportRole.getXbrlRoleDimensionList().stream().filter(xbrlRoleDimension -> xbrlRoleDimension.getDimensionType() == DimensionType.EXPLICIT_MEMBER).filter(dimension -> preparedValue.startsWith((String)this.explicitDimensionMap.get(dimension.getDimension()))).findFirst().ifPresent(dimension -> values.add(DimensionValuePair.of((String)dimension.getDimension(), (String)((String)this.explicitDimensionMap.get(dimension.getDimension())), (String)stringCellValue, null, (int)0)));
        }
        this.saveMembers(xbrlReportRole, values, sheetModel.getTlbUiModel().getYRootHash());
    }

    private YLevel getYLevelValue(SheetModel sheetModel, String preparedValue, List<YLevel> added) {
        List yLevelList = Optional.ofNullable(sheetModel.getTlbUiModel().getPeriodLevelList().get(0)).map(PeriodLevel::getZLevelList).map(list -> (ZLevel)list.get(0)).map(ZLevel::getYLevelList).orElse(null);
        if (yLevelList == null) {
            return null;
        }
        return this.findYLevel(yLevelList, preparedValue, added);
    }

    private YLevel findYLevel(List<YLevel> yLevelList, String preparedValue, List<YLevel> added) {
        for (YLevel yLevel : yLevelList) {
            YLevel level;
            if ((yLevel.getTitle().startsWith(preparedValue) || yLevel.getTitle().equals("") && preparedValue.equals("empty row header")) && !added.contains(yLevel)) {
                added.add(yLevel);
                return yLevel;
            }
            if (CollectionUtils.isEmpty((Collection)yLevel.getYLevelList()) || (level = this.findYLevel(yLevel.getYLevelList(), preparedValue, added)) == null) continue;
            return level;
        }
        return null;
    }

    private void saveMembers(XbrlReportRole xbrlReportRole, List<DimensionValuePair> values, String parentHash) {
        DimensionValuePair[][] preparedValueList;
        for (DimensionValuePair[] dimensionValuePairs : preparedValueList = this.prepareDimensionValue(values)) {
            String currentHash = parentHash;
            for (DimensionValuePair dimensionValuePair : dimensionValuePairs) {
                if (dimensionValuePair == null) continue;
                try {
                    if (dimensionValuePair.getHash() == null) {
                        AspectNodeMember newMember = this.aspectNodeService.saveMember(xbrlReportRole.getId(), dimensionValuePair.getDimension(), dimensionValuePair.getClearedValue(), currentHash, null);
                        currentHash = newMember.getCommonId();
                        continue;
                    }
                    currentHash = dimensionValuePair.getHash();
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private DimensionValuePair[][] prepareDimensionValue(List<DimensionValuePair> values) {
        Integer max = values.stream().map(DimensionValuePair::getLevel).max(Comparator.naturalOrder()).orElse(0);
        DimensionValuePair[][] result = new DimensionValuePair[values.size()][max + 1];
        for (int i = 0; i < values.size(); ++i) {
            DimensionValuePair current = values.get(i);
            int level = current.getLevel();
            result[i][level] = current;
            if (i == 0 || level == 0) continue;
            System.arraycopy(result[i - 1], 0, result[i], 0, level);
        }
        return result;
    }

    private int getOffset(SheetModel sheetModel) {
        List periodLevelList = sheetModel.getTlbUiModel().getPeriodLevelList();
        int periodLevelOffset = periodLevelList != null ? periodLevelList.size() : 0;
        Integer topHeaderOffset = sheetModel.getTopHeaderHeight();
        return 4 + periodLevelOffset + topHeaderOffset;
    }

    private void validateSchema(XSSFSheet xlsxSheet, SheetModel sheetModel, int labelsRowIndex) throws SchemaValidationException {
        Map sheetModelMap = this.convertSheetModelToMap(sheetModel);
        for (Map.Entry rowEntry : sheetModelMap.entrySet()) {
            int rowNum = (Integer)rowEntry.getKey() + labelsRowIndex + 1;
            XSSFRow row = xlsxSheet.getRow(rowNum);
            for (Map.Entry columnEntry : ((Map)rowEntry.getValue()).entrySet()) {
                XSSFCell cell = row.getCell(((Integer)columnEntry.getKey()).intValue());
                if (cell != null && this.prepareValue((String)columnEntry.getValue()).equalsIgnoreCase(this.prepareValue(cell.getStringCellValue()))) continue;
                EventLog eventLog = new EventLog();
                eventLog.setEventLogType(EventLog.EventLogType.IMPORT_XLSX);
                eventLog.setAddress(cell == null ? String.format("(%s, %s)", rowNum, (Integer)columnEntry.getKey() + 1) : cell.getAddress().formatAsString());
                eventLog.setRole(xlsxSheet.getSheetName());
                eventLog.setMessage("\u041e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c: " + (String)columnEntry.getValue());
                eventLog.setXbrlReportId(this.xbrlPackage.getXbrlReport().getId());
                this.eventLogService.createInNewTransaction(eventLog);
                throw new SchemaValidationException();
            }
        }
    }

    private String prepareValue(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        return value.trim().replaceAll("[\n\r]", "");
    }

    private Map<Integer, Map<Integer, String>> convertSheetModelToMap(SheetModel sheetModel) {
        HashMap<Integer, Map<Integer, String>> result = new HashMap<Integer, Map<Integer, String>>();
        List allColumns = this.getAllColumns(sheetModel.getTlbUiModel().getColumnList());
        allColumns.forEach(columnHeader -> {
            Integer rowIndex = columnHeader.getY();
            if (!result.containsKey(rowIndex)) {
                result.put(rowIndex, new HashMap());
            }
            ((Map)result.get(rowIndex)).put(columnHeader.getX(), columnHeader.getCaption());
        });
        return result;
    }

    private List<ColumnHeader> getAllColumns(List<ColumnHeader> columns) {
        LinkedList<ColumnHeader> columnList = new LinkedList<ColumnHeader>();
        if (CollectionUtils.isEmpty(columns)) {
            return columnList;
        }
        columnList.addAll(columns);
        for (ColumnHeader column : columns) {
            columnList.addAll(this.getAllColumns(column.getColumnList()));
        }
        return columnList;
    }

    private List<AspectCellData> parseRole(Long roleId, XSSFSheet xlsxSheet, SheetModel sheetModel, XbrlReportRole xbrlReportRole, Boolean isAlternativeFormat) throws SchemaValidationException {
        ArrayList<AspectCellData> roleAspectCellData = new ArrayList<AspectCellData>();
        try {
            List periodLevels = sheetModel.getTlbUiModel().getPeriodLevelList();
            for (int periodIndex = 0; periodIndex < periodLevels.size(); ++periodIndex) {
                List periodAspectCellDataList;
                block7: {
                    PeriodLevel periodLevel = (PeriodLevel)periodLevels.get(periodIndex);
                    if (BooleanUtils.isFalse((Boolean)isAlternativeFormat)) {
                        try {
                            periodAspectCellDataList = this.parsePeriodLevelNewFormat(xlsxSheet, sheetModel, periodIndex, periodLevel, xbrlReportRole);
                            break block7;
                        }
                        catch (Exception e) {
                            log.error("Role does not support new format", (Throwable)e);
                            this.unsupportedRoles.add(xbrlReportRole.getSystemId());
                            break;
                        }
                    }
                    periodAspectCellDataList = this.parsePeriodLevel(xlsxSheet, sheetModel, periodIndex, periodLevel, xbrlReportRole);
                }
                roleAspectCellData.addAll(periodAspectCellDataList);
            }
        }
        catch (SchemaValidationException sve) {
            throw sve;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return roleAspectCellData;
    }

    private List<AspectCellData> parsePeriodLevel(XSSFSheet xlsxSheet, SheetModel sheetModel, int periodIndex, PeriodLevel periodLevel, XbrlReportRole xbrlReportRole) throws SchemaValidationException {
        ArrayList<AspectCellData> editedCells = new ArrayList<AspectCellData>();
        int periodBias = sheetModel.getPeriodBias(periodIndex);
        this.validateSchema(xlsxSheet, sheetModel, periodBias);
        XSSFRow labelsRow = xlsxSheet.getRow(periodBias);
        if (labelsRow == null) {
            log.error("Labels xlsx row is null, sheet " + xlsxSheet.getSheetName() + ", row " + periodBias);
            return editedCells;
        }
        List zLevelList = periodLevel.getZLevelList();
        ColumnHeader[] columnLeaves = sheetModel.getTopHeaderModel().getLeaves();
        List mergedRegions = xlsxSheet.getMergedRegions();
        block0: for (int z = 0; z < zLevelList.size(); ++z) {
            ZLevel zLevel = (ZLevel)zLevelList.get(z);
            List yLevelsUnwinded = sheetModel.getLeftHeaderModel().prepareLeftHeader(zLevel);
            Map yLevelsUnwindedMap = new HashMap();
            boolean isHierarchy = yLevelsUnwinded.stream().anyMatch(y -> !y.getYLevelList().isEmpty());
            if (isHierarchy) {
                yLevelsUnwindedMap = sheetModel.getLeftHeaderModel().getHashMapYLevels(zLevel);
            }
            YLevel.collectFullAspectListForEachYLevel((List)zLevel.getYLevelList(), null);
            int zTableOffset = z * (sheetModel.getTableWidth() + 1);
            XSSFCell periodLabelCell = labelsRow.getCell(zTableOffset);
            if (periodLabelCell == null) {
                log.info("periodLabelCell #{} is null, sheet {}, col {}: row {}", new Object[]{periodIndex, xlsxSheet.getSheetName(), zTableOffset, periodBias});
                continue;
            }
            this.setCellTypeToString((Cell)periodLabelCell);
            int zLabelCol = zTableOffset + sheetModel.getTableWidth() - 1;
            XSSFCell zLabelCell = labelsRow.getCell(zLabelCol);
            if (zLabelCell == null) {
                log.info("zLabelCell #{} is null, sheet {}, col {}: row {}", new Object[]{z, xlsxSheet.getSheetName(), zLabelCol, periodBias});
                continue;
            }
            this.setCellTypeToString((Cell)zLabelCell);
            Map finalYLevelsUnwindedMap = yLevelsUnwindedMap;
            int yRange = isHierarchy ? xlsxSheet.getLastRowNum() : yLevelsUnwinded.size();
            DimensionValuePair[][] dimensions = new DimensionValuePair[yRange][15];
            for (int yIndex = 0; yIndex < yRange; ++yIndex) {
                YLevel yLevel = isHierarchy ? null : (YLevel)yLevelsUnwinded.get(yIndex);
                int excelRowNum = periodBias + yIndex + 1 + sheetModel.getTopHeaderHeight();
                XSSFRow xlsRow = xlsxSheet.getRow(excelRowNum);
                if (isHierarchy && xlsRow == null) continue block0;
                if (xlsRow == null) continue;
                int LEFT_HEADER_WIDTH = 1;
                if (isHierarchy) {
                    XSSFCell yLevelCell = xlsRow.getCell(0);
                    if (yLevelCell != null) {
                        DimensionValuePair dimensionValuePair = DimensionValuePair.of(null, null, (String)yLevelCell.getStringCellValue(), null, (int)0);
                        int level = this.getLevel(dimensionValuePair);
                        dimensions[yIndex][level] = dimensionValuePair;
                        if (yIndex != 0) {
                            System.arraycopy(dimensions[yIndex - 1], 0, dimensions[yIndex], 0, level);
                        }
                    }
                    DimensionValuePair[] dimension = dimensions[yIndex];
                    String collect = Arrays.stream(dimension).filter(Objects::nonNull).map(DimensionValuePair::getValue).map(String::trim).collect(Collectors.joining()).replace("empty row header", "");
                    yLevel = (YLevel)finalYLevelsUnwindedMap.get(DigestUtils.md5Hex((String)collect));
                }
                YLevel finalYLevel = yLevel;
                IntStream.range(LEFT_HEADER_WIDTH, columnLeaves.length).forEach(xIndex -> {
                    int excelColNum = zTableOffset + xIndex;
                    ColumnHeader columnHeader = columnLeaves[xIndex];
                    AspectCellData aspectCellData = new AspectCellData();
                    aspectCellData.setAspectDataList(new ArrayList());
                    aspectCellData.getAspectDataList().addAll(periodLevel.getAspectDataList());
                    aspectCellData.getAspectDataList().addAll(zLevel.getAspectDataList());
                    aspectCellData.getAspectDataList().addAll(finalYLevel.getFullAspectDataList());
                    aspectCellData.getAspectDataList().addAll(columnHeader.getFullAspectDataList());
                    XSSFCell cell = xlsRow.getCell(excelColNum);
                    aspectCellData.setMerged(mergedRegions.stream().anyMatch(arg_0 -> this.lambda$null$19((Cell)cell, arg_0)));
                    this.setCellTypeToString((Cell)cell);
                    String cellValue = cell != null ? cell.getStringCellValue() : null;
                    AspectData concept = aspectCellData.getConcept();
                    if (StringUtils.isNotBlank((CharSequence)cellValue) && concept != null && sheetModel.getEnumerations().containsKey(concept.getAspectValue())) {
                        Optional enumerateItemOptional = XslxSheet.getEnumeratedFactValueByLabel((Map)sheetModel.getEnumerations(), (String)cellValue, (String)concept.getAspectValue());
                        if (!enumerateItemOptional.isPresent()) {
                            log.warn("Enumeration value not present, role {}, conceptName {}, factValue {}", new Object[]{sheetModel.getTlbUiModel().getLabel(), concept.getLabel(), cellValue});
                        }
                        String enumValue = enumerateItemOptional.isPresent() ? ((EnumerateItem)enumerateItemOptional.get()).getMember() : cellValue;
                        aspectCellData.setCellValue(enumValue);
                    } else {
                        aspectCellData.setCellValue(cellValue);
                    }
                    CellReference cellReference = new CellReference(excelRowNum, excelColNum, false, false);
                    aspectCellData.setAddress(cellReference.formatAsString());
                    if (StringUtils.isNotBlank((CharSequence)aspectCellData.getCellValue())) {
                        editedCells.add(aspectCellData);
                    }
                });
            }
        }
        return editedCells;
    }

    private List<AspectCellData> parsePeriodLevelNewFormat(XSSFSheet xlsxSheet, SheetModel sheetModel, int periodIndex, PeriodLevel periodLevel, XbrlReportRole xbrlReportRole) throws SchemaValidationException {
        ArrayList<AspectCellData> editedCells = new ArrayList<AspectCellData>();
        int periodBias = sheetModel.getPeriodBiasNewFormat(periodIndex, this.currentTableHeight);
        XSSFRow labelsRow = xlsxSheet.getRow(periodBias);
        if (labelsRow == null) {
            log.error("Labels xlsx row is null, sheet " + xlsxSheet.getSheetName() + ", row " + periodBias);
            return editedCells;
        }
        List zLevelList = periodLevel.getZLevelList();
        ColumnHeader[] columnLeaves = sheetModel.getTopHeaderModel().getLeaves();
        List mergedRegions = xlsxSheet.getMergedRegions();
        for (int z = 0; z < zLevelList.size(); ++z) {
            int zTableOffset;
            XSSFCell periodLabelCell;
            ZLevel zLevel = (ZLevel)zLevelList.get(z);
            List yLevelsUnwinded = sheetModel.getLeftHeaderModel().prepareLeftHeader(zLevel).stream().filter(y -> y.getChildAspectNodes() == null).collect(Collectors.toList());
            YLevel.collectFullAspectListForEachYLevel((List)zLevel.getYLevelList(), null);
            int leftHeaderWidth = 1;
            if (!xbrlReportRole.getXbrlRoleDimensionList().isEmpty()) {
                leftHeaderWidth = xbrlReportRole.getXbrlRoleDimensionList().size();
            }
            if ((periodLabelCell = labelsRow.getCell(zTableOffset = z * (sheetModel.getTableWidth() + 1 + (leftHeaderWidth == 1 ? 0 : leftHeaderWidth - 1)))) == null) {
                log.info("periodLabelCell #{} is null, sheet {}, col {}: row {}", new Object[]{periodIndex, xlsxSheet.getSheetName(), zTableOffset, periodBias});
                continue;
            }
            this.setCellTypeToString((Cell)periodLabelCell);
            int zLabelCol = zTableOffset + sheetModel.getTableWidth() - 1;
            XSSFCell zLabelCell = labelsRow.getCell(zLabelCol);
            if (zLabelCell == null) {
                log.info("zLabelCell #{} is null, sheet {}, col {}: row {}", new Object[]{z, xlsxSheet.getSheetName(), zLabelCol, periodBias});
                continue;
            }
            this.setCellTypeToString((Cell)zLabelCell);
            int FINAL_LEFT_HEADER_WIDTH = leftHeaderWidth;
            IntStream.range(0, yLevelsUnwinded.size()).forEach(yIndex -> {
                YLevel yLevel = (YLevel)yLevelsUnwinded.get(yIndex);
                int excelRowNum = periodBias + yIndex + 1 + sheetModel.getTopHeaderHeight() + 1;
                XSSFRow xlsRow = xlsxSheet.getRow(excelRowNum);
                if (xlsRow != null) {
                    IntStream.range(FINAL_LEFT_HEADER_WIDTH, FINAL_LEFT_HEADER_WIDTH == 1 ? columnLeaves.length : columnLeaves.length + FINAL_LEFT_HEADER_WIDTH - 1).forEach(xIndex -> {
                        int excelColNum = zTableOffset + xIndex;
                        int columnIndex = FINAL_LEFT_HEADER_WIDTH == 1 ? xIndex : xIndex - FINAL_LEFT_HEADER_WIDTH + 1;
                        ColumnHeader columnHeader = columnLeaves[columnIndex];
                        AspectCellData aspectCellData = new AspectCellData();
                        aspectCellData.setAspectDataList(new ArrayList());
                        aspectCellData.getAspectDataList().addAll(periodLevel.getAspectDataList());
                        aspectCellData.getAspectDataList().addAll(zLevel.getAspectDataList());
                        aspectCellData.getAspectDataList().addAll(yLevel.getFullAspectDataList());
                        aspectCellData.getAspectDataList().addAll(columnHeader.getFullAspectDataList());
                        XSSFCell cell = xlsRow.getCell(excelColNum);
                        aspectCellData.setMerged(mergedRegions.stream().anyMatch(arg_0 -> this.lambda$null$22((Cell)cell, arg_0)));
                        this.setCellTypeToString((Cell)cell);
                        String cellValue = cell != null ? cell.getStringCellValue() : null;
                        AspectData concept = aspectCellData.getConcept();
                        if (StringUtils.isNotBlank((CharSequence)cellValue) && concept != null && sheetModel.getEnumerations().containsKey(concept.getAspectValue())) {
                            Optional enumerateItemOptional = XslxSheet.getEnumeratedFactValueByLabel((Map)sheetModel.getEnumerations(), (String)cellValue, (String)concept.getAspectValue());
                            if (!enumerateItemOptional.isPresent()) {
                                log.warn("Enumeration value not present, role {}, conceptName {}, factValue {}", new Object[]{sheetModel.getTlbUiModel().getLabel(), concept.getLabel(), cellValue});
                            }
                            String enumValue = enumerateItemOptional.isPresent() ? ((EnumerateItem)enumerateItemOptional.get()).getMember() : cellValue;
                            aspectCellData.setCellValue(enumValue);
                        } else {
                            aspectCellData.setCellValue(cellValue);
                        }
                        CellReference cellReference = new CellReference(excelRowNum, excelColNum, false, false);
                        aspectCellData.setAddress(cellReference.formatAsString());
                        if (StringUtils.isNotBlank((CharSequence)aspectCellData.getCellValue())) {
                            editedCells.add(aspectCellData);
                        }
                    });
                }
            });
        }
        return editedCells;
    }

    private int getLevel(DimensionValuePair dimensionValuePair) {
        String value = dimensionValuePair.getValue();
        return (value.length() - value.trim().length()) / 6;
    }

    private void setCellTypeToString(Cell cell) {
        if (cell == null) {
            return;
        }
        cell.setCellType(1);
    }

    private /* synthetic */ boolean lambda$null$22(Cell cell, CellRangeAddress region) {
        return this.isRegionContainsCell(region, cell);
    }

    private /* synthetic */ boolean lambda$null$19(Cell cell, CellRangeAddress region) {
        return this.isRegionContainsCell(region, cell);
    }
}

