/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.csv;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.ContextCsvDuplicateException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.UnitCsvDuplicateException;
import ru.cbr.xbrl.converter.exception.XbrlExportException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.model.validation.CsvLineInfo;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.utils.FileUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvCommon;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvFileSet;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvToXmlConverter;
import ru.cbr.xbrl.converter.xbrl.import_export.xml.XbrlXmlWriter;

/*
 * Exception performing whole class analysis ignored.
 */
public class CsvToXmlConverter {
    private static final Logger log = LoggerFactory.getLogger(CsvToXmlConverter.class);

    public static String convertToTemp(CsvFileSet csvInputFileSet, String pathToXsd, List<ConfigProperties.Namespace> namespaces, Consumer<ImportCsvEvent> importCsvEventConsumer, Consumer<CsvLineInfo> csvLineInfoConsumer, BiFunction<String, CsvCommon.CSV_SOURCE_FILES, CsvLineInfo> getCsvLineInfo, BiFunction<XbrlValue, Integer, Boolean> validateXbrlValue, Supplier<String> getCurrentVersion) throws XbrlImportException, XbrlExportException, ContextCsvDuplicateException, UnitCsvDuplicateException {
        String tempFileName = FileUtils.getTempFileName((String)".importedfromcsv.xml");
        CsvToXmlConverter.convert((CsvFileSet)csvInputFileSet, (String)tempFileName, (String)pathToXsd, namespaces, importCsvEventConsumer, csvLineInfoConsumer, getCsvLineInfo, validateXbrlValue, getCurrentVersion);
        return tempFileName;
    }

    public static void convert(CsvFileSet csvInputFileSet, String xbrlOutputFileName, String pathToXsd, List<ConfigProperties.Namespace> namespaces, Consumer<ImportCsvEvent> importCsvEventConsumer, Consumer<CsvLineInfo> csvLineInfoConsumer, BiFunction<String, CsvCommon.CSV_SOURCE_FILES, CsvLineInfo> getCsvLineInfo, BiFunction<XbrlValue, Integer, Boolean> validateXbrlValue, Supplier<String> getCurrentVersion) throws XbrlImportException, XbrlExportException, ContextCsvDuplicateException, UnitCsvDuplicateException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(xbrlOutputFileName));){
            CsvToXmlConverter.convert((CsvFileSet)csvInputFileSet, (OutputStream)outputStream, (String)pathToXsd, namespaces, importCsvEventConsumer, csvLineInfoConsumer, getCsvLineInfo, validateXbrlValue, getCurrentVersion);
        }
        catch (FileNotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
        catch (NotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
        catch (XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static void convert(CsvFileSet csvFileSet, OutputStream outputStream, String pathToXsd, List<ConfigProperties.Namespace> namespaces, Consumer<ImportCsvEvent> importCsvEventConsumer, Consumer<CsvLineInfo> csvLineInfoConsumer, BiFunction<String, CsvCommon.CSV_SOURCE_FILES, CsvLineInfo> getCsvLineInfo, BiFunction<XbrlValue, Integer, Boolean> validateXbrlValue, Supplier<String> getCurrentVersion) throws XbrlImportException, NotFoundException, IOException, XMLStreamException, XbrlExportException, ContextCsvDuplicateException, UnitCsvDuplicateException {
        Date start = new Date();
        XbrlXmlWriter xbrlXmlWriter = new XbrlXmlWriter(outputStream, namespaces, pathToXsd);
        xbrlXmlWriter.prepare(getCurrentVersion);
        AtomicBoolean isFirstFootnoteProcessed = new AtomicBoolean(false);
        HashMap existingFootnoteFactMap = new HashMap();
        new /* Unavailable Anonymous Inner Class!! */;
        if (isFirstFootnoteProcessed.get()) {
            xbrlXmlWriter.writeFootnoteEndTag();
        }
        xbrlXmlWriter.finalize();
        log.info("CSV converted to xbrl in {} msec", (Object)(new Date().getTime() - start.getTime()));
    }

    private static void checkBlank(Object getContent, String content) {
    }

    private static String buildErrorMessage(String fullFileName, String field) {
        String fileName = FilenameUtils.getName((String)fullFileName);
        String template = "\u0412 \u0448\u0430\u0431\u043b\u043e\u043d\u0435 %s \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u043e\u043b\u0435 %s";
        return String.format(template, fileName, field);
    }

    private static CsvLineInfo buildCsvLineInfo(CsvCommon.CSV_SOURCE_FILES sourceFile, Integer lineNumber, String csvId, String contextId) {
        CsvLineInfo csvLineInfo = new CsvLineInfo();
        csvLineInfo.setCsvType(sourceFile);
        csvLineInfo.setCsvId(csvId);
        csvLineInfo.setLineNumber(lineNumber);
        if (sourceFile.equals((Object)CsvCommon.CSV_SOURCE_FILES.VALUES)) {
            csvLineInfo.setContextId(contextId);
        }
        CsvLineInfoId csvLineInfoId = new CsvLineInfoId();
        csvLineInfoId.setCsvId(csvId);
        csvLineInfoId.setSourceFile(sourceFile);
        return csvLineInfo;
    }

    private CsvToXmlConverter() {
    }

    static /* synthetic */ String access$000(String x0, String x1) {
        return CsvToXmlConverter.buildErrorMessage((String)x0, (String)x1);
    }

    static /* synthetic */ CsvLineInfo access$100(CsvCommon.CSV_SOURCE_FILES x0, Integer x1, String x2, String x3) {
        return CsvToXmlConverter.buildCsvLineInfo((CsvCommon.CSV_SOURCE_FILES)x0, (Integer)x1, (String)x2, (String)x3);
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }
}

