/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.csv;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvFileSet;

public class CsvFileSet {
    private String directory;
    public static String CONTEXT_CSV = "Contexts.csv";
    public static String UNITS_CSV = "Units.csv";
    public static String VALUES_CSV = "Values.csv";
    public static String FOOTNOTES_CSV = "Footnotes.csv";
    private String contextsPath;
    private String unitsPath;
    private String valuesPath;
    private String footnotesPath;

    public CsvFileSet(String contextsPath, String unitsPath, String valuesPath, String footnotesPath, CsvFileSetDataType csvFileSetDataType) {
        if (StringUtils.isBlank((CharSequence)footnotesPath) || StringUtils.equalsIgnoreCase((CharSequence)footnotesPath, (CharSequence)"null")) {
            footnotesPath = null;
        }
        if (csvFileSetDataType.equals((Object)CsvFileSetDataType.DIRECTORIES_ONLY)) {
            this.contextsPath = FilenameUtils.concat((String)contextsPath, (String)CONTEXT_CSV);
            this.unitsPath = FilenameUtils.concat((String)unitsPath, (String)UNITS_CSV);
            this.valuesPath = FilenameUtils.concat((String)valuesPath, (String)VALUES_CSV);
            this.footnotesPath = footnotesPath == null ? null : FilenameUtils.concat((String)footnotesPath, (String)FOOTNOTES_CSV);
        } else {
            this.contextsPath = contextsPath;
            this.unitsPath = unitsPath;
            this.valuesPath = valuesPath;
            this.footnotesPath = footnotesPath;
        }
    }

    public CsvFileSet(String directory) {
        this.directory = directory;
        this.contextsPath = FilenameUtils.concat((String)directory, (String)CONTEXT_CSV);
        this.unitsPath = FilenameUtils.concat((String)directory, (String)UNITS_CSV);
        this.valuesPath = FilenameUtils.concat((String)directory, (String)VALUES_CSV);
        this.footnotesPath = FilenameUtils.concat((String)directory, (String)FOOTNOTES_CSV);
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getContextsPath() {
        return this.contextsPath;
    }

    public String getUnitsPath() {
        return this.unitsPath;
    }

    public String getValuesPath() {
        return this.valuesPath;
    }

    public String getFootnotesPath() {
        return this.footnotesPath;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setContextsPath(String contextsPath) {
        this.contextsPath = contextsPath;
    }

    public void setUnitsPath(String unitsPath) {
        this.unitsPath = unitsPath;
    }

    public void setValuesPath(String valuesPath) {
        this.valuesPath = valuesPath;
    }

    public void setFootnotesPath(String footnotesPath) {
        this.footnotesPath = footnotesPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CsvFileSet)) {
            return false;
        }
        CsvFileSet other = (CsvFileSet)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$directory = this.getDirectory();
        String other$directory = other.getDirectory();
        if (this$directory == null ? other$directory != null : !this$directory.equals(other$directory)) {
            return false;
        }
        String this$contextsPath = this.getContextsPath();
        String other$contextsPath = other.getContextsPath();
        if (this$contextsPath == null ? other$contextsPath != null : !this$contextsPath.equals(other$contextsPath)) {
            return false;
        }
        String this$unitsPath = this.getUnitsPath();
        String other$unitsPath = other.getUnitsPath();
        if (this$unitsPath == null ? other$unitsPath != null : !this$unitsPath.equals(other$unitsPath)) {
            return false;
        }
        String this$valuesPath = this.getValuesPath();
        String other$valuesPath = other.getValuesPath();
        if (this$valuesPath == null ? other$valuesPath != null : !this$valuesPath.equals(other$valuesPath)) {
            return false;
        }
        String this$footnotesPath = this.getFootnotesPath();
        String other$footnotesPath = other.getFootnotesPath();
        return !(this$footnotesPath == null ? other$footnotesPath != null : !this$footnotesPath.equals(other$footnotesPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CsvFileSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $directory = this.getDirectory();
        result = result * 59 + ($directory == null ? 43 : $directory.hashCode());
        String $contextsPath = this.getContextsPath();
        result = result * 59 + ($contextsPath == null ? 43 : $contextsPath.hashCode());
        String $unitsPath = this.getUnitsPath();
        result = result * 59 + ($unitsPath == null ? 43 : $unitsPath.hashCode());
        String $valuesPath = this.getValuesPath();
        result = result * 59 + ($valuesPath == null ? 43 : $valuesPath.hashCode());
        String $footnotesPath = this.getFootnotesPath();
        result = result * 59 + ($footnotesPath == null ? 43 : $footnotesPath.hashCode());
        return result;
    }

    public String toString() {
        return "CsvFileSet(directory=" + this.getDirectory() + ", contextsPath=" + this.getContextsPath() + ", unitsPath=" + this.getUnitsPath() + ", valuesPath=" + this.getValuesPath() + ", footnotesPath=" + this.getFootnotesPath() + ")";
    }

    public CsvFileSet() {
    }
}

