/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;

/*
 * Exception performing whole class analysis ignored.
 */
public class AspectUtils {
    private static final Logger log = LoggerFactory.getLogger(AspectUtils.class);
    public static final HashSet<String> PERIODS = new HashSet();
    public static final String PERIOD_TYPE = "period type";
    public static final String PERIOD_START = "period start";
    public static final String PERIOD_END = "period end";
    public static final String PERIOD_INSTANT = "period instant";
    public static final String DURATION = "duration";
    public static final String PERIOD_START_TAG_SELECTOR = "PeriodStart";

    public static PeriodDates getDefaultPeriodDates(AspectCellData aspectCellData) {
        return AspectUtils.getDefaultPeriodDates((List)aspectCellData.getAspectDataList());
    }

    public static PeriodDates getDefaultPeriodDates(List<AspectData> aspectDataList) {
        Optional<AspectData> periodAspect = aspectDataList.stream().filter(a -> a.getType() != null).filter(a -> a.getType().equals((Object)AspectType.PERIOD)).reduce((a, b) -> b);
        if (periodAspect.isPresent()) {
            return new PeriodDates(periodAspect.get().getAspectValue());
        }
        List aspects = aspectDataList.stream().filter(it -> it.getTag() == null && PERIODS.contains(it.getAspect())).collect(Collectors.toList());
        return AspectUtils.getParamPeriodDates(aspects);
    }

    public static PeriodDates getPeriodDatesForTag(List<AspectData> aspectDataList, String tag) {
        Map<String, List<AspectData>> tagToAsp = aspectDataList.stream().filter(it -> it.getTag() != null).collect(Collectors.groupingBy(AspectData::getTag));
        List<AspectData> aspectDataTag = tagToAsp.get(tag);
        if (aspectDataTag == null) {
            return null;
        }
        return AspectUtils.getParamPeriodDates(aspectDataTag);
    }

    public static PeriodDates getPeriodDatesForConceptOrDefault(List<AspectData> aspectData, AspectData concept, PeriodDates defaultPeriodDates) {
        PeriodDates periodDates = defaultPeriodDates;
        if (concept == null) {
            return periodDates;
        }
        if (concept.getTagSelector() != null) {
            PeriodDates periodDatesForTag = AspectUtils.getPeriodDatesForTag(aspectData, (String)concept.getTagSelector());
            if (periodDatesForTag == null) {
                log.debug("Not fount period date for tag {} and concept {}, trying use default date", (Object)concept.getTagSelector(), (Object)concept.getAspectValue());
            } else {
                log.debug("Found period date for tag {} and concept {}, date {}", new Object[]{concept.getTagSelector(), concept.getAspectValue(), periodDatesForTag.formatDate()});
                periodDates = periodDatesForTag;
            }
        }
        return periodDates;
    }

    public static PeriodDates getPeriodDatesForConcept(List<AspectData> aspectData, AspectData concept) {
        return AspectUtils.getPeriodDatesForConceptOrDefault(aspectData, (AspectData)concept, (PeriodDates)AspectUtils.getDefaultPeriodDates(aspectData));
    }

    public static PeriodDates getParamPeriodDates(List<AspectData> aspectData) {
        HashMap<String, String> aspectsCheckMap = new HashMap<String, String>();
        for (AspectData aspectDataItem : aspectData) {
            if (aspectsCheckMap.containsKey(aspectDataItem.getAspect())) {
                String periodType = (String)aspectsCheckMap.get("period type");
                if (periodType.equals("duration")) {
                    return new PeriodDates((String)aspectsCheckMap.get("period start") + " - " + (String)aspectsCheckMap.get("period end"));
                }
                return new PeriodDates((String)aspectsCheckMap.get("period instant"));
            }
            aspectsCheckMap.put(aspectDataItem.getAspect(), aspectDataItem.getAspectValue());
        }
        Map<String, String> aspects = aspectData.stream().collect(Collectors.toMap(AspectData::getAspect, AspectData::getAspectValue));
        if (aspects.keySet().isEmpty()) {
            return null;
        }
        String periodType = aspects.get("period type");
        if (periodType.equals("duration")) {
            return new PeriodDates(aspects.get("period start") + " - " + aspects.get("period end"));
        }
        return new PeriodDates(aspects.get("period instant"));
    }

    static {
        PERIODS.add("period type");
        PERIODS.add("period start");
        PERIODS.add("period end");
        PERIODS.add("period instant");
    }
}

