/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.tablelinkbase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.model.XbrlDimension;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.filter.FilterViewType;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.AspectNodeMember;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterClosedAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterClosedAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlRoleDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.repository.XbrlContextRepository;
import ru.cbr.xbrl.converter.repository.XbrlDimensionRepository;
import ru.cbr.xbrl.converter.repository.XbrlValueRepository;
import ru.cbr.xbrl.converter.service.TableLinkBaseDynamicStructureService;
import ru.cbr.xbrl.converter.service.XbrlContectValueDTO;
import ru.cbr.xbrl.converter.service.XbrlDimensionService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisMemberService;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisService;
import ru.cbr.xbrl.converter.service.internal.XbrlReportCrudService;
import ru.cbr.xbrl.converter.service.presentation_definition.InactiveMembersService;
import ru.cbr.xbrl.converter.utils.LabelUtils;
import ru.cbr.xbrl.converter.utils.LispStyleUtil;
import ru.cbr.xbrl.converter.utils.MathUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;
import ru.cbr.xbrl.converter.xbrl.import_export.scenario.XbrlContextScenarioParser;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AxisService {
    private static final Logger log = LoggerFactory.getLogger(AxisService.class);
    @Autowired
    private XbrlFilterOpenAxisService xbrlFilterOpenAxisService;
    @Autowired
    private XbrlValueRepository xbrlValueRepository;
    @Autowired
    private XbrlFilterOpenAxisMemberService xbrlFilterOpenAxisMemberService;
    @Autowired
    private XbrlReportCrudService xbrlReportCrudService;
    @Autowired
    private XbrlDimensionRepository xbrlDimensionRepository;
    @Autowired
    private XbrlDimensionService xbrlDimensionService;
    @Autowired
    private InactiveMembersService inactiveMembersService;
    @Autowired
    private XbrlContextRepository xbrlContextRepository;
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private TableLinkBaseDynamicStructureService tableLinkBaseDynamicStructureService;
    private static final String PERIOD = "period";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String Z = "z";
    private static final String GENERATED = "EMPTY_AXIS";
    private Map<String, List<XbrlContectValueDTO>> cachedConcepts = new HashMap();

    public List<FilterOpenAxis> addTypedAxisToRole(Set<AspectData> typedDimensions, XbrlReportRole xbrlReportRole) {
        ArrayList<FilterOpenAxis> typedAxises = new ArrayList<FilterOpenAxis>();
        for (AspectData typedDimension : typedDimensions) {
            List defaultOpenAxis = this.xbrlFilterOpenAxisService.findFilterOpenAxisBySystemId(typedDimension.getAspect());
            Optional first = defaultOpenAxis.stream().findFirst();
            FilterOpenAxis filterOpenAxis = first.orElseGet(() -> {
                FilterOpenAxis newFilterOpenAxis = new FilterOpenAxis();
                newFilterOpenAxis.setTitle(typedDimension.getLabel());
                newFilterOpenAxis.setSystemId(typedDimension.getAspect());
                newFilterOpenAxis.setDomain(typedDimension.getDomain());
                return this.xbrlFilterOpenAxisService.update(newFilterOpenAxis);
            });
            XbrlRoleDimension xbrlRoleDimension = new XbrlRoleDimension();
            xbrlRoleDimension.setFilterOpenAxis(filterOpenAxis);
            xbrlRoleDimension.setXbrlReportRole(xbrlReportRole);
            xbrlRoleDimension.setDimensionType(DimensionType.TYPED_MEMBER);
            filterOpenAxis.getXbrlRoleDimensionList().add(xbrlRoleDimension);
            typedAxises.add(this.xbrlFilterOpenAxisService.update(filterOpenAxis));
        }
        return typedAxises;
    }

    public void addExplicitAxisToRole(TableLinkBaseStructure structure, XbrlReportRole xbrlReportRole) {
        Set dimensionsOfAspectNodes = structure.getDimensionsOfAspectNodes();
        dimensionsOfAspectNodes.forEach(dimension -> {
            boolean isExplicitDimension = this.xbrlDimensionService.isExplicitDimension(dimension);
            if (isExplicitDimension) {
                XbrlRoleDimension xbrlRoleDimension = new XbrlRoleDimension();
                xbrlRoleDimension.setDimensionType(DimensionType.EXPLICIT_MEMBER);
                xbrlRoleDimension.setDimension(dimension);
                xbrlRoleDimension.setXbrlReportRole(xbrlReportRole);
                xbrlReportRole.getXbrlRoleDimensionList().add(xbrlRoleDimension);
            }
        });
    }

    public List<FilterAxis> fillFilterAxisList(String roleSystemId, List<XbrlRoleDimension> xbrlRoleDimensionList) {
        List<FilterAxis> filterAxisList = xbrlRoleDimensionList.stream().map(d -> {
            if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                FilterOpenAxis filterOpenAxis = d.getFilterOpenAxis();
                filterOpenAxis.getAxisMemberList().forEach(filterOpenAxisValue -> {
                    boolean isActive = !this.inactiveMembersService.isInactiveOpenMember(roleSystemId, filterOpenAxisValue.getId(), FilterViewType.TABLELINKBASE);
                    filterOpenAxisValue.setActive(Boolean.valueOf(isActive));
                });
                return filterOpenAxis;
            }
            FilterClosedAxis filterClosedAxis = new FilterClosedAxis();
            List members = this.xbrlDimensionService.findMembers(d.getDimension());
            if (!members.isEmpty()) {
                filterClosedAxis.setTitle(((XbrlDimension)members.get(0)).getDimIntLabel());
                filterClosedAxis.setSystemId(d.getDimension());
                members.forEach(xbrlDimension -> {
                    FilterClosedAxisValue filterClosedAxisValue = new FilterClosedAxisValue();
                    filterClosedAxisValue.setValue(xbrlDimension.getMemIntLabel());
                    String memInt = xbrlDimension.getMemInt();
                    filterClosedAxisValue.setMember(memInt);
                    boolean isActive = !this.inactiveMembersService.isInactiveClosedMember(roleSystemId, d.getDimension(), memInt, FilterViewType.TABLELINKBASE);
                    filterClosedAxisValue.setActive(Boolean.valueOf(isActive));
                    filterClosedAxis.getAxisMemberList().add(filterClosedAxisValue);
                });
            }
            return filterClosedAxis;
        }).collect(Collectors.toList());
        return filterAxisList;
    }

    public void fillAspectNodeMembers(TableLinkBaseStructure structure, XbrlReportRole xbrlReportRole, List<FilterOpenAxis> filterOpenAxes, Map<String, List<XbrlContextDimension>> cacheContextDimensions, List<XbrlContext> usedContext, Boolean onlyWithData) {
        this.cachedConcepts = new HashMap();
        ArrayList aspectNodes = new ArrayList();
        this.processAspectNodes(structure.getXAxis(), aspectNodes);
        this.processAspectNodes(structure.getYAxis(), aspectNodes);
        this.processAspectNodes(structure.getZAxis(), aspectNodes);
        if (aspectNodes.isEmpty()) {
            return;
        }
        HashMap contextsByTypedValues = new HashMap();
        for (XbrlContext c : usedContext) {
            for (XbrlContextDimension d : c.getXbrlContextDimensions()) {
                Set<XbrlContext> ctxs;
                if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                    if (contextsByTypedValues.containsKey(d.getDomainValue())) {
                        ctxs = (Set)contextsByTypedValues.get(d.getDomainValue());
                    } else {
                        ctxs = new HashSet();
                        contextsByTypedValues.put(d.getDomainValue(), ctxs);
                    }
                    ctxs.add(c);
                    continue;
                }
                if (contextsByTypedValues.containsKey(d.getMember())) {
                    ctxs = (Set)contextsByTypedValues.get(d.getMember());
                } else {
                    ctxs = new HashSet();
                    contextsByTypedValues.put(d.getMember(), ctxs);
                }
                ctxs.add(c);
            }
        }
        structure.setXAxis((AxisMemberHierarchy)LispStyleUtil.car((List)this.fillDynamicData(structure.getXAxis(), filterOpenAxes, cacheContextDimensions, contextsByTypedValues, new Stack(), new Stack(), null)));
        List yStructure = this.fillDynamicData(structure.getYAxis(), filterOpenAxes, cacheContextDimensions, contextsByTypedValues, new Stack(), new Stack(), null);
        structure.setYAxis((AxisMemberHierarchy)LispStyleUtil.car((List)yStructure));
        structure.setZAxis((AxisMemberHierarchy)LispStyleUtil.car((List)this.createFilledAxis(structure.getZAxis(), cacheContextDimensions)));
        this.fillDates(structure, xbrlReportRole);
        Set axisesHasValue = this.calculateAspectNodeMembers(structure);
        HashMap cachedClosedMembers = new HashMap();
        if (!axisesHasValue.isEmpty()) {
            this.createMembersForAxis(structure.getXAxis(), null, xbrlReportRole, filterOpenAxes, axisesHasValue, cachedClosedMembers, onlyWithData);
            this.createMembersForAxis(structure.getYAxis(), null, xbrlReportRole, filterOpenAxes, axisesHasValue, cachedClosedMembers, onlyWithData);
        }
        this.createMembersForZ(structure.getZAxis(), filterOpenAxes);
    }

    private void createMembersForZ(AxisMemberHierarchy zAxis, List<FilterOpenAxis> filterOpenAxes) {
        List typedAspects = zAxis.getAspectDataList().stream().filter(it -> it.getType() == AspectType.DIMENSION && it.getDimensionType() == DimensionType.TYPED_MEMBER).collect(Collectors.toList());
        for (AspectData aspectData : typedAspects) {
            FilterOpenAxis filterOpenAxis;
            Optional<FilterOpenAxisValue> firstMember;
            Optional<FilterOpenAxis> filterOpenAxisList = filterOpenAxes.stream().filter(it -> it.getSystemId().equals(aspectData.getAspect())).findFirst();
            if (!filterOpenAxisList.isPresent()) {
                System.out.println("ERROR");
            }
            if ((firstMember = (filterOpenAxis = filterOpenAxisList.get()).getAxisMemberList().stream().filter(it -> it.getValue().equals(aspectData.getAspectValue())).findFirst()).isPresent()) continue;
            FilterOpenAxisValue newMember = new FilterOpenAxisValue();
            newMember.setFilterOpenAxis(filterOpenAxis);
            newMember.setValue(aspectData.getAspectValue());
            newMember = this.xbrlFilterOpenAxisMemberService.update(newMember);
            filterOpenAxis.getAxisMemberList().add(newMember);
        }
        for (AxisMemberHierarchy axisMemberHierarchy : zAxis.getAxisMemberHierarchyList()) {
            this.createMembersForZ(axisMemberHierarchy, filterOpenAxes);
        }
    }

    private void createMembersForAxis(AxisMemberHierarchy axis, AxisMemberHierarchy parent, XbrlReportRole xbrlReportRole, List<FilterOpenAxis> filterOpenAxes, Set<String> axisesHasValue, HashMap<String, List<XbrlDimension>> cachedClosedMembers, Boolean onlyWithData) {
        Optional<AspectData> first;
        if (axis.getNodeType() == NodeType.ASPECT && (!onlyWithData.booleanValue() || axisesHasValue.contains(axis.getId())) && (first = axis.getAspectDataList().stream().filter(it -> it.getType() == AspectType.DIMENSION).findFirst()).isPresent()) {
            AspectData aspectData = first.get();
            this.addOpenMemberToRole(aspectData, axis.getId(), parent.getId(), xbrlReportRole, filterOpenAxes, cachedClosedMembers);
        }
        for (AxisMemberHierarchy axisMemberHierarchy : axis.getAxisMemberHierarchyList()) {
            this.createMembersForAxis(axisMemberHierarchy, axis, xbrlReportRole, filterOpenAxes, axisesHasValue, cachedClosedMembers, onlyWithData);
        }
    }

    private void addOpenMemberToRole(AspectData aspectData, String commonId, String hash, XbrlReportRole xbrlReportRole, List<FilterOpenAxis> filterOpenAxes, HashMap<String, List<XbrlDimension>> cachedClosedMembers) {
        if (aspectData.getDimensionType() == DimensionType.TYPED_MEMBER) {
            FilterOpenAxisValue target;
            FilterOpenAxis filterOpenAxis;
            Optional<FilterOpenAxisValue> first;
            Optional<FilterOpenAxis> filterOpenAxisList = filterOpenAxes.stream().filter(it -> it.getSystemId().equals(aspectData.getAspect())).findFirst();
            if (!filterOpenAxisList.isPresent()) {
                System.out.println("ERROR");
            }
            if ((first = (filterOpenAxis = filterOpenAxisList.get()).getAxisMemberList().stream().filter(it -> it.getValue().equals(aspectData.getAspectValue())).findFirst()).isPresent()) {
                target = first.get();
            } else {
                target = new FilterOpenAxisValue();
                target.setFilterOpenAxis(filterOpenAxis);
                target.setValue(aspectData.getAspectValue());
                target = this.xbrlFilterOpenAxisMemberService.update(target);
                filterOpenAxis.getAxisMemberList().add(target);
            }
            AspectNodeMember aspectNodeMember = new AspectNodeMember();
            aspectNodeMember.setXbrlReportRole(xbrlReportRole);
            aspectNodeMember.setFilterOpenAxisValue(target);
            aspectNodeMember.setDimension(aspectData.getAspect());
            aspectNodeMember.setHash(hash);
            aspectNodeMember.setCommonId(commonId);
            FilterOpenAxisValue finalTarget = target;
            Optional<AspectNodeMember> existing = xbrlReportRole.getAspectNodeMembers().stream().filter(exist -> exist.getXbrlReportRole().equals((Object)xbrlReportRole) && exist.getFilterOpenAxisValue() != null && exist.getFilterOpenAxisValue().getId().equals(finalTarget.getId()) && exist.getDimension().equals(aspectData.getAspect()) && exist.getHash().equals(hash)).findAny();
            if (!existing.isPresent()) {
                xbrlReportRole.getAspectNodeMembers().add(aspectNodeMember);
                this.xbrlReportCrudService.updateXbrlReportRole(xbrlReportRole);
            }
        } else {
            Optional<XbrlDimension> targetMember;
            AspectNodeMember aspectNodeMember = new AspectNodeMember();
            aspectNodeMember.setXbrlReportRole(xbrlReportRole);
            List xbrlDimensions = cachedClosedMembers.get(aspectData.getAspect());
            if (xbrlDimensions == null) {
                xbrlDimensions = this.xbrlDimensionRepository.findAllByDimInt(aspectData.getAspect());
                cachedClosedMembers.put(aspectData.getAspect(), xbrlDimensions);
            }
            String label = aspectData.getAspectValue();
            if (xbrlDimensions != null && (targetMember = xbrlDimensions.stream().filter(it -> it.getMemInt().equals(aspectData.getAspectValue())).findFirst()).isPresent()) {
                label = targetMember.get().getMemIntLabel();
            }
            aspectNodeMember.setClosedMemberLabel(label);
            aspectNodeMember.setClosedMemberValue(aspectData.getAspectValue());
            aspectNodeMember.setDimension(aspectData.getAspect());
            aspectNodeMember.setHash(hash);
            aspectNodeMember.setCommonId(commonId);
            Optional<AspectNodeMember> existing = xbrlReportRole.getAspectNodeMembers().stream().filter(exist -> exist.getXbrlReportRole().equals((Object)xbrlReportRole) && exist.getClosedMemberValue() != null && exist.getClosedMemberValue().equals(aspectData.getAspectValue()) && exist.getDimension().equals(aspectData.getAspect()) && exist.getHash().equals(hash)).findAny();
            if (!existing.isPresent()) {
                xbrlReportRole.getAspectNodeMembers().add(aspectNodeMember);
                this.xbrlReportCrudService.updateXbrlReportRole(xbrlReportRole);
            }
        }
    }

    private Set<String> calculateAspectNodeMembers(TableLinkBaseStructure structure) {
        HashSet<String> axisesHasValue = new HashSet<String>();
        for (AxisMemberHierarchy zAxisMemberHierarchy : structure.getZAxis().getAxisMemberHierarchyList()) {
            HashMap flatY = new HashMap();
            HashMap flatX = new HashMap();
            this.flattenAspects(structure.getYAxis(), new ArrayList(), flatY);
            this.flattenAspects(structure.getXAxis(), new ArrayList(), flatX);
            HashMap flatYId = new HashMap();
            HashMap flatXId = new HashMap();
            this.flattenIds(structure.getYAxis(), new ArrayList(), flatYId);
            this.flattenIds(structure.getXAxis(), new ArrayList(), flatXId);
            for (AxisMemberHierarchy yItem : structure.getYAxis().getAxisMemberHierarchyList()) {
                this.calculateByFact(yItem, flatX, flatY, zAxisMemberHierarchy.getAspectDataList(), structure.getDimensionsDefault(), axisesHasValue, flatXId, flatYId);
            }
        }
        return axisesHasValue;
    }

    private void calculateByFact(AxisMemberHierarchy yItem, Map<String, List<AspectData>> flatX, Map<String, List<AspectData>> flatY, List<AspectData> zAspectData, Map<String, String> dimensionsDefault, Set<String> axisesHasValue, Map<String, List<String>> flatXId, Map<String, List<String>> flatYId) {
        for (String xKey : flatX.keySet()) {
            List<AspectData> yAspectData;
            ArrayList<AspectData> all = new ArrayList<AspectData>();
            List<AspectData> xAspectData = flatX.get(xKey);
            if (xAspectData != null) {
                all.addAll(xAspectData);
            }
            if ((yAspectData = flatY.get(yItem.getId())) != null) {
                all.addAll(yAspectData);
            }
            if (!zAspectData.isEmpty()) {
                all.addAll(zAspectData);
            }
            AspectCellData aspectCellData = new AspectCellData();
            aspectCellData.setAspectDataList(all);
            AspectData concept = aspectCellData.getConcept();
            if (concept == null || concept.isAbstractNode()) continue;
            List byElementName = (List)this.cachedConcepts.get(concept.getAspectValue());
            if (byElementName == null) {
                byElementName = this.xbrlValueRepository.findByXbrlValueIdElementLabel(concept.getAspectValue());
                this.cachedConcepts.put(concept.getAspectValue(), byElementName);
            }
            List dimensions = aspectCellData.getDimensions();
            List dimensionsWithoutDefaults = XbrlContextDimension.removeDefaultDimensions((List)dimensions, dimensionsDefault);
            List xbrlContextDimensions = dimensionsWithoutDefaults.stream().map(d -> {
                if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                    return new XbrlContextDimension(d.getAspect(), d.getDomain(), d.getAspectValue());
                }
                return new XbrlContextDimension(d.getAspect(), d.getAspectValue());
            }).collect(Collectors.toList());
            String dimensionsHash = XbrlContextDimension.dimensionToHash(xbrlContextDimensions);
            for (XbrlContectValueDTO xbrlContectValueDTO : byElementName) {
                if (!dimensionsHash.equals(xbrlContectValueDTO.getDimensionsHash())) continue;
                axisesHasValue.addAll((Collection<String>)flatXId.get(xKey));
                axisesHasValue.addAll((Collection<String>)flatYId.get(yItem.getId()));
            }
        }
        for (AxisMemberHierarchy axisMemberHierarchy : yItem.getAxisMemberHierarchyList()) {
            this.calculateByFact(axisMemberHierarchy, flatX, flatY, zAspectData, dimensionsDefault, axisesHasValue, flatXId, flatYId);
        }
    }

    public List<AxisMemberHierarchy> createFilledAxis(AxisMemberHierarchy original, Map<String, List<XbrlContextDimension>> cacheContextDimensions) {
        ArrayList<AxisMemberHierarchy> filled = new ArrayList<AxisMemberHierarchy>();
        List typedAspects = original.getAspectDataList().stream().filter(it -> it.getType() == AspectType.DIMENSION && it.getDimensionType() == DimensionType.TYPED_MEMBER).collect(Collectors.toList());
        if (typedAspects.isEmpty()) {
            AxisMemberHierarchy newSimpleAxisMemberHierarchy = new AxisMemberHierarchy();
            newSimpleAxisMemberHierarchy.setAxis(original.getAxis());
            if ("title".equals(original.getId())) {
                newSimpleAxisMemberHierarchy.setId("title");
            } else {
                newSimpleAxisMemberHierarchy.setId(UUID.randomUUID().toString());
            }
            newSimpleAxisMemberHierarchy.setAspectDataList(original.getAspectDataList());
            newSimpleAxisMemberHierarchy.setLabel(LabelUtils.calcLabel((List)newSimpleAxisMemberHierarchy.getAspectDataList(), (String)original.getLabel()));
            filled.add(newSimpleAxisMemberHierarchy);
        } else {
            ArrayList<List<XbrlContextDimension>> values = new ArrayList<List<XbrlContextDimension>>();
            for (AspectData effectiveAspect : typedAspects) {
                List<XbrlContextDimension> value = cacheContextDimensions.get(effectiveAspect.getAspect());
                if (value == null || value.isEmpty()) continue;
                values.add(value);
            }
            List cartesian = MathUtils.cartesianProduct(values);
            for (List filterOpenAxisValues : cartesian) {
                AxisMemberHierarchy newTypedAxisMemberHierarchy = new AxisMemberHierarchy();
                newTypedAxisMemberHierarchy.setAxis(original.getAxis());
                newTypedAxisMemberHierarchy.setId(UUID.randomUUID().toString());
                for (XbrlContextDimension xbrlContextDimension : filterOpenAxisValues) {
                    AspectData newAspectData = new AspectData();
                    newAspectData.setAspect(xbrlContextDimension.getDimension());
                    if (xbrlContextDimension.getDimensionType() == DimensionType.TYPED_MEMBER) {
                        newAspectData.setAspectValue(xbrlContextDimension.getDomainValue());
                    } else {
                        newAspectData.setAspectValue(xbrlContextDimension.getMember());
                    }
                    newAspectData.setType(AspectType.DIMENSION);
                    newAspectData.setDimensionType(xbrlContextDimension.getDimensionType());
                    newAspectData.setDomain(xbrlContextDimension.getDomain());
                    newTypedAxisMemberHierarchy.getAspectDataList().add(newAspectData);
                }
                newTypedAxisMemberHierarchy.setLabel(LabelUtils.calcLabel((List)newTypedAxisMemberHierarchy.getAspectDataList(), null));
                filled.add(newTypedAxisMemberHierarchy);
            }
        }
        for (AxisMemberHierarchy originalChild : original.getAxisMemberHierarchyList()) {
            filled.forEach(it -> it.getAxisMemberHierarchyList().addAll(this.createFilledAxis(originalChild, cacheContextDimensions)));
        }
        return filled;
    }

    private Boolean IsContextPathExist(AxisMemberHierarchy newItem, Map<String, Set<XbrlContext>> contextsByTypedValues, Stack<AxisMemberHierarchy> axisMemberValueStack) {
        List<Object> pathToCheck = new ArrayList<AxisMemberHierarchy>(axisMemberValueStack);
        if ((pathToCheck = pathToCheck.stream().filter(x -> x.getNodeType() == NodeType.ASPECT).collect(Collectors.toList())).size() == 0) {
            return true;
        }
        AspectData firstData = (AspectData)newItem.getAspectDataList().get(0);
        if (!contextsByTypedValues.containsKey(firstData.getAspectValue())) {
            return false;
        }
        Set<XbrlContext> availContext = contextsByTypedValues.get(firstData.getAspectValue());
        for (XbrlContext c : availContext) {
            Boolean pathFound = true;
            for (AxisMemberHierarchy axisMemberHierarchy : pathToCheck) {
                AspectData pData = (AspectData)axisMemberHierarchy.getAspectDataList().get(0);
                Optional<XbrlContextDimension> found = c.getXbrlContextDimensions().stream().filter(d -> d.equalsWithAspectData(pData)).findAny();
                if (found.isPresent()) continue;
                pathFound = false;
                break;
            }
            if (!pathFound.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private List<AxisMemberHierarchy> fillDynamicData(AxisMemberHierarchy original, List<FilterOpenAxis> filterOpenAxes, Map<String, List<XbrlContextDimension>> cacheContextDimensions, Map<String, Set<XbrlContext>> contextsByTypedValues, Stack<AxisMemberHierarchy> axisMemberHierarchyStack, Stack<AxisMemberHierarchy> axisMemberValueStack, String parentId) {
        AspectData aspectData;
        List<XbrlContextDimension> xbrlContextDimensions;
        Optional<AspectData> first;
        ArrayList<AxisMemberHierarchy> filled = new ArrayList<AxisMemberHierarchy>();
        if (original.getNodeType() == NodeType.RULE) {
            AxisMemberHierarchy newSimpleAxisMemberHierarchy = new AxisMemberHierarchy();
            newSimpleAxisMemberHierarchy.setAxis(original.getAxis());
            newSimpleAxisMemberHierarchy.setId(original.getId());
            newSimpleAxisMemberHierarchy.setAspectDataList(original.getAspectDataList());
            newSimpleAxisMemberHierarchy.setDefinitionNodeId(original.getDefinitionNodeId());
            newSimpleAxisMemberHierarchy.setParentDefinitionNodeId(original.getParentDefinitionNodeId());
            filled.add(newSimpleAxisMemberHierarchy);
        } else if (original.getNodeType() == NodeType.ASPECT && (first = original.getAspectDataList().stream().filter(it -> it.getType() == AspectType.DIMENSION).findFirst()).isPresent() && (xbrlContextDimensions = cacheContextDimensions.get((aspectData = first.get()).getAspect())) != null) {
            for (XbrlContextDimension xbrlContextDimension : xbrlContextDimensions) {
                String axisValueId;
                Optional<FilterOpenAxis> filterOpenAxisList = filterOpenAxes.stream().filter(it -> it.getSystemId().equals(aspectData.getAspect())).findFirst();
                AxisMemberHierarchy newOpenAxisMemberHierarchy = new AxisMemberHierarchy();
                newOpenAxisMemberHierarchy.setAxis(original.getAxis());
                newOpenAxisMemberHierarchy.setNodeType(NodeType.ASPECT);
                newOpenAxisMemberHierarchy.setDefinitionNodeId(original.getDefinitionNodeId());
                newOpenAxisMemberHierarchy.setParentDefinitionNodeId(original.getParentDefinitionNodeId());
                AspectData newAspectData = new AspectData();
                newAspectData.setAspect(xbrlContextDimension.getDimension());
                if (xbrlContextDimension.getDimensionType() == DimensionType.TYPED_MEMBER) {
                    newAspectData.setAspectValue(xbrlContextDimension.getDomainValue());
                    FilterOpenAxis filterOpenAxis = filterOpenAxisList.get();
                    axisValueId = filterOpenAxis.findValue(newAspectData.getAspectValue()).isPresent() ? ((FilterOpenAxisValue)filterOpenAxis.findValue(newAspectData.getAspectValue()).get()).getValue() : newAspectData.getAspectValue();
                    axisValueId = DigestUtils.md5Hex((String)axisValueId);
                } else {
                    newAspectData.setAspectValue(xbrlContextDimension.getMember());
                    axisValueId = xbrlContextDimension.getMember();
                }
                String naturalId = original.getDefinitionNodeId() + "#" + newAspectData.getAspect() + "#" + axisValueId;
                if (parentId != null) {
                    naturalId = parentId + "#" + naturalId;
                }
                newOpenAxisMemberHierarchy.setId(naturalId);
                newAspectData.setType(AspectType.DIMENSION);
                newAspectData.setDimensionType(xbrlContextDimension.getDimensionType());
                newAspectData.setDomain(xbrlContextDimension.getDomain());
                newOpenAxisMemberHierarchy.getAspectDataList().add(newAspectData);
                if (!this.IsContextPathExist(newOpenAxisMemberHierarchy, contextsByTypedValues, axisMemberValueStack).booleanValue()) continue;
                filled.add(newOpenAxisMemberHierarchy);
            }
        }
        for (AxisMemberHierarchy originalChild : original.getAxisMemberHierarchyList()) {
            axisMemberHierarchyStack.push(originalChild);
            for (AxisMemberHierarchy v : filled) {
                axisMemberValueStack.push(v);
                v.getAxisMemberHierarchyList().addAll(this.fillDynamicData(originalChild, filterOpenAxes, cacheContextDimensions, contextsByTypedValues, axisMemberHierarchyStack, axisMemberValueStack, v.getId()));
                axisMemberValueStack.pop();
            }
            axisMemberHierarchyStack.pop();
        }
        return filled;
    }

    private void processAspectNodes(AxisMemberHierarchy axis, List<AxisMemberHierarchy> result) {
        if (axis.getNodeType() == NodeType.ASPECT) {
            result.add(axis);
        }
        for (AxisMemberHierarchy axisMemberHierarchy : axis.getAxisMemberHierarchyList()) {
            this.processAspectNodes(axisMemberHierarchy, result);
        }
    }

    private void flattenAspects(AxisMemberHierarchy axis, List<AspectData> aspectDataList, Map<String, List<AspectData>> result) {
        ArrayList<AspectData> newList = new ArrayList<AspectData>(aspectDataList);
        if (!axis.getAspectDataList().isEmpty()) {
            newList.addAll(axis.getAspectDataList());
            if (result.containsKey(axis.getId())) {
                result.get(axis.getId()).addAll(newList);
            } else {
                result.put(axis.getId(), newList);
            }
        }
        for (AxisMemberHierarchy child : axis.getAxisMemberHierarchyList()) {
            this.flattenAspects(child, newList, result);
        }
    }

    private void flattenIds(AxisMemberHierarchy axis, List<String> ids, Map<String, List<String>> result) {
        ArrayList<String> newList = new ArrayList<String>(ids);
        newList.add(axis.getId());
        if (result.containsKey(axis.getId())) {
            result.get(axis.getId()).addAll(newList);
        } else {
            result.put(axis.getId(), newList);
        }
        for (AxisMemberHierarchy child : axis.getAxisMemberHierarchyList()) {
            this.flattenIds(child, newList, result);
        }
    }

    public void fillDates(TableLinkBaseStructure structure, XbrlReportRole role) {
        List reportRolePeriodList = role.getXbrlReport().getXbrlPackage().getXbrlPackagePeriodList();
        List activePeriods = reportRolePeriodList.stream().filter(it -> it.getActive() == null || it.getActive() != false).collect(Collectors.toList());
        String periodAxis = structure.getPeriodAxis();
        if (StringUtils.isNotBlank((CharSequence)periodAxis)) {
            AxisMemberHierarchy target;
            HashSet<String> periods = new HashSet<String>();
            periods.add("EMPTY_AXIS");
            structure.setPeriods(periods);
            switch (periodAxis) {
                case "x": {
                    target = structure.getXAxis();
                    break;
                }
                case "y": {
                    target = structure.getYAxis();
                    break;
                }
                case "z": {
                    target = structure.getZAxis();
                    break;
                }
                default: {
                    target = structure.getXAxis();
                }
            }
            for (XbrlPeriod xbrlPeriod : activePeriods) {
                AxisMemberHierarchy currentMemberHierarchy = new AxisMemberHierarchy();
                String period = PeriodDates.from((XbrlPeriod)xbrlPeriod).formatDate();
                currentMemberHierarchy.setAxis(periodAxis);
                currentMemberHierarchy.setLabel(period);
                currentMemberHierarchy.setId(period);
                currentMemberHierarchy.getAspectDataList().add(new AspectData("period", AspectType.forValue((String)"period"), period, null));
                target.getAxisMemberHierarchyList().add(currentMemberHierarchy);
            }
        } else {
            int processed = this.processingParamsPeriods(structure);
            if (processed > 0) {
                HashSet<String> periods = new HashSet<String>();
                periods.add("EMPTY_AXIS");
                structure.setPeriods(periods);
            } else {
                structure.setPeriods(activePeriods.stream().map(it -> PeriodDates.from((XbrlPeriod)it).formatDate()).collect(Collectors.toSet()));
            }
        }
    }

    private int processingParamsPeriods(TableLinkBaseStructure structure) {
        return this.processingMemberParamsPeriods(structure.getXAxis()) + this.processingMemberParamsPeriods(structure.getYAxis()) + this.processingMemberParamsPeriods(structure.getZAxis());
    }

    private int processingMemberParamsPeriods(AxisMemberHierarchy axis) {
        boolean axisHaveParamPeriod;
        int processed = 0;
        if (axis.getAspectDataList() != null && (axisHaveParamPeriod = axis.getAspectDataList().stream().anyMatch(it -> it.getAspect().equals("period type")))) {
            ++processed;
        }
        for (AxisMemberHierarchy axisMemberHierarchy : axis.getAxisMemberHierarchyList()) {
            processed += this.processingMemberParamsPeriods(axisMemberHierarchy);
        }
        return processed;
    }

    public void processAllContexts() {
        Date start = new Date();
        log.info("AxisService process contexts started");
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        List allContexts = this.xbrlContextRepository.findAll();
        List roles = xbrlPackage.getXbrlReport().getXbrlReportRoles();
        long[] maxRoleTime = new long[]{0L};
        roles.forEach(reportRole -> {
            Date d = new Date();
            TableLinkBaseStructure structure = reportRole.unpackTableLinkBaseStructure();
            if (structure.containsAspectNodes()) {
                List roleContext = allContexts.stream().filter(c -> structure.getDimensionsSet().containsAll(c.getDimensionsSet())).collect(Collectors.toList());
                this.processContexts(reportRole, structure, roleContext, Boolean.TRUE);
                long duration = new Date().getTime() - d.getTime();
                if (duration > maxRoleTime[0]) {
                    maxRoleTime[0] = duration;
                }
            }
        });
        log.info("AxisService process contexts complete in {} msec, max role duration is {} msec", (Object)(new Date().getTime() - start.getTime()), (Object)maxRoleTime);
    }

    public void processContexts(List<String> xbrlContextIds) {
        Date start = new Date();
        log.info("AxisService process contexts started");
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        List allContexts = this.xbrlContextRepository.findByXbrlContextId_ContextId(xbrlContextIds);
        List roles = xbrlPackage.getXbrlReport().getXbrlReportRoles();
        long[] maxRoleTime = new long[]{0L};
        roles.forEach(reportRole -> {
            Date d = new Date();
            TableLinkBaseStructure structure = reportRole.unpackTableLinkBaseStructure();
            if (structure.containsAspectNodes()) {
                this.processContexts(reportRole, structure, allContexts, Boolean.FALSE);
                long duration = new Date().getTime() - d.getTime();
                if (duration > maxRoleTime[0]) {
                    maxRoleTime[0] = duration;
                }
            }
        });
        log.info("AxisService process contexts complete in {} msec, max role duration is {} msec", (Object)(new Date().getTime() - start.getTime()), (Object)maxRoleTime);
    }

    public void processContexts(XbrlReportRole xbrlReportRole, TableLinkBaseStructure tableLinkBaseStructure, List<XbrlContext> usedContexts, Boolean onlyWithData) {
        List filterOpenAxes = this.xbrlFilterOpenAxisService.findAll();
        HashSet xbrlContextDimensions = new HashSet();
        for (XbrlContext xbrlContext : usedContexts) {
            ArrayList dimensionList = new ArrayList();
            new XbrlContextScenarioParser(xbrlContext.getScenario(), dim -> {
                if (dim != null) {
                    AxisService.addToUniqueSet((Set)xbrlContextDimensions, (XbrlContextDimension)dim);
                    dimensionList.add(dim);
                }
            });
            xbrlContext.setXbrlContextDimensions(dimensionList);
        }
        Map<String, List<XbrlContextDimension>> cacheContextDimensions = xbrlContextDimensions.stream().collect(Collectors.groupingBy(XbrlContextDimension::getDimension));
        this.fillAspectNodeMembers(tableLinkBaseStructure, xbrlReportRole, filterOpenAxes, cacheContextDimensions, usedContexts, onlyWithData);
    }

    public static void addToUniqueSet(Set<XbrlContextDimension> xbrlContextDimensions, XbrlContextDimension dim) {
        if (dim.getDimensionType() == DimensionType.TYPED_MEMBER) {
            Optional<XbrlContextDimension> first = xbrlContextDimensions.stream().filter(it -> it.getDimension().equals(dim.getDimension()) && it.getDomainValue().equals(dim.getDomainValue())).findFirst();
            if (!first.isPresent()) {
                xbrlContextDimensions.add(dim);
            }
        } else {
            Optional<XbrlContextDimension> first = xbrlContextDimensions.stream().filter(it -> it.getDimension().equals(dim.getDimension()) && it.getMember().equals(dim.getMember())).findFirst();
            if (!first.isPresent()) {
                xbrlContextDimensions.add(dim);
            }
        }
    }
}

