/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.system;

import java.beans.ConstructorProperties;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.model_main.Parameter;
import ru.cbr.xbrl.converter.model_main.ParameterName;
import ru.cbr.xbrl.converter.model_main.ParameterType;
import ru.cbr.xbrl.converter.repository_main.ParameterRepository;
import ru.cbr.xbrl.converter.service.system.ParameterService;

@Service
public class ParameterServiceImpl
implements ParameterService {
    private final ParameterRepository parameterRepository;

    public List<Parameter> getParameters() {
        return this.parameterRepository.findAll();
    }

    public Parameter getParameter(ParameterName name) {
        return this.parameterRepository.findByName(name).orElse(null);
    }

    public Parameter saveParameter(Parameter parameter) {
        return this.saveParameter(parameter.getName(), parameter.getValue(), parameter.getType());
    }

    public Parameter saveParameter(ParameterName name, String value, ParameterType type) {
        Parameter parameter = this.parameterRepository.findByName(name).orElse(new Parameter(name));
        parameter.setValue(value);
        parameter.setType(type);
        return (Parameter)this.parameterRepository.save((Object)parameter);
    }

    @Transactional
    public void deleteParameter(ParameterName name) {
        this.parameterRepository.deleteByName(name);
    }

    @ConstructorProperties(value={"parameterRepository"})
    public ParameterServiceImpl(ParameterRepository parameterRepository) {
        this.parameterRepository = parameterRepository;
    }
}

