/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.repair_tagselectors;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;
import ru.cbr.xbrl.converter.service.XbrlPeriodService;
import ru.cbr.xbrl.converter.service.XbrlRoleService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlContextCrudService;
import ru.cbr.xbrl.converter.service.repair_tagselectors.RepairTagselectorsService;
import ru.cbr.xbrl.converter.utils.AspectUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;

@Service
public class RepairTagselectorsService {
    private static final Logger log = LoggerFactory.getLogger(RepairTagselectorsService.class);
    @Autowired
    private XbrlPeriodService xbrlPeriodService;
    @Autowired
    private XbrlContextCrudService xbrlContextCrudService;
    @Autowired
    private ConceptInMemoryService conceptInMemoryService;
    @Autowired
    private XbrlRoleService xbrlRoleService;
    private Map<String, RepairedFactMask> repairedFacts = new HashMap();

    public void fillRepairData(TableLinkBaseStructure tableLinkBaseStructure) {
        XbrlPeriod defaultPeriod = this.xbrlPeriodService.getDefaultPeriod();
        if (defaultPeriod == null) {
            return;
        }
        PeriodDates defaultDuration = PeriodDates.from((XbrlPeriod)defaultPeriod);
        PeriodDates defaultInstant = defaultPeriod.getAdditionalInstant();
        HashSet explicitAspectNodeSet = new HashSet();
        tableLinkBaseStructure.getZAxis().iterate((axisMemberHierarchy, parents) -> explicitAspectNodeSet.addAll(this.xbrlRoleService.getExplicitAspectNodeDimensionSet(axisMemberHierarchy)));
        tableLinkBaseStructure.getYAxis().iterate((axisMemberHierarchy, parents) -> explicitAspectNodeSet.addAll(this.xbrlRoleService.getExplicitAspectNodeDimensionSet(axisMemberHierarchy)));
        tableLinkBaseStructure.getXAxis().iterate((axisMemberHierarchy, parents) -> explicitAspectNodeSet.addAll(this.xbrlRoleService.getExplicitAspectNodeDimensionSet(axisMemberHierarchy)));
        tableLinkBaseStructure.iterateAllAspects(aspectDataList -> {
            AspectCellData aspectCellData = new AspectCellData(aspectDataList);
            AspectData concept = aspectCellData.getConcept();
            List dimensions = aspectCellData.getDimensions();
            dimensions = XbrlContextDimension.removeDefaultDimensions((List)dimensions, (Map)tableLinkBaseStructure.getDimensionsDefault());
            List xbrlDimensions = XbrlContextDimension.buildFromAspectDataList((List)dimensions);
            String openHash = XbrlContextDimension.dimensionsOpenToHash((List)xbrlDimensions, (Set)explicitAspectNodeSet);
            if (concept != null && StringUtils.isNotBlank((CharSequence)concept.getRepairTagSelector())) {
                String periodString = null;
                if (concept.getConceptPeriodType() == PeriodType.DURATION) {
                    periodString = defaultDuration.formatDate();
                } else if (concept.getConceptPeriodType() == PeriodType.INSTANT) {
                    periodString = defaultInstant.formatDate();
                }
                AspectCellData aspectCellDataWithoutTags = (AspectCellData)SerializationUtils.clone((Serializable)aspectCellData);
                aspectCellDataWithoutTags.getAspectDataList().forEach(aspectData -> aspectData.setTag(null));
                PeriodDates newPeriodDates = AspectUtils.getPeriodDatesForConcept((List)aspectCellData.getAspectDataList(), (AspectData)concept);
                if (newPeriodDates != null) {
                    String newDate = newPeriodDates.formatDate();
                    RepairedFactMask repairedFactMask = new RepairedFactMask(periodString, openHash, concept.getAspectValue(), newDate);
                    this.repairedFacts.put(repairedFactMask.generateKey(), repairedFactMask);
                }
            }
        });
    }

    public void repairValue(XbrlContext xbrlContext, XbrlValue xbrlValue, Consumer<String> eventMessage) {
        String conceptQname;
        String openHash = xbrlContext.getDimensionsOpenHash();
        String period = xbrlContext.getPeriodDates().formatDate();
        String key = new RepairedFactMask(period, openHash, conceptQname = xbrlValue.getXbrlValueId().getElementLabel(), null).generateKey();
        if (this.repairedFacts.containsKey(key)) {
            XbrlContext existingContext;
            String newPeriod = ((RepairedFactMask)this.repairedFacts.get(key)).getNewPeriod();
            PeriodDates newPeriodDates = new PeriodDates(newPeriod);
            List existingContexts = this.xbrlContextCrudService.findByPeriodDatesAndDimensionsHash(newPeriodDates, xbrlContext.getDimensionsHash());
            XbrlContext xbrlContext2 = existingContext = !existingContexts.isEmpty() ? (XbrlContext)existingContexts.get(0) : null;
            if (existingContext != null) {
                xbrlValue.getXbrlValueId().setXbrlContextId(existingContext.getXbrlContextId().getContextId());
                eventMessage.accept(String.format("\u0421\u043c\u0435\u043d\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0434\u043b\u044f \u0444\u0430\u043a\u0442\u0430 \u0441 %s \u043d\u0430 %s (\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 %s)", period, newPeriodDates.formatDate(), existingContext.getXbrlContextId().getContextId()));
            } else {
                XbrlContext newContext = new XbrlContext(xbrlContext, newPeriodDates);
                this.xbrlContextCrudService.create(newContext);
                xbrlValue.getXbrlValueId().setXbrlContextId(newContext.getXbrlContextId().getContextId());
                eventMessage.accept(String.format("\u0421\u043c\u0435\u043d\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0434\u043b\u044f \u0444\u0430\u043a\u0442\u0430 \u0441 %s \u043d\u0430 %s (\u043d\u043e\u0432\u044b\u0439 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 %s)", period, newPeriodDates.formatDate(), newContext.getXbrlContextId().getContextId()));
            }
            xbrlValue.buildAspectDataList(xbrlContext);
        }
    }
}

