/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.presentation_definition;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.arelle.parse.DimConcept;
import ru.cbr.xbrl.converter.arelle.parse.DimConceptProcessor;
import ru.cbr.xbrl.converter.arelle.parse.DimParser;
import ru.cbr.xbrl.converter.arelle.parse.HypercubeDimensions;
import ru.cbr.xbrl.converter.arelle.parse.HypercubeService;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.enums.AxisType;
import ru.cbr.xbrl.converter.model.filter.FilterViewType;
import ru.cbr.xbrl.converter.model.presentation_definition.ConceptGroup;
import ru.cbr.xbrl.converter.model.presentation_definition.StructuredViewUIModel;
import ru.cbr.xbrl.converter.model.presentation_definition.StructuredViewValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlFootnoteDTO;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevel;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValueId;
import ru.cbr.xbrl.converter.model.xbrl_content.presentation_definition.XbrlValueRole;
import ru.cbr.xbrl.converter.model_main.ParameterName;
import ru.cbr.xbrl.converter.model_main.ParameterType;
import ru.cbr.xbrl.converter.repository.FilterOpenAxisRepository;
import ru.cbr.xbrl.converter.repository.XbrlValueRepository;
import ru.cbr.xbrl.converter.repository.XbrlValueRoleRepository;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;
import ru.cbr.xbrl.converter.service.DimensionsDefaultService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.XbrlRoleService;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisService;
import ru.cbr.xbrl.converter.service.internal.XbrlReportCrudService;
import ru.cbr.xbrl.converter.service.presentation_definition.InactiveMembersService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionData;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRole;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRoleMember;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.service.system.ParameterService;
import ru.cbr.xbrl.converter.utils.GzipUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

@Service
public class PresentationDefinitionService {
    private static final Logger log = LoggerFactory.getLogger(PresentationDefinitionService.class);
    @Autowired
    private XbrlValueRoleRepository xbrlValueRoleRepository;
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private XbrlReportCrudService xbrlReportCrudService;
    @Autowired
    private DimensionsDefaultService dimensionsDefaultService;
    private PresentationDefinitionData presentationDefinitionData = null;
    private Map<String, Boolean> conceptDimensionsRows = new HashMap();
    @Autowired
    private XbrlValueRepository xbrlValueRepository;
    @Autowired
    private XbrlRoleService xbrlRoleService;
    @Autowired
    private XbrlFilterOpenAxisService xbrlFilterOpenAxisService;
    @Autowired
    private InactiveMembersService inactiveMembersService;
    @Autowired
    private ConceptInMemoryService conceptInMemoryService;
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private FilterOpenAxisRepository filterOpenAxisRepository;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private HypercubeService hypercubeService;
    private Map<String, String> conceptLabels = new HashMap();
    private Map<String, String> conceptNameLabelMap = new HashMap();
    private Map<String, String> dimintLabels = new HashMap();
    private Map<String, Map<String, String>> memintLabels = new HashMap();
    private Set<String> largeDimensions = new HashSet();
    private Set<HypercubeDimensions> largeDimensionHypercubes = new HashSet();

    public boolean isEditable(String concept, List<XbrlContextDimension> xbrlContextDimensions, String dimensionHash) {
        if (this.conceptDimensionsRows.isEmpty()) {
            return true;
        }
        if (this.largeDimensionHypercubes.stream().anyMatch(s -> s.contains(xbrlContextDimensions))) {
            return true;
        }
        String key = this.generateConceptDimensionHash(concept, dimensionHash);
        return this.conceptDimensionsRows.containsKey(key) && (Boolean)this.conceptDimensionsRows.get(key) != false;
    }

    public void clearPresentationDefinitionData() {
        log.info("Clear PresentationDefinitionData");
        this.presentationDefinitionData = null;
    }

    public void loadDimensionXml(XbrlReport xbrlReport) {
        try {
            log.info("Load dimensionXml");
            if (xbrlReport.getDimXml() == null) {
                log.error("Skip load dimension.xml, DimXml is null");
                return;
            }
            String dimXml = GzipUtils.decompressString((byte[])xbrlReport.getDimXml());
            long startMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            log.info("Load presentation/definition data started...");
            Date start = new Date();
            this.presentationDefinitionData = new PresentationDefinitionData();
            List<String> tlbRoles = xbrlReport.getXbrlReportRoles().stream().map(XbrlReportRole::getSystemId).collect(Collectors.toList());
            tlbRoles.forEach(role -> {
                Set cfr_ignored_0 = this.presentationDefinitionData.getTlbPdRoleMap().put(role, new HashSet());
            });
            this.loadDimensionXml(dimXml);
            long endMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            log.info("Presentation/definition data loaded in " + (new Date().getTime() - start.getTime()) + " msec");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            XbrlReport e = this.xbrlReportCrudService.update(xbrlReport);
        }
        catch (NotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void loadDimensionXmlSafe(String dimXml) {
        this.presentationDefinitionData = new PresentationDefinitionData();
        this.loadDimensionXml(dimXml);
    }

    private void addOpenDimensions(AxisMemberHierarchy axisMemberHierarchy, List<String> openDimensions) {
        for (AspectData aspectData : axisMemberHierarchy.getAspectDataList()) {
            if (aspectData.getType() != AspectType.DIMENSION || aspectData.getDimensionType() != DimensionType.TYPED_MEMBER) continue;
            openDimensions.add(aspectData.getAspect());
        }
        for (AxisMemberHierarchy children : axisMemberHierarchy.getAxisMemberHierarchyList()) {
            this.addOpenDimensions(children, openDimensions);
        }
    }

    private void loadDimensionXml(String dimXml) {
        this.hypercubeService.readXml(dimXml);
        Map rolesMap = this.xbrlPackageService.findLastPackage().getXbrlReport().getXbrlReportRoles().stream().collect(Collectors.toMap(XbrlReportRole::getSystemId, Function.identity()));
        DimParser.parseString((String)dimXml, (role, dimConcepts) -> {
            Boolean isAbstractRole = !dimConcepts.stream().filter(dimConcept -> BooleanUtils.isFalse((Boolean)dimConcept.getAbstractNode())).findFirst().isPresent();
            if (!isAbstractRole.booleanValue()) {
                String linkrole = (String)role.getKey();
                String roledefinition = (String)role.getValue();
                DimConceptProcessor dimConceptProcessor = new DimConceptProcessor(this.dimensionsDefaultService.getDimensionsDefault(), dimConcepts);
                dimConceptProcessor.prepareRoleDimensionMap(linkrole, (dimint, memint) -> this.processDimensionByRole(linkrole, dimint, memint));
                dimConceptProcessor.prepareRoleConceptMap(linkrole, concept -> this.processConceptByRole(linkrole, concept));
                List rootConcepts = dimConcepts.stream().filter(c -> c.getParents().size() == 0).collect(Collectors.toList());
                String title = ((DimConcept)rootConcepts.get(0)).getLabel();
                String code = DigestUtils.md5Hex((String)linkrole).toString();
                List dimensions = (List)this.presentationDefinitionData.getDimensionsByRoleMap().get(linkrole);
                Map members = (Map)this.presentationDefinitionData.getMembersByRoleMap().get(linkrole);
                List concepts = (List)this.presentationDefinitionData.getConceptsByRoleMap().get(linkrole);
                ArrayList abstractConcepts = new ArrayList();
                dimConcepts.forEach(dimConcept -> {
                    if (dimConcept.getAbstractNode().booleanValue()) {
                        String concept = dimConcept.getName();
                        if (concepts.stream().anyMatch(x -> ((String)x.getLeft()).equals(concept))) {
                            abstractConcepts.add(concept);
                        }
                    }
                });
                List hypercubeConcepts = dimConceptProcessor.getHypercubeConceptsList();
                ArrayList tlbRoles = new ArrayList();
                this.presentationDefinitionData.getTlbPdRoleMap().keySet().forEach(tlbRole -> {
                    if (tlbRole.equals(linkrole) || linkrole.startsWith(tlbRole + "/")) {
                        ((Set)this.presentationDefinitionData.getTlbPdRoleMap().get(tlbRole)).add(linkrole);
                        tlbRoles.add(tlbRole.toString());
                    }
                });
                HashMap enumerations = new HashMap();
                ArrayList openDimensions = new ArrayList();
                for (String roleSystemId : tlbRoles) {
                    try {
                        XbrlReportRole reportRole = (XbrlReportRole)rolesMap.get(roleSystemId);
                        ObjectMapper mapper = new ObjectMapper();
                        TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)mapper.readValue(reportRole.getStaticStructureJson(), TableLinkBaseStructure.class);
                        enumerations.putAll(tableLinkBaseStructure.getEnumerations());
                        this.addOpenDimensions(tableLinkBaseStructure.getZAxis(), openDimensions);
                        this.addOpenDimensions(tableLinkBaseStructure.getYAxis(), openDimensions);
                        this.addOpenDimensions(tableLinkBaseStructure.getXAxis(), openDimensions);
                    }
                    catch (Exception e) {
                        log.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
                PresentationDefinitionRole presentationDefinitionRole = new PresentationDefinitionRole(roledefinition, title, linkrole, code, dimensions, members, new ArrayList(), null, null, concepts, (Map)new HashedMap(), (Map)new HashedMap(), (Map)new HashedMap(), new HashMap(), new HashMap(), enumerations, openDimensions, abstractConcepts, null);
                this.presentationDefinitionData.getRoles().add(presentationDefinitionRole);
                this.presentationDefinitionData.getRoleMap().put(code, presentationDefinitionRole);
                dimConceptProcessor.buildCellExclusionsData();
                List roleCellList = dimConceptProcessor.getRoleCells();
                roleCellList.forEach(c -> {
                    String key = this.generateConceptDimensionHash(c.getRoleCellId().getConcept(), c.getRoleCellId().getDimenisonsHash());
                    this.conceptDimensionsRows.put(key, c.isEnabled());
                });
                this.largeDimensions.addAll(dimConceptProcessor.getLargeDimensions());
                this.largeDimensionHypercubes.addAll(dimConceptProcessor.getLargeDimensionHypercubes());
            }
        });
    }

    private void processDimensionByRole(String linkrole, DimConcept dimint, DimConcept memint) {
        boolean notExists;
        String dimintName = dimint.getName();
        String memintName = memint != null ? memint.getName() : null;
        this.xbrlRoleService.addPresentationDefinitionDimension(linkrole, dimintName, memintName);
        String key = dimintName + ":" + (memint != null ? memint.getName() : "open");
        this.presentationDefinitionData.getDimintRoleMap().putIfAbsent(key, new HashSet());
        ((Set)this.presentationDefinitionData.getDimintRoleMap().get(key)).add(linkrole);
        this.presentationDefinitionData.getDimensionsByRoleMap().putIfAbsent(linkrole, new ArrayList());
        boolean dimintExists = ((List)this.presentationDefinitionData.getDimensionsByRoleMap().get(linkrole)).stream().anyMatch(stringStringPair -> ((String)stringStringPair.getKey()).equals(dimintName));
        if (!dimintExists) {
            ((List)this.presentationDefinitionData.getDimensionsByRoleMap().get(linkrole)).add(new ImmutablePair((Object)dimintName, (Object)dimint.getLabel()));
        }
        this.presentationDefinitionData.getMembersByRoleMap().putIfAbsent(linkrole, new HashMap());
        ((Map)this.presentationDefinitionData.getMembersByRoleMap().get(linkrole)).putIfAbsent(dimintName, new ArrayList());
        if (memint != null && (notExists = ((List)((Map)this.presentationDefinitionData.getMembersByRoleMap().get(linkrole)).get(dimintName)).stream().noneMatch(m -> ((String)m.getKey()).equals(memint.getName())))) {
            ((List)((Map)this.presentationDefinitionData.getMembersByRoleMap().get(linkrole)).get(dimintName)).add(new ImmutablePair((Object)memint.getName(), (Object)new PresentationDefinitionRoleMember(memint.getLabel(), null, null, AxisType.CLOSED)));
        }
        this.dimintLabels.putIfAbsent(dimintName, dimint.getLabel());
        if (memint != null) {
            this.memintLabels.putIfAbsent(dimintName, new HashMap());
            ((Map)this.memintLabels.get(dimintName)).putIfAbsent(memintName, memint.getLabel());
        }
    }

    private void processConceptByRole(String linkrole, DimConcept concept) {
        String conceptName = concept.getName();
        this.xbrlRoleService.addPresentationDefinitionConcept(linkrole, conceptName);
        this.presentationDefinitionData.getConceptRoleMap().putIfAbsent(conceptName, new HashSet());
        ((Set)this.presentationDefinitionData.getConceptRoleMap().get(conceptName)).add(linkrole);
        this.presentationDefinitionData.getConceptsByRoleMap().putIfAbsent(linkrole, new ArrayList());
        ((List)this.presentationDefinitionData.getConceptsByRoleMap().get(linkrole)).add(new ImmutablePair((Object)conceptName, (Object)concept.getLabel()));
        this.conceptLabels.putIfAbsent(conceptName, concept.getLabel());
        String[] splitConceptName = StringUtils.split((String)conceptName, (String)":");
        if (splitConceptName != null && splitConceptName.length > 1) {
            this.conceptNameLabelMap.putIfAbsent(splitConceptName[1], concept.getLabel());
        }
    }

    private void refreshPeriodsForRole(PresentationDefinitionRole presentationDefinitionRole) {
        ArrayList periods = new ArrayList();
        List xbrlPeriods = this.xbrlReportService.findPdReportRolePeriodList(presentationDefinitionRole.getSystemId());
        xbrlPeriods.stream().filter(XbrlPeriod::getActive).forEach(period -> {
            ImmutablePair duration = new ImmutablePair((Object)period.toPeriodDates().formatDate(), (Object)period.getTitle());
            if (period.getIsDefaultPeriod().booleanValue()) {
                presentationDefinitionRole.setDefaultPeriod(period.toPeriodDates().formatDate());
            }
            periods.add(duration);
            String additionalInstantTitle = period.getIsEditablePeriod() == false ? period.getAdditionalInstant().formatDate() : period.getTitle() + "-instant";
            ImmutablePair instant = new ImmutablePair((Object)period.getAdditionalInstant().formatDate(), (Object)additionalInstantTitle);
            periods.add(instant);
        });
        presentationDefinitionRole.setPeriods(periods);
    }

    public List<PresentationDefinitionRole> getPresentationDefinitionRoles() {
        return this.presentationDefinitionData.getRoles();
    }

    @Transactional(value="cacheTransactionManager")
    public PresentationDefinitionRole getPresentationDefinitionRoleForUi(String roleId) {
        PresentationDefinitionRole presentationDefinitionRole = this.getPresentationDefinitionRole(roleId);
        presentationDefinitionRole.getAbstractConcepts().forEach(abstractConcept -> presentationDefinitionRole.getConcepts().removeIf(concept -> ((String)concept.getLeft()).equals(abstractConcept)));
        return presentationDefinitionRole;
    }

    @Transactional(value="cacheTransactionManager")
    public PresentationDefinitionRole getPresentationDefinitionRole(String roleId) {
        PresentationDefinitionRole presentationDefinitionRoleOrig = (PresentationDefinitionRole)this.presentationDefinitionData.getRoleMap().get(roleId);
        PresentationDefinitionRole presentationDefinitionRole = (PresentationDefinitionRole)SerializationUtils.clone((Serializable)presentationDefinitionRoleOrig);
        if (presentationDefinitionRole.getMembers() != null) {
            presentationDefinitionRole.getMembers().forEach((dimensionCode, pairs) -> pairs.forEach(pair -> {
                String memberCode = (String)pair.getKey();
                ((PresentationDefinitionRoleMember)pair.getValue()).setActive(Boolean.valueOf(!this.inactiveMembersService.isInactiveClosedMember(roleId, dimensionCode, memberCode, FilterViewType.PRESENTATION_DEFINITION)));
            }));
        }
        List dimensions = presentationDefinitionRole.getDimensions();
        HashMap domains = new HashMap();
        HashMap ids = new HashMap();
        if (dimensions != null) {
            Map<String, List> members = dimensions.stream().collect(Collectors.toMap(d -> (String)d.getKey(), d -> {
                String dimint = (String)d.getKey();
                return this.findOpenAxisValues(roleId, dimint);
            }));
            dimensions.forEach(d -> {
                String dimint = (String)d.getKey();
                List filters = this.filterOpenAxisRepository.findAllBySystemId(dimint);
                if (CollectionUtils.isNotEmpty((Collection)filters)) {
                    ids.put(d.getKey(), ((FilterOpenAxis)filters.get(0)).getId());
                }
                domains.put(d.getKey(), this.conceptInMemoryService.findDomainByDimension(dimint));
                List currentMembers = (List)presentationDefinitionRole.getMembers().get(dimint);
                if (members.containsKey(dimint)) {
                    ((List)members.get(dimint)).forEach(m -> {
                        PresentationDefinitionRoleMember presentationDefinitionRoleMember = m;
                        currentMembers.add(new ImmutablePair((Object)m.getValue(), (Object)presentationDefinitionRoleMember));
                    });
                }
                presentationDefinitionRole.getDimensionsAxisType().put(dimint, this.xbrlFilterOpenAxisService.countAllBySystemId(dimint) > 0L ? AxisType.OPEN : AxisType.CLOSED);
            });
        }
        List concepts = presentationDefinitionRole.getConcepts();
        HashMap xsdTypes = new HashMap();
        HashMap patterns = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)concepts)) {
            concepts.forEach(concept -> {
                xsdTypes.put(concept.getKey(), this.conceptInMemoryService.findXsdTypeByConcept((String)concept.getKey()));
                patterns.put(concept.getKey(), this.conceptInMemoryService.findPatternByConcept((String)concept.getKey()));
            });
        }
        presentationDefinitionRole.setXsdTypes(xsdTypes);
        presentationDefinitionRole.setPatterns(patterns);
        presentationDefinitionRole.setDomains(domains);
        presentationDefinitionRole.setFilterIds(ids);
        this.refreshPeriodsForRole(presentationDefinitionRole);
        presentationDefinitionRole.setDimensionsDefault(this.dimensionsDefaultService.getDimensionsDefault());
        presentationDefinitionRole.getConcepts().forEach(c -> presentationDefinitionRole.getConceptDataTypes().put(c.getKey(), this.conceptInMemoryService.findTypeByConcept((String)c.getKey())));
        return presentationDefinitionRole;
    }

    private List<PresentationDefinitionRoleMember> findOpenAxisValues(String roleId, String dimint) {
        List filterOpenAxisValues = this.xbrlFilterOpenAxisService.getFilterOpenAxisValues(dimint);
        ArrayList roleMembers = filterOpenAxisValues.stream().map(filterOpenAxisValue -> new PresentationDefinitionRoleMember(filterOpenAxisValue.getValue(), Boolean.valueOf(!this.inactiveMembersService.isInactiveOpenMember(roleId, filterOpenAxisValue.getId(), FilterViewType.PRESENTATION_DEFINITION)), filterOpenAxisValue.getId(), AxisType.OPEN)).collect(Collectors.toList());
        return CollectionUtils.isNotEmpty(roleMembers) ? roleMembers : new ArrayList();
    }

    public Function<String, List<AspectCellData>> getRoleListItemsFunction() {
        return arg_0 -> this.getRoleListItems(arg_0);
    }

    @Transactional(value="cacheTransactionManager")
    public List<AspectCellData> getRoleListItems(String roleCode) {
        PresentationDefinitionRole presentationDefinitionRole = (PresentationDefinitionRole)this.presentationDefinitionData.getRoleMap().get(roleCode);
        if (presentationDefinitionRole != null) {
            String roleSystemId = presentationDefinitionRole.getSystemId();
            List dto = this.xbrlValueRoleRepository.findbyPresentationDefinitionRole(roleSystemId);
            List footnoteCountList = this.xbrlValueRepository.findFootnoteCountByXbrlValueId();
            HashMap<XbrlValueId, Integer> footnoteCountMap = new HashMap<XbrlValueId, Integer>();
            for (XbrlFootnoteDTO xbrlFootnoteDTO : footnoteCountList) {
                if (xbrlFootnoteDTO == null) continue;
                footnoteCountMap.put(new XbrlValueId(xbrlFootnoteDTO.getElementLabel(), xbrlFootnoteDTO.getXbrlReportId(), xbrlFootnoteDTO.getContext()), xbrlFootnoteDTO.getCount());
            }
            ArrayList dimensionKeys = presentationDefinitionRole.getDimensions() != null ? presentationDefinitionRole.getDimensions().stream().map(Pair::getKey).collect(Collectors.toList()) : new ArrayList();
            List<AspectCellData> aspectCellDataList = dto.stream().map(xbrlValueRole -> {
                AspectData periodAspect = xbrlValueRole.getPeriodDates().buildAspectData();
                List dimensions = XbrlContextDimension.dimensionsFromString((String)xbrlValueRole.getDimensions());
                List dimensionAspects = dimensions.stream().filter(dim -> dim.getDimensionType() != null).map(XbrlContextDimension::toAspectData).collect(Collectors.toList());
                AspectData conceptAspect = new AspectData("concept", AspectType.CONCEPT, xbrlValueRole.getElementLabel(), this.conceptInMemoryService.findPeriodTypeByConcept(xbrlValueRole.getElementLabel()));
                conceptAspect.setConceptDataType(this.conceptInMemoryService.findTypeByConcept(xbrlValueRole.getElementLabel()));
                conceptAspect.setXsdType(this.conceptInMemoryService.findXsdTypeByConcept(conceptAspect.getAspectValue()));
                conceptAspect.setPattern(this.conceptInMemoryService.findPatternByConcept(conceptAspect.getAspectValue()));
                ArrayList<Object> aspectDatas = new ArrayList<Object>();
                aspectDatas.add(periodAspect);
                aspectDatas.addAll(dimensionAspects);
                aspectDatas.add(conceptAspect);
                AspectCellData aspectCellData = new AspectCellData(aspectDatas);
                aspectCellData.setCellValue(xbrlValueRole.getValue());
                XbrlValueId xbrlValueId = new XbrlValueId(conceptAspect.getAspectValue(), xbrlValueRole.getXbrlReportId(), xbrlValueRole.getXbrlContextId());
                Integer footnoteCount = footnoteCountMap.getOrDefault(xbrlValueId, 0);
                aspectCellData.setFootnoteCount(footnoteCount);
                this.fillDimensionsDefaultMembers(dimensionKeys, aspectCellData);
                aspectCellData.setUnitId(xbrlValueRole.getXbrlUnit());
                aspectCellData.setDecimals((String)Optional.ofNullable(xbrlValueRole.getDecimals()).map(Object::toString).orElse(null));
                aspectCellData.setPrecision((String)Optional.ofNullable(xbrlValueRole.getPrecision()).map(Object::toString).orElse(null));
                return aspectCellData;
            }).filter(x -> {
                List aspectDataList = x.getAspectDataList();
                ArrayList openDimensions = new ArrayList(presentationDefinitionRole.getOpenDimensions());
                List left = aspectDataList.stream().filter(aspectData -> {
                    switch (1.$SwitchMap$ru$cbr$xbrl$converter$xbrl$import_export$enums$AspectType[aspectData.getType().ordinal()]) {
                        case 1: {
                            List leftOpenDimensions = openDimensions.stream().filter(dimension -> !dimension.equals(aspectData.getAspect())).collect(Collectors.toList());
                            openDimensions.clear();
                            openDimensions.addAll(leftOpenDimensions);
                            if (presentationDefinitionRole.getDimensions() == null) {
                                return true;
                            }
                            return !presentationDefinitionRole.getDimensions().stream().anyMatch(pair -> ((String)pair.getLeft()).equals(aspectData.getAspect()));
                        }
                        case 2: {
                            return !presentationDefinitionRole.getConcepts().stream().anyMatch(pair -> ((String)pair.getLeft()).equals(aspectData.getAspectValue()));
                        }
                    }
                    return false;
                }).collect(Collectors.toList());
                return left.isEmpty() && openDimensions.isEmpty();
            }).collect(Collectors.toList());
            ArrayList periods = new ArrayList();
            List xbrlPeriods = this.xbrlReportService.findPdReportRolePeriodList(presentationDefinitionRole.getSystemId());
            xbrlPeriods.stream().filter(xbrlPeriod -> xbrlPeriod.getActive() == false).forEach(xbrlPeriod -> {
                AspectData aspectData = xbrlPeriod.toPeriodDates().buildAspectData();
                aspectCellDataList.removeIf(aspectCellData -> aspectCellData.getPeriodAspect().getAspectValue().equals(aspectData.getAspectValue()));
            });
            return aspectCellDataList;
        }
        return null;
    }

    private void fillDimensionsDefaultMembers(List<String> dimensionKeys, AspectCellData aspectCellData) {
        dimensionKeys.forEach(dimensionKey -> {
            if (!aspectCellData.hasDimension(dimensionKey) && this.dimensionsDefaultService.getDimensionsDefault().containsKey(dimensionKey)) {
                AspectData dimensionDefaultAspect = new AspectData();
                dimensionDefaultAspect.setType(AspectType.DIMENSION);
                dimensionDefaultAspect.setDimensionType(DimensionType.EXPLICIT_MEMBER);
                dimensionDefaultAspect.setAspect(dimensionKey);
                dimensionDefaultAspect.setAspectValue((String)this.dimensionsDefaultService.getDimensionsDefault().get(dimensionKey));
                aspectCellData.getAspectDataList().add(dimensionDefaultAspect);
            }
        });
    }

    public Set<String> getRolesForConceptAndDimensions(String concept, List<XbrlContextDimension> xbrlContextDimensions) {
        if (this.presentationDefinitionData == null) {
            return new HashSet<String>();
        }
        Set rolesConcept = (Set)this.presentationDefinitionData.getConceptRoleMap().get(concept);
        if (rolesConcept == null) {
            return new HashSet<String>();
        }
        List dimensions = xbrlContextDimensions.stream().map(xbrlContextDimension -> xbrlContextDimension.getDimension() + ":" + xbrlContextDimension.getMember()).collect(Collectors.toList());
        List dimensionSets = dimensions.stream().map(d -> (Set)this.presentationDefinitionData.getDimintRoleMap().get(d)).collect(Collectors.toList());
        Optional<Set> dimensionsIntersection = dimensionSets.stream().filter(CollectionUtils::isNotEmpty).reduce((strings, strings2) -> SetUtils.intersection((Set)strings, (Set)strings2));
        Set intersection = dimensionsIntersection.isPresent() ? SetUtils.intersection((Set)rolesConcept, (Set)dimensionsIntersection.get()) : rolesConcept;
        log.debug("intersection " + intersection);
        if (intersection.size() == 0) {
            log.error("ERROR: Role not found!, concept {} dimensions {}", (Object)concept, (Object)dimensions.stream().collect(Collectors.joining(", ")));
        }
        return intersection;
    }

    public void savePresentationDefinitionRolesData(XbrlReport xbrlReport, XbrlValue xbrlValue1, AspectCellData aspectCellData) {
        XbrlValue xbrlValue = (XbrlValue)this.xbrlValueRepository.findOne((Serializable)xbrlValue1.getXbrlValueId());
        HashMap dimensionsDefault = this.dimensionsDefaultService.getDimensionsDefault();
        if (dimensionsDefault == null) {
            dimensionsDefault = new HashMap();
        }
        AspectData concept = aspectCellData.getConcept();
        List aspectDimensions = aspectCellData.getDimensions();
        List dimensions = XbrlContextDimension.buildFromAspectDataList((List)aspectDimensions);
        dimensions = XbrlContextDimension.removeDuplicates((List)dimensions);
        HashMap finalDimensionsDefault = dimensionsDefault;
        List dimensionsFiltered = dimensions;
        Set roles = this.getRolesForConceptAndDimensions(concept.getAspectValue(), dimensionsFiltered);
        for (String roleSystemId : roles) {
            XbrlValueRole xbrlValueRole = new XbrlValueRole();
            String id = DigestUtils.md5Hex((String)(roleSystemId + " " + xbrlValue.getGuid()));
            xbrlValueRole.setId(id);
            xbrlValueRole.setRoleSystemId(roleSystemId);
            xbrlValueRole.setXbrlValue(xbrlValue);
            xbrlValueRole.setGuid(xbrlValue.getGuid());
            try {
                XbrlValueRole saved = (XbrlValueRole)this.xbrlValueRoleRepository.save((Object)xbrlValueRole);
                log.debug("saved XbrlValueRole " + saved);
            }
            catch (Exception e) {
                try {
                    log.error("Can't save XbrlValueRole");
                    log.error("Can't save XbrlValueRole: " + xbrlValueRole);
                }
                catch (Exception e1) {
                    log.error("Cant't log xbrlValueRole");
                    log.error(ExceptionUtils.getStackTrace((Throwable)e1));
                }
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public PresentationDefinitionData getPresentationDefinitionData() {
        return this.presentationDefinitionData;
    }

    private String generateConceptDimensionHash(String concept, String dimensionHash) {
        String DIVIDER = " ";
        return DigestUtils.md5Hex((String)concept) + " " + DigestUtils.md5Hex((String)(concept + " " + dimensionHash.toString()));
    }

    public Map<String, String> getConceptLabels() {
        return this.conceptLabels;
    }

    public Map<String, String> getConceptNameLabelMap() {
        return this.conceptNameLabelMap;
    }

    public Map<String, String> getDimintLabels() {
        return this.dimintLabels;
    }

    public Map<String, Map<String, String>> getMemintLabels() {
        return this.memintLabels;
    }

    public String buildDimensionsLabel(List<XbrlContextDimension> xbrlContextDimensions) {
        return xbrlContextDimensions.stream().map(xbrlContextDimension -> {
            String dimintLabel = (String)this.getDimintLabels().get(xbrlContextDimension.getDimension());
            if (StringUtils.isBlank((CharSequence)dimintLabel)) {
                dimintLabel = xbrlContextDimension.getDimension();
            }
            if (xbrlContextDimension.getDimensionType().equals((Object)DimensionType.EXPLICIT_MEMBER)) {
                String member = xbrlContextDimension.getMember();
                String memberLabel = (String)((Map)this.getMemintLabels().getOrDefault(xbrlContextDimension.getDimension(), new HashMap())).get(member);
                return String.format("%s -> %s", dimintLabel, memberLabel);
            }
            if (xbrlContextDimension.getDimensionType().equals((Object)DimensionType.TYPED_MEMBER)) {
                return String.format("%s -> %s", dimintLabel, xbrlContextDimension.getDomainValue());
            }
            return null;
        }).collect(Collectors.joining("; "));
    }

    @Transactional(value="cacheTransactionManager")
    public StructuredViewUIModel getStructuredViewUIModel(String code, List<String> direction, boolean dontCheckSize) throws NotFoundException {
        PresentationDefinitionRole definitionRole = this.getPresentationDefinitionRole(code);
        return this.createStructuredViewUIModel(definitionRole, direction, dontCheckSize);
    }

    private StructuredViewUIModel createStructuredViewUIModel(PresentationDefinitionRole definitionRole, List<String> direction, boolean dontCheckSize) {
        List dimensions = definitionRole.getDimensions() != null ? definitionRole.getDimensions() : new LinkedList();
        Map members = definitionRole.getMembers() != null ? definitionRole.getMembers() : new HashMap();
        List roleListItems = this.getRoleListItems(definitionRole.getCode());
        if (CollectionUtils.isNotEmpty(direction)) {
            dimensions = this.getSortedDimensions(dimensions, direction);
        }
        StructuredViewUIModel model = new StructuredViewUIModel();
        MutableInt countCols = new MutableInt();
        List columns = this.getColumns(dimensions, members, 0, countCols);
        this.checkMaxStructuredViewSize(dontCheckSize, countCols.getValue().intValue());
        this.generateHashToLeafs(columns, new LinkedList());
        model.setColumnList(columns);
        MutableInt countRows = new MutableInt();
        model.setYLevelList(this.getYLevels(definitionRole.getPeriods(), definitionRole.getConcepts(), definitionRole.getAbstractConcepts(), countRows, columns));
        int allSize = countCols.getValue() * countRows.getValue();
        this.checkMaxStructuredViewSize(dontCheckSize, allSize);
        model.setValues(this.getValues(roleListItems, members, definitionRole));
        model.setDimensions(dimensions);
        model.setMembers(members);
        model.setConcepts(definitionRole.getConcepts());
        model.setPeriods(definitionRole.getPeriods());
        model.setXsdTypes(definitionRole.getXsdTypes());
        model.setPatterns(definitionRole.getPatterns());
        HashMap domains = new HashMap();
        HashMap ids = new HashMap();
        if (dimensions != null) {
            dimensions.forEach(d -> {
                String dimint = (String)d.getKey();
                domains.put(d.getKey(), this.conceptInMemoryService.findDomainByDimension(dimint));
                List filters = this.filterOpenAxisRepository.findAllBySystemId(dimint);
                if (CollectionUtils.isNotEmpty((Collection)filters)) {
                    ids.put(d.getKey(), ((FilterOpenAxis)filters.get(0)).getId());
                }
            });
        }
        model.setDomains(domains);
        model.setFilterIds(ids);
        model.setDimensionsAxisType(definitionRole.getDimensionsAxisType());
        model.setConceptDataTypes(definitionRole.getConceptDataTypes());
        return model;
    }

    private void checkMaxStructuredViewSize(boolean dontCheckSize, int size) {
        int maxStructuredViewSize = this.getMaxStructuredViewSize();
        if (!dontCheckSize && size > maxStructuredViewSize) {
            throw new RuntimeException("structuredViewSizeTooMuch");
        }
        if (dontCheckSize && size >= maxStructuredViewSize) {
            this.saveMaxStructuredViewSize(String.valueOf(size));
        }
    }

    private List<Pair<String, String>> getSortedDimensions(List<Pair<String, String>> dimensions, List<String> direction) {
        LinkedList<Pair<String, String>> result = new LinkedList<Pair<String, String>>();
        direction.forEach(item -> dimensions.stream().filter(dim -> ((String)dim.getKey()).equalsIgnoreCase((String)item)).findFirst().ifPresent(result::add));
        return result;
    }

    private List<StructuredViewValue> getValues(List<AspectCellData> roleListItems, Map<String, List<Pair<String, PresentationDefinitionRoleMember>>> members, PresentationDefinitionRole presentationDefinitionRole) {
        LinkedList<StructuredViewValue> values = new LinkedList<StructuredViewValue>();
        for (AspectCellData item : roleListItems) {
            Map<AspectType, List<AspectData>> aspectMap;
            String cellValue = item.getCellValue();
            if (StringUtils.isEmpty((CharSequence)cellValue) || (aspectMap = item.getAspectDataList().stream().collect(Collectors.groupingBy(AspectData::getType))).get(AspectType.PERIOD) == null || aspectMap.get(AspectType.CONCEPT) == null) continue;
            if (aspectMap.get(AspectType.DIMENSION) != null) {
                HashMap dimensionMembers = new HashMap();
                for (AspectData dimension : aspectMap.get(AspectType.DIMENSION)) {
                    String aspectValue = dimension.getAspectValue();
                    Optional<Pair> definitionRole = members.get(dimension.getAspect()).stream().filter(x -> ((String)x.getLeft()).equals(aspectValue)).findFirst();
                    definitionRole.ifPresent(definitionRoleValue -> dimensionMembers.put(aspectValue, ((PresentationDefinitionRoleMember)definitionRoleValue.getRight()).getValue()));
                }
                presentationDefinitionRole.getPeriods().forEach(p -> values.add(new StructuredViewValue(cellValue, (Map)dimensionMembers, (List)aspectMap.get(AspectType.DIMENSION), (AspectData)((List)aspectMap.get(AspectType.PERIOD)).get(0), (AspectData)((List)aspectMap.get(AspectType.CONCEPT)).get(0), item)));
                continue;
            }
            presentationDefinitionRole.getPeriods().forEach(p -> values.add(new StructuredViewValue(cellValue, null, null, (AspectData)((List)aspectMap.get(AspectType.PERIOD)).get(0), (AspectData)((List)aspectMap.get(AspectType.CONCEPT)).get(0), item)));
        }
        return values;
    }

    private List<YLevel> getYLevels(List<Pair<String, String>> periods, List<Pair<String, String>> concepts, List<String> abstractConcepts, MutableInt count, List<ColumnHeader> columns) {
        LinkedList<YLevel> result = new LinkedList<YLevel>();
        List reorderConcepts = this.reorderConcepts(concepts, abstractConcepts);
        periods.forEach(p -> {
            LinkedList<YLevel> conceptList = new LinkedList<YLevel>();
            YLevel yLevel = this.createYLevel((String)p.getValue(), (String)p.getKey());
            for (Pair concept : reorderConcepts) {
                YLevel level = this.createYLevel((String)concept.getValue(), (String)concept.getKey());
                count.increment();
                level.setHash(DigestUtils.md5Hex((String)((String)p.getKey() + (String)concept.getKey())));
                level.setAbstractNode(abstractConcepts.contains(concept.getLeft()));
                conceptList.add(level);
            }
            yLevel.setYLevelList(conceptList);
            if (CollectionUtils.isEmpty((Collection)columns)) {
                yLevel.setHash(DigestUtils.md5Hex((String)((String)p.getKey())));
            }
            result.add(yLevel);
        });
        return result;
    }

    private List<Pair<String, String>> reorderConcepts(List<Pair<String, String>> concepts, List<String> abstractConcepts) {
        LinkedList<Pair<String, String>> result = new LinkedList<Pair<String, String>>();
        LinkedList<ConceptGroup> conceptGroups = new LinkedList<ConceptGroup>();
        ConceptGroup conceptGroup = new ConceptGroup(abstractConcepts);
        for (Pair<String, String> concept : concepts) {
            conceptGroup.add(concept);
            if (!abstractConcepts.contains(concept.getKey())) continue;
            conceptGroups.add(conceptGroup);
            conceptGroup = new ConceptGroup(abstractConcepts);
        }
        conceptGroups.stream().filter(ConceptGroup.hasOnlyAbstractConcept).forEach(group -> result.addAll(group.toList()));
        conceptGroups.stream().filter(ConceptGroup.hasOnlyAbstractConcept.negate()).forEach(group -> result.addAll(group.toList()));
        return result;
    }

    private YLevel createYLevel(String title, String period) {
        YLevel yLevel = new YLevel();
        yLevel.setTitle(title);
        yLevel.setPeriod(period);
        return yLevel;
    }

    private List<ColumnHeader> getColumns(List<Pair<String, String>> dimensions, Map<String, List<Pair<String, PresentationDefinitionRoleMember>>> members, int dimensionLevel, MutableInt count) {
        Pair<String, String> dimension;
        List<Pair<String, PresentationDefinitionRoleMember>> membersForDimension;
        LinkedList<ColumnHeader> result = new LinkedList<ColumnHeader>();
        if (dimensions.size() > dimensionLevel && !CollectionUtils.isEmpty(membersForDimension = members.get((dimension = dimensions.get(dimensionLevel++)).getKey()))) {
            for (Pair<String, PresentationDefinitionRoleMember> memberPair : membersForDimension) {
                ColumnHeader column = this.createColumn(dimension, (PresentationDefinitionRoleMember)memberPair.getValue());
                count.increment();
                if (dimensionLevel < dimensions.size()) {
                    column.setColumnList(this.getColumns(dimensions, members, dimensionLevel, count));
                }
                result.add(column);
            }
        }
        return result;
    }

    private void generateHashToLeafs(List<ColumnHeader> columns, List<String> dimensions) {
        for (ColumnHeader columnHeader : columns) {
            LinkedList<String> dimensionsForParent = new LinkedList<String>(dimensions);
            dimensionsForParent.add(columnHeader.getDataField());
            if (CollectionUtils.isEmpty((Collection)columnHeader.getColumnList())) {
                columnHeader.setHash(this.generateMd5FromList(dimensionsForParent));
                continue;
            }
            this.generateHashToLeafs(columnHeader.getColumnList(), dimensionsForParent);
        }
    }

    private String generateMd5FromList(List<String> dimensions) {
        dimensions.sort(String::compareTo);
        return DigestUtils.md5Hex((String)String.join((CharSequence)"", dimensions));
    }

    private ColumnHeader createColumn(Pair<String, String> dimension, PresentationDefinitionRoleMember member) {
        return this.createColumn((String)dimension.getKey(), (String)dimension.getValue(), member.getValue());
    }

    private ColumnHeader createColumn(String key, String value, String memberValue) {
        ColumnHeader columnHeader = new ColumnHeader();
        columnHeader.setCaption(String.format("%s-%s", value, memberValue));
        columnHeader.setDataField(String.format("%s%s", key, memberValue));
        columnHeader.setDimension(key);
        return columnHeader;
    }

    public int getMaxStructuredViewSize() {
        return Optional.ofNullable(this.parameterService.getParameter(ParameterName.MAX_STRUCTURED_VIEW_SIZE)).map(p -> Integer.parseInt(p.getValue())).orElse(this.configProperties.getMaxStructuredViewSize());
    }

    public void saveMaxStructuredViewSize(String maxStructuredViewSize) {
        if (StringUtils.isNumeric((CharSequence)maxStructuredViewSize)) {
            this.parameterService.saveParameter(ParameterName.MAX_STRUCTURED_VIEW_SIZE, maxStructuredViewSize, ParameterType.INTEGER);
        }
    }
}

