/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.presentation_definition;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.model.XbrlDimension;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.enums.AxisType;
import ru.cbr.xbrl.converter.model.filter.FilterViewType;
import ru.cbr.xbrl.converter.model.filter.RoleClosedAxisInactiveMember;
import ru.cbr.xbrl.converter.model.filter.RoleOpenAxisInactiveMember;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.AspectNodeMember;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterClosedAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterClosedAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlRoleDimension;
import ru.cbr.xbrl.converter.model.validation.Dimension;
import ru.cbr.xbrl.converter.model.web.rest.ToggleDTO;
import ru.cbr.xbrl.converter.repository.RoleClosedAxisInactiveMemberRepository;
import ru.cbr.xbrl.converter.repository.RoleOpenAxisInactiveMemberRepository;
import ru.cbr.xbrl.converter.service.XbrlDimensionService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlRoleService;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisMemberService;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

@Service
public class InactiveMembersService {
    private static final Logger log = LoggerFactory.getLogger(InactiveMembersService.class);
    @Autowired
    private RoleOpenAxisInactiveMemberRepository roleOpenAxisInactiveMemberRepository;
    @Autowired
    private RoleClosedAxisInactiveMemberRepository roleClosedAxisInactiveMemberRepository;
    @Autowired
    private XbrlFilterOpenAxisService xbrlFilterOpenAxisService;
    @Autowired
    private XbrlFilterOpenAxisMemberService xbrlFilterOpenAxisMemberService;
    @Autowired
    @Lazy
    private PresentationDefinitionService presentationDefinitionService;
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private XbrlDimensionService xbrlDimensionService;
    @Autowired
    private XbrlRoleService xbrlRoleService;

    public void toggleOpenMember(String roleSystemId, Long filterOpenAxisValueId, FilterViewType filterViewType) {
        RoleOpenAxisInactiveMember.RoleOpenAxisInactiveMemberId id = new RoleOpenAxisInactiveMember.RoleOpenAxisInactiveMemberId(roleSystemId, filterOpenAxisValueId, filterViewType);
        if (this.isInactiveOpenMember(roleSystemId, filterOpenAxisValueId, filterViewType)) {
            this.roleOpenAxisInactiveMemberRepository.delete((Serializable)id);
        } else {
            RoleOpenAxisInactiveMember inactiveMember = new RoleOpenAxisInactiveMember();
            inactiveMember.setRoleOpenAxisInactiveMemberId(id);
            this.roleOpenAxisInactiveMemberRepository.save((Object)inactiveMember);
        }
    }

    public boolean isInactiveOpenMember(String roleSystemId, Long filterOpenAxisValueId, FilterViewType filterViewType) {
        RoleOpenAxisInactiveMember.RoleOpenAxisInactiveMemberId id = new RoleOpenAxisInactiveMember.RoleOpenAxisInactiveMemberId(roleSystemId, filterOpenAxisValueId, filterViewType);
        return this.roleOpenAxisInactiveMemberRepository.exists((Serializable)id);
    }

    public void toggleClosedMember(String roleSystemId, String dimension, String member, FilterViewType filterViewType) {
        RoleClosedAxisInactiveMember.RoleClosedAxisInactiveMemberId id = new RoleClosedAxisInactiveMember.RoleClosedAxisInactiveMemberId(roleSystemId, dimension, member, filterViewType);
        if (this.isInactiveClosedMember(roleSystemId, dimension, member, filterViewType)) {
            this.roleClosedAxisInactiveMemberRepository.delete((Serializable)id);
        } else {
            RoleClosedAxisInactiveMember inactiveMember = new RoleClosedAxisInactiveMember();
            inactiveMember.setRoleClosedAxisInactiveMemberId(id);
            this.roleClosedAxisInactiveMemberRepository.save((Object)inactiveMember);
        }
    }

    public boolean isInactiveClosedMember(String roleSystemId, String dimension, String member, FilterViewType filterViewType) {
        RoleClosedAxisInactiveMember.RoleClosedAxisInactiveMemberId id = new RoleClosedAxisInactiveMember.RoleClosedAxisInactiveMemberId(roleSystemId, dimension, member, filterViewType);
        return this.roleClosedAxisInactiveMemberRepository.exists((Serializable)id);
    }

    public void saveInactiveMembers(XbrlPackage xbrlPackage) {
        this.saveClosedMembers(xbrlPackage.getPresentationDefinitionInactiveClosedAxisMembers(), FilterViewType.PRESENTATION_DEFINITION);
        this.saveOpenMembers(xbrlPackage.getPresentationDefinitionInactiveOpenAxisMembers(), FilterViewType.PRESENTATION_DEFINITION);
        this.saveClosedMembers(xbrlPackage.getTablelinkbaseInactiveClosedAxisMembers(), FilterViewType.TABLELINKBASE);
        this.saveOpenMembers(xbrlPackage.getTablelinkbaseInactiveOpenAxisMembers(), FilterViewType.TABLELINKBASE);
    }

    private void saveOpenMembers(Map<String, XbrlPackage.DimensionList> openMembers, FilterViewType filterViewType) {
        this.roleOpenAxisInactiveMemberRepository.findByRoleOpenAxisInactiveMemberId_FilterViewType(filterViewType).forEach(member -> {
            String roleSystemId = member.getRoleOpenAxisInactiveMemberId().getRoleSystemId();
            openMembers.putIfAbsent(roleSystemId, new XbrlPackage.DimensionList());
            Long filterOpenAxisValueId = member.getRoleOpenAxisInactiveMemberId().getFilterOpenAxisValueId();
            FilterOpenAxisValue filterOpenAxisValue = this.xbrlFilterOpenAxisService.getFilterOpenAxisValue(filterOpenAxisValueId);
            if (filterOpenAxisValue != null) {
                String key = filterOpenAxisValue.getFilterOpenAxis().getSystemId();
                String value = filterOpenAxisValue.getValue();
                Dimension pair = new Dimension(key, value);
                ((XbrlPackage.DimensionList)openMembers.get(roleSystemId)).getDimensions().add(pair);
            }
        });
    }

    private void saveClosedMembers(Map<String, XbrlPackage.DimensionList> closedMembers, FilterViewType filterViewType) {
        this.roleClosedAxisInactiveMemberRepository.findByRoleClosedAxisInactiveMemberId_FilterViewType(filterViewType).forEach(member -> {
            String roleSystemId = member.getRoleClosedAxisInactiveMemberId().getRoleSystemId();
            closedMembers.putIfAbsent(roleSystemId, new XbrlPackage.DimensionList());
            Dimension pair = new Dimension(member.getRoleClosedAxisInactiveMemberId().getDimension(), member.getRoleClosedAxisInactiveMemberId().getMember());
            ((XbrlPackage.DimensionList)closedMembers.get(roleSystemId)).getDimensions().add(pair);
        });
    }

    public void restoreInactiveMembers(XbrlPackage xbrlPackage) {
        Map openMembersPd = xbrlPackage.getPresentationDefinitionInactiveOpenAxisMembers();
        this.restoreOpenMembers(openMembersPd, FilterViewType.PRESENTATION_DEFINITION);
        Map closedMembersPd = xbrlPackage.getPresentationDefinitionInactiveClosedAxisMembers();
        this.restoreClosedMembers(closedMembersPd, FilterViewType.PRESENTATION_DEFINITION);
        Map openMembersTlb = xbrlPackage.getTablelinkbaseInactiveOpenAxisMembers();
        this.restoreOpenMembers(openMembersTlb, FilterViewType.TABLELINKBASE);
        Map closedMembersTlb = xbrlPackage.getTablelinkbaseInactiveClosedAxisMembers();
        this.restoreClosedMembers(closedMembersTlb, FilterViewType.TABLELINKBASE);
    }

    private void restoreClosedMembers(Map<String, XbrlPackage.DimensionList> closedMembers, FilterViewType filterViewType) {
        closedMembers.forEach((roleSystemId, dimensionList) -> dimensionList.getDimensions().forEach(dimension -> {
            RoleClosedAxisInactiveMember.RoleClosedAxisInactiveMemberId id = new RoleClosedAxisInactiveMember.RoleClosedAxisInactiveMemberId(roleSystemId, dimension.getDimension(), dimension.getMember(), filterViewType);
            RoleClosedAxisInactiveMember inactiveMember = new RoleClosedAxisInactiveMember();
            inactiveMember.setRoleClosedAxisInactiveMemberId(id);
            this.roleClosedAxisInactiveMemberRepository.save((Object)inactiveMember);
        }));
    }

    private void restoreOpenMembers(Map<String, XbrlPackage.DimensionList> openMembers, FilterViewType filterViewType) {
        openMembers.forEach((roleSystemId, dimensionList) -> dimensionList.getDimensions().forEach(dimension -> {
            Optional first = this.xbrlFilterOpenAxisMemberService.findFilterOpenAxisValueByDimensionAndValue(dimension);
            if (first.isPresent()) {
                RoleOpenAxisInactiveMember.RoleOpenAxisInactiveMemberId id = new RoleOpenAxisInactiveMember.RoleOpenAxisInactiveMemberId(roleSystemId, ((FilterOpenAxisValue)first.get()).getId(), filterViewType);
                RoleOpenAxisInactiveMember inactiveMember = new RoleOpenAxisInactiveMember();
                inactiveMember.setRoleOpenAxisInactiveMemberId(id);
                this.roleOpenAxisInactiveMemberRepository.save((Object)inactiveMember);
            }
        }));
    }

    private void toggleOpenMemberOn(String roleSystemId, Long filterOpenAxisValueId, FilterViewType filterViewType) {
        RoleOpenAxisInactiveMember.RoleOpenAxisInactiveMemberId id = new RoleOpenAxisInactiveMember.RoleOpenAxisInactiveMemberId(roleSystemId, filterOpenAxisValueId, filterViewType);
        RoleOpenAxisInactiveMember inactiveMember = new RoleOpenAxisInactiveMember();
        inactiveMember.setRoleOpenAxisInactiveMemberId(id);
        this.roleOpenAxisInactiveMemberRepository.save((Object)inactiveMember);
    }

    private void toggleClosedMemberOn(String roleSystemId, String dimension, String member, FilterViewType filterViewType) {
        RoleClosedAxisInactiveMember.RoleClosedAxisInactiveMemberId id = new RoleClosedAxisInactiveMember.RoleClosedAxisInactiveMemberId(roleSystemId, dimension, member, filterViewType);
        RoleClosedAxisInactiveMember inactiveMember = new RoleClosedAxisInactiveMember();
        inactiveMember.setRoleClosedAxisInactiveMemberId(id);
        this.roleClosedAxisInactiveMemberRepository.save((Object)inactiveMember);
    }

    @Transactional(value="cacheTransactionManager")
    public Set<String> toggle(ToggleDTO toggleDTO, FilterViewType filterViewType) {
        if (toggleDTO.getRoleSystemId() != null) {
            if (toggleDTO.getMemberType().equals((Object)AxisType.OPEN)) {
                this.toggleOpenMember(toggleDTO.getRoleSystemId(), toggleDTO.getFilterOpenAxisValueId(), filterViewType);
            } else {
                this.toggleClosedMember(toggleDTO.getRoleSystemId(), toggleDTO.getDimension(), toggleDTO.getMember(), filterViewType);
            }
        } else if (toggleDTO.getHide() != null) {
            if (toggleDTO.getHide().booleanValue()) {
                if (filterViewType.equals((Object)FilterViewType.TABLELINKBASE)) {
                    return this.toggleAllTlb(toggleDTO);
                }
                return this.toggleAllPd(toggleDTO);
            }
            this.deleteAllToggle(toggleDTO, filterViewType);
        }
        return Collections.emptySet();
    }

    private Set<String> toggleAllTlb(ToggleDTO toggleDTO) {
        HashSet<String> rolesWithData = new HashSet<String>();
        XbrlReport xbrlReport = this.xbrlPackageService.findLastPackage().getXbrlReport();
        List<String> roles = xbrlReport.getXbrlReportRoles().stream().map(XbrlReportRole::getSystemId).collect(Collectors.toList());
        if (toggleDTO.getMemberType().equals((Object)AxisType.OPEN)) {
            List<AspectNodeMember> aspectNodeMemberList = null;
            if (toggleDTO.getConfirm() == null || !toggleDTO.getConfirm().booleanValue()) {
                aspectNodeMemberList = Optional.ofNullable(this.xbrlFilterOpenAxisService.getFilterOpenAxisValue(toggleDTO.getFilterOpenAxisValueId())).map(FilterOpenAxisValue::getAspectNodeMemberList).orElse(Collections.emptyList());
                aspectNodeMemberList.forEach(aspectNodeMember -> rolesWithData.add(aspectNodeMember.getXbrlReportRole().getSystemId()));
            }
            if (aspectNodeMemberList == null || BooleanUtils.isTrue((Boolean)toggleDTO.getConfirm())) {
                roles.forEach(role -> this.toggleOpenMemberOn(role, toggleDTO.getFilterOpenAxisValueId(), FilterViewType.TABLELINKBASE));
            }
        } else {
            HashSet rolesByDimension = new HashSet();
            if (toggleDTO.getConfirm() == null || !toggleDTO.getConfirm().booleanValue()) {
                rolesByDimension.addAll(this.xbrlRoleService.getFilledTlbRolesByDimensions(toggleDTO.getDimension(), toggleDTO.getMember()));
                rolesWithData.addAll(rolesByDimension);
            }
            if (rolesByDimension.isEmpty() || BooleanUtils.isTrue((Boolean)toggleDTO.getConfirm())) {
                roles.forEach(role -> this.toggleClosedMemberOn(role, toggleDTO.getDimension(), toggleDTO.getMember(), FilterViewType.TABLELINKBASE));
            }
        }
        return rolesWithData;
    }

    private Set<String> toggleAllPd(ToggleDTO toggleDTO) {
        HashSet<String> rolesWithData = new HashSet<String>();
        List presentationDefinitionRoles = this.presentationDefinitionService.getPresentationDefinitionRoles();
        if (toggleDTO.getMemberType().equals((Object)AxisType.OPEN)) {
            List<AspectNodeMember> aspectNodeMemberList = null;
            if (toggleDTO.getConfirm() == null || !toggleDTO.getConfirm().booleanValue()) {
                aspectNodeMemberList = Optional.ofNullable(this.xbrlFilterOpenAxisService.getFilterOpenAxisValue(toggleDTO.getFilterOpenAxisValueId())).map(FilterOpenAxisValue::getAspectNodeMemberList).orElse(Collections.emptyList());
                aspectNodeMemberList.forEach(aspectNodeMember -> rolesWithData.add(aspectNodeMember.getXbrlReportRole().getSystemId()));
            }
            if (aspectNodeMemberList == null || BooleanUtils.isTrue((Boolean)toggleDTO.getConfirm())) {
                presentationDefinitionRoles.forEach(role -> this.toggleOpenMemberOn(role.getCode(), toggleDTO.getFilterOpenAxisValueId(), FilterViewType.PRESENTATION_DEFINITION));
            }
        } else {
            HashSet rolesByDimension = new HashSet();
            if (toggleDTO.getConfirm() == null || !toggleDTO.getConfirm().booleanValue()) {
                rolesByDimension.addAll(this.xbrlRoleService.getFilledPdRolesByDimension(toggleDTO.getDimension(), toggleDTO.getMember()));
                rolesWithData.addAll(rolesByDimension);
            }
            if (rolesByDimension.isEmpty() || BooleanUtils.isTrue((Boolean)toggleDTO.getConfirm())) {
                presentationDefinitionRoles.forEach(role -> this.toggleClosedMemberOn(role.getCode(), toggleDTO.getDimension(), toggleDTO.getMember(), FilterViewType.PRESENTATION_DEFINITION));
            }
        }
        return rolesWithData;
    }

    private void deleteAllToggle(ToggleDTO toggleDTO, FilterViewType filterViewType) {
        if (toggleDTO.getMemberType().equals((Object)AxisType.OPEN)) {
            this.roleOpenAxisInactiveMemberRepository.deleteAll(toggleDTO.getFilterOpenAxisValueId(), filterViewType);
        } else {
            this.roleClosedAxisInactiveMemberRepository.deleteAll(toggleDTO.getDimension(), toggleDTO.getMember(), filterViewType);
        }
    }

    @Transactional(value="cacheTransactionManager")
    public Set<FilterAxis> getAllFilterAxis() {
        HashSet<FilterAxis> filterAxisList = new HashSet<FilterAxis>();
        HashSet<FilterClosedAxis> filterClosedAxes = new HashSet<FilterClosedAxis>();
        XbrlReport xbrlReport = this.xbrlPackageService.findLastPackage().getXbrlReport();
        for (XbrlReportRole xbrlReportRole : xbrlReport.getXbrlReportRoles()) {
            for (XbrlRoleDimension xbrlRoleDimension : xbrlReportRole.getXbrlRoleDimensionList()) {
                if (xbrlRoleDimension.getDimensionType() == DimensionType.TYPED_MEMBER) {
                    xbrlRoleDimension.getFilterOpenAxis().getAxisMemberList().size();
                    filterAxisList.add((FilterAxis)xbrlRoleDimension.getFilterOpenAxis());
                    continue;
                }
                if (!filterClosedAxes.stream().noneMatch(closedAxis -> closedAxis.getSystemId().equals(xbrlRoleDimension.getDimension()))) continue;
                FilterClosedAxis filterClosedAxis = new FilterClosedAxis();
                List members = this.xbrlDimensionService.findMembers(xbrlRoleDimension.getDimension());
                if (!members.isEmpty()) {
                    filterClosedAxis.setTitle(((XbrlDimension)members.get(0)).getDimIntLabel());
                    filterClosedAxis.setSystemId(xbrlRoleDimension.getDimension());
                    members.forEach(xbrlDimension -> {
                        FilterClosedAxisValue filterClosedAxisValue = new FilterClosedAxisValue();
                        filterClosedAxisValue.setValue(xbrlDimension.getMemIntLabel());
                        String memInt = xbrlDimension.getMemInt();
                        filterClosedAxisValue.setMember(memInt);
                        filterClosedAxis.getAxisMemberList().add(filterClosedAxisValue);
                    });
                }
                filterClosedAxes.add(filterClosedAxis);
            }
        }
        filterAxisList.addAll(filterClosedAxes);
        return filterAxisList;
    }
}

