/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.log;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.repository.EventLogRepository;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.XbrlRoleService;
import ru.cbr.xbrl.converter.service.log.EventLogService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.event_log.EventLogXlsxWriter;

@Service
public class EventLogServiceImpl
implements EventLogService {
    private static final Logger log = LoggerFactory.getLogger(EventLogServiceImpl.class);
    @Autowired
    private EventLogRepository eventLogRepository;
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private XbrlRoleService xbrlRoleService;
    @Autowired
    private PresentationDefinitionService presentationDefinitionService;

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public Page<EventLog> getPage(Long xbrlReportId, EventLog.EventLogType eventLogType, Integer pageName) throws NotFoundException {
        Integer pageSize = this.configProperties.getLogPageSize();
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        Page eventsPage = this.eventLogRepository.findAllByXbrlReportIdAndEventLogType(xbrlReportId, eventLogType, (Pageable)new PageRequest(pageName.intValue(), pageSize.intValue()));
        eventsPage.getContent().forEach(eventLog -> {
            eventLog.buildAspectData();
            Set tableRoles = this.xbrlRoleService.getTlbRoleMap().findRoles(eventLog.getAspectDataList());
            eventLog.setTableRoles(tableRoles);
            Set pdRoles = this.xbrlRoleService.getPdRoleMap().findRoles(eventLog.getAspectDataList());
            eventLog.setPresentationDefinitionRoles(pdRoles);
            this.fillLabels(eventLog);
        });
        return eventsPage;
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public List<EventLog> findAll(Long xbrlReportId, EventLog.EventLogType eventLogType) throws NotFoundException {
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        List events = this.eventLogRepository.findAllByXbrlReportIdAndEventLogType(xbrlReportId, eventLogType);
        events.forEach(eventLog -> this.fillLabels(eventLog));
        return events;
    }

    private void fillLabels(EventLog eventLog) {
        if (StringUtils.isNotBlank((CharSequence)eventLog.getConcept())) {
            String conceptLabel = (String)this.presentationDefinitionService.getConceptLabels().get(eventLog.getConcept());
            eventLog.setConceptLabel(conceptLabel);
        }
        if (StringUtils.isNotBlank((CharSequence)eventLog.getDimensions())) {
            List xbrlContextDimensions = XbrlContextDimension.dimensionsFromString((String)eventLog.getDimensions());
            String dimensionsLabel = this.presentationDefinitionService.buildDimensionsLabel(xbrlContextDimensions);
            eventLog.setDimensionsLabel(dimensionsLabel);
        }
    }

    @Transactional(value="cacheTransactionManager")
    public EventLog create(EventLog eventLog) {
        return (EventLog)this.eventLogRepository.save((Object)eventLog);
    }

    public void clearAll() {
        this.eventLogRepository.deleteAll();
    }

    @Transactional(value="cacheTransactionManager", propagation=Propagation.REQUIRES_NEW)
    public void clearXml() {
        this.eventLogRepository.deleteAllByEventLogType(EventLog.EventLogType.IMPORT_XML);
    }

    @Transactional(value="cacheTransactionManager", propagation=Propagation.REQUIRES_NEW)
    public void clearCsv() {
        this.eventLogRepository.deleteAllByEventLogType(EventLog.EventLogType.IMPORT_CSV);
    }

    @Transactional(value="cacheTransactionManager", propagation=Propagation.REQUIRES_NEW)
    public void clearXlsx() {
        this.eventLogRepository.deleteAllByEventLogType(EventLog.EventLogType.IMPORT_XLSX);
    }

    @Transactional(value="cacheTransactionManager", propagation=Propagation.REQUIRES_NEW)
    public void clearXlsxCompare() {
        this.eventLogRepository.deleteAllByEventLogType(EventLog.EventLogType.COMPARE_XBRL);
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public void exportEventsToXlsx(Long xbrlReportId, EventLog.EventLogType eventLogType, String xlsxFileName) throws NotFoundException {
        List eventList = this.findAll(xbrlReportId, eventLogType);
        new EventLogXlsxWriter(xlsxFileName, eventLogType, eventList);
    }

    @Transactional(value="cacheTransactionManager", propagation=Propagation.REQUIRES_NEW)
    public EventLog createInNewTransaction(EventLog eventLog) {
        return (EventLog)this.eventLogRepository.save((Object)eventLog);
    }

    @Transactional(value="cacheTransactionManager", propagation=Propagation.REQUIRES_NEW)
    public void createEventLogMessageInNewTransaction(String message, EventLog.EventLogType eventLogType, XbrlReport xbrlReport) {
        log.warn("Log event: {} {}", (Object)eventLogType, (Object)message);
        EventLog eventLog = new EventLog();
        eventLog.setEventLogType(eventLogType);
        eventLog.setMessage(message);
        eventLog.setXbrlReportId(xbrlReport.getId());
        this.create(eventLog);
    }

    @Transactional(value="cacheTransactionManager", propagation=Propagation.REQUIRES_NEW)
    public void createCsvEventLogMessageInNewTransaction(String message, String valueContextUnit, String rowNumbers, XbrlReport xbrlReport) {
        EventLog.EventLogType eventLogType = EventLog.EventLogType.IMPORT_CSV;
        log.warn("Log event: {} {}", (Object)eventLogType, (Object)message);
        EventLog eventLog = new EventLog();
        eventLog.setEventLogType(eventLogType);
        eventLog.setMessage(message);
        eventLog.setXbrlReportId(xbrlReport.getId());
        eventLog.setConcept(valueContextUnit);
        eventLog.setAddress(rowNumbers);
        this.create(eventLog);
    }

    @Transactional(value="cacheTransactionManager", propagation=Propagation.REQUIRES_NEW)
    public void createEventLogMessageInNewTransaction(String message, EventLog.EventLogType eventLogType, XbrlReport xbrlReport, String concept, String dimensions, String period) {
        log.warn("Log event: {} {}", (Object)eventLogType, (Object)message);
        EventLog eventLog = new EventLog();
        eventLog.setEventLogType(eventLogType);
        eventLog.setMessage(message);
        eventLog.setXbrlReportId(xbrlReport.getId());
        eventLog.setConcept(concept);
        eventLog.setDimensions(dimensions);
        this.create(eventLog);
    }
}

