/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.internal.xbrl;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlUnit;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlUnitId;
import ru.cbr.xbrl.converter.repository.XbrlUnitRepository;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlUnitCrudService;

@Service
public class XbrlUnitCrudServiceImpl
implements XbrlUnitCrudService {
    private static final Logger log = LoggerFactory.getLogger(XbrlUnitCrudServiceImpl.class);
    @Autowired
    private XbrlUnitRepository xbrlUnitRepository;
    @PersistenceContext(unitName="cachePU")
    private EntityManager entityManager;

    public List<XbrlUnit> list() {
        return this.xbrlUnitRepository.findAll();
    }

    public Slice<XbrlUnit> list(Pageable pageable) {
        return this.xbrlUnitRepository.findAll(pageable);
    }

    public XbrlUnit find(XbrlUnitId id) throws NotFoundException {
        XbrlUnit xbrlUnit = (XbrlUnit)this.xbrlUnitRepository.findOne((Serializable)id);
        if (xbrlUnit == null) {
            log.error("Xbrl unit not found with id " + id);
            throw new NotFoundException();
        }
        return xbrlUnit;
    }

    public XbrlUnit findSafe(XbrlUnitId id) throws NotFoundException {
        XbrlUnit xbrlUnit = (XbrlUnit)this.xbrlUnitRepository.findOne((Serializable)id);
        return xbrlUnit;
    }

    public XbrlUnit findByMeasure(String measure) {
        return this.xbrlUnitRepository.findOneByMeasureIgnoreCase(measure);
    }

    public XbrlUnit create(XbrlUnit xbrlUnit) {
        return (XbrlUnit)this.xbrlUnitRepository.save((Object)xbrlUnit);
    }

    public XbrlUnit update(XbrlUnit xbrlUnit) throws NotFoundException {
        XbrlUnit existingXbrlUnit = this.find(xbrlUnit.getXbrlUnitId());
        return (XbrlUnit)this.xbrlUnitRepository.save((Object)xbrlUnit);
    }

    public void delete(XbrlUnitId id) throws NotFoundException {
        XbrlUnit xbrlUnit = this.find(id);
        this.xbrlUnitRepository.delete((Object)xbrlUnit);
    }

    public void deleteAllByXbrlReport(XbrlReport xbrlReport) {
        this.entityManager.createQuery("delete from XbrlUnit c where c.xbrlUnitId.xbrlReportId = :r").setParameter("r", (Object)xbrlReport.getId()).executeUpdate();
    }

    public long count() {
        return this.xbrlUnitRepository.count();
    }
}

