/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportValidationEvent;
import ru.cbr.xbrl.converter.model.validation.ValidationEvent;
import ru.cbr.xbrl.converter.repository.XbrlReportValidationEventRepository;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.internal.XbrlReportValidationEventCrudService;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.validation_log.ValidationLogXlsxWriter;

@Service
public class XbrlReportValidationEventCrudServiceImpl
implements XbrlReportValidationEventCrudService {
    private static final Logger log = LoggerFactory.getLogger(XbrlReportValidationEventCrudServiceImpl.class);
    private static final String EXISTENCE = "existence";
    public static final String EXISTENCE_LABEL = "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u0435\u0439";
    public static final String STOP_CONTROL = "stop-control";
    public static final String STOP_CONTROL_LABEL = "\u0421\u0442\u043e\u043f-\u043a\u043e\u043d\u0442\u0440\u043e\u043b\u0438";
    public static final String WARNINGS = "warnings";
    public static final String WARNINGS_LABEL = "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f";
    private final String EXISTENCE_ASSERTION = "existenceAssertion";
    private final String VALUE_ASSERTION = "valueAssertion";
    private final String ERROR = "ERROR";
    private final String WARNING = "WARNING";
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private XbrlReportValidationEventRepository xbrlReportValidationEventRepository;
    @Autowired
    private XbrlReportService xbrlReportService;

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public Page<XbrlReportValidationEvent> getPage(Long xbrlReportId, Integer pageName, String type) throws NotFoundException {
        Integer pageSize = this.configProperties.getValidation().getPageSize();
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        switch (type) {
            case "existence": {
                return this.xbrlReportValidationEventRepository.findAllByXbrlReportAndType(xbrlReport, "existenceAssertion", (Pageable)new PageRequest(pageName.intValue(), pageSize.intValue()));
            }
            case "stop-control": {
                return this.xbrlReportValidationEventRepository.findAllByXbrlReportAndTypeAndSeverity(xbrlReport, "valueAssertion", "ERROR", (Pageable)new PageRequest(pageName.intValue(), pageSize.intValue()));
            }
            case "warnings": {
                return this.xbrlReportValidationEventRepository.findAllByXbrlReportAndTypeAndSeverity(xbrlReport, "valueAssertion", "WARNING", (Pageable)new PageRequest(pageName.intValue(), pageSize.intValue()));
            }
        }
        log.warn("\u0417\u0430\u043f\u0440\u043e\u0441 \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f. \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 - {}", (Object)type);
        throw new NotFoundException();
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public List<XbrlReportValidationEvent> findAll(Long xbrlReportId, String type) throws NotFoundException {
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        switch (type) {
            case "existence": {
                return this.xbrlReportValidationEventRepository.findAllByXbrlReportAndType(xbrlReport, "existenceAssertion");
            }
            case "stop-control": {
                return this.xbrlReportValidationEventRepository.findAllByXbrlReportAndTypeAndSeverity(xbrlReport, "valueAssertion", "ERROR");
            }
            case "warnings": {
                return this.xbrlReportValidationEventRepository.findAllByXbrlReportAndTypeAndSeverity(xbrlReport, "valueAssertion", "WARNING");
            }
        }
        log.warn("\u0417\u0430\u043f\u0440\u043e\u0441 \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f. \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 - {}", (Object)type);
        throw new NotFoundException();
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlReportValidationEvent create(XbrlReportValidationEvent xbrlReportValidationEvent) {
        return (XbrlReportValidationEvent)this.xbrlReportValidationEventRepository.save((Object)xbrlReportValidationEvent);
    }

    @Transactional(value="cacheTransactionManager")
    public void deleteAll() {
        this.xbrlReportValidationEventRepository.deleteAll();
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public void exportValidationEventsToXlsx(Long xbrlReportId, String xlsxFileName) throws NotFoundException {
        ObjectMapper objectMapper = new ObjectMapper();
        String[] tabs = new String[]{EXISTENCE, STOP_CONTROL, WARNINGS};
        XSSFWorkbook workbook = new XSSFWorkbook();
        for (String tabName : tabs) {
            List eventList = this.findAll(xbrlReportId, tabName);
            List validationEvents = eventList.stream().map(xbrlReportValidationEvent -> {
                String json = xbrlReportValidationEvent.getJson();
                try {
                    return (ValidationEvent)objectMapper.readValue(json, ValidationEvent.class);
                }
                catch (IOException e) {
                    log.warn(ExceptionUtils.getStackTrace((Throwable)e));
                    return null;
                }
            }).collect(Collectors.toList());
            new ValidationLogXlsxWriter(workbook, tabName, validationEvents);
        }
        try (FileOutputStream out = new FileOutputStream(xlsxFileName);){
            workbook.write((OutputStream)out);
        }
        catch (FileNotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static String getTabLabel(String tabName) {
        switch (tabName) {
            case "existence": {
                return EXISTENCE_LABEL;
            }
            case "stop-control": {
                return STOP_CONTROL_LABEL;
            }
            case "warnings": {
                return WARNINGS_LABEL;
            }
        }
        return null;
    }
}

