/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.import_export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.exception.UnsupportedAlternativeExportRoleException;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.Fact;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.PeriodLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.TLBUiModel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.ZLevel;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.service.AspectNodeService;
import ru.cbr.xbrl.converter.service.TableLinkBaseDataService;
import ru.cbr.xbrl.converter.service.import_export.XlsExportService;
import ru.cbr.xbrl.converter.utils.LabelUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.BodyRow;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.Grid;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.TableLinkViewUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.TopHeaderModel;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XslxSheet;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class XlsExportServiceImpl
implements XlsExportService {
    private static final Logger log = LoggerFactory.getLogger(XlsExportServiceImpl.class);
    @Autowired
    private AspectNodeService aspectNodeService;
    @Autowired
    private TableLinkBaseDataService tableLinkBaseDataService;

    public void drawRoleWithYLevelColumns(XslxSheet xslxSheet, TLBUiModel tlbUiModel) throws UnsupportedAlternativeExportRoleException {
        TableLinkBaseStructure staticStructure = tlbUiModel.getStaticStructure();
        ColumnHeader xAspectColumnHeader = null;
        ColumnHeader yAspectColumnHeader = null;
        HashMap xLevelAspectColumnMap = new HashMap();
        HashMap yLevelAspectColumnMap = new HashMap();
        Map dimensionsDefault = staticStructure.getDimensionsDefault();
        Function calcDimensionOpenHashByAspectCellData = this.aspectNodeService.calcDimensionOpenHashByAspectCellData(dimensionsDefault);
        ColumnHeader xHeader = this.tableLinkBaseDataService.buildColumnsFromHierarchyWithAspectColumn(staticStructure.getXAxis(), staticStructure.getPeriodAxis(), xAspectColumnHeader, xLevelAspectColumnMap, -1, calcDimensionOpenHashByAspectCellData);
        ColumnHeader yHeader = this.tableLinkBaseDataService.buildColumnsFromHierarchyWithAspectColumn(staticStructure.getYAxis(), staticStructure.getPeriodAxis(), yAspectColumnHeader, yLevelAspectColumnMap, -1, calcDimensionOpenHashByAspectCellData);
        TopHeaderModel.buildColumnAspectsMap((List)xHeader.getColumnList(), null);
        Map enumerations = tlbUiModel.getEnumerations();
        List xHeaderLeafList = this.getLeafList(xHeader.getColumnList());
        HashMap<String, ColumnHeader> xColumnHeaderMap = new HashMap<String, ColumnHeader>();
        for (ColumnHeader columnHeader : xHeaderLeafList) {
            String hash = columnHeader.getHash();
            ColumnHeader existingColumnHeader = (ColumnHeader)xColumnHeaderMap.get(hash);
            if (existingColumnHeader != null) {
                log.warn("\u041d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u043e\u0432 \u0441 \u043e\u0434\u043d\u0438\u043c hash");
            }
            xColumnHeaderMap.put(hash, columnHeader);
        }
        Grid grid = XlsExportServiceImpl.buildHeaderCrossing((ColumnHeader)xHeader, (ColumnHeader)yHeader);
        grid.setEnumerations(enumerations);
        List periodLevelList = tlbUiModel.getPeriodLevelList();
        int lastYOffset = 4;
        for (PeriodLevel periodLevel : periodLevelList) {
            int lastXOffset = 0;
            List zLevelList = periodLevel.getZLevelList();
            for (ZLevel zLevel : zLevelList) {
                Grid currentGrid = new Grid(grid);
                LinkedList yLevelList = new LinkedList();
                List yLevelListInitial = zLevel.getYLevelList();
                YLevel.collectFullAspectListForEachYLevel((List)yLevelListInitial, null);
                for (YLevel yLevel : yLevelListInitial) {
                    yLevelList.addAll(this.prepareYLevel(yLevel, xColumnHeaderMap, 0));
                }
                List bodyRowList = this.fillBodyRows(xHeader, yHeader, yLevelList, tlbUiModel);
                currentGrid.setBodyRowList(bodyRowList);
                currentGrid.setYOffset(lastYOffset);
                currentGrid.setXOffset(lastXOffset);
                currentGrid.setZAxis(zLevel);
                currentGrid.setPeriod(periodLevel);
                this.drawGrid(xslxSheet, currentGrid);
                lastXOffset = lastXOffset + currentGrid.getColumnCount() + 1;
            }
            lastYOffset = lastYOffset + grid.getRowCount() + 1;
        }
    }

    private void drawGrid(XslxSheet xslxSheet, Grid currentGrid) {
        int columnCount = currentGrid.getColumnCount();
        int xOffset = currentGrid.getXOffset();
        xslxSheet.setColumnWidth(xOffset, 12750);
        for (int i = xOffset; i <= columnCount; ++i) {
            xslxSheet.setColumnWidth(i, 5100);
        }
        List headerList = currentGrid.getHeaderList();
        ColumnHeader titleHeader = null;
        ColumnHeader aspectHeader = null;
        LinkedList<ColumnHeader> dataHeaderList = new LinkedList<ColumnHeader>();
        if (CollectionUtils.isEmpty((Collection)headerList)) {
            throw new RuntimeException("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 xlsx, \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u043f\u043e \u043e\u0441\u0438 \u0445 \u043f\u0443\u0441\u0442\u043e\u0439");
        }
        for (ColumnHeader columnHeader : headerList) {
            if (StringUtils.equals((CharSequence)columnHeader.getDataField(), (CharSequence)"title")) {
                if (titleHeader != null) {
                    throw new RuntimeException("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 xlsx, \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u0438\u043c\u0435\u0435\u0442 \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u0434\u043b\u044f \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u043f\u043e y");
                }
                titleHeader = columnHeader;
                continue;
            }
            if (StringUtils.equals((CharSequence)columnHeader.getDataField(), (CharSequence)"aspectColumn")) {
                aspectHeader = columnHeader;
                continue;
            }
            dataHeaderList.add(columnHeader);
        }
        if (titleHeader == null || CollectionUtils.isEmpty(dataHeaderList)) {
            throw new RuntimeException();
        }
        LinkedHashMap columnHashMap = new LinkedHashMap();
        this.drawGridCoordinates(xslxSheet, currentGrid);
        int maxHeaderYOffset = currentGrid.getYOffset() + currentGrid.getHeaderHeight();
        this.drawHeaderGroup(xslxSheet, titleHeader, xOffset, currentGrid.getYOffset() + 1, columnHashMap, false, maxHeaderYOffset);
        xOffset += titleHeader.getColspan().intValue();
        if (aspectHeader != null) {
            int aspectYOffset = currentGrid.getYOffset() + 1;
            for (ColumnHeader aspectHeaderItem : aspectHeader.getColumnList()) {
                this.drawHeaderGroup(xslxSheet, aspectHeaderItem, xOffset, aspectYOffset, columnHashMap, true, maxHeaderYOffset);
                ++aspectYOffset;
            }
            xOffset += aspectHeader.getColspan().intValue();
        }
        for (ColumnHeader dataHeader : dataHeaderList) {
            this.drawHeaderGroup(xslxSheet, dataHeader, xOffset, currentGrid.getYOffset() + 1, columnHashMap, false, maxHeaderYOffset);
            xOffset += dataHeader.getColspan().intValue();
        }
        List titleLeafList = this.getLeafList(Collections.singletonList(titleHeader));
        this.drawBody(currentGrid, columnHashMap, xslxSheet);
    }

    private void drawGridCoordinates(XslxSheet xslxSheet, Grid currentGrid) {
        int yOffset = currentGrid.getYOffset();
        int xOffset = currentGrid.getXOffset();
        Row row = xslxSheet.getRow(yOffset);
        Cell cellPeriod = xslxSheet.createCell(row, xOffset);
        cellPeriod.setCellStyle(xslxSheet.getCellStyleHeader());
        cellPeriod.setCellValue("T=" + currentGrid.getPeriod().getLabel());
        int lastColumnNumber = xOffset + currentGrid.getColumnCount() - 1;
        Cell cellZ = xslxSheet.createCell(row, lastColumnNumber);
        cellZ.setCellStyle(xslxSheet.getCellStyleHeader());
        cellZ.setCellValue("Z=" + currentGrid.getZAxis().getTitle());
        for (int columnNumber = xOffset + 1; columnNumber < xOffset + currentGrid.getColumnCount() - 1; ++columnNumber) {
            Cell rowEmptyCell = xslxSheet.createCell(row, columnNumber);
            rowEmptyCell.setCellStyle(xslxSheet.getCellStyleHeader());
        }
    }

    private void drawBody(Grid grid, Map<Integer, ColumnHeader> columnMap, XslxSheet xslxSheet) {
        if (grid == null) {
            return;
        }
        List bodyRowList = grid.getBodyRowList();
        if (CollectionUtils.isEmpty(columnMap) || CollectionUtils.isEmpty((Collection)bodyRowList)) {
            return;
        }
        HashMap<CellAddress, CellAddress> mergedCellMap = new HashMap<CellAddress, CellAddress>();
        HashMap cellForMergeMap = new HashMap();
        ArrayList gridCommonAspectDataList = new ArrayList();
        gridCommonAspectDataList.addAll(grid.getPeriod().getAspectDataList());
        gridCommonAspectDataList.addAll(grid.getZAxis().getAspectDataList());
        int rowYOffset = grid.getYOffset() + grid.getHeaderHeight();
        for (BodyRow bodyRow : bodyRowList) {
            boolean beforeFilledCell = true;
            for (Map.Entry<Integer, ColumnHeader> columnEntry : columnMap.entrySet()) {
                Fact fact;
                ColumnHeader columnHeader = columnEntry.getValue();
                Row row = xslxSheet.getRow(rowYOffset);
                Cell cell = xslxSheet.createCell(row, columnHeader.getX().intValue());
                if (columnEntry.getKey() < grid.getYHeaderWidth()) {
                    cell.setCellStyle(xslxSheet.getCellStyleHeader());
                }
                if ((fact = (Fact)bodyRow.getValueMap().get(columnHeader.getDataField())) == null) {
                    if (!beforeFilledCell) continue;
                    CellAddress previousRowCellAddress = new CellAddress(rowYOffset - 1, columnHeader.getX().intValue());
                    CellAddress currentCellAddress = new CellAddress(cell);
                    CellAddress parentCellAddress = (CellAddress)mergedCellMap.get(previousRowCellAddress);
                    if (parentCellAddress != null) {
                        mergedCellMap.put(currentCellAddress, new CellAddress(parentCellAddress.getRow(), parentCellAddress.getColumn()));
                        mergedCellMap.remove(previousRowCellAddress);
                        continue;
                    }
                    mergedCellMap.put(currentCellAddress, previousRowCellAddress);
                    continue;
                }
                beforeFilledCell = false;
                ArrayList aspectDataList = new ArrayList();
                aspectDataList.addAll(columnHeader.getFullAspectDataList());
                aspectDataList.addAll(bodyRow.getAspectDataList());
                aspectDataList.addAll(gridCommonAspectDataList);
                AspectData concept = new AspectCellData(aspectDataList).getConcept();
                if (concept == null) {
                    cell.setCellValue(fact.getValue());
                    continue;
                }
                cell.setCellValue(xslxSheet.checkEnumerationValue(fact.getValue(), concept.getAspectValue(), grid.getEnumerations()));
            }
            ++rowYOffset;
        }
    }

    private CellAddress getParentMergedCell(HashMap<CellAddress, CellAddress> mergedCellMap, CellAddress cellAddress) {
        CellAddress parentMergedCell = mergedCellMap.get(cellAddress);
        if (parentMergedCell == null) {
            return null;
        }
        if ((parentMergedCell = this.getParentMergedCell(mergedCellMap, parentMergedCell)) == null) {
            return cellAddress;
        }
        return parentMergedCell;
    }

    private void drawHeaderGroup(XslxSheet xslxSheet, ColumnHeader columnHeader, int xOffset, int yOffset, Map<Integer, ColumnHeader> columnHashMap, boolean isAspectColumn, int maxHeaderYOffset) {
        Row row = xslxSheet.getRow(yOffset);
        Cell cell = xslxSheet.createCell(row, xOffset);
        cell.setCellStyle(xslxSheet.getCellStyleHeader());
        List childColumnList = columnHeader.getColumnList();
        cell.setCellValue(columnHeader.getCaption());
        if (columnHeader.getColspan() > 1) {
            xslxSheet.addMergedRegion(new CellRangeAddress(yOffset, yOffset, xOffset, xOffset + columnHeader.getColspan() - 1));
        }
        columnHeader.setX(Integer.valueOf(xOffset));
        columnHeader.setY(Integer.valueOf(yOffset));
        if (CollectionUtils.isEmpty((Collection)childColumnList) && !isAspectColumn) {
            this.fillColumnHeaderLeafToCommonHeight(xslxSheet, xOffset, yOffset, maxHeaderYOffset);
            columnHashMap.put(columnHashMap.keySet().size(), columnHeader);
            return;
        }
        if (!columnHeader.isAbstractNode() && !isAspectColumn) {
            this.fillColumnHeaderLeafToCommonHeight(xslxSheet, xOffset, yOffset, maxHeaderYOffset);
            columnHashMap.put(columnHashMap.keySet().size(), columnHeader);
            ++xOffset;
        }
        ++yOffset;
        for (ColumnHeader header : childColumnList) {
            this.drawHeaderGroup(xslxSheet, header, xOffset, yOffset, columnHashMap, isAspectColumn, maxHeaderYOffset);
            xOffset += header.getColspan() == null ? 1 : header.getColspan();
        }
    }

    private void fillColumnHeaderLeafToCommonHeight(XslxSheet xslxSheet, int xOffset, int yOffset, int maxHeaderYOffset) {
        if (yOffset >= maxHeaderYOffset) {
            return;
        }
        for (int i = yOffset + 1; i <= maxHeaderYOffset; ++i) {
            Row currentRow = xslxSheet.getRow(i);
            Cell currentCell = xslxSheet.createCell(currentRow, xOffset);
            currentCell.setCellStyle(xslxSheet.getCellStyleHeader());
        }
    }

    private List<YLevel> prepareYLevel(YLevel yLevel, Map<String, ColumnHeader> xHeaderLeafList, int nestLevel) {
        List yLevelList = yLevel.getYLevelList();
        Fact fact = new Fact();
        NodeType nodeType = yLevel.getNodeType();
        if (nodeType == NodeType.ASPECT) {
            fact.setValue(LabelUtils.calcMemberValueLabel((List)yLevel.getAspectDataList()));
        } else {
            fact.setValue(yLevel.getTitle());
        }
        fact.setDisabled(true);
        yLevel.getFactMap().put("Level_" + nestLevel, fact);
        String hash = yLevel.getHash();
        ColumnHeader columnHeader = xHeaderLeafList.get(hash);
        if (CollectionUtils.isEmpty((Collection)yLevelList)) {
            return Collections.singletonList(yLevel);
        }
        ArrayList<YLevel> result = new ArrayList<YLevel>();
        if (nodeType == NodeType.ASPECT) {
            for (YLevel level2 : yLevelList) {
                List childLevelList = this.prepareYLevel(level2, xHeaderLeafList, nestLevel + 1);
                for (YLevel yLevelAdditional : childLevelList) {
                    if (yLevelAdditional.getNodeType() != NodeType.ASPECT) continue;
                    YLevel modifiedYLevel = new YLevel(yLevel);
                    modifiedYLevel.setYLevelList(new ArrayList<YLevel>(Collections.singletonList(yLevelAdditional)));
                    result.add(modifiedYLevel);
                }
            }
            yLevelList.removeIf(level -> level.getNodeType() == NodeType.ASPECT);
            if (!CollectionUtils.isEmpty((Collection)yLevelList)) {
                result.add(yLevel);
            }
            return result;
        }
        if (nodeType == NodeType.RULE) {
            for (YLevel level3 : yLevelList) {
                result.addAll(this.prepareYLevel(level3, xHeaderLeafList, nestLevel + 1));
            }
            yLevel.setYLevelList(result);
            return Collections.singletonList(yLevel);
        }
        return result;
    }

    private List<BodyRow> fillBodyRows(ColumnHeader xHeader, ColumnHeader yHeader, List<YLevel> yLevelList, TLBUiModel tlbUiModel) {
        ArrayList<BodyRow> bodyRowList = new ArrayList<BodyRow>();
        for (YLevel yLevel : yLevelList) {
            BodyRow bodyRow = new BodyRow();
            Map valueMap = bodyRow.getValueMap();
            valueMap.putAll(yLevel.getFactMap());
            List yLevelChildList = yLevel.getYLevelList();
            if (CollectionUtils.isEmpty((Collection)yLevelChildList)) {
                bodyRow.setAspectDataList(yLevel.getFullAspectDataList());
                bodyRowList.add(bodyRow);
                continue;
            }
            NodeType nodeType = yLevel.getNodeType();
            YLevel yLevelFirstChild = (YLevel)yLevelChildList.get(0);
            if (nodeType == NodeType.RULE) {
                if (yLevel.isAbstractNode()) {
                    valueMap.putAll(yLevelFirstChild.getFactMap());
                    bodyRow.getAspectDataList().addAll(yLevelFirstChild.getFullAspectDataList());
                    yLevelChildList.remove(0);
                } else {
                    bodyRow.getAspectDataList().addAll(yLevel.getFullAspectDataList());
                }
            }
            if (nodeType == NodeType.ASPECT && yLevelFirstChild.getNodeType() == NodeType.ASPECT) {
                valueMap.putAll(this.collectAspectNodeRowFactMap(yLevelFirstChild));
                bodyRow.setAspectDataList(yLevel.getFullAspectDataList());
                yLevelChildList.remove(0);
            }
            bodyRowList.add(bodyRow);
            bodyRowList.addAll(this.fillBodyRows(xHeader, yHeader, yLevelChildList, tlbUiModel));
        }
        return bodyRowList;
    }

    public Map<String, Fact> collectAspectNodeRowFactMap(YLevel yLevel) {
        HashMap<String, Fact> factMap = new HashMap<String, Fact>();
        if (yLevel.getNodeType() == NodeType.ASPECT) {
            factMap.putAll(yLevel.getFactMap());
            List yLevelChildList = yLevel.getYLevelList();
            if (CollectionUtils.isEmpty((Collection)yLevelChildList)) {
                return factMap;
            }
            YLevel level = (YLevel)yLevelChildList.get(0);
            if (level != null && level.getNodeType() == NodeType.ASPECT) {
                factMap.putAll(this.collectAspectNodeRowFactMap(level));
            }
        }
        return factMap;
    }

    public List<ColumnHeader> getLeafList(List<ColumnHeader> columnHeaders) {
        ArrayList<ColumnHeader> result = new ArrayList<ColumnHeader>();
        for (ColumnHeader columnHeader : columnHeaders) {
            if (StringUtils.startsWith((CharSequence)columnHeader.getHash(), (CharSequence)"aspectColumn")) continue;
            if (!columnHeader.isAbstractNode()) {
                result.add(columnHeader);
            }
            if (CollectionUtils.isEmpty((Collection)columnHeader.getColumnList())) continue;
            result.addAll(this.getLeafList(columnHeader.getColumnList()));
        }
        return result;
    }

    private static Grid buildHeaderCrossing(ColumnHeader xHeader, ColumnHeader yHeader) throws UnsupportedAlternativeExportRoleException {
        ColumnHeader column;
        int xHeaderDepth;
        List aspectYColumnList;
        List aspectXColumnList = xHeader.getColumnList().stream().filter(item -> StringUtils.equals((CharSequence)item.getDataField(), (CharSequence)"aspectColumn")).collect(Collectors.toList());
        boolean hasXAspect = true;
        boolean isLastXLevelAspect = true;
        boolean isLastYLevelAspect = true;
        ColumnHeader aspectXColumnHeader = new ColumnHeader();
        if (CollectionUtils.isEmpty(aspectXColumnList) || aspectXColumnList.size() != 1) {
            log.warn("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 xlsx \u0432 \u043d\u043e\u0432\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435. \u041f\u043e \u043e\u0441\u0438 \u0425 \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e aspect \u0441\u0442\u043e\u043b\u0431\u0446\u0430.");
            throw new UnsupportedAlternativeExportRoleException();
        }
        if (!CollectionUtils.isEmpty(aspectXColumnList) && aspectXColumnList.size() == 1 && (aspectXColumnHeader = (ColumnHeader)aspectXColumnList.get(0)).getColumnList().stream().allMatch(item -> StringUtils.isBlank((CharSequence)item.getHash()))) {
            hasXAspect = false;
            xHeader.getColumnList().removeIf(next -> StringUtils.equals((CharSequence)next.getDataField(), (CharSequence)"aspectColumn"));
        }
        if (CollectionUtils.isEmpty(aspectYColumnList = yHeader.getColumnList().stream().filter(item -> StringUtils.equals((CharSequence)item.getDataField(), (CharSequence)"aspectColumn")).collect(Collectors.toList())) || aspectYColumnList.size() != 1) {
            log.warn("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 xlsx \u0432 \u043d\u043e\u0432\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435. \u041f\u043e \u043e\u0441\u0438 Y \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e aspect \u0441\u0442\u043e\u043b\u0431\u0446\u0430.");
            throw new UnsupportedAlternativeExportRoleException();
        }
        ColumnHeader aspectYColumnHeader = (ColumnHeader)aspectYColumnList.get(0);
        if (hasXAspect) {
            xHeaderDepth = aspectXColumnHeader.getColumnList().size();
            column = (ColumnHeader)aspectXColumnHeader.getColumnList().get(xHeaderDepth - 1);
            if (StringUtils.isBlank((CharSequence)column.getHash())) {
                isLastXLevelAspect = false;
            }
        } else {
            xHeaderDepth = TableLinkViewUtils.calcHeadersDepth((List)xHeader.getColumnList());
            isLastXLevelAspect = false;
        }
        int yHeaderWidth = aspectYColumnHeader.getColumnList().size();
        if (yHeaderWidth > 0) {
            column = (ColumnHeader)aspectYColumnHeader.getColumnList().get(yHeaderWidth - 1);
            if (StringUtils.isBlank((CharSequence)column.getHash())) {
                isLastYLevelAspect = false;
            }
        } else {
            isLastYLevelAspect = false;
        }
        List xTitleColumnList = xHeader.getColumnList().stream().filter(item -> StringUtils.equals((CharSequence)item.getDataField(), (CharSequence)"title")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(xTitleColumnList) || xTitleColumnList.size() != 1) {
            log.warn("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 xlsx \u0432 \u043d\u043e\u0432\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435. \u041f\u043e \u043e\u0441\u0438 X \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0441\u0442\u043e\u043b\u0431\u0446\u0430 title (\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f)");
            throw new UnsupportedAlternativeExportRoleException();
        }
        if (xHeaderDepth == 1) {
            xHeaderDepth = 2;
        }
        ColumnHeader xTitleHeader = (ColumnHeader)xTitleColumnList.get(0);
        xTitleHeader.setColspan(Integer.valueOf(yHeaderWidth));
        xTitleHeader.setAbstractNode(true);
        for (int i = 1; i < xHeaderDepth - 1; ++i) {
            ColumnHeader columnHeader = new ColumnHeader();
            columnHeader.setAbstractNode(true);
            columnHeader.setColspan(Integer.valueOf(yHeaderWidth));
            xTitleHeader.getColumnList().add(columnHeader);
            xTitleHeader = columnHeader;
        }
        xTitleHeader.setColumnList(aspectYColumnHeader.getColumnList());
        xHeader.setColspan(xHeader.getColumnList().stream().map(ColumnHeader::getColspan).reduce(0, Integer::sum));
        yHeader.getColumnList().removeIf(next -> StringUtils.equals((CharSequence)next.getDataField(), (CharSequence)"aspectColumn"));
        Grid grid = new Grid();
        grid.setColumnCount(xHeader.getColspan().intValue());
        grid.setRowCount(yHeader.getColspan() + xHeaderDepth);
        grid.setHeaderList(xHeader.getColumnList());
        grid.setYHeaderWidth(yHeaderWidth);
        grid.setHeaderHeight(xHeaderDepth + 1);
        return grid;
    }

    private static void prepareTlbUiModelForYLevelAsColumn(TLBUiModel tlbUiModel) throws UnsupportedAlternativeExportRoleException {
        List periodLevelList = tlbUiModel.getPeriodLevelList();
        for (PeriodLevel periodLevel : periodLevelList) {
            List zLevelList = periodLevel.getZLevelList();
            for (ZLevel zLevel : zLevelList) {
                List yLevelList = zLevel.getYLevelList();
                ((ColumnHeader)tlbUiModel.getColumnList().get(0)).setAbstractNode(true);
                for (YLevel yLevel : yLevelList) {
                    XlsExportServiceImpl.addDynamicColumn((ColumnHeader)((ColumnHeader)tlbUiModel.getColumnList().get(0)), (YLevel)yLevel, (Integer)0, null);
                }
            }
        }
        XlsExportServiceImpl.checkOneHeaderForRule((ColumnHeader)((ColumnHeader)tlbUiModel.getColumnList().get(0)));
    }

    private static Pair<Integer, Integer> addDynamicColumn(ColumnHeader columnHeader, YLevel yLevel, Integer colNum, Map<String, Fact> aspectFactMap) throws UnsupportedAlternativeExportRoleException {
        ColumnHeader columnHeaderNested = new ColumnHeader();
        columnHeaderNested.setAbstractNode(false);
        NodeType nodeType = yLevel.getNodeType();
        if (nodeType != NodeType.ASPECT) {
            throw new UnsupportedAlternativeExportRoleException();
        }
        List columnHeaderGeneratedTitleList = columnHeader.getColumnList().stream().map(ColumnHeader::getCaption).collect(Collectors.toList());
        if (nodeType == NodeType.ASPECT) {
            List aspectDataList = yLevel.getAspectDataList();
            if (CollectionUtils.isEmpty((Collection)aspectDataList)) {
                return new Pair((Object)0, (Object)0);
            }
            AspectData aspectDataItem = (AspectData)aspectDataList.get(0);
            if (aspectDataItem == null) {
                return new Pair((Object)0, (Object)0);
            }
            String title = aspectDataItem.getAxisLabel();
            if (!CollectionUtils.contains(columnHeaderGeneratedTitleList.iterator(), (Object)title)) {
                columnHeaderNested.setCaption(title);
                columnHeaderNested.setDataField("header_common_title_" + colNum);
                columnHeader.getColumnList().add(columnHeaderNested);
            }
            Fact fact = new Fact();
            fact.setDisabled(true);
            fact.setValue(((AspectData)yLevel.getAspectDataList().get(0)).getAxisValueLabel());
            if (!CollectionUtils.isEmpty(aspectFactMap)) {
                Set<Map.Entry<String, Fact>> yHeaderMapEntry = aspectFactMap.entrySet();
                for (Map.Entry<String, Fact> stringFactEntry : yHeaderMapEntry) {
                    if (!StringUtils.startsWith((CharSequence)stringFactEntry.getKey(), (CharSequence)"header_common_title_")) continue;
                    yLevel.getFactMap().put(stringFactEntry.getKey(), stringFactEntry.getValue());
                }
            }
            yLevel.getFactMap().put("header_common_title_" + colNum, fact);
        }
        if (nodeType == NodeType.RULE) {
            if (!CollectionUtils.contains(columnHeaderGeneratedTitleList.iterator(), (Object)("header_common_title_" + colNum))) {
                columnHeaderNested.setCaption("header_common_title_" + colNum);
                columnHeaderNested.setDataField("header_common_title_" + colNum);
                columnHeader.getColumnList().add(columnHeaderNested);
            }
            Fact fact = new Fact();
            fact.setDisabled(true);
            fact.setValue(yLevel.getTitle());
            yLevel.getFactMap().put("header_common_title_" + colNum, fact);
        }
        if (yLevel.isAbstractNode() || yLevel.getNodeType() == NodeType.ASPECT) {
            yLevel.setRowspan(Integer.valueOf(0));
        } else {
            yLevel.setRowspan(Integer.valueOf(1));
        }
        List yLevelList = yLevel.getYLevelList();
        if (CollectionUtils.isEmpty((Collection)yLevelList)) {
            yLevel.setLevel(Integer.valueOf(1));
            yLevel.setRowspan(Integer.valueOf(1));
            return new Pair((Object)1, (Object)1);
        }
        yLevel.setLevel(Integer.valueOf(1));
        Pair resultPair = new Pair((Object)0, (Object)0);
        for (YLevel level : yLevelList) {
            resultPair = XlsExportServiceImpl.addDynamicColumn((ColumnHeader)columnHeader, (YLevel)level, (Integer)(colNum + 1), (Map)(yLevel.getNodeType() == NodeType.RULE ? null : yLevel.getFactMap()));
            yLevel.setLevel(Integer.valueOf(Math.max(yLevel.getLevel(), (Integer)resultPair.getValue() + 1)));
            yLevel.setRowspan(Integer.valueOf(yLevel.getRowspan() + (Integer)resultPair.getKey()));
        }
        return new Pair((Object)yLevel.getRowspan(), (Object)((Integer)resultPair.getValue() + 1));
    }

    private static void checkOneHeaderForRule(ColumnHeader columnHeader) {
        Set ruleTitleSet = columnHeader.getColumnList().stream().map(ColumnHeader::getCaption).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(ruleTitleSet)) {
            columnHeader.getColumnList().clear();
            columnHeader.setDataField("header_common_title_0");
            return;
        }
        if (ruleTitleSet.size() == 1 && StringUtils.startsWith((CharSequence)((CharSequence)ruleTitleSet.iterator().next()), (CharSequence)"header_common_title_")) {
            columnHeader.getColumnList().clear();
            columnHeader.setDataField("header_common_title_0");
        }
    }
}

