/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.import_export;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import ru.cbr.xbrl.converter.exception.FileCreateException;
import ru.cbr.xbrl.converter.service.import_export.TemporaryFileService;

@Service
public class TemporaryFileServiceImpl
implements TemporaryFileService {
    private static final Logger log = LoggerFactory.getLogger(TemporaryFileServiceImpl.class);

    public File saveTemporaryFile(MultipartFile multipartFile) {
        File savedFile = null;
        try {
            savedFile = File.createTempFile(multipartFile.getOriginalFilename(), null);
            Files.write(savedFile.toPath(), multipartFile.getBytes(), new OpenOption[0]);
            return savedFile;
        }
        catch (IOException e) {
            if (savedFile != null) {
                this.deleteTemporaryFile(savedFile);
            }
            throw new FileCreateException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 \u0438\u0437-\u0437\u0430 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432\u0432\u043e\u0434\u0430-\u0432\u044b\u0432\u043e\u0434\u0430", e.getCause());
        }
    }

    public void deleteTemporaryFile(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            throw new FileCreateException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 \u0438\u0437-\u0437\u0430 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432\u0432\u043e\u0434\u0430-\u0432\u044b\u0432\u043e\u0434\u0430", e.getCause());
        }
    }
}

