/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.import_export;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.arelle.ArelleService;
import ru.cbr.xbrl.converter.arelle.parse.HypercubeService;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.controller.import_export.ImportXlsxResponse;
import ru.cbr.xbrl.converter.exception.ActionCancelledException;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.CommandExecutionException;
import ru.cbr.xbrl.converter.exception.ContextCsvDuplicateException;
import ru.cbr.xbrl.converter.exception.CsvDataNotValidException;
import ru.cbr.xbrl.converter.exception.CsvDataNotValidRuntimeException;
import ru.cbr.xbrl.converter.exception.CsvValidateHeaderIncorrectOrderException;
import ru.cbr.xbrl.converter.exception.CsvValidateHeaderNotContainFieldsException;
import ru.cbr.xbrl.converter.exception.CsvValidateHeadersException;
import ru.cbr.xbrl.converter.exception.FileAlreadyExistsException;
import ru.cbr.xbrl.converter.exception.IncompatibleSchemaRefException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.RefreshInternalXbrlException;
import ru.cbr.xbrl.converter.exception.SchemaValidationException;
import ru.cbr.xbrl.converter.exception.TaxonomyNotFoundException;
import ru.cbr.xbrl.converter.exception.TypedMemberDomainValueIsEmptyException;
import ru.cbr.xbrl.converter.exception.UnitCsvDuplicateException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.exception.WriteFileException;
import ru.cbr.xbrl.converter.exception.XbrlContextEmptyIdentifierException;
import ru.cbr.xbrl.converter.exception.XbrlContextEmptySchemeException;
import ru.cbr.xbrl.converter.exception.XbrlDataNotValidException;
import ru.cbr.xbrl.converter.exception.XbrlDataNotValidRuntimeException;
import ru.cbr.xbrl.converter.exception.XbrlExportException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.exception.XlsxDataNotValidRuntimeException;
import ru.cbr.xbrl.converter.model.DataType;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.pkg.ContextPeriod;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.model.validation.CsvLineInfo;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextId;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlFootnote;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlUnit;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlUnitId;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValueId;
import ru.cbr.xbrl.converter.model_main.Taxonomy;
import ru.cbr.xbrl.converter.repository.XbrlContextRepository;
import ru.cbr.xbrl.converter.service.AspectNodeService;
import ru.cbr.xbrl.converter.service.CacheManagementService;
import ru.cbr.xbrl.converter.service.CellEditableCheckerService;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;
import ru.cbr.xbrl.converter.service.ConceptService;
import ru.cbr.xbrl.converter.service.EnumerationsService;
import ru.cbr.xbrl.converter.service.NamespacesService;
import ru.cbr.xbrl.converter.service.TableLinkBaseDataService;
import ru.cbr.xbrl.converter.service.TaxonomyService;
import ru.cbr.xbrl.converter.service.UpdateService;
import ru.cbr.xbrl.converter.service.XbrlDimensionService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlPeriodService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.XbrlReportServiceImpl;
import ru.cbr.xbrl.converter.service.XbrlRoleService;
import ru.cbr.xbrl.converter.service.event.NotificationEventService;
import ru.cbr.xbrl.converter.service.event.NotificationEventServiceImpl;
import ru.cbr.xbrl.converter.service.import_export.CellValidator;
import ru.cbr.xbrl.converter.service.import_export.ContextCacheKey;
import ru.cbr.xbrl.converter.service.import_export.CsvLineInfoService;
import ru.cbr.xbrl.converter.service.import_export.EditXbrlService;
import ru.cbr.xbrl.converter.service.import_export.ExportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.ImportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.ImportXbrlServiceImpl;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.import_export.XbrlParserStatistics;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisMemberService;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlContextCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlFootnoteCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlUnitCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlValueCrudService;
import ru.cbr.xbrl.converter.service.log.EventLogService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRole;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.service.repair_tagselectors.RepairTagselectorsService;
import ru.cbr.xbrl.converter.utils.LruCache;
import ru.cbr.xbrl.converter.utils.PeriodicallyExecutor;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvCommon;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvFileSet;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvToXmlConverter;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.enums.CsvContextColumns;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.enums.CsvFootnoteColumns;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.enums.CsvUnitColumns;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.enums.CsvValueColumns;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.scenario.XbrlContextScenarioParser;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XslxParser;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.presentation_definition.XlsxPresentationDefinitionParser;

@Service
public class ImportXbrlServiceImpl
implements ImportXbrlService {
    private static final Logger log = LoggerFactory.getLogger(ImportXbrlServiceImpl.class);
    public static final Charset ENCODING = Charset.forName("cp1251");
    private static final int UNITS_HEADER_SIZE = 2;
    private static final int CONTEXTS_HEADER_SIZE = 6;
    private static final int VALUES_HEADER_SIZE = 6;
    private static final int FOOTNOTES_HEADER_SIZE = 9;
    public static final String MESSAGE_LIST_HAS_MERGED_CELL = "\u041b\u0438\u0441\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043e\u0431\u044a\u0435\u0434\u0438\u043d\u0435\u043d\u043d\u044b\u0435 \u044f\u0447\u0435\u0439\u043a\u0438";
    public static final String MESSAGE_INCORRECT_DATA = "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435: ";
    public static final String NONEDITABLE_CELL = "\u041d\u0435\u0440\u0435\u0434\u0435\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u0430\u044f \u044f\u0447\u0435\u0439\u043a\u0430: ";
    private static Set<String> EXCLUDED_CURRENCIES = new HashSet<String>(Arrays.asList("RUR"));
    private static Set<String> AVAILABLE_CURRENCIES = Currency.getAvailableCurrencies().stream().map(m -> m.getCurrencyCode()).filter(c -> !EXCLUDED_CURRENCIES.contains(c)).collect(Collectors.toSet());
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private XbrlContextCrudService xbrlContextCrudService;
    @Autowired
    private XbrlUnitCrudService xbrlUnitCrudService;
    @Autowired
    private XbrlValueCrudService xbrlValueCrudService;
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private ExportXbrlService exportXbrlService;
    @Autowired
    private CounterService counterService;
    @Autowired
    private GaugeService gaugeService;
    @Autowired
    private CacheManagementService cacheManagementService;
    @Autowired
    private XbrlPeriodService xbrlPeriodService;
    @Autowired
    private XbrlContextRepository xbrlContextRepository;
    @Autowired
    private XbrlReportServiceImpl xbrlReportServiceImpl;
    @Autowired
    private TableLinkBaseDataService tableLinkBaseDataService;
    @Autowired
    private EditXbrlService editXbrlService;
    @Autowired
    private NotificationEventService notificationEventService;
    @Autowired
    private ConceptService conceptService;
    @Autowired
    private XbrlFilterOpenAxisService xbrlFilterOpenAxisService;
    @Autowired
    private XbrlFilterOpenAxisMemberService xbrlFilterOpenAxisMemberService;
    @Autowired
    private EventLogService eventLogService;
    @Autowired
    private XbrlFootnoteCrudService xbrlFootnoteCrudService;
    @Autowired
    private PresentationDefinitionService presentationDefinitionService;
    @Autowired
    private UpdateService updateService;
    @Autowired
    private EnumerationsService enumerationsService;
    @Autowired
    private CsvLineInfoService csvLineInfoService;
    @Autowired
    private AspectNodeService aspectNodeService;
    @Autowired
    private ConceptInMemoryService conceptInMemoryService;
    @Autowired
    private ArelleService arelleService;
    @Autowired
    private TaxonomyService taxonomyService;
    @Autowired
    private CellEditableCheckerService cellEditableCheckerService;
    @Autowired
    private XbrlDimensionService xbrlDimensionService;
    @Autowired
    private RepairTagselectorsService repairTagselectorsService;
    @Autowired
    private XbrlRoleService xbrlRoleService;
    @Autowired
    private NamespacesService namespacesService;
    @Autowired
    private HypercubeService hypercubeService;
    private Map<String, String> footnoteFactIdNewExistingMap = new HashMap();

    @Transactional(value="cacheTransactionManager")
    public void importCsv(Long xbrlReportId, CsvFileSet csvFileSet, Boolean isOverwriteData, Boolean isCreateLog) throws IOException, XbrlImportException, NotFoundException, XbrlExportException {
        Date start = new Date();
        log.info("Import from XBRL CSV started...");
        this.eventLogService.clearCsv();
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        List allPeriods = this.xbrlPeriodService.findAll();
        this.importCsv(xbrlPackage, xbrlReport, csvFileSet, allPeriods, isOverwriteData);
        try {
            this.refreshInternalXbrlXml(xbrlReport);
        }
        catch (RefreshInternalXbrlException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlImportException();
        }
        log.info("Import from XBRL CSV completed in " + (new Date().getTime() - start.getTime()) + " msec");
        this.logStat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCsv(XbrlPackage xbrlPackage, XbrlReport xbrlReport, CsvFileSet csvFileSet, List<XbrlPeriod> allPeriods, Boolean isOverwriteData) {
        EventLog.EventLogType eventLogType = EventLog.EventLogType.IMPORT_CSV;
        Boolean isRepairTagselectors = Boolean.FALSE;
        XbrlParserStatistics xbrlParserStatistics = new XbrlParserStatistics();
        PeriodicallyExecutor periodicallyExecutor = null;
        try {
            periodicallyExecutor = new PeriodicallyExecutor(1, () -> this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent(xbrlParserStatistics.printState())));
            HashMap usedUnits = new HashMap();
            HashMap existingFootnoteFactMap = new HashMap();
            Map<String, String> existingContexts = this.xbrlContextCrudService.streamAll().collect(Collectors.toMap(XbrlContext::buildPeriodAndDimensionsHash, XbrlContext::getXbrlContextIdContextId));
            new /* Unavailable Anonymous Inner Class!! */;
        }
        catch (ActionCancelledException e) {
            throw new ActionCancelledException();
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            periodicallyExecutor.stop();
        }
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlPackage importCsvAndRefreshView_old(Long xbrlReportId, CsvFileSet csvFileSet, Boolean isOverwriteData, Boolean isCreateLog) throws IOException, XbrlImportException, NotFoundException, CancelledException, TaxonomyNotFoundException, XbrlExportException, UploadException {
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent("\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u043a\u044d\u0448\u0430"));
        this.cacheManagementService.clearRoles();
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent("\u0417\u0430\u043f\u0440\u043e\u0441 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0442\u0447\u0435\u0442\u0430"));
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelImport();
        }
        this.importCsv(xbrlReportId, csvFileSet, isOverwriteData, isCreateLog);
        XbrlPackage xbrlPackage = xbrlReport.getXbrlPackage();
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent("\u041f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0435 Table Linkbase"));
        this.xbrlReportService.processXbrlFile(xbrlPackage);
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0442\u0447\u0435\u0442\u0430"));
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelImport();
        }
        XbrlPackage processedPackage = this.xbrlPackageService.find(xbrlPackage.getId());
        processedPackage.initAllLazy();
        return processedPackage;
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlPackage importCsvAndRefreshView(Long xbrlReportId, CsvFileSet csvFileSet, Boolean isOverwriteData, Boolean isCreateLog) throws NotFoundException, XbrlExportException, XbrlImportException, CommandExecutionException, IncompatibleSchemaRefException, UploadException, TaxonomyNotFoundException, IOException, XbrlDataNotValidException, CsvDataNotValidException {
        this.eventLogService.clearCsv();
        this.csvLineInfoService.clearAll();
        XbrlReport xbrlReport = null;
        try {
            xbrlReport = this.xbrlReportService.find(xbrlReportId);
            XbrlPackage xbrlPackage = xbrlReport.getXbrlPackage();
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent("\u0427\u0442\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 CSV"));
            if (xbrlPackage.getPathToXsd() == null) {
                throw new RuntimeException("Empty pathToXsd");
            }
            String pathToXsd = xbrlPackage.getPathToXsd().replace("../", "http://");
            this.validateCsv(csvFileSet);
            XbrlReport finalXbrlReport = xbrlReport;
            BiFunction<String, CsvCommon.CSV_SOURCE_FILES, CsvLineInfo> getCsvLineInfoByIdAndType = (csvId, csvSourceFile) -> {
                List csvLineInfoList = this.csvLineInfoService.findByCsvIdAndType(csvId, csvSourceFile);
                if (CollectionUtils.isEmpty((Collection)csvLineInfoList)) {
                    return null;
                }
                return (CsvLineInfo)csvLineInfoList.iterator().next();
            };
            BiFunction<XbrlValue, Integer, Boolean> validateXbrlValue = (xbrlValue, rowNumber) -> {
                String value;
                List namespaceList = this.configProperties.getXbrl().getNamespace();
                String prefix = null;
                String elementUri = xbrlValue.getElementUri();
                for (ConfigProperties.Namespace namespace : namespaceList) {
                    if (namespace.getFacts() == null || !namespace.getFacts().booleanValue() || !StringUtils.equals((CharSequence)namespace.getUri(), (CharSequence)elementUri)) continue;
                    prefix = namespace.getPrefix();
                }
                if (StringUtils.isBlank(prefix)) {
                    this.eventLogService.createCsvEventLogMessageInNewTransaction(String.format(" \u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u043f\u043e \u0441\u0442\u0440\u043e\u043a\u0435 %s \u0432 \u0444\u0430\u0439\u043b\u0435 %s \u0441 \u0442\u0430\u043a\u0438\u043c\u0438 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435\u043c \u0438 \u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u043e\u043c \u0438\u043c\u0435\u043d \u043d\u0435 \u043e\u043f\u0438\u0441\u0430\u043d \u0432 \u0442\u0430\u043a\u0441\u043e\u043d\u043e\u043c\u0438\u0438.", rowNumber, FilenameUtils.getName((String)csvFileSet.getValuesPath())), CsvCommon.CSV_SOURCE_FILES.VALUES.name(), Integer.toString(rowNumber), finalXbrlReport);
                    return false;
                }
                String conceptId = prefix + ":" + xbrlValue.getElementName();
                if (!this.conceptService.exists(conceptId).booleanValue()) {
                    this.eventLogService.createCsvEventLogMessageInNewTransaction(String.format("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u043f\u043e \u0441\u0442\u0440\u043e\u043a\u0435 %s \u0432 \u0444\u0430\u0439\u043b\u0435 %s \u0441 \u0442\u0430\u043a\u0438\u043c\u0438 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435\u043c \u0438 \u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u043e\u043c \u0438\u043c\u0435\u043d \u043d\u0435 \u043e\u043f\u0438\u0441\u0430\u043d \u0432 \u0442\u0430\u043a\u0441\u043e\u043d\u043e\u043c\u0438\u0438", rowNumber, FilenameUtils.getName((String)csvFileSet.getValuesPath())), CsvCommon.CSV_SOURCE_FILES.VALUES.name(), Integer.toString(rowNumber), finalXbrlReport);
                    return false;
                }
                Map enumerationsMap = this.enumerationsService.getEnumerations();
                boolean isEnumeratedItemValid = CellValidator.validateEnumerations((Map)enumerationsMap, (String)conceptId, (String)(value = xbrlValue.getValue()));
                if (!isEnumeratedItemValid) {
                    this.eventLogService.createCsvEventLogMessageInNewTransaction(String.format("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f %s \u043f\u043e \u0441\u0442\u0440\u043e\u043a\u0435 %s \u0444\u0430\u0439\u043b\u0435 %s \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0438\u043f\u0443, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0432 \u0442\u0430\u043a\u0441\u043e\u043d\u043e\u043c\u0438\u0438.", value, rowNumber, FilenameUtils.getName((String)csvFileSet.getValuesPath())), CsvCommon.CSV_SOURCE_FILES.VALUES.name(), Integer.toString(rowNumber), finalXbrlReport);
                    return false;
                }
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    String xsdType = this.conceptService.findXsdTypeByConcept(conceptId);
                    String pattern = this.conceptService.findPatternByConcept(conceptId);
                    boolean isXsdTypeValid = CellValidator.validateSafe((String)value, (String)xsdType);
                    if (!isXsdTypeValid) {
                        this.eventLogService.createCsvEventLogMessageInNewTransaction(String.format("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f %s \u043f\u043e \u0441\u0442\u0440\u043e\u043a\u0435 %s \u0444\u0430\u0439\u043b\u0435 %s \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0438\u043f\u0443, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0432 \u0442\u0430\u043a\u0441\u043e\u043d\u043e\u043c\u0438\u0438.", value, rowNumber, FilenameUtils.getName((String)csvFileSet.getValuesPath())), CsvCommon.CSV_SOURCE_FILES.VALUES.name(), Integer.toString(rowNumber), finalXbrlReport);
                        return false;
                    }
                    boolean isPatternValid = CellValidator.validatePattern((String)value, (String)pattern);
                    if (!isPatternValid) {
                        this.eventLogService.createCsvEventLogMessageInNewTransaction(String.format("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f %s \u043f\u043e \u0441\u0442\u0440\u043e\u043a\u0435 %s \u0444\u0430\u0439\u043b\u0435 %s \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0438\u043f\u0443, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0432 \u0442\u0430\u043a\u0441\u043e\u043d\u043e\u043c\u0438\u0438.", value, rowNumber, FilenameUtils.getName((String)csvFileSet.getValuesPath())), CsvCommon.CSV_SOURCE_FILES.VALUES.name(), Integer.toString(rowNumber), finalXbrlReport);
                        return false;
                    }
                }
                return true;
            };
            String xbrlFileName = CsvToXmlConverter.convertToTemp((CsvFileSet)csvFileSet, (String)pathToXsd, (List)this.configProperties.getXbrl().getNamespace(), importCsvEvent -> this.eventLogService.createCsvEventLogMessageInNewTransaction(importCsvEvent.getMessage(), importCsvEvent.getConceptDimensionUnit(), Integer.toString(importCsvEvent.getRowNumber()), finalXbrlReport), csvLineInfo -> this.csvLineInfoService.save(csvLineInfo), getCsvLineInfoByIdAndType, validateXbrlValue, () -> this.updateService.getCurrentVersion());
            log.info("Generated temporary XBRL: {}", (Object)xbrlFileName);
            EventLog.EventLogType eventLogType = EventLog.EventLogType.IMPORT_CSV;
            Boolean isRepairTagselectors = Boolean.FALSE;
            return this.importXmlAndRefreshView(xbrlReportId, xbrlFileName, isOverwriteData, isCreateLog, isRepairTagselectors, eventLogType);
        }
        catch (CsvValidateHeaderNotContainFieldsException e) {
            this.eventLogService.createEventLogMessageInNewTransaction(String.format("\u0412 \u0448\u0430\u0431\u043b\u043e\u043d\u0435 \u00ab%s\u00bb \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u043f\u043e\u043b\u044f \u00ab%s\u00bb", e.getFilePath(), e.getField()), EventLog.EventLogType.IMPORT_CSV, xbrlReport);
            throw new CsvDataNotValidRuntimeException();
        }
        catch (CsvValidateHeadersException e) {
            this.eventLogService.createEventLogMessageInNewTransaction(String.format("\u0412 \u0448\u0430\u0431\u043b\u043e\u043d\u0435 \u00ab%s\u00bb \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0438", e.getFilePath()), EventLog.EventLogType.IMPORT_CSV, xbrlReport);
            throw new CsvDataNotValidRuntimeException();
        }
        catch (CsvValidateHeaderIncorrectOrderException e) {
            this.eventLogService.createEventLogMessageInNewTransaction(String.format("\u0412 \u0448\u0430\u0431\u043b\u043e\u043d\u0435 \u00ab%s\u00bb \u043d\u0430\u0440\u0443\u0448\u0435\u043d \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u043e\u043b\u0435\u0439.", e.getFilePath()), EventLog.EventLogType.IMPORT_CSV, xbrlReport);
            throw new CsvDataNotValidRuntimeException();
        }
        catch (UnitCsvDuplicateException e) {
            XbrlReport finalXbrlReport = xbrlReport;
            e.getDuplicates().forEach((unitId, rowNumbers) -> {
                String rowNumbersLabel = rowNumbers.stream().map(d -> d.toString()).collect(Collectors.joining("; "));
                this.eventLogService.createCsvEventLogMessageInNewTransaction(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0444\u0430\u0439\u043b\u0430 %s: \u0434\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u044e\u043d\u0438\u0442\u0430", e.getFilePath()), "Unit Id: " + unitId, rowNumbersLabel, finalXbrlReport);
            });
            throw new CsvDataNotValidRuntimeException();
        }
        catch (ContextCsvDuplicateException e) {
            XbrlReport finalXbrlReport = xbrlReport;
            e.getDuplicates().forEach((contextId, rowNumbers) -> {
                String rowNumbersLabel = rowNumbers.stream().map(d -> d.toString()).collect(Collectors.joining("; "));
                this.eventLogService.createCsvEventLogMessageInNewTransaction(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0444\u0430\u0439\u043b\u0430 %s: \u0434\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430", e.getFilePath()), "Context Id: " + contextId, rowNumbersLabel, finalXbrlReport);
            });
            throw new CsvDataNotValidRuntimeException();
        }
        catch (ActionCancelledException e) {
            throw new ActionCancelledException();
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CsvDataNotValidRuntimeException();
        }
    }

    private void validateCsv(CsvFileSet csvFileSet) throws CsvValidateHeaderNotContainFieldsException, CsvValidateHeadersException, CsvValidateHeaderIncorrectOrderException {
        String contexts = csvFileSet.getContextsPath();
        String units = csvFileSet.getUnitsPath();
        String values = csvFileSet.getValuesPath();
        String footnotes = csvFileSet.getFootnotesPath();
        this.validateContexts(contexts);
        this.validateUnits(units);
        this.validateValues(values);
        if (footnotes != null) {
            this.validateFootnotes(footnotes);
        }
    }

    private void validateUnits(String unitsXmlPath) throws CsvValidateHeaderNotContainFieldsException, CsvValidateHeadersException, CsvValidateHeaderIncorrectOrderException {
        try (CSVParser parser = CSVParser.parse((File)new File(unitsXmlPath), (Charset)CsvCommon.CHARSET, (CSVFormat)CsvCommon.CSV_FORMAT_WITHOUT_HEADER);){
            CSVRecord header = (CSVRecord)parser.getRecords().get(0);
            if (header.size() != 0) {
                String record = header.toString();
                if (!record.contains(CsvUnitColumns.UNIT_ID.name) && !record.contains(CsvUnitColumns.CONTENT.name)) {
                    log.warn("CSV header validation error: wrong units header");
                    throw new CsvValidateHeadersException(unitsXmlPath);
                }
                if (!record.contains(CsvUnitColumns.UNIT_ID.name)) {
                    log.warn("CSV header validation error: units header not contain field ", (Object)CsvUnitColumns.UNIT_ID.name);
                    throw new CsvValidateHeaderNotContainFieldsException(unitsXmlPath, CsvUnitColumns.UNIT_ID.name);
                }
                if (!record.contains(CsvUnitColumns.CONTENT.name)) {
                    log.warn("CSV header validation error: units header not contain field ", (Object)CsvUnitColumns.CONTENT.name);
                    throw new CsvValidateHeaderNotContainFieldsException(unitsXmlPath, CsvUnitColumns.CONTENT.name);
                }
                if (header.size() < 2) {
                    log.warn("CSV header validation error: units header wrong fields count");
                } else if (!header.get(0).equals(CsvUnitColumns.UNIT_ID.name)) {
                    log.warn("CSV header validation error: units header incorrect fields order");
                    throw new CsvValidateHeaderIncorrectOrderException(unitsXmlPath);
                }
            }
        }
        catch (IOException ex) {
            log.error("validateUnits");
        }
    }

    private void validateContexts(String contextsXmlPath) throws CsvValidateHeaderNotContainFieldsException, CsvValidateHeadersException, CsvValidateHeaderIncorrectOrderException {
        try (CSVParser parser = CSVParser.parse((File)new File(contextsXmlPath), (Charset)CsvCommon.CHARSET, (CSVFormat)CsvCommon.CSV_FORMAT_WITHOUT_HEADER);){
            CSVRecord header = (CSVRecord)parser.getRecords().get(0);
            if (header.size() != 0) {
                String record = header.toString();
                if (!(record.contains(CsvContextColumns.CONTEXT_ID.name) || record.contains(CsvContextColumns.PERIOD.name) || record.contains(CsvContextColumns.IDENTIFIER.name) || record.contains(CsvContextColumns.SCHEME.name) || record.contains(CsvContextColumns.SEGMENT.name) || record.contains(CsvContextColumns.SCENARIO.name))) {
                    log.warn("CSV header validation error: wrong contexts header");
                    throw new CsvValidateHeadersException(contextsXmlPath);
                }
                if (!record.contains(CsvContextColumns.CONTEXT_ID.name)) {
                    log.warn("CSV header validation error: contexts header not contain field: ", (Object)CsvContextColumns.CONTEXT_ID.name);
                    throw new CsvValidateHeaderNotContainFieldsException(contextsXmlPath, CsvContextColumns.CONTEXT_ID.name);
                }
                if (!record.contains(CsvContextColumns.PERIOD.name)) {
                    log.warn("CSV header validation error: contexts header not contain field: ", (Object)CsvContextColumns.PERIOD.name);
                    throw new CsvValidateHeaderNotContainFieldsException(contextsXmlPath, CsvContextColumns.PERIOD.name);
                }
                if (!record.contains(CsvContextColumns.IDENTIFIER.name)) {
                    log.warn("CSV header validation error: contexts header not contain field: ", (Object)CsvContextColumns.IDENTIFIER.name);
                    throw new CsvValidateHeaderNotContainFieldsException(contextsXmlPath, CsvContextColumns.IDENTIFIER.name);
                }
                if (!record.contains(CsvContextColumns.SCHEME.name)) {
                    log.warn("CSV header validation error: contexts header not contain field: ", (Object)CsvContextColumns.SCHEME.name);
                    throw new CsvValidateHeaderNotContainFieldsException(contextsXmlPath, CsvContextColumns.SCHEME.name);
                }
                if (!record.contains(CsvContextColumns.SEGMENT.name)) {
                    log.warn("CSV header validation error: contexts header not contain field: ", (Object)CsvContextColumns.SEGMENT.name);
                    throw new CsvValidateHeaderNotContainFieldsException(contextsXmlPath, CsvContextColumns.SEGMENT.name);
                }
                if (!record.contains(CsvContextColumns.SCENARIO.name)) {
                    log.warn("CSV header validation error: contexts header not contain field: ", (Object)CsvContextColumns.SCENARIO.name);
                    throw new CsvValidateHeaderNotContainFieldsException(contextsXmlPath, CsvContextColumns.SCENARIO.name);
                }
                if (header.size() < 6) {
                    log.warn("CSV header validation error: contexts header wrong fields count");
                } else if (!(header.get(0).equals(CsvContextColumns.CONTEXT_ID.name) && header.get(1).equals(CsvContextColumns.PERIOD.name) && header.get(2).equals(CsvContextColumns.IDENTIFIER.name) && header.get(3).equals(CsvContextColumns.SCHEME.name) && header.get(4).equals(CsvContextColumns.SEGMENT.name) && header.get(5).equals(CsvContextColumns.SCENARIO.name))) {
                    log.warn("CSV header validation error: contexts header incorrect fields order");
                    throw new CsvValidateHeaderIncorrectOrderException(contextsXmlPath);
                }
            }
        }
        catch (IOException ex) {
            log.error("validateContexts");
        }
    }

    private void validateValues(String valuesXmlPath) throws CsvValidateHeaderNotContainFieldsException, CsvValidateHeadersException, CsvValidateHeaderIncorrectOrderException {
        try (CSVParser parser = CSVParser.parse((File)new File(valuesXmlPath), (Charset)CsvCommon.CHARSET, (CSVFormat)CsvCommon.CSV_FORMAT_WITHOUT_HEADER);){
            CSVRecord header = (CSVRecord)parser.getRecords().get(0);
            if (header.size() != 0) {
                String record = header.toString();
                if (!(record.contains(CsvValueColumns.ELEMENT_LABEL.name) || record.contains(CsvValueColumns.ELEMENT_URI.name) || record.contains(CsvValueColumns.ELEMENT_NAME.name) || record.contains(CsvValueColumns.VALUE.name) || record.contains(CsvValueColumns.NIL.name) || record.contains(CsvValueColumns.CONTEXT.name) || record.contains(CsvValueColumns.UNIT.name) || record.contains(CsvValueColumns.TUPLE.name) || record.contains(CsvValueColumns.PRECISION.name) || record.contains(CsvValueColumns.DECIMALS.name) || record.contains(CsvValueColumns.LANG.name))) {
                    log.warn("CSV header validation error: wrong values header");
                    throw new CsvValidateHeadersException(valuesXmlPath);
                }
                if (!record.contains(CsvValueColumns.ELEMENT_LABEL.name)) {
                    log.warn("CSV header validation error: values header not contain field", (Object)CsvValueColumns.ELEMENT_LABEL.name);
                    throw new CsvValidateHeaderNotContainFieldsException(valuesXmlPath, CsvValueColumns.ELEMENT_LABEL.name);
                }
                if (!record.contains(CsvValueColumns.ELEMENT_URI.name)) {
                    log.warn("CSV header validation error: values header not contain field", (Object)CsvValueColumns.ELEMENT_URI.name);
                    throw new CsvValidateHeaderNotContainFieldsException(valuesXmlPath, CsvValueColumns.ELEMENT_URI.name);
                }
                if (!record.contains(CsvValueColumns.ELEMENT_NAME.name)) {
                    log.warn("CSV header validation error: values header not contain field", (Object)CsvValueColumns.ELEMENT_NAME.name);
                    throw new CsvValidateHeaderNotContainFieldsException(valuesXmlPath, CsvValueColumns.ELEMENT_NAME.name);
                }
                if (!record.contains(CsvValueColumns.VALUE.name)) {
                    log.warn("CSV header validation error: values header not contain field", (Object)CsvValueColumns.VALUE.name);
                    throw new CsvValidateHeaderNotContainFieldsException(valuesXmlPath, CsvValueColumns.VALUE.name);
                }
                if (!record.contains(CsvValueColumns.NIL.name)) {
                    log.warn("CSV header validation error: values header not contain field", (Object)CsvValueColumns.NIL.name);
                    throw new CsvValidateHeaderNotContainFieldsException(valuesXmlPath, CsvValueColumns.NIL.name);
                }
                if (!record.contains(CsvValueColumns.CONTEXT.name)) {
                    log.warn("CSV header validation error: values header not contain field", (Object)CsvValueColumns.CONTEXT.name);
                    throw new CsvValidateHeaderNotContainFieldsException(valuesXmlPath, CsvValueColumns.CONTEXT.name);
                }
                if (!record.contains(CsvValueColumns.UNIT.name)) {
                    log.warn("CSV header validation error: values header not contain field", (Object)CsvValueColumns.UNIT.name);
                    throw new CsvValidateHeaderNotContainFieldsException(valuesXmlPath, CsvValueColumns.UNIT.name);
                }
                if (!record.contains(CsvValueColumns.TUPLE.name)) {
                    log.warn("CSV header validation error: values header not contain field", (Object)CsvValueColumns.TUPLE.name);
                    throw new CsvValidateHeaderNotContainFieldsException(valuesXmlPath, CsvValueColumns.TUPLE.name);
                }
                if (!record.contains(CsvValueColumns.PRECISION.name)) {
                    log.warn("CSV header validation error: values header not contain field", (Object)CsvValueColumns.PRECISION.name);
                    throw new CsvValidateHeaderNotContainFieldsException(valuesXmlPath, CsvValueColumns.PRECISION.name);
                }
                if (!record.contains(CsvValueColumns.DECIMALS.name)) {
                    log.warn("CSV header validation error: values header not contain field", (Object)CsvValueColumns.DECIMALS.name);
                    throw new CsvValidateHeaderNotContainFieldsException(valuesXmlPath, CsvValueColumns.DECIMALS.name);
                }
                if (!record.contains(CsvValueColumns.LANG.name)) {
                    log.warn("CSV header validation error: values header not contain field", (Object)CsvValueColumns.LANG.name);
                    throw new CsvValidateHeaderNotContainFieldsException(valuesXmlPath, CsvValueColumns.LANG.name);
                }
                if (header.size() < 6) {
                    log.warn("CSV header validation error: values header wrong fields count");
                } else if (!(header.get(0).equals(CsvValueColumns.ELEMENT_LABEL.name) && header.get(1).equals(CsvValueColumns.ELEMENT_URI.name) && header.get(2).equals(CsvValueColumns.ELEMENT_NAME.name) && header.get(3).equals(CsvValueColumns.VALUE.name) && header.get(4).equals(CsvValueColumns.NIL.name) && header.get(5).equals(CsvValueColumns.CONTEXT.name) && header.get(6).equals(CsvValueColumns.UNIT.name) && header.get(7).equals(CsvValueColumns.TUPLE.name) && header.get(8).equals(CsvValueColumns.PRECISION.name) && header.get(9).equals(CsvValueColumns.DECIMALS.name) && header.get(10).equals(CsvValueColumns.LANG.name))) {
                    log.warn("CSV header validation error: values header incorrect fields order");
                    throw new CsvValidateHeaderIncorrectOrderException(valuesXmlPath);
                }
            }
        }
        catch (IOException ex) {
            log.error("validateValues");
        }
    }

    private void validateFootnotes(String footnotesXmlPath) throws CsvValidateHeaderNotContainFieldsException, CsvValidateHeadersException, CsvValidateHeaderIncorrectOrderException {
        try (CSVParser parser = CSVParser.parse((File)new File(footnotesXmlPath), (Charset)CsvCommon.CHARSET, (CSVFormat)CsvCommon.CSV_FORMAT_WITHOUT_HEADER);){
            CSVRecord header = (CSVRecord)parser.getRecords().get(0);
            if (header.size() != 0) {
                String record = header.toString();
                if (!(record.contains(CsvFootnoteColumns.FOOTNOTE_ID.name) || record.contains(CsvFootnoteColumns.CONTENT.name) || record.contains(CsvFootnoteColumns.LANGUAGE.name) || record.contains(CsvFootnoteColumns.EXTENDED_LINK_ROLE.name) || record.contains(CsvFootnoteColumns.LOCATOR_ROLE.name) || record.contains(CsvFootnoteColumns.ELEMENT_URI.name) || record.contains(CsvFootnoteColumns.ELEMENT_NAME.name) || record.contains(CsvFootnoteColumns.VALUE.name) || record.contains(CsvFootnoteColumns.CONTEXT.name) || record.contains(CsvFootnoteColumns.UNIT.name) || record.contains(CsvFootnoteColumns.TUPLE.name))) {
                    log.warn("CSV header validation error: wrong footnotes header");
                    throw new CsvValidateHeadersException(footnotesXmlPath);
                }
                if (!record.contains(CsvFootnoteColumns.FOOTNOTE_ID.name)) {
                    log.warn("CSV header validation error: footnotes header not contain field ", (Object)CsvFootnoteColumns.FOOTNOTE_ID.name);
                    throw new CsvValidateHeaderNotContainFieldsException(footnotesXmlPath, CsvFootnoteColumns.FOOTNOTE_ID.name);
                }
                if (!record.contains(CsvFootnoteColumns.CONTENT.name)) {
                    log.warn("CSV header validation error: footnotes header not contain field ", (Object)CsvFootnoteColumns.CONTENT.name);
                    throw new CsvValidateHeaderNotContainFieldsException(footnotesXmlPath, CsvFootnoteColumns.CONTENT.name);
                }
                if (!record.contains(CsvFootnoteColumns.LANGUAGE.name)) {
                    log.warn("CSV header validation error: footnotes header not contain field ", (Object)CsvFootnoteColumns.LANGUAGE.name);
                    throw new CsvValidateHeaderNotContainFieldsException(footnotesXmlPath, CsvFootnoteColumns.LANGUAGE.name);
                }
                if (!record.contains(CsvFootnoteColumns.EXTENDED_LINK_ROLE.name)) {
                    log.warn("CSV header validation error: footnotes header not contain field ", (Object)CsvFootnoteColumns.EXTENDED_LINK_ROLE.name);
                    throw new CsvValidateHeaderNotContainFieldsException(footnotesXmlPath, CsvFootnoteColumns.EXTENDED_LINK_ROLE.name);
                }
                if (!record.contains(CsvFootnoteColumns.LOCATOR_ROLE.name)) {
                    log.warn("CSV header validation error: footnotes header not contain field ", (Object)CsvFootnoteColumns.LOCATOR_ROLE.name);
                    throw new CsvValidateHeaderNotContainFieldsException(footnotesXmlPath, CsvFootnoteColumns.LOCATOR_ROLE.name);
                }
                if (!record.contains(CsvFootnoteColumns.ELEMENT_URI.name)) {
                    log.warn("CSV header validation error: footnotes header not contain field ", (Object)CsvFootnoteColumns.ELEMENT_URI.name);
                    throw new CsvValidateHeaderNotContainFieldsException(footnotesXmlPath, CsvFootnoteColumns.ELEMENT_URI.name);
                }
                if (!record.contains(CsvFootnoteColumns.ELEMENT_NAME.name)) {
                    log.warn("CSV header validation error: footnotes header not contain field ", (Object)CsvFootnoteColumns.ELEMENT_NAME.name);
                    throw new CsvValidateHeaderNotContainFieldsException(footnotesXmlPath, CsvFootnoteColumns.ELEMENT_NAME.name);
                }
                if (!record.contains(CsvFootnoteColumns.VALUE.name)) {
                    log.warn("CSV header validation error: footnotes header not contain field ", (Object)CsvFootnoteColumns.VALUE.name);
                    throw new CsvValidateHeaderNotContainFieldsException(footnotesXmlPath, CsvFootnoteColumns.VALUE.name);
                }
                if (!record.contains(CsvFootnoteColumns.CONTEXT.name)) {
                    log.warn("CSV header validation error: footnotes header not contain field ", (Object)CsvFootnoteColumns.CONTEXT.name);
                    throw new CsvValidateHeaderNotContainFieldsException(footnotesXmlPath, CsvFootnoteColumns.CONTEXT.name);
                }
                if (!record.contains(CsvFootnoteColumns.UNIT.name)) {
                    log.warn("CSV header validation error: footnotes header not contain field ", (Object)CsvFootnoteColumns.UNIT.name);
                    throw new CsvValidateHeaderNotContainFieldsException(footnotesXmlPath, CsvFootnoteColumns.UNIT.name);
                }
                if (!record.contains(CsvFootnoteColumns.TUPLE.name)) {
                    log.warn("CSV header validation error: footnotes header not contain field ", (Object)CsvFootnoteColumns.TUPLE.name);
                    throw new CsvValidateHeaderNotContainFieldsException(footnotesXmlPath, CsvFootnoteColumns.TUPLE.name);
                }
                if (header.size() < 9) {
                    log.warn("CSV header validation error: footnotes header wrong fields count");
                } else if (!(header.get(0).equals(CsvFootnoteColumns.FOOTNOTE_ID.name) && header.get(1).equals(CsvFootnoteColumns.CONTENT.name) && header.get(2).equals(CsvFootnoteColumns.LANGUAGE.name) && header.get(3).equals(CsvFootnoteColumns.EXTENDED_LINK_ROLE.name) && header.get(4).equals(CsvFootnoteColumns.LOCATOR_ROLE.name) && header.get(5).equals(CsvFootnoteColumns.ELEMENT_URI.name) && header.get(6).equals(CsvFootnoteColumns.ELEMENT_NAME.name) && header.get(7).equals(CsvFootnoteColumns.VALUE.name) && header.get(8).equals(CsvFootnoteColumns.CONTEXT.name) && header.get(9).equals(CsvFootnoteColumns.UNIT.name) && header.get(10).equals(CsvFootnoteColumns.TUPLE.name))) {
                    log.warn("CSV header validation error: footnotes header incorrect fields order");
                    throw new CsvValidateHeaderIncorrectOrderException(footnotesXmlPath);
                }
            }
        }
        catch (IOException ex) {
            log.error("validateFootnotes");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional(value="cacheTransactionManager")
    public boolean importXml(Long xbrlReportId, String xbrlFullPath, Boolean isOverwriteData, Boolean isCreateLog, Boolean isRepairTagselectors, EventLog.EventLogType eventLogType) throws IOException, XbrlImportException, NotFoundException, XbrlExportException, IncompatibleSchemaRefException {
        boolean hasErrors = false;
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(xbrlFullPath));){
            hasErrors = this.importXml(xbrlReportId, (InputStream)inputStream, isOverwriteData, isCreateLog, isRepairTagselectors, eventLogType);
            if (this.xbrlReportService.isLastActionCanceled()) {
                this.cancelImport();
            }
            XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
            this.refreshInternalXbrlXml(xbrlReport);
            boolean bl = hasErrors;
            return bl;
        }
        catch (RefreshInternalXbrlException e) {
            throw new XbrlImportException();
        }
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public boolean checkEntryPoint(String xbrlFullPath, String expectedSchema) {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(xbrlFullPath));){
            2 parser = new /* Unavailable Anonymous Inner Class!! */;
            if (StringUtils.isBlank((CharSequence)parser.getEntryPoint())) {
                throw new IncompatibleSchemaRefException();
            }
        }
        catch (IncompatibleSchemaRefException e) {
            return false;
        }
        catch (FileNotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(value="cacheTransactionManager")
    public boolean importXml(Long xbrlReportId, InputStream inputStream, Boolean isOverwriteData, Boolean isCreateLog, Boolean isRepairTagselectors, EventLog.EventLogType eventLogType) throws IOException, XbrlImportException, NotFoundException, IncompatibleSchemaRefException {
        AtomicBoolean hasErrors = new AtomicBoolean(false);
        Date start = new Date();
        log.info("Import from XBRL XML started...");
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        List allPeriods = this.xbrlPeriodService.findAll();
        XbrlParserStatistics xbrlParserStatistics = new XbrlParserStatistics();
        PeriodicallyExecutor periodicallyExecutor = null;
        HashMap usedUnits = new HashMap();
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelImport();
        }
        try {
            periodicallyExecutor = new PeriodicallyExecutor(1, () -> this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent(xbrlParserStatistics.printState())));
            String expectedSchema = xbrlPackage.getPathToXsd();
            Map conceptLabelMap = this.presentationDefinitionService.getConceptLabels();
            Map conceptNameLabelMap = this.presentationDefinitionService.getConceptNameLabelMap();
            this.footnoteFactIdNewExistingMap.clear();
            HashMap contextMap = new HashMap();
            Map<String, String> existingContexts = this.xbrlContextCrudService.streamAll().collect(Collectors.toMap(XbrlContext::buildPeriodAndDimensionsHash, XbrlContext::getXbrlContextIdContextId));
            new /* Unavailable Anonymous Inner Class!! */;
        }
        catch (ActionCancelledException e) {
            throw new ActionCancelledException();
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            periodicallyExecutor.stop();
        }
        log.info("Import from XBRL XML completed in " + (new Date().getTime() - start.getTime()) + " msec");
        this.logStat();
        return hasErrors.get();
    }

    @Transactional(value="cacheTransactionManager", propagation=Propagation.REQUIRED)
    public XbrlPackage importXmlAndRefreshView(Long xbrlReportId, String xbrlFullPath, Boolean isOverwriteData, Boolean isCreateLog, Boolean isRepairTagselectors, EventLog.EventLogType eventLogType) throws IOException, XbrlImportException, NotFoundException, TaxonomyNotFoundException, XbrlExportException, UploadException, IncompatibleSchemaRefException, CommandExecutionException, XbrlDataNotValidException, CsvDataNotValidException {
        this.xbrlRoleService.clearContextRoleMap();
        int totalStages = 5;
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445", 1, 5));
        XbrlReport checkedReport = this.xbrlReportService.find(xbrlReportId);
        if (!eventLogType.equals((Object)EventLog.EventLogType.IMPORT_CSV)) {
            this.eventLogService.clearXml();
        }
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelImport();
        }
        boolean checkResult = true;
        if (BooleanUtils.isTrue((Boolean)this.configProperties.getSkipXbrlCheck())) {
            log.info("Skip check xbrl file");
        } else {
            log.info("Check xbrl file...");
            Date startCheck = new Date();
            try {
                checkResult = this.xbrlReportService.checkXbrlFile(checkedReport, xbrlFullPath, eventLogType);
            }
            catch (CancelledException e) {
                this.cancelImport();
            }
            log.info("Check xbrl file complete in {} msec", (Object)(new Date().getTime() - startCheck.getTime()));
        }
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent("\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u043a\u044d\u0448\u0430", 2, 5));
        this.cacheManagementService.clearRoles();
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent("\u0417\u0430\u043f\u0440\u043e\u0441 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0442\u0447\u0435\u0442\u0430", 3, 5));
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        boolean hasErrors = this.importXml(xbrlReportId, xbrlFullPath, isOverwriteData, isCreateLog, isRepairTagselectors, eventLogType);
        XbrlPackage xbrlPackage = xbrlReport.getXbrlPackage();
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent("\u041f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0435 Table Linkbase", 4, 5));
        if (hasErrors) {
            if (eventLogType.equals((Object)EventLog.EventLogType.IMPORT_CSV)) {
                throw new CsvDataNotValidRuntimeException();
            }
            throw new XbrlDataNotValidRuntimeException();
        }
        try {
            this.xbrlReportService.processXbrlFile(xbrlPackage);
        }
        catch (CancelledException e) {
            this.cancelImport();
        }
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0442\u0447\u0435\u0442\u0430", 5, 5));
        XbrlPackage processedPackage = this.xbrlPackageService.find(xbrlPackage.getId());
        processedPackage.initAllLazy();
        this.xbrlPackageService.processPeriodEnabled(processedPackage.getXbrlReport());
        if (!checkResult) {
            processedPackage.setError("XBRL_DATA_NOT_VALID");
        }
        return processedPackage;
    }

    @Transactional(value="cacheTransactionManager")
    public ImportXlsxResponse importXlsxAndRefreshView(Long xbrlReportId, String xbrlFullPath, Boolean isOverwriteData, Boolean isCreateLog, Boolean isAlternativeFormat) throws NotFoundException, XbrlImportException, UploadException, TaxonomyNotFoundException, XlsxDataNotValidRuntimeException, SchemaValidationException {
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelImport();
        }
        List unsupportedRoles = new ArrayList();
        boolean hasError = false;
        try {
            unsupportedRoles = this.importXlsx(xbrlPackage.getXbrlReport().getId(), xbrlFullPath, isOverwriteData, isCreateLog, isAlternativeFormat);
        }
        catch (XlsxDataNotValidRuntimeException e) {
            hasError = true;
        }
        XbrlPackage processedPackage = this.xbrlPackageService.find(xbrlPackage.getId());
        processedPackage.initAllLazy();
        if (hasError) {
            processedPackage.setError("XLSX_DATA_NOT_VALID");
        }
        return new ImportXlsxResponse(xbrlPackage, unsupportedRoles);
    }

    private List<String> importXlsx(Long xbrlReportId, String xlsxPath, Boolean isOverwriteData, Boolean isCreateLog, Boolean isAlternativeFormat) throws XbrlImportException, XlsxDataNotValidRuntimeException, SchemaValidationException {
        Date start = new Date();
        log.info("Import from XBRL XLSX started...");
        this.eventLogService.clearXlsx();
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        AtomicLong saveDataDuration = new AtomicLong();
        LruCache contexIdLruCache = new LruCache(5000);
        Map cachedDimensionsDefault = null;
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelImport();
        }
        AtomicBoolean hasErrors = new AtomicBoolean(false);
        List explicitDimensions = this.xbrlDimensionService.findAll();
        ArrayList<String> unsupportedRoles = new ArrayList<String>();
        XslxParser xslxParser = new XslxParser(xlsxPath, xbrlPackage, this.eventLogService, this.aspectNodeService, explicitDimensions, this.tableLinkBaseDataService.getTableLinkBaseUIFromFunction(), (aspectCellDataList, notificationEvent) -> this.validateAndSaveValues(null, xbrlReportId, isOverwriteData, xbrlPackage, saveDataDuration, contexIdLruCache, cachedDimensionsDefault, hasErrors, aspectCellDataList, notificationEvent, "Import XLSX validation error"), isAlternativeFormat, unsupportedRoles);
        log.info("Import from XBRL XLSX completed in " + (new Date().getTime() - start.getTime()) + " msec. Data saved in " + saveDataDuration.get() + " msec");
        this.logStat();
        if (hasErrors.get()) {
            throw new XlsxDataNotValidRuntimeException();
        }
        return unsupportedRoles;
    }

    private void validateAndSaveValues(PresentationDefinitionRole role, Long xbrlReportId, Boolean isOverwriteData, XbrlPackage xbrlPackage, AtomicLong saveDataDuration, LruCache<ContextCacheKey, String> contexIdLruCache, Map<String, String> cachedDimensionsDefault, AtomicBoolean hasErrors, List<AspectCellData> aspectCellDataList, NotificationEvent notificationEvent, String warningTitle) {
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, notificationEvent);
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelImport();
        }
        if (!aspectCellDataList.isEmpty()) {
            ArrayList validatedCells = new ArrayList();
            aspectCellDataList.forEach(aspectCellData -> {
                if (this.xbrlReportService.isLastActionCanceled()) {
                    this.cancelImport();
                }
                if (aspectCellData.isMerged()) {
                    this.addError(xbrlReportId, hasErrors, aspectCellData, warningTitle, MESSAGE_LIST_HAS_MERGED_CELL);
                } else if (!this.cellEditableCheckerService.isEditable(aspectCellData)) {
                    this.addError(xbrlReportId, hasErrors, aspectCellData, warningTitle, NONEDITABLE_CELL + aspectCellData.getCellValue());
                } else if (!aspectCellData.validate()) {
                    this.addError(xbrlReportId, hasErrors, aspectCellData, warningTitle, MESSAGE_INCORRECT_DATA + aspectCellData.getCellValue());
                } else {
                    Optional<EnumerateItem> item;
                    List list;
                    aspectCellData.prepare();
                    AspectData aspectData = aspectCellData.getConcept();
                    if (role != null && aspectData.getXsdType().equals("QName") && (list = (List)role.getEnumerations().get(aspectData.getAspectValue())) != null && (item = list.stream().filter(x -> x.getLabel().equals(aspectCellData.getCellValue())).findFirst()).isPresent()) {
                        aspectCellData.setCellValue(item.get().getMember());
                    }
                    validatedCells.add(aspectCellData);
                }
            });
            ContextPeriod contextPeriod = xbrlPackage.getContextPeriod();
            String ctxPeriod = PeriodDates.buildDuration((Date)contextPeriod.getStartDate(), (Date)contextPeriod.getEndDate()).formatDate();
            ArrayList ctxCells = new ArrayList();
            validatedCells.stream().forEach(validatedCell -> {
                Optional<AspectData> period = validatedCell.getAspectDataList().stream().filter(aspectData -> aspectData.getType().equals((Object)AspectType.PERIOD)).findFirst();
                if (period.isPresent() && period.get().getAspectValue().equals(ctxPeriod)) {
                    ctxCells.add(validatedCell);
                }
            });
            validatedCells.removeAll(ctxCells);
            validatedCells.addAll(validatedCells.size(), ctxCells);
            Date startSave = new Date();
            this.editXbrlService.saveCells(xbrlPackage, validatedCells, contexIdLruCache, cachedDimensionsDefault, false, isOverwriteData);
            saveDataDuration.addAndGet(new Date().getTime() - startSave.getTime());
        }
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlPackage importXlsxDefAndRefreshView(Long xbrlReportId, String xbrlFullPath, Boolean isOverwriteData, Boolean isCreateLog) throws NotFoundException, XbrlImportException {
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelImport();
        }
        boolean hasError = false;
        try {
            this.importXlsxDef(xbrlReportId, xbrlFullPath, isOverwriteData.booleanValue(), isCreateLog.booleanValue());
        }
        catch (XlsxDataNotValidRuntimeException e) {
            hasError = true;
        }
        XbrlPackage processedPackage = this.xbrlPackageService.find(xbrlPackage.getId());
        processedPackage.initAllLazy();
        if (hasError) {
            processedPackage.setError("XLSX_DATA_NOT_VALID");
        }
        return processedPackage;
    }

    public void importXlsxDef(Long xbrlReportId, String xlsxPath, boolean isOverwriteData, boolean isCreateLog) throws XbrlImportException, XlsxDataNotValidRuntimeException {
        Date start = new Date();
        log.info("Import from XLSX for presentation definition started...");
        this.eventLogService.clearXlsx();
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        AtomicLong saveDataDuration = new AtomicLong();
        LruCache contexIdLruCache = new LruCache(5000);
        Map cachedDimensionsDefault = null;
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelImport();
        }
        AtomicBoolean hasErrors = new AtomicBoolean(false);
        List roles = this.presentationDefinitionService.getPresentationDefinitionData().getRoles();
        ArrayList<PresentationDefinitionRole> newRoles = new ArrayList<PresentationDefinitionRole>();
        for (PresentationDefinitionRole role2 : roles) {
            newRoles.add(this.presentationDefinitionService.getPresentationDefinitionRole(role2.getCode()));
        }
        newRoles.forEach(newRole -> {
            HashMap domains = new HashMap();
            if (newRole.getDimensions() != null) {
                newRole.getDimensions().forEach(dim -> domains.put(dim.getKey(), this.conceptInMemoryService.findDomainByDimension((String)dim.getKey())));
                newRole.setDomains(domains);
            }
        });
        new XlsxPresentationDefinitionParser(xlsxPath, xbrlPackage, newRoles, this.conceptInMemoryService, this.eventLogService, (role, aspectCellDataList, notificationEvent) -> this.validateAndSaveValues(role, xbrlReportId, Boolean.valueOf(isOverwriteData), xbrlPackage, saveDataDuration, contexIdLruCache, cachedDimensionsDefault, hasErrors, aspectCellDataList, notificationEvent, "Import XLSX presentation definition validation error"));
        log.info("Import from XLSX for presentation definition completed in " + (new Date().getTime() - start.getTime()) + " msec. Data saved in " + saveDataDuration.get() + " msec");
        this.logStat();
        if (hasErrors.get()) {
            throw new XlsxDataNotValidRuntimeException();
        }
    }

    private void addError(Long xbrlReportId, AtomicBoolean hasErrors, AspectCellData aspectCellData, String warningTitle, String message) {
        EventLog eventLog = new EventLog();
        eventLog.setEventLogType(EventLog.EventLogType.IMPORT_XLSX);
        eventLog.setAddress(aspectCellData.getAddress());
        eventLog.setRole(aspectCellData.getRoleLabel());
        eventLog.setMessage(message);
        eventLog.setXbrlReportId(xbrlReportId);
        this.eventLogService.createInNewTransaction(eventLog);
        log.warn("{}: {}", (Object)warningTitle, (Object)message);
        hasErrors.set(true);
    }

    private void saveContext(XbrlContext xbrlContext, XbrlPackage xbrlPackage, List<XbrlPeriod> allPeriods, Map<String, String> contextIdSubstitutionMap, Map<String, String> existingContexts) throws TypedMemberDomainValueIsEmptyException, XbrlContextEmptyIdentifierException, XbrlContextEmptySchemeException {
        this.counterService.increment("saveContext");
        Date start = new Date();
        if (StringUtils.isBlank((CharSequence)xbrlContext.getIdentifier())) {
            throw new XbrlContextEmptyIdentifierException();
        }
        if (StringUtils.isBlank((CharSequence)xbrlContext.getScheme())) {
            throw new XbrlContextEmptySchemeException();
        }
        String scenario = xbrlContext.getScenario();
        new XbrlContextScenarioParser(scenario, dim -> {
            if (dim != null) {
                xbrlContext.getXbrlContextDimensions().add(dim);
            }
        });
        String segment = xbrlContext.getSegment();
        if (StringUtils.isNotBlank((CharSequence)segment)) {
            AtomicInteger segmentDimCount = new AtomicInteger(0);
            new XbrlContextScenarioParser(segment, dim -> {
                if (dim != null) {
                    xbrlContext.getXbrlContextDimensions().add(dim);
                    segmentDimCount.incrementAndGet();
                }
            });
            if (segmentDimCount.get() == 0) {
                xbrlContext.setSegment(null);
            }
        }
        if (xbrlContext.hasEmptyDomainMember()) {
            throw new TypedMemberDomainValueIsEmptyException();
        }
        xbrlContext.rebuildDimensions(this.conceptInMemoryService.getExplicitAspectNodeSet());
        String periodAndDimensionsHash = xbrlContext.buildPeriodAndDimensionsHash();
        if (contextIdSubstitutionMap != null) {
            boolean contextExists = existingContexts.containsKey(periodAndDimensionsHash);
            if (contextExists) {
                contextIdSubstitutionMap.put(xbrlContext.getXbrlContextId().getContextId(), existingContexts.get(periodAndDimensionsHash));
                return;
            }
            try {
                XbrlContext xbrlContextExisting = this.xbrlContextCrudService.find(new XbrlContextId(xbrlContext.getXbrlContextId().getContextId(), xbrlPackage.getXbrlReport().getId()));
                if (!xbrlContextExisting.getPeriodDates().equals((Object)xbrlContext.getPeriodDates()) || !xbrlContextExisting.getDimensionsHash().equals(xbrlContext.getDimensionsHash())) {
                    String newContextId = this.editXbrlService.generateContextId();
                    contextIdSubstitutionMap.put(xbrlContext.getXbrlContextId().getContextId(), newContextId);
                    xbrlContext.getXbrlContextId().setContextId(newContextId);
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        xbrlContext.buildAspectData();
        xbrlContext.getXbrlContextId().setXbrlReportId(xbrlPackage.getXbrlReport().getId());
        xbrlContext.setIdentifier(xbrlPackage.getOgrn());
        xbrlContext.setScheme("http://www.cbr.ru");
        this.xbrlContextCrudService.create(xbrlContext);
        existingContexts.put(periodAndDimensionsHash, xbrlContext.getXbrlContextIdContextId());
        this.saveContextPeriod(xbrlContext, xbrlPackage, allPeriods);
        Long duration = new Date().getTime() - start.getTime();
        this.gaugeService.submit("saveContextDuration", (double)duration.longValue());
    }

    public void fillAxisMembers() {
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent("\u041f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u043e\u0441\u0435\u0439 "));
        List collect = this.xbrlContextRepository.streamAll().collect(Collectors.toList());
        List allAxises = this.xbrlFilterOpenAxisService.findAll();
        List allMembers = this.xbrlFilterOpenAxisMemberService.findAll();
        for (XbrlContext xbrlContext : collect) {
            new XbrlContextScenarioParser(xbrlContext.getScenario(), dim -> {
                if (dim != null) {
                    xbrlContext.getXbrlContextDimensions().add(dim);
                }
            });
            this.xbrlReportServiceImpl.addTypedDimensions(xbrlContext, allAxises, allMembers);
        }
    }

    private void saveContextPeriod(XbrlContext xbrlContext, XbrlPackage xbrlPackage, List<XbrlPeriod> allPeriods) {
        XbrlPeriod existingPeriod;
        PeriodDates periodDates = xbrlContext.getPeriodDates();
        if (periodDates.getPeriodType() != PeriodType.INSTANT && (existingPeriod = this.findPeriod(periodDates, allPeriods)) == null) {
            XbrlPeriod newPeriod = new XbrlPeriod(xbrlPackage, periodDates);
            XbrlPeriod savedPeriod = this.xbrlPeriodService.save(newPeriod);
            allPeriods.add(savedPeriod);
        }
    }

    private XbrlPeriod findPeriod(PeriodDates periodDates, List<XbrlPeriod> allPeriods) {
        for (XbrlPeriod period : allPeriods) {
            if (period.getEnd() == null && this.isSameDaySafe(period.getStart(), periodDates.getInstantDate())) {
                return period;
            }
            if (period.getStart() == null || period.getEnd() == null || !this.isSameDaySafe(period.getStart(), periodDates.getStartDate()) || !this.isSameDaySafe(period.getEnd(), periodDates.getEndDate())) continue;
            return period;
        }
        return null;
    }

    private boolean isSameDaySafe(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        return DateUtils.isSameDay((Date)date1, (Date)date2);
    }

    private boolean saveUnit(XbrlUnit xbrlUnit, XbrlReport xbrlReport, Map<String, String> usedUnits, EventLog.EventLogType eventLogType) {
        boolean hasErrors = false;
        this.counterService.increment("saveUnit");
        Date start = new Date();
        String oldUnitId = xbrlUnit.getXbrlUnitId().getUnitId();
        String[] measureParts = xbrlUnit.getMeasure().split(":");
        if (measureParts.length != 2) {
            throw new RuntimeException("Wrong unit measure:" + xbrlUnit.getMeasure());
        }
        String measureCode = measureParts[1].toUpperCase();
        if (xbrlUnit.getMeasure().startsWith("iso4217")) {
            if (measureCode.equals("PURE")) {
                return false;
            }
            if (!AVAILABLE_CURRENCIES.contains(measureCode)) {
                this.eventLogService.createEventLogMessageInNewTransaction(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u044e\u043d\u0438\u0442\u0430. \u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043a\u043e\u0434 \u044e\u043d\u0438\u0442\u0430: %s.", xbrlUnit.getMeasure()), eventLogType, xbrlReport);
                return true;
            }
        } else if (xbrlUnit.getMeasure().toUpperCase().equals("SHARES") || xbrlUnit.getMeasure().toUpperCase().equals("PURE")) {
            // empty if block
        }
        xbrlUnit.getXbrlUnitId().setUnitId(measureCode);
        String newUnitId = xbrlUnit.getXbrlUnitId().getUnitId();
        usedUnits.putIfAbsent(oldUnitId, newUnitId);
        XbrlUnit existingUnit = this.xbrlUnitCrudService.findByMeasure(xbrlUnit.getMeasure());
        if (existingUnit != null) {
            return hasErrors;
        }
        xbrlUnit.getXbrlUnitId().setXbrlReportId(xbrlReport.getId());
        XbrlUnit createdUnit = this.xbrlUnitCrudService.create(xbrlUnit);
        Long duration = new Date().getTime() - start.getTime();
        this.gaugeService.submit("saveUnitDuration", (double)duration.longValue());
        return hasErrors;
    }

    private boolean saveValue(String contextId, String unitId, XbrlValue xbrlValue, XbrlReport xbrlReport, Boolean isOverwriteData, Map<String, String> usedUnits, Boolean isRepairTagselectors, EventLog.EventLogType eventLogType) throws NotFoundException {
        DataType dataType;
        boolean hasErrors = false;
        this.counterService.increment("saveValue");
        Date start = new Date();
        xbrlValue.getXbrlValueId().setXbrlReportId(xbrlReport.getId());
        XbrlContext xbrlContext = null;
        try {
            xbrlContext = this.xbrlContextCrudService.find(new XbrlContextId(contextId, xbrlReport.getId()));
        }
        catch (NotFoundException e) {
            this.eventLogService.createEventLogMessageInNewTransaction(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0444\u0430\u043a\u0442\u0430, \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d (\u043a\u043e\u043d\u0446\u0435\u043f\u0442 %s)", contextId, xbrlValue.getXbrlValueId().getElementLabel()), eventLogType, xbrlReport);
            hasErrors = true;
            return hasErrors;
        }
        xbrlContext.unpackAspectDataList();
        xbrlValue.getXbrlValueId().setXbrlContextId(xbrlContext.getXbrlContextId().getContextId());
        xbrlValue.setContextIdHash(DigestUtils.md5Hex((String)xbrlContext.getXbrlContextId().getContextId()));
        String conceptId = xbrlValue.getXbrlValueId().getElementLabel();
        AspectCellData aspectCellDataHypercube = new AspectCellData();
        LinkedList<AspectData> aspectDataList = new LinkedList<AspectData>();
        aspectDataList.add(AspectData.buildConcept((String)conceptId));
        List list = XbrlContextDimension.dimensionsFromString((String)xbrlContext.getDimensions());
        list.stream().forEach(xbrlContextDimension -> {
            if (xbrlContextDimension.getDimensionType() != null) {
                aspectDataList.add(xbrlContextDimension.toAspectData());
            }
        });
        aspectCellDataHypercube.setAspectDataList(aspectDataList);
        if (this.cellEditableCheckerService.checkNotEditable(aspectCellDataHypercube)) {
            return false;
        }
        String xsdType = this.conceptService.findXsdTypeByConcept(conceptId);
        String pattern = this.conceptService.findPatternByConcept(conceptId);
        if (StringUtils.isNotBlank((CharSequence)xbrlValue.getValue())) {
            boolean isXsdTypeValid = CellValidator.validateSafe((String)xbrlValue.getValue(), (String)xsdType);
            if (!isXsdTypeValid) {
                this.eventLogService.createEventLogMessageInNewTransaction(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0444\u0430\u043a\u0442\u0430 (\u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 %s, \u043a\u043e\u043d\u0446\u0435\u043f\u0442 %s).  \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 %s \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0438\u043f\u0443 %s", xbrlValue.getXbrlValueId().getXbrlContextId(), xbrlValue.getXbrlValueId().getElementLabel(), xbrlValue.getValue(), xsdType), eventLogType, xbrlReport);
                return hasErrors;
            }
            boolean isPatternValid = CellValidator.validatePattern((String)xbrlValue.getValue(), (String)pattern);
            if (!isPatternValid) {
                this.eventLogService.createEventLogMessageInNewTransaction(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0444\u0430\u043a\u0442\u0430 (\u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 %s, \u043a\u043e\u043d\u0446\u0435\u043f\u0442 %s).  \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 %s \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0430\u0442\u0442\u0435\u0440\u043d\u0443 %s", xbrlValue.getXbrlValueId().getXbrlContextId(), xbrlValue.getXbrlValueId().getElementLabel(), xbrlValue.getValue(), pattern), eventLogType, xbrlReport);
                return hasErrors;
            }
        }
        if ((dataType = this.conceptService.findTypeByConcept(conceptId)).equals((Object)DataType.MONETARY) && StringUtils.isBlank((CharSequence)unitId)) {
            this.eventLogService.createEventLogMessageInNewTransaction(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0444\u0430\u043a\u0442\u0430 (\u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 %s, \u043a\u043e\u043d\u0446\u0435\u043f\u0442 %s).  \u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d unit \u0434\u043b\u044f \u043c\u043e\u043d\u0435\u0442\u0430\u0440\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430", xbrlValue.getXbrlValueId().getXbrlContextId(), xbrlValue.getXbrlValueId().getElementLabel()), eventLogType, xbrlReport);
            hasErrors = true;
            return hasErrors;
        }
        if (StringUtils.isNotBlank((CharSequence)unitId)) {
            XbrlUnit existingUnit = this.xbrlUnitCrudService.findSafe(new XbrlUnitId(unitId, xbrlReport.getId()));
            if (existingUnit == null && usedUnits.containsKey(unitId)) {
                unitId = usedUnits.get(unitId);
                existingUnit = this.xbrlUnitCrudService.findSafe(new XbrlUnitId(unitId, xbrlReport.getId()));
            }
            if (existingUnit != null) {
                xbrlValue.setXbrlUnit(unitId);
            } else {
                this.eventLogService.createEventLogMessageInNewTransaction(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0444\u0430\u043a\u0442\u0430 (\u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 %s, \u043a\u043e\u043d\u0446\u0435\u043f\u0442 %s). \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d unit: %s", xbrlValue.getXbrlValueId().getXbrlContextId(), xbrlValue.getXbrlValueId().getElementLabel(), unitId), eventLogType, xbrlReport);
                hasErrors = true;
                return hasErrors;
            }
        }
        xbrlValue.buildGuid();
        xbrlValue.setDataType(this.conceptService.findTypeByConcept(xbrlValue.getXbrlValueId().getElementLabel()));
        xbrlValue.buildAspectDataList(xbrlContext);
        XbrlValue existingOrCreated = this.xbrlValueCrudService.find(xbrlValue.getXbrlValueId());
        if (existingOrCreated == null) {
            if (isRepairTagselectors.booleanValue()) {
                this.repairTagselectorsService.repairValue(xbrlContext, xbrlValue, eventMessage -> this.eventLogService.createEventLogMessageInNewTransaction(eventMessage, eventLogType, xbrlReport));
            }
            existingOrCreated = this.xbrlValueCrudService.create(xbrlValue);
        } else if (isOverwriteData.booleanValue()) {
            existingOrCreated.setValue(xbrlValue.getValue());
            existingOrCreated.setDecimals(xbrlValue.getDecimals());
            existingOrCreated.setPrecision(xbrlValue.getPrecision());
            existingOrCreated.setXbrlUnit(xbrlValue.getXbrlUnit());
        }
        String existingOrCreatedId = existingOrCreated.getId();
        String xbrlValueId = xbrlValue.getId();
        if (!(StringUtils.isBlank((CharSequence)existingOrCreatedId) || StringUtils.isBlank((CharSequence)xbrlValueId) || StringUtils.equals((CharSequence)existingOrCreatedId, (CharSequence)xbrlValueId))) {
            this.footnoteFactIdNewExistingMap.put(xbrlValueId, existingOrCreatedId);
        }
        if (StringUtils.isBlank((CharSequence)existingOrCreatedId) && !StringUtils.isBlank((CharSequence)xbrlValueId)) {
            existingOrCreated.setId(xbrlValueId);
            existingOrCreated = this.xbrlValueCrudService.update(existingOrCreated);
        }
        AspectCellData aspectCellData = new AspectCellData();
        aspectCellData.setAspectDataList(xbrlValue.getAspectDataList());
        this.presentationDefinitionService.savePresentationDefinitionRolesData(xbrlReport, existingOrCreated, aspectCellData);
        Long duration = new Date().getTime() - start.getTime();
        this.gaugeService.submit("saveValueDuration", (double)duration.longValue());
        return hasErrors;
    }

    private void saveFootnote(XbrlFootnote xbrlFootnote, XbrlReport xbrlReport, EventLog.EventLogType eventLogType) {
        List xbrlValueList;
        if (xbrlFootnote == null || xbrlReport == null) {
            log.info("Saving empty footnote! Check data!");
            this.eventLogService.createEventLogMessageInNewTransaction("\u041f\u0443\u0441\u0442\u043e\u0439 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 (id \u0444\u0430\u043a\u0442\u0430 null)", eventLogType, xbrlReport);
            return;
        }
        xbrlFootnote.setId("a" + UUID.randomUUID().toString());
        xbrlFootnote.setContent(StringUtils.trim((String)xbrlFootnote.getContent()));
        xbrlFootnote.setXbrlReportId(xbrlReport.getId());
        String footnoteFactId = xbrlFootnote.getFootnoteFactId();
        if (StringUtils.isBlank((CharSequence)footnoteFactId)) {
            this.eventLogService.createEventLogMessageInNewTransaction("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0441\u0432\u044f\u0437\u0438 \u0441 \u0444\u0430\u043a\u0442\u043e\u043c (\u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430)", eventLogType, xbrlReport);
            log.error("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0435\u0432 \u043f\u0440\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0435. \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 footnoteFactId");
            return;
        }
        String existingFootnoteFactId = (String)this.footnoteFactIdNewExistingMap.get(footnoteFactId);
        if (!StringUtils.isBlank((CharSequence)existingFootnoteFactId)) {
            footnoteFactId = existingFootnoteFactId;
            xbrlFootnote.setFootnoteFactId(footnoteFactId);
        }
        if (CollectionUtils.isEmpty((Collection)(xbrlValueList = this.xbrlValueCrudService.findAllByIdForFootnote(footnoteFactId)))) {
            this.eventLogService.createEventLogMessageInNewTransaction(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0444\u0430\u043a\u0442 \u0434\u043b\u044f \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f %s (id \u0444\u0430\u043a\u0442\u0430 %s)", xbrlFootnote.getContent(), footnoteFactId), eventLogType, xbrlReport);
            return;
        }
        if (xbrlValueList.size() > 1) {
            this.eventLogService.createEventLogMessageInNewTransaction(String.format("\u0421\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0444\u0430\u043a\u0442\u043e\u0432 \u0434\u043b\u044f \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f %s (id \u0444\u0430\u043a\u0442\u0430 %s)", xbrlFootnote.getContent(), footnoteFactId), eventLogType, xbrlReport);
            log.warn("\u0421\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0444\u0430\u043a\u0442\u043e\u0432, \u0438\u043c\u0435\u044e\u0449\u0438\u0445 \u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u0439 \u043d\u0430\u0431\u043e\u0440 \u043f\u043e\u043b\u0435\u0439 \u0434\u043b\u044f \u0441\u0432\u044f\u0437\u0438 \u0441 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f\u043c\u0438");
            for (XbrlValue currentXbrlValue : xbrlValueList) {
                XbrlValueId xbrlValueId = currentXbrlValue.getXbrlValueId();
                log.warn("\u0424\u0430\u043a\u0442 label - {}, contextId - {}, reportId - {}", new Object[]{xbrlValueId.getElementLabel(), xbrlValueId.getXbrlContextId(), xbrlValueId.getXbrlReportId()});
            }
            return;
        }
        XbrlValue xbrlValue = (XbrlValue)xbrlValueList.iterator().next();
        if (xbrlValue == null && this.xbrlFootnoteCrudService.isFootnoteContentExists(xbrlFootnote.getContent()).booleanValue()) {
            return;
        }
        if (xbrlValue != null && StringUtils.isBlank((CharSequence)xbrlValue.getId())) {
            String footnoteId = "a" + UUID.randomUUID().toString();
            xbrlFootnote.setFootnoteFactId(footnoteId);
            xbrlValue.setId(footnoteId);
            this.xbrlValueCrudService.update(xbrlValue);
        } else if (xbrlValue != null && !StringUtils.isBlank((CharSequence)xbrlValue.getId()) && this.xbrlFootnoteCrudService.isFootnoteFactLinkExists(xbrlFootnote.getContent(), footnoteFactId)) {
            return;
        }
        this.xbrlFootnoteCrudService.fillFootnoteByXbrlValue(xbrlFootnote, xbrlValue);
        this.xbrlFootnoteCrudService.create(xbrlFootnote);
    }

    public void logStat() {
        Long contextsCount = this.xbrlContextCrudService.count();
        Long valuesCount = this.xbrlValueCrudService.count();
        Long unitsCount = this.xbrlUnitCrudService.count();
        log.info(String.format("XbrlReport contents stat: C %d, V %d, U %d", contextsCount, valuesCount, unitsCount));
    }

    public void clearXbrlContent(XbrlReport xbrlReport) {
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent("\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f"));
        this.xbrlValueCrudService.deleteAllByXbrlReport(xbrlReport);
        this.xbrlContextCrudService.deleteAllByXbrlReport(xbrlReport);
        this.xbrlUnitCrudService.deleteAllByXbrlReport(xbrlReport);
    }

    public void refreshInternalXbrlXml(XbrlReport xbrlReport) throws NotFoundException, XbrlExportException, RefreshInternalXbrlException {
        log.info("Refreshing XBRL file in internal store");
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent("\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 XBRL \u0444\u0430\u0439\u043b\u0430 \u0432\u043e \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u043c \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435"));
        String xbrlFullPath = xbrlReport.getFilePath();
        boolean allowOverwriteFile = true;
        try {
            this.exportXbrlService.exportXbrlXml(xbrlReport.getId(), xbrlFullPath, Boolean.TRUE, Boolean.valueOf(allowOverwriteFile));
        }
        catch (FileAlreadyExistsException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new RefreshInternalXbrlException();
        }
        catch (WriteFileException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new RefreshInternalXbrlException();
        }
    }

    public String convertIxbrlToXml(String localPath) throws CommandExecutionException, CancelledException, NotFoundException {
        Date start = new Date();
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.IMPORT, new NotificationEvent("\u041f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0435 IXBRL \u0444\u0430\u0439\u043b\u0430"));
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        Taxonomy taxonomy = this.taxonomyService.findByVersion(xbrlPackage.getTaxonomyVersion());
        String[] packages = new String[]{taxonomy.getFilePath()};
        String resultFileName = this.arelleService.convertIxbrlToXml(localPath, packages);
        Long duration = new Date().getTime() - start.getTime();
        this.gaugeService.submit("saveContextDuration", (double)duration.longValue());
        log.info("Convert IXBRL To XML completed in {} msec", (Object)duration);
        return resultFileName;
    }

    private void cancelImport() {
        log.info("Import xlsx cancelled by user");
        this.xbrlReportService.setLastActionCanceled(false);
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.CANCEL, new NotificationEvent());
        throw new ActionCancelledException();
    }

    static /* synthetic */ XbrlReportService access$000(ImportXbrlServiceImpl x0) {
        return x0.xbrlReportService;
    }

    static /* synthetic */ void access$100(ImportXbrlServiceImpl x0) {
        x0.cancelImport();
    }

    static /* synthetic */ void access$200(ImportXbrlServiceImpl x0, XbrlContext x1, XbrlPackage x2, List x3, Map x4, Map x5) throws TypedMemberDomainValueIsEmptyException, XbrlContextEmptyIdentifierException, XbrlContextEmptySchemeException {
        x0.saveContext(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ EventLogService access$300(ImportXbrlServiceImpl x0) {
        return x0.eventLogService;
    }

    static /* synthetic */ boolean access$400(ImportXbrlServiceImpl x0, String x1, String x2, XbrlValue x3, XbrlReport x4, Boolean x5, Map x6, Boolean x7, EventLog.EventLogType x8) throws NotFoundException {
        return x0.saveValue(x1, x2, x3, x4, x5, x6, x7, x8);
    }

    static /* synthetic */ Logger access$500() {
        return log;
    }

    static /* synthetic */ boolean access$600(ImportXbrlServiceImpl x0, XbrlUnit x1, XbrlReport x2, Map x3, EventLog.EventLogType x4) {
        return x0.saveUnit(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$700(ImportXbrlServiceImpl x0, XbrlFootnote x1, XbrlReport x2, EventLog.EventLogType x3) {
        x0.saveFootnote(x1, x2, x3);
    }
}

