/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.comparing;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.IncompatibleSchemaRefException;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.repository.XbrlContextCompRepository;
import ru.cbr.xbrl.converter.repository.XbrlValueCompRepository;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;

@Service
public class ComparingModelProcessor {
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private XbrlContextCompRepository xbrlContextCompRepository;
    @Autowired
    private XbrlValueCompRepository xbrlValueCompRepository;
    @Autowired
    private ConceptInMemoryService conceptInMemoryService;
    @Autowired
    NamedParameterJdbcTemplate jdbcTemplate;

    @Transactional(value="cacheTransactionManager", propagation=Propagation.REQUIRES_NEW)
    public void fillComparingModel(XbrlPackage xbrlPackage, String otherXbrlInstance) throws IncompatibleSchemaRefException {
        this.xbrlValueCompRepository.deleteAll();
        this.xbrlContextCompRepository.deleteAll();
        String expectedSchema = xbrlPackage.getPathToXsd();
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(otherXbrlInstance));){
            new /* Unavailable Anonymous Inner Class!! */;
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    static /* synthetic */ ConceptInMemoryService access$000(ComparingModelProcessor x0) {
        return x0.conceptInMemoryService;
    }

    static /* synthetic */ XbrlContextCompRepository access$100(ComparingModelProcessor x0) {
        return x0.xbrlContextCompRepository;
    }

    static /* synthetic */ XbrlValueCompRepository access$200(ComparingModelProcessor x0) {
        return x0.xbrlValueCompRepository;
    }
}

