/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.arelle.ArelleOutputParser;
import ru.cbr.xbrl.converter.arelle.ArelleService;
import ru.cbr.xbrl.converter.exception.ActionCancelledException;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.CommandExecutionException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.TaxonomyNotFoundException;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.XbrlReportValidationEvent;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.pkg.ContextPeriod;
import ru.cbr.xbrl.converter.model.validation.ValidationEvent;
import ru.cbr.xbrl.converter.model.validation.ValidationItemRefContext;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model_main.Taxonomy;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;
import ru.cbr.xbrl.converter.service.DimensionsDefaultService;
import ru.cbr.xbrl.converter.service.TaxonomyService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.XbrlRoleService;
import ru.cbr.xbrl.converter.service.XbrlValidateService;
import ru.cbr.xbrl.converter.service.event.NotificationEventService;
import ru.cbr.xbrl.converter.service.event.NotificationEventServiceImpl;
import ru.cbr.xbrl.converter.service.import_export.ExportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.internal.XbrlReportValidationEventCrudService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionData;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRole;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

@Service
public class XbrlValidateServiceImpl
implements XbrlValidateService {
    private static final Logger log = LoggerFactory.getLogger(XbrlValidateServiceImpl.class);
    @Autowired
    private ArelleService arelleService;
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private TaxonomyService taxonomyService;
    @Autowired
    private XbrlReportValidationEventCrudService xbrlReportValidationEventCrudService;
    @Autowired
    private ExportXbrlService exportXbrlService;
    @Autowired
    private NotificationEventService notificationEventService;
    @Autowired
    private XbrlRoleService xbrlRoleService;
    @Autowired
    private ConceptInMemoryService conceptInMemoryService;
    @Autowired
    private PresentationDefinitionService presentationDefinitionService;
    @Autowired
    private DimensionsDefaultService dimensionsDefaultService;

    public List<ValidationEvent> validate(Long id, String[] packages) throws NotFoundException, CommandExecutionException, CancelledException {
        XbrlReport xbrlReport = this.xbrlReportService.find(id);
        if (xbrlReport == null) {
            log.error("Validaton error, xbrlReport not found with id " + id);
            throw new NotFoundException();
        }
        return this.arelleService.validate(xbrlReport, packages);
    }

    public List<ValidationEvent> validate(XbrlReport xbrlReport, String[] packages) throws CommandExecutionException, CancelledException {
        return this.arelleService.validate(xbrlReport, packages);
    }

    public List<ValidationEvent> validate(Long xbrlReportId) throws NotFoundException, CommandExecutionException, TaxonomyNotFoundException, CancelledException {
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        List validated = this.validate(xbrlReportId, xbrlReport.getFilePath());
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        return validated;
    }

    public List<ValidationEvent> validate(Long xbrlReportId, String xbrlFullPath) throws NotFoundException, CommandExecutionException, TaxonomyNotFoundException {
        List validationEvents;
        Taxonomy taxonomy;
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        String taxonomyVersion = xbrlReport.getXbrlPackage().getTaxonomyVersion();
        try {
            taxonomy = this.taxonomyService.findByVersion(taxonomyVersion);
        }
        catch (NotFoundException e) {
            if (this.xbrlReportService.isLastActionCanceled()) {
                this.cancelValidateProcess();
            }
            throw new TaxonomyNotFoundException();
        }
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        String taxonomyPath = taxonomy.getFilePath();
        String[] taxonomyPackages = new String[]{taxonomyPath};
        this.sendStartValidationEventMessage();
        this.xbrlReportValidationEventCrudService.deleteAll();
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        try {
            validationEvents = this.arelleService.validate(xbrlReport, xbrlFullPath, taxonomyPackages);
        }
        catch (CancelledException e) {
            this.cancelValidateProcess();
            return null;
        }
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        for (ValidationEvent validationEvent : validationEvents) {
            if (this.xbrlReportService.isLastActionCanceled()) {
                this.cancelValidateProcess();
            }
            this.fillAspectData(xbrlReport.getXbrlPackage().getContextPeriod(), validationEvent);
            this.sendValidationEvent(xbrlReport, validationEvent);
        }
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelValidateProcess();
        }
        this.sendEndValidationEventMessage();
        return validationEvents;
    }

    private void fillAspectData(ContextPeriod contextPeriod, ValidationEvent validationEvent) {
        ArrayList<AspectData> aspectDataList = new ArrayList<AspectData>();
        String conceptValue = validationEvent.getConceptQName();
        AspectData conceptAspect = new AspectData();
        conceptAspect.setAspect("concept");
        conceptAspect.setAspectValue(conceptValue);
        conceptAspect.setType(AspectType.CONCEPT);
        aspectDataList.add(conceptAspect);
        PeriodType periodType = this.conceptInMemoryService.findPeriodTypeByConcept(conceptValue);
        if (validationEvent.getValidationItemRefContext() == null) {
            validationEvent.setValidationItemRefContext(new ValidationItemRefContext());
        }
        if (StringUtils.isBlank((CharSequence)validationEvent.getValidationItemRefContext().getStartDate()) && StringUtils.isBlank((CharSequence)validationEvent.getValidationItemRefContext().getEndDate()) && StringUtils.isBlank((CharSequence)validationEvent.getValidationItemRefContext().getInstant())) {
            PeriodDates periodDates = null;
            if (periodType == PeriodType.INSTANT) {
                periodDates = PeriodDates.buildInstant((Date)contextPeriod.getEndDate());
                validationEvent.getValidationItemRefContext().setInstant(PeriodDates.formatDate((Date)periodDates.getInstantDate()));
            } else {
                periodDates = PeriodDates.buildDuration((Date)contextPeriod.getStartDate(), (Date)contextPeriod.getEndDate());
                validationEvent.getValidationItemRefContext().setStartDate(PeriodDates.formatDate((Date)periodDates.getStartDate()));
                validationEvent.getValidationItemRefContext().setEndDate(PeriodDates.formatDate((Date)periodDates.getEndDate()));
            }
            ValidationItemRefContext contextRef = validationEvent.getValidationItemRefContext();
            if (contextRef == null) {
                return;
            }
            String instant = contextRef.getInstant();
            if (!StringUtils.contains((CharSequence)validationEvent.getId(), (CharSequence)"existenceAssertion")) {
                if (StringUtils.isNotBlank((CharSequence)instant)) {
                    validationEvent.setPeriodStart(instant);
                } else {
                    validationEvent.setPeriodStart(contextRef.getStartDate());
                    validationEvent.setPeriodStop(contextRef.getEndDate());
                }
            }
        }
        String startDate = validationEvent.getValidationItemRefContext().getStartDate();
        String endDate = validationEvent.getValidationItemRefContext().getEndDate();
        String instantDate = validationEvent.getValidationItemRefContext().getInstant();
        PeriodDates periodDates = null;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            String durationDate = startDate + " - " + endDate;
            periodDates = new PeriodDates(durationDate);
        } else if (StringUtils.isNotBlank((CharSequence)instantDate)) {
            periodDates = new PeriodDates(instantDate);
        }
        AspectData periodAspect = periodDates.buildAspectData();
        aspectDataList.add(periodAspect);
        List dimensions = validationEvent.getValidationItemRefContext().getDimensions();
        List xbrlContextDimensions = dimensions.stream().map(d -> {
            XbrlContextDimension xbrlContextDimension = new XbrlContextDimension();
            xbrlContextDimension.setDimension(d.getDimension());
            xbrlContextDimension.setMember(d.getMember());
            xbrlContextDimension.setDimensionType(DimensionType.EXPLICIT_MEMBER);
            return xbrlContextDimension;
        }).collect(Collectors.toList());
        List dimensionAspects = xbrlContextDimensions.stream().map(XbrlContextDimension::toAspectData).collect(Collectors.toList());
        dimensionAspects = XbrlContextDimension.removeDefaultDimensions(dimensionAspects, (Map)this.dimensionsDefaultService.getDimensionsDefault());
        aspectDataList.addAll(dimensionAspects);
        validationEvent.getItemDescriptionList().stream().forEach(validationEvent1 -> this.fillAspectData(contextPeriod, validationEvent1));
        String dimensionsLabel = this.presentationDefinitionService.buildDimensionsLabel(xbrlContextDimensions);
        validationEvent.setSection(dimensionsLabel);
        Set pdRoles = this.xbrlRoleService.getPdRoleMap().findRoles(aspectDataList);
        Set tableRoles = this.xbrlRoleService.getTlbRoleMap().findRoles(aspectDataList);
        validationEvent.setTableRoles(tableRoles);
        validationEvent.setPresentationDefinitionRoles(pdRoles);
        validationEvent.setAspectDataList(aspectDataList);
        if (!CollectionUtils.isEmpty((Collection)pdRoles)) {
            ArrayList pdRolesTitle = new ArrayList();
            pdRoles.forEach(pdRoleId -> {
                PresentationDefinitionData pdData = this.presentationDefinitionService.getPresentationDefinitionData();
                PresentationDefinitionRole pdRole = (PresentationDefinitionRole)pdData.getRoleMap().get(DigestUtils.md5Hex((String)pdRoleId));
                if (pdRole != null) {
                    pdRolesTitle.add(pdRole.getTitle());
                }
            });
            validationEvent.setPreHeader(pdRolesTitle.stream().collect(Collectors.joining(", ")));
        }
        if (!CollectionUtils.isEmpty((Collection)tableRoles)) {
            ArrayList tableRolesTitle = new ArrayList();
            tableRoles.forEach(tableRoleId -> {
                try {
                    XbrlReportRole tableRole = this.xbrlReportService.findReportRoleBySystemId(tableRoleId);
                    if (tableRole != null) {
                        tableRolesTitle.add(tableRole.getTitle());
                    }
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            });
            validationEvent.setTableHeader(tableRolesTitle.stream().collect(Collectors.joining(", ")));
        }
    }

    public void cancelValidation() {
        this.arelleService.killCurrentArelleProcess();
    }

    private void sendValidationEvent(XbrlReport xbrlReport, ValidationEvent validationEvent) {
        try {
            XbrlReportValidationEvent xbrlReportValidationEvent = new XbrlReportValidationEvent(validationEvent);
            xbrlReportValidationEvent.setXbrlReport(xbrlReport);
            this.xbrlReportValidationEventCrudService.create(xbrlReportValidationEvent);
        }
        catch (JsonProcessingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void sendStartValidationEventMessage() {
        this.simpMessagingTemplate.convertAndSend((Object)"/topic/validation-started", (Object)"");
    }

    private void sendEndValidationEventMessage() {
        this.simpMessagingTemplate.convertAndSend((Object)"/topic/validation-ended", (Object)"");
    }

    private void cancelValidateProcess() {
        log.debug("Report processing cancelled by user");
        this.xbrlReportService.setLastActionCanceled(false);
        ArelleOutputParser.setIsLastActionCancelled((Boolean)false);
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.CANCEL, new NotificationEvent());
        throw new ActionCancelledException();
    }
}

