/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.arelle.ArelleCliService;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.AccessDeniedDirectoryException;
import ru.cbr.xbrl.converter.exception.ActionCancelledException;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.IncompatibleSchemaRefException;
import ru.cbr.xbrl.converter.exception.MoveFileException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.PackageAlreadyContainsXbrlReportException;
import ru.cbr.xbrl.converter.exception.RemoveFileException;
import ru.cbr.xbrl.converter.exception.SavePackageException;
import ru.cbr.xbrl.converter.exception.TaxonomyNotFoundException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.exception.XbrlExportException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.exception.ZipExtractFileException;
import ru.cbr.xbrl.converter.model.XbrlContextPDRole;
import ru.cbr.xbrl.converter.model.XbrlParameter;
import ru.cbr.xbrl.converter.model.XbrlPdRolePeriod;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.XbrlRolePeriod;
import ru.cbr.xbrl.converter.model.XbrlValueContextCounter;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.pkg.ContextPeriod;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackageFile;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.web.rest.RoleDTO;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextId;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValueId;
import ru.cbr.xbrl.converter.model_main.Taxonomy;
import ru.cbr.xbrl.converter.model_main.TaxonomyEntryPoint;
import ru.cbr.xbrl.converter.repository.XbrlContextRepository;
import ru.cbr.xbrl.converter.repository.XbrlPdRolePeriodRepository;
import ru.cbr.xbrl.converter.repository.XbrlValueRepository;
import ru.cbr.xbrl.converter.service.CacheManagementService;
import ru.cbr.xbrl.converter.service.CompressedXbrlPackageService;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;
import ru.cbr.xbrl.converter.service.DimensionsDefaultService;
import ru.cbr.xbrl.converter.service.EnumerationsService;
import ru.cbr.xbrl.converter.service.TaxonomyService;
import ru.cbr.xbrl.converter.service.XbrlContectValueDTO;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlPackageServiceImpl;
import ru.cbr.xbrl.converter.service.XbrlParameterService;
import ru.cbr.xbrl.converter.service.XbrlPeriodService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.XbrlRoleService;
import ru.cbr.xbrl.converter.service.event.NotificationEventService;
import ru.cbr.xbrl.converter.service.event.NotificationEventServiceImpl;
import ru.cbr.xbrl.converter.service.import_export.EditXbrlService;
import ru.cbr.xbrl.converter.service.import_export.ExportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.internal.XbrlPackageCrudService;
import ru.cbr.xbrl.converter.service.internal.XbrlReportCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlContextCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlUnitCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlValueCrudService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionData;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRole;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.utils.AspectUtils;
import ru.cbr.xbrl.converter.utils.FileUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class XbrlPackageServiceImpl
implements XbrlPackageService {
    private static final Logger log = LoggerFactory.getLogger(XbrlPackageServiceImpl.class);
    public static final boolean ONLY_ONE_PACKAGE_CAN_BE_OPENED = true;
    public static final String PAR_REF_PERIOD_END = "par:refPeriodEnd";
    private static final String ALL_PERIODS = "all-periods";
    @Autowired
    private XbrlPackageCrudService xbrlPackageCrudService;
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private TaxonomyService taxonomyService;
    @Autowired
    private CompressedXbrlPackageService compressedXbrlPackageService;
    @Autowired
    private ExportXbrlService xbrlBuilderService;
    @Autowired
    private XbrlContextCrudService xbrlContextCrudService;
    @Autowired
    private XbrlUnitCrudService xbrlUnitCrudService;
    @Autowired
    private XbrlValueCrudService xbrlValueCrudService;
    @Autowired
    private CacheManagementService cacheManagementService;
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private XbrlPeriodService xbrlPeriodService;
    @Autowired
    private XbrlReportCrudService xbrlReportCrudService;
    @PersistenceContext(unitName="cachePU")
    private EntityManager entityManager;
    @Autowired
    private NotificationEventService notificationEventService;
    @Autowired
    private XbrlParameterService xbrlParameterService;
    @Autowired
    private PresentationDefinitionService presentationDefinitionService;
    @Autowired
    private DimensionsDefaultService dimensionsDefaultService;
    @Autowired
    private EnumerationsService enumerationsService;
    @Autowired
    private ArelleCliService arelleService;
    @Autowired
    private EditXbrlService editXbrlService;
    @Autowired
    private XbrlRoleService xbrlRoleService;
    @Autowired
    private XbrlValueRepository xbrlValueRepository;
    @Autowired
    private XbrlContextRepository xbrlContextRepository;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private XbrlPdRolePeriodRepository xbrlPdRolePeriodRepository;
    @Autowired
    private ConceptInMemoryService conceptInMemoryService;

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public List<XbrlPackage> list() {
        return this.xbrlPackageCrudService.list();
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public XbrlPackage find(Long id) throws NotFoundException {
        return this.xbrlPackageCrudService.find(id);
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public XbrlPackage findLastPackage() {
        XbrlPackage lastXbrlPackage = this.xbrlPackageCrudService.findLastXbrlPackage();
        if (lastXbrlPackage == null) {
            return null;
        }
        XbrlReport xbrlReport = lastXbrlPackage.getXbrlReport();
        this.dimensionsDefaultService.loadFromReport(xbrlReport);
        this.enumerationsService.loadFromReport(xbrlReport);
        if (this.presentationDefinitionService.getPresentationDefinitionData() == null) {
            this.presentationDefinitionService.loadDimensionXml(xbrlReport);
        }
        this.xbrlRoleService.loadFromReport(xbrlReport);
        return lastXbrlPackage;
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlPackage create(XbrlPackage xbrlPackage) throws CancelledException, TaxonomyNotFoundException, NotFoundException, UploadException, RemoveFileException, MoveFileException, XbrlExportException {
        Taxonomy taxonomy;
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.CREATE, new NotificationEvent("\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u043a\u044d\u0448\u0430"));
        this.deleteAll();
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.CREATE, new NotificationEvent("\u0417\u0430\u043f\u0440\u043e\u0441 \u0434\u0430\u043d\u043d\u044b\u0445 \u0442\u0430\u043a\u0441\u043e\u043d\u043e\u043c\u0438\u0438"));
        String taxonomyVersion = xbrlPackage.getTaxonomyVersion();
        String pathToXsd = xbrlPackage.getPathToXsd();
        try {
            taxonomy = this.taxonomyService.findByVersion(taxonomyVersion);
        }
        catch (NotFoundException e) {
            throw new TaxonomyNotFoundException();
        }
        TaxonomyEntryPoint entryPoint = taxonomy.getEntryPointByXsdPath(xbrlPackage.getPathToXsd());
        xbrlPackage.fillTaxonomyEntryPointInfo(entryPoint);
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.CREATE, new NotificationEvent("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u043a\u0435\u0442\u0430"));
        XbrlReport xbrlReport = xbrlPackage.getXbrlReport();
        xbrlPackage.getContextPeriod().setStartDate(XbrlPackageServiceImpl.truncateDate((Date)xbrlPackage.getContextPeriod().getStartDate()));
        xbrlPackage.getContextPeriod().setEndDate(XbrlPackageServiceImpl.truncateDate((Date)xbrlPackage.getContextPeriod().getEndDate()));
        XbrlPackage createdPackage = this.xbrlPackageCrudService.create(xbrlPackage);
        if (xbrlReport == null) {
            String generatedFileName = xbrlPackage.generateXbrlName();
            String xbrlInternalStorePath = FileUtils.relativePathToAbsolute((String)this.configProperties.getXbrlStorePath());
            String xbrlFullPath = FilenameUtils.concat((String)xbrlInternalStorePath, (String)generatedFileName);
            String generatedXbrlFullPath = this.xbrlBuilderService.buildEmptyXbrlXml(xbrlFullPath, pathToXsd);
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.CREATE, new NotificationEvent("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0433\u043e \u043e\u0442\u0447\u0435\u0442\u0430 \u0438 \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0435 Table Linkbase"));
            XbrlReport savedXbrlReport = this.xbrlReportService.createXbrlFile(createdPackage, generatedXbrlFullPath, taxonomy);
            savedXbrlReport.setXbrlPackage(xbrlPackage);
            createdPackage.setXbrlReport(savedXbrlReport);
        }
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelPackageProcess();
        }
        this.xbrlPackageCrudService.update(createdPackage);
        XbrlPackage updatedPackage = this.xbrlPackageCrudService.find(xbrlPackage.getId());
        log.info("Created package, pathToXsd " + updatedPackage.getPathToXsd());
        return updatedPackage;
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlPackage update(XbrlPackage xbrlPackage) throws NotFoundException, CancelledException, UploadException, TaxonomyNotFoundException {
        XbrlPackage existing = this.find(xbrlPackage.getId());
        this.updateIdentifier(xbrlPackage, existing);
        Set updatedParameterSet = this.update(existing, xbrlPackage);
        boolean allParametersChanged = this.updatePeriods(existing, xbrlPackage);
        if (allParametersChanged) {
            updatedParameterSet.clear();
            updatedParameterSet.add("all-periods");
        }
        Map parameterPeriodValueMap = new HashMap();
        if (xbrlPackage.isMoveFacts() && (allParametersChanged || !CollectionUtils.isEmpty((Collection)updatedParameterSet))) {
            parameterPeriodValueMap = this.preparePeriodParameterListForMovingContext(existing.getXbrlReport());
        }
        xbrlPackage.getXbrlReport().setXbrlPackage(existing);
        this.xbrlReportCrudService.update(xbrlPackage.getXbrlReport());
        XbrlPackage updated = this.xbrlPackageCrudService.update(existing);
        this.regenerateXbrlFilename(updated);
        this.xbrlReportService.processXbrlFile(updated);
        XbrlPackage reloaded = this.xbrlPackageCrudService.find(updated.getId());
        updated.initAllLazy();
        this.entityManager.flush();
        this.entityManager.detach((Object)reloaded);
        this.xbrlRoleService.loadFromReport(reloaded.getXbrlReport());
        List xbrlParameters = this.xbrlParameterService.findAll();
        reloaded.getXbrlParameters().clear();
        reloaded.getXbrlParameters().addAll(xbrlParameters);
        if (xbrlPackage.isMoveFacts() && (allParametersChanged || !CollectionUtils.isEmpty((Collection)updatedParameterSet))) {
            this.moveContextByValuePeriodParameter(updatedParameterSet, reloaded.getXbrlReport(), this.editXbrlService.getDimensionsDefault(), parameterPeriodValueMap);
        }
        this.processPeriodEnabled(reloaded.getXbrlReport());
        return reloaded;
    }

    private void updateIdentifier(XbrlPackage xbrlPackage, XbrlPackage existing) {
        String identifier = existing.getOgrn();
        this.xbrlContextCrudService.findByIdentifier(identifier).forEach(xbrlContext -> {
            xbrlContext.setIdentifier(xbrlPackage.getOgrn());
            try {
                this.xbrlContextCrudService.update(xbrlContext);
            }
            catch (NotFoundException e) {
                log.error("XbrlContext {} not found.", (Object)xbrlContext.getXbrlContextId());
            }
        });
    }

    public boolean updatePeriods(XbrlPackage existing, XbrlPackage newPackage) {
        ContextPeriod newContextPeriod;
        ContextPeriod existingContextPeriod = existing.getContextPeriod();
        ContextPeriodChangingType contextPeriodChangingType = this.contextPeriodChanging(existingContextPeriod, newContextPeriod = newPackage.getContextPeriod());
        if (contextPeriodChangingType.equals((Object)ContextPeriodChangingType.NO_CHANGES)) {
            return false;
        }
        existing.getXbrlParameters().clear();
        if (newPackage.isMoveFacts()) {
            switch (1.$SwitchMap$ru$cbr$xbrl$converter$service$XbrlPackageServiceImpl$ContextPeriodChangingType[contextPeriodChangingType.ordinal()]) {
                case 1: 
                case 2: {
                    this.editXbrlService.movePeriodsData(existingContextPeriod, newContextPeriod, false);
                    break;
                }
                case 3: {
                    this.editXbrlService.movePeriodsData(existingContextPeriod, newContextPeriod, true);
                    break;
                }
                case 4: {
                    this.editXbrlService.movePeriodsData(existingContextPeriod, newContextPeriod, false);
                    List nonEditablePeriods = this.xbrlPeriodService.findAll().stream().filter(p -> p.getIsEditablePeriod() == false).collect(Collectors.toList());
                    List defaultPeriods = nonEditablePeriods.stream().filter(XbrlPeriod::getIsDefaultPeriod).collect(Collectors.toList());
                    this.editXbrlService.deletePeriodsData(defaultPeriods);
                    break;
                }
            }
        }
        List xbrlPackagePeriodList = existing.getXbrlPackagePeriodList();
        Iterator iterator = xbrlPackagePeriodList.iterator();
        while (iterator.hasNext()) {
            XbrlPeriod xbrlPeriod = (XbrlPeriod)iterator.next();
            if (xbrlPeriod == null || xbrlPeriod.getIsEditablePeriod().booleanValue()) continue;
            iterator.remove();
            List periodList = xbrlPeriod.getPeriodList();
            if (!CollectionUtils.isEmpty((Collection)periodList)) {
                for (XbrlRolePeriod xbrlRolePeriod : periodList) {
                    this.xbrlReportCrudService.deleteRolePeriod(xbrlRolePeriod);
                }
                this.entityManager.flush();
                xbrlPeriod.getPeriodList().clear();
            }
            this.xbrlPeriodService.delete(xbrlPeriod);
        }
        existingContextPeriod.setEndDate(newContextPeriod.getEndDate());
        existingContextPeriod.setStartDate(newContextPeriod.getStartDate());
        existingContextPeriod.setTitle(PeriodDates.from((XbrlPeriod)new XbrlPeriod(newContextPeriod.getStartDate(), newContextPeriod.getEndDate(), "")).formatDate());
        this.xbrlReportService.createReportPeriods(existing);
        return true;
    }

    private void updatePeriod(ContextPeriodChangingType contextPeriodChangingType, List<XbrlPeriod> xbrlPackagePeriodList, ContextPeriod existingContextPeriod, ContextPeriod newContextPeriod) {
        if (newContextPeriod == null || contextPeriodChangingType == null || contextPeriodChangingType.equals((Object)ContextPeriodChangingType.NO_CHANGES)) {
            return;
        }
        Date newStartDate = newContextPeriod.getStartDate();
        xbrlPackagePeriodList.forEach(period -> {
            if (period == null || period.getIsEditablePeriod().booleanValue()) {
                return;
            }
            if (period.getStart().equals(existingContextPeriod.getStartDate()) && period.getEnd().equals(existingContextPeriod.getEndDate())) {
                period.setStart(newStartDate);
                period.setEnd(newContextPeriod.getEndDate());
                if (DateUtils.isSameDay((Date)newStartDate, (Date)DateUtils.truncate((Date)newStartDate, (int)1))) {
                    period.setIsDefaultPeriod(Boolean.valueOf(true));
                }
                this.xbrlPeriodService.save(period);
            }
            switch (1.$SwitchMap$ru$cbr$xbrl$converter$service$XbrlPackageServiceImpl$ContextPeriodChangingType[contextPeriodChangingType.ordinal()]) {
                case 1: 
                case 2: {
                    if (period.getStart().equals(existingContextPeriod.getStartDate()) && period.getEnd().equals(existingContextPeriod.getEndDate())) {
                        period.setStart(newStartDate);
                        period.setEnd(newContextPeriod.getEndDate());
                        this.xbrlPeriodService.save(period);
                        break;
                    }
                    if (!DateUtils.isSameDay((Date)period.getStart(), (Date)DateUtils.truncate((Date)period.getStart(), (int)1)) || !period.getEnd().equals(existingContextPeriod.getEndDate())) break;
                    period.setEnd(newContextPeriod.getEndDate());
                    this.xbrlPeriodService.save(period);
                    break;
                }
                case 3: {
                    if (!period.getStart().equals(existingContextPeriod.getStartDate()) || !period.getEnd().equals(existingContextPeriod.getEndDate())) break;
                    period.setStart(newStartDate);
                    period.setEnd(newContextPeriod.getEndDate());
                    this.xbrlPeriodService.save(period);
                }
            }
        });
    }

    private ContextPeriodChangingType contextPeriodChanging(ContextPeriod existingContextPeriod, ContextPeriod newContextPeriod) {
        if (existingContextPeriod == null || newContextPeriod == null) {
            log.warn("Checking context period updating. Existing context period is {}null, new context period is {}null", (Object)(existingContextPeriod == null ? "" : "not "), (Object)(newContextPeriod == null ? "" : "not "));
            throw new RuntimeException("Checking context period updating. Existing context period is null or/and new context period is null");
        }
        Date existingStartDate = existingContextPeriod.getStartDate();
        Date newStartDate = newContextPeriod.getStartDate();
        Date existingEndDate = existingContextPeriod.getEndDate();
        Date newEndDate = newContextPeriod.getEndDate();
        if (DateUtils.isSameDay((Date)existingStartDate, (Date)newStartDate) && DateUtils.isSameDay((Date)existingEndDate, (Date)newEndDate)) {
            return ContextPeriodChangingType.NO_CHANGES;
        }
        if (DateUtils.isSameDay((Date)existingStartDate, (Date)newStartDate)) {
            return ContextPeriodChangingType.CHANGE_END_DATE;
        }
        if (DateUtils.isSameDay((Date)existingStartDate, (Date)DateUtils.truncate((Date)existingStartDate, (int)1))) {
            return ContextPeriodChangingType.MOVING_FROM_YEAR_START;
        }
        if (DateUtils.isSameDay((Date)newStartDate, (Date)DateUtils.truncate((Date)newStartDate, (int)1))) {
            return ContextPeriodChangingType.MOVING_TO_YEAR_START;
        }
        return ContextPeriodChangingType.MOVING_INSIDE_YEAR;
    }

    private void regenerateXbrlFilename(XbrlPackage xbrlPackage) {
        File oldFile;
        String generatedFileName = xbrlPackage.generateXbrlName();
        String xbrlStorePath = this.configProperties.getXbrlStorePath();
        String xbrlInternalStorePath = FileUtils.relativePathToAbsolute((String)xbrlStorePath);
        String oldXbrlFullPath = FilenameUtils.concat((String)xbrlInternalStorePath, (String)xbrlPackage.getXbrlReport().getFilePath());
        String newXbrlFullPath = FilenameUtils.concat((String)xbrlInternalStorePath, (String)generatedFileName);
        File file = oldFile = StringUtils.isBlank((CharSequence)oldXbrlFullPath) ? null : new File(oldXbrlFullPath);
        if (oldFile != null && oldFile.exists()) {
            oldFile.renameTo(new File(newXbrlFullPath));
            xbrlPackage.getXbrlReport().setFileName(generatedFileName);
            xbrlPackage.getXbrlReport().setFilePath(newXbrlFullPath);
        }
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public void save(Long id) throws NotFoundException, MoveFileException, SavePackageException, AccessDeniedDirectoryException {
        XbrlPackage xbrlPackage = this.find(id);
        xbrlPackage.initAllLazy();
        this.entityManager.detach((Object)xbrlPackage);
        this.compressedXbrlPackageService.savePackageFiles(xbrlPackage);
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlPackage open(String localPath) throws NotFoundException, RemoveFileException, UploadException, TaxonomyNotFoundException, CancelledException, MoveFileException, ZipExtractFileException, XbrlExportException, IOException, XbrlImportException, IncompatibleSchemaRefException {
        if (StringUtils.isEmpty((CharSequence)localPath) || !Files.exists(Paths.get(localPath, new String[0]), new LinkOption[0])) {
            log.error("Package file not found: " + localPath);
            throw new NotFoundException();
        }
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelPackageProcess();
        }
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.OPEN, new NotificationEvent("\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u043a\u044d\u0448\u0430"));
        this.deleteAll();
        if (this.xbrlReportService.isLastActionCanceled()) {
            this.cancelPackageProcess();
        }
        this.xbrlRoleService.clearContextRoleMap();
        return this.compressedXbrlPackageService.load(localPath);
    }

    @Transactional(value="cacheTransactionManager")
    public void close(Long xbrlPackageId) throws NotFoundException, RemoveFileException {
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.OPEN, new NotificationEvent("\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u043a\u044d\u0448\u0430"));
        this.deleteAll();
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlReport addXbrlReportToPackage(XbrlPackage xbrlPackage, String localPath) throws NotFoundException, IOException, UploadException, TaxonomyNotFoundException, CancelledException {
        Taxonomy taxonomy = this.taxonomyService.findByVersion(xbrlPackage.getTaxonomyVersion());
        XbrlReport existingReport = xbrlPackage.getXbrlReport();
        if (existingReport != null) {
            xbrlPackage.setXbrlReport(null);
            existingReport.setXbrlPackage(null);
            this.xbrlPackageCrudService.update(xbrlPackage);
            this.xbrlReportService.deleteWithFile(existingReport.getId());
        }
        return this.xbrlReportService.uploadLocal(xbrlPackage, localPath, taxonomy);
    }

    @Transactional(value="cacheTransactionManager")
    public void addFile(Long xbrlPackageId, String fullFilePath, String description) throws NotFoundException, PackageAlreadyContainsXbrlReportException {
        XbrlPackage xbrlPackage = this.xbrlPackageCrudService.find(xbrlPackageId);
        String fileName = FilenameUtils.getName((String)fullFilePath);
        XbrlPackageFile xbrlPackageFile = new XbrlPackageFile(fileName, description);
        xbrlPackage.getFiles().add(xbrlPackageFile);
        this.xbrlPackageCrudService.update(xbrlPackage);
    }

    private void delete(Long xbrlPackageId) throws NotFoundException, RemoveFileException {
        Date start = new Date();
        log.info("Remove package id#" + xbrlPackageId + " started...");
        XbrlPackage xbrlPackage = this.find(xbrlPackageId);
        try {
            if (xbrlPackage.getXbrlReport() != null) {
                this.xbrlReportService.deleteWithFile(xbrlPackage.getXbrlReport().getId());
            }
            xbrlPackage.setXbrlReport(null);
            this.xbrlPackageCrudService.update(xbrlPackage);
            this.xbrlPackageCrudService.delete(xbrlPackageId);
            log.info("Remove package id#" + xbrlPackageId + " completed in " + (new Date().getTime() - start.getTime()) + " msec");
        }
        catch (IOException e) {
            log.error("Error remove xbrl report");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new RemoveFileException();
        }
    }

    @Transactional(value="cacheTransactionManager")
    public void deleteAll() throws NotFoundException, RemoveFileException {
        this.cacheManagementService.clearCache();
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public void saveReportingPackage(Long xbrlPackageId, Date packageDate) throws NotFoundException, MoveFileException, SavePackageException, AccessDeniedDirectoryException {
        XbrlPackage xbrlPackage = this.find(xbrlPackageId);
        this.compressedXbrlPackageService.saveReportingPackageFiles(xbrlPackage, packageDate);
    }

    @Transactional(value="cacheTransactionManager")
    public List<XbrlPeriod> createPeriod(Long id, Long roleId, XbrlPeriod xbrlPeriod) throws NotFoundException {
        XbrlPackage xbrlPackage = this.find(id);
        xbrlPeriod.setXbrlPackage(xbrlPackage);
        xbrlPackage.getXbrlPackagePeriodList().add(xbrlPeriod);
        this.xbrlPackageCrudService.update(xbrlPackage);
        if (roleId == null) {
            return this.findPackagePeriodList(id);
        }
        return this.xbrlReportService.findReportRolePeriodList(roleId);
    }

    @Transactional(value="cacheTransactionManager")
    public RoleDTO deletePeriod(Long id, Long periodId, Long roleId, boolean confirm) throws NotFoundException {
        RoleDTO roleDTO = new RoleDTO();
        XbrlPeriod xbrlPeriod = this.xbrlPeriodService.find(periodId);
        roleDTO.getPdRoles().addAll(this.xbrlRoleService.getFilledPdRolesByPeriod(xbrlPeriod.getStart(), xbrlPeriod.getEnd()));
        roleDTO.getPdRoles().forEach(pdRole -> roleDTO.getTblRoles().addAll(this.xbrlRoleService.getTlbRoleByPdRole(pdRole)));
        if (confirm || roleDTO.isRolesEmpty()) {
            this.xbrlPeriodService.deleteWithFacts(xbrlPeriod);
            this.entityManager.flush();
        }
        return roleDTO;
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public List<XbrlPeriod> findPackagePeriodList(Long packageId) throws NotFoundException {
        XbrlPackage xbrlPackage = this.find(packageId);
        List xbrlPackagePeriodList = xbrlPackage.getXbrlPackagePeriodList();
        xbrlPackagePeriodList.size();
        return xbrlPackagePeriodList;
    }

    @Transactional(value="cacheTransactionManager")
    public List<XbrlPeriod> updatePeriod(Long id, Long periodId, XbrlPeriod xbrlPeriod) throws NotFoundException {
        XbrlPeriod xbrlPeriodPersist = this.xbrlPeriodService.updateValues(periodId, xbrlPeriod);
        if (xbrlPeriodPersist == null) {
            return this.findPackagePeriodList(id);
        }
        this.xbrlPeriodService.save(xbrlPeriodPersist);
        return this.findPackagePeriodList(id);
    }

    @Transactional(value="cacheTransactionManager")
    public List<XbrlPeriod> togglePeriodList(Long id, Boolean state) throws NotFoundException {
        XbrlPackage xbrlPackage = this.find(id);
        if (xbrlPackage == null) {
            log.error("\u041f\u0435\u0440\u0435\u043a\u043b\u0447\u044e\u0447\u0435\u043d\u0438\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u0432 \u0434\u043b\u044f \u043f\u0430\u043a\u0435\u0442\u0430. \u041f\u0430\u043a\u0435\u0442 \u0441 id {} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", (Object)id);
            throw new NotFoundException();
        }
        XbrlReport xbrlReport = xbrlPackage.getXbrlReport();
        if (xbrlReport == null) {
            log.error("\u041f\u0435\u0440\u0435\u043a\u043b\u0447\u044e\u0447\u0435\u043d\u0438\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u0432 \u0434\u043b\u044f \u043f\u0430\u043a\u0435\u0442\u0430. \u0414\u043b\u044f \u043f\u0430\u043a\u0435\u0442 \u0441 id {} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043e\u0442\u0447\u0435\u0442", (Object)id);
            throw new NotFoundException();
        }
        List xbrlReportRoles = xbrlReport.getXbrlReportRoles();
        if (CollectionUtils.isEmpty((Collection)xbrlReportRoles)) {
            List xbrlPackagePeriodList = xbrlPackage.getXbrlPackagePeriodList();
            xbrlPackagePeriodList.size();
            return xbrlPackagePeriodList;
        }
        if (state.booleanValue()) {
            for (XbrlReportRole xbrlReportRole : xbrlReportRoles) {
                this.xbrlReportCrudService.deleteRolePeriodByRole(xbrlReportRole);
            }
            this.entityManager.flush();
        }
        return null;
    }

    private Set<String> update(XbrlPackage oldPackage, XbrlPackage xbrlPackage) {
        oldPackage.setOgrn(xbrlPackage.getOgrn());
        oldPackage.setName(xbrlPackage.getName());
        oldPackage.setPathForPackage(xbrlPackage.getPathForPackage());
        oldPackage.setYear(xbrlPackage.getYear());
        return this.updateXbrlParameters(oldPackage, xbrlPackage.getXbrlParameters());
    }

    private Set<String> updateXbrlParameters(XbrlPackage oldPackage, List<XbrlParameter> xbrlParameters) {
        HashSet<String> changedParameterSet = new HashSet<String>();
        XbrlParameter existingRefPeriodEnd = null;
        XbrlParameter newRefPeriodEnd = null;
        Date existingRefPeriodEndDate = null;
        Date newRefPeriodEndDate = null;
        if (!CollectionUtils.isEmpty((Collection)oldPackage.getXbrlParameters()) && (existingRefPeriodEnd = oldPackage.getRefPeriodEndValue(oldPackage.getXbrlParameters())) != null) {
            existingRefPeriodEndDate = existingRefPeriodEnd.getValue();
        }
        if (!CollectionUtils.isEmpty(xbrlParameters) && (newRefPeriodEnd = oldPackage.getRefPeriodEndValue(xbrlParameters)) != null) {
            newRefPeriodEndDate = newRefPeriodEnd.getValue();
        }
        if (existingRefPeriodEndDate != null && newRefPeriodEndDate != null && !DateUtils.isSameDay((Date)existingRefPeriodEndDate, newRefPeriodEndDate)) {
            Iterator iterator = oldPackage.getXbrlParameters().iterator();
            while (iterator.hasNext()) {
                XbrlParameter xbrlParameter = (XbrlParameter)iterator.next();
                if (!StringUtils.equals((CharSequence)xbrlParameter.getQName(), (CharSequence)"par:refPeriodEnd")) {
                    iterator.remove();
                    continue;
                }
                xbrlParameter.setValue(newRefPeriodEndDate);
            }
            changedParameterSet.add("par:refPeriodEnd");
        }
        oldPackage.getXbrlParameters().stream().forEach(existingParam -> {
            Date oldValue;
            XbrlParameter newParam = xbrlParameters.stream().filter(param -> param.getQName().equals(existingParam.getQName())).findFirst().get();
            Date newValue = newParam.getValue();
            if (DateUtils.isSameDay((Date)newValue, (Date)(oldValue = existingParam.getValue()))) {
                return;
            }
            existingParam.setValue(newValue);
            if (changedParameterSet.contains("par:refPeriodEnd")) {
                return;
            }
            changedParameterSet.add(existingParam.getQName());
        });
        return changedParameterSet;
    }

    public static Date truncateDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public void resetCancelPackageProcess() {
        this.xbrlReportService.setLastActionCanceled(false);
    }

    public void cancelProcessing() {
        this.xbrlReportService.setLastActionCanceled(true);
        this.arelleService.killCurrentArelleProcess();
    }

    private void cancelPackageProcess() {
        log.info("Package processing cancelled by user");
        this.xbrlReportService.setLastActionCanceled(false);
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.CANCEL, new NotificationEvent());
        throw new ActionCancelledException();
    }

    public Map<String, Date> preparePeriodParameterListForMovingContext(XbrlReport xbrlReport) {
        HashMap<String, Date> periodParameterValueMap = new HashMap<String, Date>();
        List xbrlReportRoleList = xbrlReport.getXbrlReportRoles();
        if (xbrlReportRoleList.isEmpty()) {
            return Collections.emptyMap();
        }
        xbrlReportRoleList.forEach(xbrlReportRole -> {
            if (xbrlReportRole == null) {
                return;
            }
            String staticStructureJson = xbrlReportRole.getStaticStructureJson();
            try {
                TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)this.objectMapper.readValue(staticStructureJson, TableLinkBaseStructure.class);
                tableLinkBaseStructure.iterateAllAspects(aspectDataList -> {
                    for (AspectData aspectData : aspectDataList) {
                        String periodParameterFormula;
                        if (aspectData == null || StringUtils.isBlank((CharSequence)(periodParameterFormula = aspectData.getPeriodFormula()))) continue;
                        Date existingDate = (Date)periodParameterValueMap.get(periodParameterFormula);
                        String aspectValue = aspectData.getAspectValue();
                        PeriodDates periodDates = new PeriodDates(aspectValue);
                        Date date = periodDates.getInstantDate();
                        if (existingDate != null) {
                            if (DateUtils.isSameDay((Date)existingDate, (Date)date)) continue;
                            log.warn("\u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e \u0444\u043e\u0440\u043c\u0443\u043b\u0430\u0445  \u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0445 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u0432. \u0412 TLB \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u044e\u0442\u0441\u044f \u0440\u0430\u0437\u043b\u0438\u0447\u043d\u044b\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f {} \u0438 {} \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0439 \u0438 \u0442\u043e\u0439 \u0436\u0435 \u0444\u043e\u0440\u043c\u0443\u043b\u044b {}", new Object[]{PeriodDates.formatDate((Date)existingDate), aspectValue, periodParameterFormula});
                            continue;
                        }
                        periodParameterValueMap.put(periodParameterFormula, date);
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return periodParameterValueMap;
    }

    @Transactional(value="cacheTransactionManager")
    public void moveContextByValuePeriodParameter(Set<String> parameterSet, XbrlReport xbrlReport, Map<String, String> dimensionsDefault, Map<String, Date> periodParameterValueMap) {
        if (CollectionUtils.isEmpty(parameterSet)) {
            log.info("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0444\u0430\u043a\u0442\u043e\u0432 \u043f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432. \u0421\u043f\u0438\u0441\u043e\u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0445 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043f\u0443\u0441\u0442\u043e\u0439, \u043f\u0435\u0440\u0435\u043d\u043e\u0441 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f.");
            return;
        }
        List xbrlReportRoleList = xbrlReport.getXbrlReportRoles();
        if (xbrlReportRoleList.isEmpty()) {
            return;
        }
        HashSet movedXbrlValueIdSet = new HashSet();
        HashMap movingWaitingXbrlValueMap = new HashMap();
        xbrlReportRoleList.forEach(xbrlReportRole -> {
            if (xbrlReportRole == null) {
                return;
            }
            String staticStructureJson = xbrlReportRole.getStaticStructureJson();
            try {
                TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)this.objectMapper.readValue(staticStructureJson, TableLinkBaseStructure.class);
                this.moveContextForParameterByRole(parameterSet, xbrlReport, dimensionsDefault, tableLinkBaseStructure, periodParameterValueMap, movedXbrlValueIdSet, movingWaitingXbrlValueMap);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        Collection waitingXbrlValue = movingWaitingXbrlValueMap.values();
        waitingXbrlValue.remove(null);
        if (!CollectionUtils.isEmpty(waitingXbrlValue)) {
            this.overwriteExistingXbrlValue(movingWaitingXbrlValueMap);
        }
    }

    private void overwriteExistingXbrlValue(Map<XbrlValueId, XbrlValueId> movingWaitingXbrlValueMap) {
        if (CollectionUtils.isEmpty(movingWaitingXbrlValueMap)) {
            return;
        }
        for (Map.Entry<XbrlValueId, XbrlValueId> xbrlValueIdEntry : movingWaitingXbrlValueMap.entrySet()) {
            XbrlValueId newXbrlValueId = xbrlValueIdEntry.getKey();
            XbrlValueId xbrlValueId = xbrlValueIdEntry.getValue();
            if (newXbrlValueId == null || xbrlValueId == null) continue;
            XbrlValue newXbrlValue = this.xbrlValueCrudService.find(newXbrlValueId);
            XbrlValue xbrlWaitingValue = this.xbrlValueCrudService.find(xbrlValueId);
            if (newXbrlValue == null || xbrlWaitingValue == null) continue;
            newXbrlValue.setValue(xbrlWaitingValue.getValue());
            this.xbrlValueCrudService.update(newXbrlValue);
            this.editXbrlService.deleteXbrlValue(xbrlWaitingValue);
        }
    }

    @Transactional(value="cacheTransactionManager")
    public void moveContextForParameterByRole(Set<String> parameterSet, XbrlReport xbrlReport, Map<String, String> dimensionsDefault, TableLinkBaseStructure tableLinkBaseStructure, Map<String, Date> periodParameterValueMap, Set<XbrlValueId> movedXbrlValueIdSet, Map<XbrlValueId, XbrlValueId> movingWaitingXbrlValueMap) {
        if (CollectionUtils.isEmpty(parameterSet)) {
            log.info("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0444\u0430\u043a\u0442\u043e\u0432 \u043f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432. \u0421\u043f\u0438\u0441\u043e\u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0445 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043f\u0443\u0441\u0442\u043e\u0439, \u043f\u0435\u0440\u0435\u043d\u043e\u0441 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f.");
            return;
        }
        HashMap conceptValueMap = new HashMap();
        AtomicInteger counter = new AtomicInteger(0);
        long startStructure = System.currentTimeMillis();
        HashMap contextPeriodMovedMap = new HashMap();
        tableLinkBaseStructure.iterateAllAspects(aspectDataList -> {
            counter.getAndIncrement();
            ArrayList<AspectData> bufferedAspectData = new ArrayList<AspectData>();
            boolean found = false;
            for (AspectData aspectData : aspectDataList) {
                String newPeriodValue;
                if (aspectData == null) continue;
                if (aspectData.getType() != AspectType.PARAMS_PERIOD || StringUtils.equals((CharSequence)aspectData.getAspect(), (CharSequence)"period type")) {
                    bufferedAspectData.add(aspectData);
                    continue;
                }
                String periodParameterFormula = aspectData.getPeriodFormula();
                Set includedParameters = parameterSet.stream().filter(parameter -> StringUtils.contains((CharSequence)periodParameterFormula, (CharSequence)parameter)).map(parameter -> parameter).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(includedParameters) && !StringUtils.equals((CharSequence)((CharSequence)parameterSet.iterator().next()), (CharSequence)"all-periods") && !StringUtils.equals((CharSequence)((CharSequence)parameterSet.iterator().next()), (CharSequence)"par:refPeriodEnd")) {
                    bufferedAspectData.add(aspectData);
                    continue;
                }
                String oldPeriodValue = PeriodDates.formatDate((Date)((Date)periodParameterValueMap.get(periodParameterFormula)));
                if (StringUtils.equals((CharSequence)oldPeriodValue, (CharSequence)(newPeriodValue = aspectData.getAspectValue()))) {
                    bufferedAspectData.add(aspectData);
                    continue;
                }
                AspectData restoredAspectData = new AspectData(aspectData);
                restoredAspectData.setAspectValue(oldPeriodValue);
                bufferedAspectData.add(restoredAspectData);
                found = true;
            }
            if (!found) {
                return;
            }
            AspectCellData currentAspectCellData = new AspectCellData(bufferedAspectData);
            AspectCellData newAspectCellData = new AspectCellData(aspectDataList);
            AspectData concept = currentAspectCellData.getConcept();
            if (concept == null) {
                return;
            }
            List conceptDTOList = (List)conceptValueMap.get(concept);
            if (conceptDTOList == null) {
                conceptDTOList = this.xbrlValueRepository.findByXbrlValueIdElementLabel(concept.getAspectValue());
                conceptValueMap.put(concept, conceptDTOList);
            }
            this.filterFacts(conceptDTOList, currentAspectCellData, dimensionsDefault, xbrlValueId -> {
                String currentContextId;
                String movingContextId;
                XbrlContext context;
                XbrlValue xbrlValue = (XbrlValue)this.xbrlValueRepository.findOne((Serializable)xbrlValueId);
                if (xbrlValue == null || xbrlValue.getXbrlValueId() == null) {
                    return;
                }
                if (movedXbrlValueIdSet.contains(xbrlValue.getXbrlValueId())) {
                    log.info("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0444\u0430\u043a\u0442\u0430 \u043f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430. \u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430 \u0444\u0430\u043a\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0441\u0434\u0435\u043b\u0430\u043d\u043d\u043e\u0433\u043e \u0443\u0436\u0435 \u0440\u0430\u043d\u0435\u0435 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430. \u041f\u0440\u043e\u043f\u0443\u0441\u043a.");
                    return;
                }
                PeriodDates periodDates = AspectUtils.getPeriodDatesForConcept((List)newAspectCellData.getAspectDataList(), (AspectData)concept);
                if (periodDates == null) {
                    periodDates = PeriodDates.from((XbrlPeriod)this.xbrlPeriodService.getDefaultPeriod());
                }
                if (concept.getConceptPeriodType() == PeriodType.INSTANT) {
                    periodDates = periodDates.toInstant();
                }
                XbrlContextId xbrlContextId = new XbrlContextId();
                xbrlContextId.setContextId(xbrlValue.getXbrlValueId().getXbrlContextId());
                xbrlContextId.setXbrlReportId(xbrlReport.getId());
                try {
                    context = this.xbrlContextCrudService.find(xbrlContextId);
                }
                catch (NotFoundException e) {
                    log.error("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0444\u0430\u043a\u0442\u0430 \u043f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430. \u0414\u043b\u044f \u0444\u0430\u043a\u0442\u0430 \u0441 guid {} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 {}", (Object)xbrlValue.getGuid(), (Object)xbrlValue.getXbrlValueId().getXbrlContextId());
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                    throw new RuntimeException();
                }
                List contextList = this.xbrlContextCrudService.findByPeriodDatesAndDimensionsHash(periodDates, context.getDimensionsHash());
                XbrlContext contextForMoving = null;
                if (!CollectionUtils.isEmpty((Collection)contextList)) {
                    if (contextList.size() > 1) {
                        log.error("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0444\u0430\u043a\u0442\u0430 \u043f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430. \u0414\u043b\u044f \u0444\u0430\u043a\u0442\u0430 \u0441 guid {} \u043d\u0430\u0439\u0434\u0435\u043d \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u043a\u043e\u0442\u0435\u043a\u0441\u0442", (Object)xbrlValue.getGuid());
                        throw new RuntimeException();
                    }
                    contextForMoving = (XbrlContext)contextList.iterator().next();
                }
                if (contextForMoving == null) {
                    contextForMoving = new XbrlContext(context);
                    if (contextForMoving.getPeriodType() == PeriodType.INSTANT) {
                        contextForMoving.setInstantDate(periodDates.getInstantDate());
                    } else if (contextForMoving.getPeriodType() == PeriodType.DURATION) {
                        contextForMoving.setStartDate(periodDates.getStartDate());
                        contextForMoving.setEndDate(periodDates.getEndDate());
                    }
                    contextForMoving = (XbrlContext)this.xbrlContextRepository.save((Object)contextForMoving);
                }
                if (StringUtils.equals((CharSequence)(movingContextId = contextForMoving.getXbrlContextId().getContextId()), (CharSequence)(currentContextId = xbrlContextId.getContextId()))) {
                    return;
                }
                PeriodDates movedContextPeriodDates = (PeriodDates)contextPeriodMovedMap.get(context.getXbrlContextId().getContextId());
                if (movedContextPeriodDates != null) {
                    if (!StringUtils.equals((CharSequence)movedContextPeriodDates.formatDate(), (CharSequence)periodDates.formatDate())) {
                        log.warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u0434\u043b\u044f \u0444\u0430\u043a\u0442\u043e\u0432, \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0445 \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438, \u043d\u0430 \u0434\u0430\u0442\u0443 {}. \u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 {} \u0443\u0436\u0435 \u0431\u044b\u043b \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d \u043d\u0430 \u0434\u0430\u0442\u0443 {} \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u044d\u0442\u043e\u0433\u043e \u0436\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u0430\u043a\u0435\u0442\u0430", new Object[]{periodDates.formatDate(), context.getXbrlContextId().getContextId(), movedContextPeriodDates.formatDate()});
                    }
                } else {
                    contextPeriodMovedMap.put(context.getXbrlContextId().getContextId(), contextForMoving.getPeriodDates());
                }
                if (this.moveXbrlValue(movedXbrlValueIdSet, movingWaitingXbrlValueMap, xbrlValue, movingContextId)) {
                    conceptValueMap.put(concept, null);
                }
            });
        });
        log.info("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0444\u0430\u043a\u0442\u043e\u0432 \u043f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432. \u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0440\u043e\u043b\u0438  " + tableLinkBaseStructure.getLabel() + ": " + (System.currentTimeMillis() - startStructure) + " \u043c\u0441, \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0442\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0445 \u0444\u0430\u043a\u0442\u043e\u0432 " + counter.get() + " \u0441\u0440\u0435\u0434\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043d\u0430 \u0444\u0430\u043a\u0442: " + (counter.get() == 0 ? 0L : (System.currentTimeMillis() - startStructure) / (long)counter.get()));
    }

    public boolean isEmpty() {
        return this.xbrlValueCrudService.isEmpty();
    }

    private boolean moveXbrlValue(Set<XbrlValueId> movedXbrlValueIdSet, Map<XbrlValueId, XbrlValueId> movingWaitingXbrlValueMap, XbrlValue xbrlValue, String movingContextId) {
        List xbrlValueList;
        XbrlValueId xbrlValueId = xbrlValue.getXbrlValueId();
        XbrlValueId bckpXbrlValueId = new XbrlValueId(xbrlValueId.getElementLabel(), xbrlValueId.getXbrlReportId(), xbrlValueId.getXbrlContextId());
        XbrlValueId movingXbrlValueId = new XbrlValueId(xbrlValueId.getElementLabel(), xbrlValueId.getXbrlReportId(), movingContextId);
        if (this.xbrlValueCrudService.find(movingXbrlValueId) != null) {
            movingWaitingXbrlValueMap.put(movingXbrlValueId, xbrlValueId);
            return false;
        }
        this.entityManager.flush();
        this.xbrlValueCrudService.updateContextConnection(xbrlValue, movingContextId);
        this.entityManager.clear();
        movedXbrlValueIdSet.add(movingXbrlValueId);
        XbrlValueId waitingXbrlValueId = movingWaitingXbrlValueMap.get(bckpXbrlValueId);
        String fromXbrlContextId = bckpXbrlValueId.getXbrlContextId();
        if (waitingXbrlValueId != null) {
            XbrlValue waitingXrlValue = this.xbrlValueCrudService.find(waitingXbrlValueId);
            if (waitingXrlValue != null) {
                this.moveXbrlValue(movedXbrlValueIdSet, movingWaitingXbrlValueMap, waitingXrlValue, fromXbrlContextId);
            }
            movingWaitingXbrlValueMap.remove(bckpXbrlValueId, waitingXbrlValueId);
        }
        if (CollectionUtils.isEmpty((Collection)(xbrlValueList = this.xbrlValueCrudService.findByContextId(fromXbrlContextId)))) {
            try {
                this.xbrlContextCrudService.delete(new XbrlContextId(fromXbrlContextId, xbrlValueId.getXbrlReportId()));
            }
            catch (NotFoundException e) {
                log.warn("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0444\u0430\u043a\u0442\u0430 \u043f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 \u043f\u043e\u0441\u043b\u0435 \u043e\u0442\u0432\u044f\u0437\u044b\u0432\u0430\u043d\u0438\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0444\u0430\u043a\u0442\u0430\u044e");
            }
        }
        return true;
    }

    @Transactional(value="cacheTransactionManager")
    public void processPeriodEnabled(XbrlReport xbrlReport) {
        HashMap xbrlPeriodContextListCacheMap = new HashMap();
        List xbrlReportRoleList = xbrlReport.getXbrlReportRoles();
        if (xbrlReportRoleList.isEmpty()) {
            return;
        }
        XbrlPackage xbrlPackage = xbrlReport.getXbrlPackage();
        if (xbrlPackage == null) {
            return;
        }
        long start = System.currentTimeMillis();
        List xbrlValueContextCounterList = this.xbrlValueCrudService.findValueCountGroupByXbrlContextId();
        Map<Object, Object> valueCounterMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)xbrlValueContextCounterList)) {
            valueCounterMap = xbrlValueContextCounterList.stream().collect(Collectors.toMap(XbrlValueContextCounter::getContextId, XbrlValueContextCounter::getCount));
        }
        List xbrlPackagePeriodList = xbrlPackage.getXbrlPackagePeriodList();
        for (XbrlReportRole xbrlReportRole : xbrlReportRoleList) {
            this.processRolePeriodEnabled(xbrlReportRole, xbrlPackagePeriodList, valueCounterMap, xbrlPeriodContextListCacheMap);
        }
        log.info("Calculation of active periods for the table mode: " + (System.currentTimeMillis() - start) + " msec");
        start = System.currentTimeMillis();
        PresentationDefinitionData presentationDefinitionData = this.presentationDefinitionService.getPresentationDefinitionData();
        if (presentationDefinitionData == null) {
            return;
        }
        List contextPDRoleList = this.xbrlContextCrudService.findContextPDRole();
        HashMap contextPDRoleMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)contextPDRoleList)) {
            for (XbrlContextPDRole xbrlContextPDRole : contextPDRoleList) {
                contextPDRoleMap.putIfAbsent(xbrlContextPDRole.getRoleSystemId(), new ArrayList());
                XbrlContextId xbrlContextId = new XbrlContextId(xbrlContextPDRole.getContextId(), xbrlReport.getId());
                try {
                    ((List)contextPDRoleMap.get(xbrlContextPDRole.getRoleSystemId())).add(this.xbrlContextCrudService.find(xbrlContextId));
                }
                catch (NotFoundException e) {
                    log.error("\u0421\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0432\u044f\u0437\u0435\u0439 \u0440\u043e\u043b\u044c P/D - \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442. \u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 \u0441 contextId " + xbrlContextId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
                }
            }
        }
        List presentationDefinitionRoleList = presentationDefinitionData.getRoles();
        for (PresentationDefinitionRole presentationDefinitionRole : presentationDefinitionRoleList) {
            this.processPDRolePeriodEnabled(presentationDefinitionRole, xbrlPackagePeriodList, valueCounterMap, contextPDRoleMap);
        }
        log.info("Calculation of active periods for the presentation/definition mode: " + (System.currentTimeMillis() - start) + " msec");
    }

    @Transactional(value="cacheTransactionManager")
    private void processRolePeriodEnabled(XbrlReportRole xbrlReportRole, List<XbrlPeriod> xbrlPackagePeriodList, Map<String, Long> valueCounterMap, HashMap<Long, List<XbrlContext>> xbrlPeriodContextListCacheMap) {
        if (xbrlReportRole == null || CollectionUtils.isEmpty(xbrlPackagePeriodList)) {
            return;
        }
        Set contextDimensionOpenHashSet = this.xbrlRoleService.getContextSetByRole(xbrlReportRole.getSystemId());
        ArrayList<XbrlPeriod> xbrlPeriodList = new ArrayList<XbrlPeriod>();
        xbrlPeriodList.addAll(xbrlPackagePeriodList);
        Iterator iterator = xbrlPeriodList.iterator();
        while (iterator.hasNext()) {
            XbrlPeriod xbrlPeriod = (XbrlPeriod)iterator.next();
            if (xbrlPeriod == null) continue;
            List contextList = xbrlPeriodContextListCacheMap.get(xbrlPeriod.getId());
            if (contextList == null) {
                contextList = this.xbrlContextCrudService.findByPeriodDates(PeriodDates.from((XbrlPeriod)xbrlPeriod));
                contextList.addAll(this.xbrlContextCrudService.findByPeriodDates(PeriodDates.buildInstant((Date)xbrlPeriod.getEnd())));
                contextList.addAll(this.xbrlContextCrudService.findByPeriodDates(PeriodDates.buildInstant((Date)DateUtils.addDays((Date)xbrlPeriod.getStart(), (int)-1))));
                if (CollectionUtils.isEmpty((Collection)contextList)) {
                    contextList = Collections.emptyList();
                }
                xbrlPeriodContextListCacheMap.put(xbrlPeriod.getId(), contextList);
            }
            int initContextListSize = contextList.size();
            Iterator<XbrlContext> contextIterator = contextList.iterator();
            while (contextIterator.hasNext()) {
                XbrlContext xbrlContext = contextIterator.next();
                if (xbrlContext == null || !contextDimensionOpenHashSet.contains(xbrlContext.getDimensionsOpenHash())) continue;
                Long count = valueCounterMap.get(xbrlContext.getXbrlContextId().getContextId());
                if (count != null && count > 0L) {
                    iterator.remove();
                    break;
                }
                if (xbrlContext.getXbrlContextId() == null) {
                    contextIterator.remove();
                    continue;
                }
                try {
                    this.xbrlContextCrudService.delete(xbrlContext.getXbrlContextId());
                }
                catch (NotFoundException e) {
                    log.error("\u0412\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u0432 \u0434\u043b\u044f \u0440\u043e\u043b\u0438. \u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442. \u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 id {}", (Object)xbrlContext.getXbrlContextId().getContextId());
                }
                contextIterator.remove();
            }
            if (initContextListSize == contextList.size()) continue;
            xbrlPeriodContextListCacheMap.put(xbrlPeriod.getId(), contextList);
        }
        for (XbrlPeriod rolePeriod : xbrlPeriodList) {
            if (rolePeriod.getIsDefaultPeriod().booleanValue()) continue;
            XbrlRolePeriod xbrlRolePeriod = new XbrlRolePeriod();
            xbrlRolePeriod.setXbrlPeriod(rolePeriod);
            xbrlRolePeriod.setXbrlReportRole(xbrlReportRole);
            xbrlReportRole.getPeriodList().add(xbrlRolePeriod);
            try {
                this.xbrlReportCrudService.updateRolePeriod(xbrlRolePeriod);
            }
            catch (NotFoundException e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    @Transactional(value="cacheTransactionManager")
    private void processPDRolePeriodEnabled(PresentationDefinitionRole presentationDefinitionRole, List<XbrlPeriod> xbrlPackagePeriodList, Map<String, Long> valueCounterMap, Map<String, List<XbrlContext>> contextPDRoleMap) {
        if (presentationDefinitionRole == null) {
            return;
        }
        String systemId = presentationDefinitionRole.getSystemId();
        ArrayList<XbrlPeriod> xbrlPeriodList = new ArrayList<XbrlPeriod>();
        xbrlPeriodList.addAll(xbrlPackagePeriodList);
        List<XbrlContext> contextList = contextPDRoleMap.get(systemId);
        if (CollectionUtils.isEmpty(contextList)) {
            return;
        }
        Iterator periodIterator = xbrlPeriodList.iterator();
        block4: while (periodIterator.hasNext()) {
            XbrlPeriod xbrlPeriod = (XbrlPeriod)periodIterator.next();
            Iterator<XbrlContext> contextIterator = contextList.iterator();
            while (contextIterator.hasNext()) {
                XbrlContext xbrlContext = contextIterator.next();
                if (xbrlContext == null) continue;
                try {
                    PeriodDates contextPeriodDates = xbrlContext.getPeriodDates();
                    if (!PeriodDates.from((XbrlPeriod)xbrlPeriod).equals((Object)contextPeriodDates) && !PeriodDates.buildInstant((Date)xbrlPeriod.getEnd()).equals((Object)contextPeriodDates) && !PeriodDates.buildInstant((Date)DateUtils.addDays((Date)xbrlPeriod.getStart(), (int)-1)).equals((Object)contextPeriodDates)) continue;
                    Long count = valueCounterMap.get(xbrlContext.getXbrlContextId().getContextId());
                    if (count != null && count > 0L) {
                        periodIterator.remove();
                        continue block4;
                    }
                    if (xbrlContext.getXbrlContextId() == null) {
                        contextIterator.remove();
                        continue;
                    }
                    try {
                        this.xbrlContextCrudService.delete(xbrlContext.getXbrlContextId());
                    }
                    catch (NotFoundException e) {
                        log.error("\u0412\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u0432 \u0434\u043b\u044f \u0440\u043e\u043b\u0438 pres/def. \u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442. \u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 id {}", (Object)xbrlContext.getXbrlContextId().getContextId());
                    }
                }
                catch (NullPointerException e) {
                    log.error("error");
                }
            }
        }
        for (XbrlPeriod rolePeriod : xbrlPeriodList) {
            if (rolePeriod.getIsDefaultPeriod().booleanValue()) continue;
            XbrlPdRolePeriod xbrlPdRolePeriod = new XbrlPdRolePeriod();
            XbrlPdRolePeriod.XbrlPdRolePeriodId xbrlPdRolePeriodId = new XbrlPdRolePeriod.XbrlPdRolePeriodId(systemId, rolePeriod.getId());
            xbrlPdRolePeriod.setXbrlPdRolePeriodId(xbrlPdRolePeriodId);
            this.xbrlPdRolePeriodRepository.save((Object)xbrlPdRolePeriod);
        }
    }

    private void addInstantPeriods(ArrayList<XbrlPeriod> xbrlPeriodList) {
        if (CollectionUtils.isEmpty(xbrlPeriodList)) {
            return;
        }
        ArrayList<XbrlPeriod> xbrlInstantPeriodList = new ArrayList<XbrlPeriod>();
        for (XbrlPeriod xbrlPeriod : xbrlPeriodList) {
            if (xbrlPeriod == null || xbrlPeriod.getType() != PeriodType.DURATION || xbrlPeriod.getStart() == null || xbrlPeriod.getEnd() == null) continue;
            xbrlInstantPeriodList.add(new XbrlPeriod(xbrlPeriod.getXbrlPackage(), PeriodDates.buildInstant((Date)xbrlPeriod.getEnd())));
            xbrlInstantPeriodList.add(new XbrlPeriod(xbrlPeriod.getXbrlPackage(), PeriodDates.buildInstant((Date)DateUtils.addDays((Date)xbrlPeriod.getStart(), (int)-1))));
        }
        xbrlPeriodList.addAll(xbrlInstantPeriodList);
    }

    private void filterFacts(List<XbrlContectValueDTO> byElementName, AspectCellData aspectCellData, Map<String, String> dimensionsDefault, Consumer<XbrlValueId> consumer) {
        AspectData concept = aspectCellData.getConcept();
        List dimensionList = aspectCellData.getDimensions();
        dimensionList = XbrlContextDimension.removeDefaultDimensions((List)dimensionList, dimensionsDefault);
        List xbrlContextDimensionList = XbrlContextDimension.buildFromAspectDataList((List)dimensionList);
        String contextDimensionHash = XbrlContextDimension.dimensionToHash((List)xbrlContextDimensionList);
        String contextDimensionOpenToHash = XbrlContextDimension.dimensionsOpenToHash((List)xbrlContextDimensionList, (Set)this.conceptInMemoryService.getExplicitAspectNodeSet());
        PeriodDates periodDates = AspectUtils.getPeriodDatesForConcept((List)aspectCellData.getAspectDataList(), (AspectData)concept);
        if (periodDates == null) {
            periodDates = PeriodDates.from((XbrlPeriod)this.xbrlPeriodService.getDefaultPeriod());
        }
        if (concept.getConceptPeriodType() == PeriodType.INSTANT) {
            periodDates = periodDates.toInstant();
        }
        for (XbrlContectValueDTO xbrlContectValueDTO : byElementName) {
            if (!contextDimensionHash.equals(xbrlContectValueDTO.getDimensionsHash()) && !contextDimensionOpenToHash.equals(xbrlContectValueDTO.getDimensionsOpenHash())) continue;
            XbrlValueId xbrlValueId = new XbrlValueId(xbrlContectValueDTO.getElementLabel(), xbrlContectValueDTO.getXbrlReportId(), xbrlContectValueDTO.getXbrlContextId());
            String value = xbrlContectValueDTO.getValue();
            if (periodDates.getPeriodType() == PeriodType.INSTANT && xbrlContectValueDTO.getInstantDate() != null && DateUtils.isSameDay((Date)periodDates.getInstantDate(), (Date)xbrlContectValueDTO.getInstantDate())) {
                consumer.accept(xbrlValueId);
            }
            if (periodDates.getPeriodType() == PeriodType.DURATION && xbrlContectValueDTO.getStartDate() != null && xbrlContectValueDTO.getEndDate() != null && DateUtils.isSameDay((Date)periodDates.getStartDate(), (Date)xbrlContectValueDTO.getStartDate()) && DateUtils.isSameDay((Date)periodDates.getEndDate(), (Date)xbrlContectValueDTO.getEndDate())) {
                consumer.accept(xbrlValueId);
            }
            if (periodDates.getPeriodType() != PeriodType.DURATION || !concept.getConceptPeriodType().equals((Object)PeriodType.INSTANT) || !DateUtils.isSameDay((Date)xbrlContectValueDTO.getInstantDate(), (Date)periodDates.getEndDate())) continue;
            consumer.accept(xbrlValueId);
        }
    }
}

