/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.filter.FilterViewType;
import ru.cbr.xbrl.converter.model.tableLinkBase.AspectNodeMember;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlRoleDimension;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.presentation_definition.InactiveMembersService;
import ru.cbr.xbrl.converter.utils.LabelUtils;
import ru.cbr.xbrl.converter.utils.LispStyleUtil;
import ru.cbr.xbrl.converter.utils.MathUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TableLinkBaseDynamicStructureService {
    private static final Logger log = LoggerFactory.getLogger(TableLinkBaseDynamicStructureService.class);
    private static final String PERIOD = "period";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String Z = "z";
    private static final String GENERATED = "EMPTY_AXIS";
    public static final String ASPECT_DELIMETER = " -> ";
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private InactiveMembersService inactiveMembersService;

    public void fillDynamicMembers(TableLinkBaseStructure structure, XbrlReportRole xbrlRole) throws NotFoundException {
        xbrlRole = this.xbrlReportService.findReportRole(xbrlRole.getId());
        this.fillTypedAxis(structure, xbrlRole);
        this.fillDates(structure, xbrlRole.getId());
    }

    private void fillTypedAxis(TableLinkBaseStructure structure, XbrlReportRole xbrlRole) {
        String systemRoleId = structure.getName();
        List originalAspectNodeMembers = xbrlRole.getAspectNodeMembers();
        Map<String, List<AspectNodeMember>> aspNodeMembers = originalAspectNodeMembers.stream().collect(Collectors.groupingBy(AspectNodeMember::getHash));
        structure.setXAxis((AxisMemberHierarchy)LispStyleUtil.car((List)this.cortegeFilledAxis(systemRoleId, aspNodeMembers, structure.getXAxis(), structure.getXAxis(), new ArrayList(), true)));
        structure.setYAxis((AxisMemberHierarchy)LispStyleUtil.car((List)this.cortegeFilledAxis(systemRoleId, aspNodeMembers, structure.getYAxis(), structure.getYAxis(), new ArrayList(), false)));
        structure.setZAxis((AxisMemberHierarchy)LispStyleUtil.car((List)this.createFilledAxis(structure.getZAxis(), xbrlRole)));
    }

    public List<AxisMemberHierarchy> cortegeFilledAxis(String systemRoleId, Map<String, List<AspectNodeMember>> aspNodeMembers, AxisMemberHierarchy original, AxisMemberHierarchy parent, List<AspectData> parentAspectData, boolean sort) {
        List<AspectNodeMember> aspectNodeMembers;
        ArrayList<AxisMemberHierarchy> filled = new ArrayList<AxisMemberHierarchy>();
        ArrayList<AspectData> currentAspectDataList = new ArrayList<AspectData>(parentAspectData);
        if (original.getNodeType() == NodeType.RULE) {
            AxisMemberHierarchy newSimpleAxisMemberHierarchy = new AxisMemberHierarchy();
            newSimpleAxisMemberHierarchy.setAxis(original.getAxis());
            if ("title".equals(original.getId())) {
                newSimpleAxisMemberHierarchy.setId("title");
            } else {
                newSimpleAxisMemberHierarchy.setId(original.getId());
            }
            newSimpleAxisMemberHierarchy.setAspectDataList(original.getAspectDataList());
            newSimpleAxisMemberHierarchy.setLabel(LabelUtils.calcLabel((List)newSimpleAxisMemberHierarchy.getAspectDataList(), (String)original.getLabel()));
            newSimpleAxisMemberHierarchy.setChildAspectNodes(TableLinkBaseDynamicStructureService.calcChildAspectNodes((AxisMemberHierarchy)original));
            newSimpleAxisMemberHierarchy.setAbstractNode(original.isAbstractNode());
            currentAspectDataList.addAll(newSimpleAxisMemberHierarchy.getAspectDataList());
            newSimpleAxisMemberHierarchy.setHash(original.getId());
            newSimpleAxisMemberHierarchy.setNodeType(original.getNodeType());
            filled.add(newSimpleAxisMemberHierarchy);
        } else if (original.getNodeType() == NodeType.ASPECT && (aspectNodeMembers = aspNodeMembers.get(parent.getHash())) != null) {
            for (AspectNodeMember aspectNodeMember : aspectNodeMembers) {
                String value;
                String label;
                boolean isOpenAxis;
                Optional<AspectData> target = original.getAspectDataList().stream().filter(it -> it.getAspect().equals(aspectNodeMember.getDimension())).findFirst();
                if (!target.isPresent()) continue;
                AspectData targetAspectData = target.get();
                AxisMemberHierarchy newAspectAxisMemberHierarchy = new AxisMemberHierarchy();
                newAspectAxisMemberHierarchy.setAxis(original.getAxis());
                newAspectAxisMemberHierarchy.setId(aspectNodeMember.getCommonId());
                boolean bl = isOpenAxis = aspectNodeMember.getFilterOpenAxisValue() != null;
                if (isOpenAxis) {
                    label = aspectNodeMember.getFilterOpenAxisValue().getValue();
                    value = aspectNodeMember.getFilterOpenAxisValue().getValue();
                } else {
                    label = aspectNodeMember.getClosedMemberLabel();
                    value = aspectNodeMember.getClosedMemberValue();
                }
                AspectData aspectData = new AspectData();
                aspectData.setAspect(targetAspectData.getAspect());
                aspectData.setAxisLabel(targetAspectData.getLabel());
                aspectData.setAxisValueLabel(label);
                aspectData.setLabel(targetAspectData.getLabel() + "-" + label);
                aspectData.setAspectValue(value);
                aspectData.setType(AspectType.DIMENSION);
                aspectData.setDimensionType(targetAspectData.getDimensionType());
                aspectData.setDomain(targetAspectData.getDomain());
                aspectData.setAxisId(aspectNodeMember.getAxisId());
                newAspectAxisMemberHierarchy.getAspectDataList().add(aspectData);
                newAspectAxisMemberHierarchy.getAspectDataList().addAll(original.getAspectDataList().stream().filter(it -> it.getType().equals((Object)AspectType.CONCEPT)).collect(Collectors.toList()));
                newAspectAxisMemberHierarchy.setAbstractNode(original.isAbstractNode());
                newAspectAxisMemberHierarchy.setLabel(LabelUtils.calcLabel((List)newAspectAxisMemberHierarchy.getAspectDataList(), null));
                newAspectAxisMemberHierarchy.setChildAspectNodes(TableLinkBaseDynamicStructureService.calcChildAspectNodes((AxisMemberHierarchy)original));
                newAspectAxisMemberHierarchy.setNodeType(original.getNodeType());
                currentAspectDataList.addAll(newAspectAxisMemberHierarchy.getAspectDataList());
                newAspectAxisMemberHierarchy.setHash(aspectNodeMember.getCommonId());
                boolean bl2 = isOpenAxis ? !this.inactiveMembersService.isInactiveOpenMember(systemRoleId, aspectNodeMember.getFilterOpenAxisValue().getId(), FilterViewType.TABLELINKBASE) : !this.inactiveMembersService.isInactiveClosedMember(systemRoleId, aspectData.getAspect(), aspectData.getAspectValue(), FilterViewType.TABLELINKBASE);
                boolean isActive = bl2;
                if (!isActive) continue;
                filled.add(newAspectAxisMemberHierarchy);
            }
        }
        for (AxisMemberHierarchy originalChild : original.getAxisMemberHierarchyList()) {
            filled.forEach(it -> it.getAxisMemberHierarchyList().addAll(this.cortegeFilledAxis(systemRoleId, aspNodeMembers, originalChild, it, (List)currentAspectDataList, sort)));
        }
        if (sort) {
            Collections.sort(filled, Comparator.comparing(AxisMemberHierarchy::getLabel));
        }
        return filled;
    }

    private String md5Aspects(List<AspectData> aspectData, String alternative) {
        ArrayList<String> stringAspects = new ArrayList<String>();
        for (AspectData aspect : aspectData) {
            if (aspect.getType() == AspectType.CONCEPT) {
                stringAspects.add(aspect.getAspectValue());
            }
            if (aspect.getType() == AspectType.DIMENSION) {
                if (aspect.getDimensionType() == DimensionType.EXPLICIT_MEMBER) {
                    stringAspects.add(aspect.getAspect() + " -> " + aspect.getAspectValue());
                }
                if (aspect.getDimensionType() == DimensionType.TYPED_MEMBER) {
                    stringAspects.add(aspect.getAspect() + " -> " + aspect.getAspectValue() + " -> " + aspect.getDomain());
                }
            }
            if (aspect.getType() != AspectType.PARAMS_PERIOD) continue;
            stringAspects.add(aspect.getAspect() + " -> " + aspect.getAspectValue());
        }
        if (stringAspects.isEmpty()) {
            return DigestUtils.md5Hex((String)alternative);
        }
        return DigestUtils.md5Hex((String)stringAspects.stream().sorted().collect(Collectors.joining(";")));
    }

    public static List<String> calcChildAspectNodes(AxisMemberHierarchy original) {
        for (AxisMemberHierarchy child : original.getAxisMemberHierarchyList()) {
            Optional<AspectData> first;
            if (child.getNodeType() != NodeType.ASPECT || !(first = child.getAspectDataList().stream().filter(it -> it.getType() == AspectType.DIMENSION).findFirst()).isPresent()) continue;
            return Collections.singletonList(first.get().getAspect());
        }
        return null;
    }

    public List<AxisMemberHierarchy> createFilledAxis(AxisMemberHierarchy original, XbrlReportRole xbrlRole) {
        ArrayList<AxisMemberHierarchy> filled = new ArrayList<AxisMemberHierarchy>();
        List typedAspects = original.getAspectDataList().stream().filter(it -> it.getType() == AspectType.DIMENSION && it.getDimensionType() == DimensionType.TYPED_MEMBER).collect(Collectors.toList());
        if (typedAspects.isEmpty()) {
            AxisMemberHierarchy newSimpleAxisMemberHierarchy = new AxisMemberHierarchy();
            newSimpleAxisMemberHierarchy.setAxis(original.getAxis());
            if ("title".equals(original.getId())) {
                newSimpleAxisMemberHierarchy.setId("title");
            } else {
                newSimpleAxisMemberHierarchy.setId(UUID.randomUUID().toString());
            }
            newSimpleAxisMemberHierarchy.setAspectDataList(original.getAspectDataList());
            newSimpleAxisMemberHierarchy.setLabel(LabelUtils.calcLabel((List)newSimpleAxisMemberHierarchy.getAspectDataList(), (String)original.getLabel()));
            filled.add(newSimpleAxisMemberHierarchy);
        } else {
            ArrayList<List> values = new ArrayList<List>();
            for (AspectData effectiveAspect : typedAspects) {
                String dimension = effectiveAspect.getAspect();
                Optional<FilterOpenAxis> first = xbrlRole.getXbrlRoleDimensionList().stream().map(XbrlRoleDimension::getFilterOpenAxis).filter(it -> it.getSystemId().equals(dimension)).findFirst();
                values.add(this.getActiveMemberList(xbrlRole, first.get()));
            }
            List cartesian = MathUtils.cartesianProduct(values);
            for (List filterOpenAxisValues : cartesian) {
                AxisMemberHierarchy newTypedAxisMemberHierarchy = new AxisMemberHierarchy();
                newTypedAxisMemberHierarchy.setAxis(original.getAxis());
                newTypedAxisMemberHierarchy.setId(UUID.randomUUID().toString());
                for (FilterOpenAxisValue filterOpenAxisValue : filterOpenAxisValues) {
                    AspectData aspectData = new AspectData();
                    aspectData.setAspect(filterOpenAxisValue.getFilterOpenAxis().getSystemId());
                    aspectData.setLabel(filterOpenAxisValue.getFilterOpenAxis().getTitle() + "-" + filterOpenAxisValue.getValue());
                    aspectData.setAspectValue(filterOpenAxisValue.getValue());
                    aspectData.setType(AspectType.DIMENSION);
                    aspectData.setDimensionType(DimensionType.TYPED_MEMBER);
                    aspectData.setDomain(filterOpenAxisValue.getFilterOpenAxis().getDomain());
                    newTypedAxisMemberHierarchy.getAspectDataList().add(aspectData);
                }
                newTypedAxisMemberHierarchy.setLabel(LabelUtils.calcLabel((List)newTypedAxisMemberHierarchy.getAspectDataList(), null));
                filled.add(newTypedAxisMemberHierarchy);
            }
        }
        for (AxisMemberHierarchy originalChild : original.getAxisMemberHierarchyList()) {
            filled.forEach(it -> it.getAxisMemberHierarchyList().addAll(this.createFilledAxis(originalChild, xbrlRole)));
        }
        return filled;
    }

    public List<FilterOpenAxisValue> getActiveMemberList(XbrlReportRole xbrlReportRole, FilterOpenAxis filterOpenAxis) {
        if (xbrlReportRole == null || filterOpenAxis == null) {
            return Collections.emptyList();
        }
        List axisMemberList = filterOpenAxis.getAxisMemberList();
        return axisMemberList.stream().filter(filterOpenAxisValue -> !this.inactiveMembersService.isInactiveOpenMember(xbrlReportRole.getSystemId(), filterOpenAxisValue.getId(), FilterViewType.TABLELINKBASE)).collect(Collectors.toList());
    }

    private void fillDates(TableLinkBaseStructure structure, Long xbrlRoleId) throws NotFoundException {
        List reportRolePeriodList = this.xbrlReportService.findReportRolePeriodList(xbrlRoleId);
        List activePeriods = reportRolePeriodList.stream().filter(it -> it.getActive() == null || it.getActive() != false).collect(Collectors.toList());
        String periodAxis = structure.getPeriodAxis();
        if (StringUtils.isNotBlank((CharSequence)periodAxis)) {
            AxisMemberHierarchy target;
            HashSet<String> periods = new HashSet<String>();
            periods.add("EMPTY_AXIS");
            structure.setPeriods(periods);
            switch (periodAxis) {
                case "x": {
                    target = structure.getXAxis();
                    break;
                }
                case "y": {
                    target = structure.getYAxis();
                    break;
                }
                case "z": {
                    target = structure.getZAxis();
                    break;
                }
                default: {
                    target = structure.getXAxis();
                }
            }
            for (XbrlPeriod xbrlPeriod : activePeriods) {
                AxisMemberHierarchy currentMemberHierarchy = new AxisMemberHierarchy();
                String period = PeriodDates.from((XbrlPeriod)xbrlPeriod).formatDate();
                currentMemberHierarchy.setAxis(periodAxis);
                currentMemberHierarchy.setLabel(period);
                currentMemberHierarchy.setId(period);
                currentMemberHierarchy.getAspectDataList().add(new AspectData("period", AspectType.forValue((String)"period"), period, null));
                target.getAxisMemberHierarchyList().add(currentMemberHierarchy);
            }
        } else {
            int processed = this.processingParamsPeriods(structure);
            if (processed > 0) {
                HashSet<String> periods = new HashSet<String>();
                periods.add("EMPTY_AXIS");
                structure.setPeriods(periods);
            } else {
                structure.setPeriods(activePeriods.stream().map(it -> PeriodDates.from((XbrlPeriod)it).formatDate()).collect(Collectors.toSet()));
            }
        }
    }

    private int processingParamsPeriods(TableLinkBaseStructure structure) {
        return this.processingMemberParamsPeriods(structure.getXAxis()) + this.processingMemberParamsPeriods(structure.getYAxis()) + this.processingMemberParamsPeriods(structure.getZAxis());
    }

    private int processingMemberParamsPeriods(AxisMemberHierarchy axis) {
        boolean axisHaveParamPeriod;
        int processed = 0;
        if (axis.getAspectDataList() != null && (axisHaveParamPeriod = axis.getAspectDataList().stream().anyMatch(it -> it.getAspect().equals("period type")))) {
            ++processed;
        }
        for (AxisMemberHierarchy axisMemberHierarchy : axis.getAxisMemberHierarchyList()) {
            processed += this.processingMemberParamsPeriods(axisMemberHierarchy);
        }
        return processed;
    }
}

