/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.exception.OpenAxisValidationException;
import ru.cbr.xbrl.converter.model.OpenAxisValidationRule;
import ru.cbr.xbrl.converter.repository.OpenAxisValidationRuleRepository;
import ru.cbr.xbrl.converter.service.OpenAxisValidationRulesService;

@Service
public class OpenAxisValidationRulesServiceImpl
implements OpenAxisValidationRulesService {
    private static final Logger log = LoggerFactory.getLogger(OpenAxisValidationRulesServiceImpl.class);
    private final OpenAxisValidationRuleRepository repository;

    @Transactional(value="cacheTransactionManager")
    public List<OpenAxisValidationRule> saveAll(Set<OpenAxisValidationRule> validationRules) {
        Set uniques = validationRules.stream().filter(rule -> !this.repository.findByDimension(rule.getDimension()).isPresent()).collect(Collectors.toSet());
        return this.repository.save(uniques);
    }

    public void validate(String dimension, String value) throws OpenAxisValidationException {
        this.validateValue((OpenAxisValidationRule)this.repository.findByDimension(dimension).orElse(null), value);
    }

    private void validateValue(OpenAxisValidationRule rule, String value) throws OpenAxisValidationException {
        Pattern p;
        if (rule != null && !(p = Pattern.compile(rule.getRegex())).matcher(value).find()) {
            throw new OpenAxisValidationException(rule.getRegex());
        }
    }

    @ConstructorProperties(value={"repository"})
    public OpenAxisValidationRulesServiceImpl(OpenAxisValidationRuleRepository repository) {
        this.repository = repository;
    }
}

