/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.service.KeyValueStoreService;
import ru.cbr.xbrl.converter.service.NamespacesService;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class NamespacesService {
    private static final Logger log = LoggerFactory.getLogger(NamespacesService.class);
    public static final String NAMESPACES_STORE_KEY = "namespaces";
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private KeyValueStoreService keyValueStoreService;
    private List<XbrlXmlNamespace> namespaces = new ArrayList();
    private Map<String, String> defaultPrefixes = new HashMap();

    @PostConstruct
    public void onCreate() {
        try {
            log.info("Load namespaces from store");
            this.readNamespaces();
            log.info("Load namespaces from store complete. Loaded namespaces: {}", (Object)this.namespaces.size());
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void parse(String namespaceXml) {
        log.info("Load namespaces from file");
        this.namespaces = NamespacesService.parseNamespaceFile((String)namespaceXml);
        log.info("Load namespaces from fule complete. Loaded namespaces: {}", (Object)this.namespaces.size());
        this.defaultPrefixes = this.namespaces.stream().collect(Collectors.toMap(XbrlXmlNamespace::getValue, XbrlXmlNamespace::getPrefix));
        try {
            this.writeNamespaces();
        }
        catch (JsonProcessingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public String getDefaultPrefixForNamespace(String namespaceUri) {
        return (String)this.defaultPrefixes.get(namespaceUri);
    }

    public Map<String, String> getDefaultPrefixes() {
        return this.defaultPrefixes;
    }

    public static List<XbrlXmlNamespace> parseNamespaceFile(String fileFullName) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XbrlXmlNamespaces.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            File file = new File(fileFullName);
            if (file.length() == 0L) {
                log.info("Empty parametersFile");
                return new ArrayList<XbrlXmlNamespace>();
            }
            XbrlXmlNamespaces parsedNamespaces = (XbrlXmlNamespaces)unmarshaller.unmarshal(file);
            return parsedNamespaces.getNamespaces();
        }
        catch (JAXBException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static List<XbrlXmlNamespace> parseNamespaceXml(String xml) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XbrlXmlNamespaces.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(xml);
            XbrlXmlNamespaces parsedNamespaces = (XbrlXmlNamespaces)unmarshaller.unmarshal((Reader)reader);
            return parsedNamespaces.getNamespaces();
        }
        catch (JAXBException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    private void writeNamespaces() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)this.namespaces);
        this.keyValueStoreService.putString("namespaces", json);
    }

    private void readNamespaces() throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        String json = this.keyValueStoreService.getString("namespaces");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            List xbrlXmlNamespaces;
            this.namespaces = xbrlXmlNamespaces = (List)objectMapper.readValue(json, (TypeReference)typeReference);
            this.defaultPrefixes = this.namespaces.stream().collect(Collectors.toMap(XbrlXmlNamespace::getValue, XbrlXmlNamespace::getPrefix));
        }
    }
}

