/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.utils.GzipUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EnumerationsService {
    private static final Logger log = LoggerFactory.getLogger(EnumerationsService.class);
    private Map<String, List<EnumerateItem>> enumerations;

    public void loadFromReport(XbrlReport xbrlReport) {
        this.enumerations = EnumerationsService.decompressEnumerations((byte[])xbrlReport.getEnumerationsJsonGzipped());
        log.info("Enumerations reloaded, size = " + this.enumerations.size());
    }

    public Map<String, List<EnumerateItem>> getEnumerations() {
        return this.enumerations;
    }

    public static byte[] compressEnumerations(List<TableLinkBaseStructure> tableLinkBaseStructures) {
        HashMap enums = new HashMap();
        List<Map> rolesEnums = tableLinkBaseStructures.stream().map(tableLinkBaseStructure -> tableLinkBaseStructure.getEnumerations()).collect(Collectors.toList());
        rolesEnums.forEach(stringListMap -> stringListMap.keySet().forEach(key -> enums.putIfAbsent(key, stringListMap.get(key))));
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String json = objectMapper.writeValueAsString(enums);
            byte[] gzipped = GzipUtils.compressString((String)json);
            return gzipped;
        }
        catch (JsonProcessingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static Map<String, List<EnumerateItem>> decompressEnumerations(byte[] gzipped) {
        if (gzipped == null) {
            return new HashMap<String, List<EnumerateItem>>();
        }
        try {
            String json = GzipUtils.decompressString((byte[])gzipped);
            ObjectMapper objectMapper = new ObjectMapper();
            Map enumerations = (Map)objectMapper.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return enumerations;
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return new HashMap<String, List<EnumerateItem>>();
        }
    }
}

