/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.exception.ExcessRoleCountException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.ReadFileException;
import ru.cbr.xbrl.converter.model.XbrlDimension;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.tableLinkBase.AspectNodeMember;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.DimensionDTO;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.MemberDTO;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.repository.XbrlDimensionRepository;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;
import ru.cbr.xbrl.converter.service.OpenAxisValidationRulesService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisMemberService;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisService;
import ru.cbr.xbrl.converter.service.internal.XbrlReportCrudService;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

@Service
public class AspectNodeService {
    private static final Logger log = LoggerFactory.getLogger(AspectNodeService.class);
    public static final String AXIS_ID_TECHNICAL_COLUMN_NAME = "AXIS_ID_TC";
    private final XbrlFilterOpenAxisService filterOpenAxisService;
    private final XbrlReportCrudService xbrlReportCrudService;
    private final XbrlReportService xbrlReportService;
    private final XbrlFilterOpenAxisMemberService xbrlFilterOpenAxisMemberService;
    private final XbrlDimensionRepository xbrlDimensionRepository;
    private final OpenAxisValidationRulesService openAxisValidationRulesService;
    @Autowired
    private ConceptInMemoryService conceptInMemoryService;

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public DimensionDTO getMembersForDimension(String dim) {
        List allByDimInt = this.xbrlDimensionRepository.findAllByDimInt(dim);
        if (!allByDimInt.isEmpty()) {
            List members = allByDimInt.stream().map(it -> new MemberDTO(it.getMemIntLabel(), it.getMemInt())).collect(Collectors.toList());
            return new DimensionDTO(((XbrlDimension)allByDimInt.get(0)).getDimIntLabel(), DimensionType.EXPLICIT_MEMBER, members);
        }
        List filterOpenAxisList = this.filterOpenAxisService.findFilterOpenAxisBySystemId(dim);
        if (filterOpenAxisList != null && !filterOpenAxisList.isEmpty()) {
            FilterOpenAxis filterOpenAxis = (FilterOpenAxis)filterOpenAxisList.get(0);
            List members = filterOpenAxis.getAxisMemberList().stream().map(it -> new MemberDTO(it.getValue(), it.getValue())).collect(Collectors.toList());
            filterOpenAxis.getAxisMemberList().size();
            return new DimensionDTO(filterOpenAxis.getTitle(), DimensionType.TYPED_MEMBER, members);
        }
        return new DimensionDTO("", DimensionType.EXPLICIT_MEMBER, new ArrayList());
    }

    @Transactional(value="cacheTransactionManager")
    public AspectNodeMember saveMember(Long reportRoleId, String dimension, String member, String hash, String axisId) throws NotFoundException {
        return this.saveMember(reportRoleId, dimension, member, hash, axisId, UUID.randomUUID().toString());
    }

    @Transactional(value="cacheTransactionManager")
    public AspectNodeMember saveMember(Long reportRoleId, String dimension, String member, String hash, String axisId, String externalId) throws NotFoundException {
        FilterOpenAxisValue target;
        String value = member == null ? null : member.trim();
        XbrlReportRole reportRole = this.xbrlReportService.findReportRole(reportRoleId);
        List allByDimInt = this.xbrlDimensionRepository.findAllByDimInt(dimension);
        if (!allByDimInt.isEmpty()) {
            Optional<XbrlDimension> first = allByDimInt.stream().filter(it -> it.getMemInt().equals(value) || StringUtils.trim((String)it.getMemIntLabel()).equals(StringUtils.trim((String)value))).findFirst();
            if (!first.isPresent()) {
                return null;
            }
            XbrlDimension target2 = first.get();
            Optional<AspectNodeMember> existingAspectNodeMember = reportRole.getAspectNodeMembers().stream().filter(a -> a.getDimension().equals(dimension) && a.getHash().equals(hash) && a.getClosedMemberValue().equals(target2.getMemInt())).findAny();
            if (existingAspectNodeMember.isPresent()) {
                return existingAspectNodeMember.get();
            }
            AspectNodeMember aspectNodeMember = new AspectNodeMember();
            aspectNodeMember.setXbrlReportRole(reportRole);
            aspectNodeMember.setClosedMemberValue(target2.getMemInt());
            aspectNodeMember.setClosedMemberLabel(target2.getMemIntLabel());
            aspectNodeMember.setDimension(dimension);
            aspectNodeMember.setHash(hash);
            aspectNodeMember.setCommonId(externalId);
            aspectNodeMember.setAxisId(axisId);
            reportRole.getAspectNodeMembers().add(aspectNodeMember);
            this.xbrlReportCrudService.updateXbrlReportRole(reportRole);
            return aspectNodeMember;
        }
        List filterOpenAxisList = this.filterOpenAxisService.findFilterOpenAxisBySystemId(dimension);
        if (filterOpenAxisList.isEmpty()) {
            log.error("Dimension not found: {}", (Object)dimension);
            throw new NotFoundException();
        }
        FilterOpenAxis filterOpenAxis = (FilterOpenAxis)filterOpenAxisList.get(0);
        this.openAxisValidationRulesService.validate(dimension, value);
        List filterOpenAxisValues = this.xbrlFilterOpenAxisMemberService.getFilterOpenAxisValuesByFilterOpenAxisAndValue(filterOpenAxis, value);
        Optional first = filterOpenAxisValues.stream().findFirst();
        if (first.isPresent()) {
            target = (FilterOpenAxisValue)first.get();
        } else {
            target = new FilterOpenAxisValue();
            target.setFilterOpenAxis(filterOpenAxis);
            target.setValue(value);
            target = this.xbrlFilterOpenAxisMemberService.update(target);
        }
        Optional<AspectNodeMember> existingAspectNodeMember = reportRole.getAspectNodeMembers().stream().filter(a -> a.getDimension().equals(dimension) && a.getHash().equals(hash) && a.getFilterOpenAxisValue().getValue().equals(value)).findAny();
        if (existingAspectNodeMember.isPresent()) {
            return existingAspectNodeMember.get();
        }
        filterOpenAxis.getAxisMemberList().add(target);
        this.filterOpenAxisService.update(filterOpenAxis);
        AspectNodeMember aspectNodeMember = new AspectNodeMember();
        aspectNodeMember.setXbrlReportRole(reportRole);
        aspectNodeMember.setFilterOpenAxisValue(target);
        aspectNodeMember.setDimension(dimension);
        aspectNodeMember.setHash(hash);
        aspectNodeMember.setCommonId(externalId);
        aspectNodeMember.setAxisId(axisId);
        reportRole.getAspectNodeMembers().add(aspectNodeMember);
        this.xbrlReportCrudService.updateXbrlReportRole(reportRole);
        return aspectNodeMember;
    }

    @Transactional(value="cacheTransactionManager")
    public void importMembers(Long reportRoleId, String rootDimension, String rootHash, String fileName, String rootAxisType) throws ReadFileException {
        try {
            AxisMemberHierarchy aspectNodeHierarchy;
            XbrlReportRole xbrlReportRole = this.xbrlReportService.findReportRole(reportRoleId);
            ObjectMapper mapper = new ObjectMapper();
            TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)mapper.readValue(xbrlReportRole.getStaticStructureJson(), TableLinkBaseStructure.class);
            AxisMemberHierarchy axisMemberHierarchy = tableLinkBaseStructure.findAxis(TableLinkBaseStructure.TableAxis.search((String)rootAxisType));
            String parentHash = axisMemberHierarchy.getId();
            AxisMemberHierarchy current = aspectNodeHierarchy = (AxisMemberHierarchy)axisMemberHierarchy.getAxisMemberHierarchyList().stream().filter(a -> a.getNodeType().equals((Object)NodeType.ASPECT)).findAny().orElse(null);
            ArrayList<String> dimensions = new ArrayList<String>();
            dimensions.add(((AspectData)current.getAspectDataList().get(0)).getAspect());
            while (!current.getAxisMemberHierarchyList().isEmpty()) {
                current = (AxisMemberHierarchy)current.getAxisMemberHierarchyList().get(0);
                dimensions.add(((AspectData)current.getAspectDataList().get(0)).getAspect());
            }
            boolean hasAxisIdTechnicalColumn = this.hasAxisIdTechnicalColumn(fileName);
            this.readMembersFromCsv(fileName, row -> {
                boolean hasBlankMembers = row.stream().anyMatch(StringUtils::isBlank);
                if (!hasBlankMembers) {
                    String currentHash = parentHash;
                    int size = hasAxisIdTechnicalColumn ? row.size() - 1 : row.size();
                    for (int colIndex = 0; colIndex < size; ++colIndex) {
                        String dimint;
                        String axisId = null;
                        if (colIndex == size - 1 && hasAxisIdTechnicalColumn) {
                            axisId = (String)row.get(colIndex + 1);
                        }
                        try {
                            dimint = (String)dimensions.get(colIndex);
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw new ExcessRoleCountException();
                        }
                        AspectNodeMember newMember = null;
                        try {
                            newMember = this.saveMember(xbrlReportRole.getId(), dimint, (String)row.get(colIndex), currentHash, axisId);
                            currentHash = newMember.getCommonId();
                            continue;
                        }
                        catch (NotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAxisIdTechnicalColumn(String csvFile) throws ReadFileException {
        try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(csvFile), Charset.forName("cp1251"));){
            CSVParser parse = CSVFormat.EXCEL.withFirstRecordAsHeader().withDelimiter(';').parse((Reader)in);
            Map headerMap = parse.getHeaderMap();
            boolean bl = headerMap.keySet().contains(AXIS_ID_TECHNICAL_COLUMN_NAME);
            return bl;
        }
        catch (IOException e) {
            throw new ReadFileException();
        }
    }

    public Function<AspectCellData, String> calcDimensionOpenHashByAspectCellData(Map<String, String> dimensionsDefault) {
        return aspectCellData -> {
            List dimensionList = aspectCellData.getDimensions();
            dimensionList = XbrlContextDimension.removeDefaultDimensions((List)dimensionList, (Map)dimensionsDefault);
            List xbrlContextDimensionList = XbrlContextDimension.buildFromAspectDataList((List)dimensionList);
            return XbrlContextDimension.dimensionsOpenToHash((List)xbrlContextDimensionList, (Set)this.conceptInMemoryService.getExplicitAspectNodeSet());
        };
    }

    @Transactional(value="cacheTransactionManager")
    public void saveMembersList(Long reportRoleId, String rootDimension, String rootHash, List<String> members) {
        String currentDomension = rootDimension;
        String curentHash = rootHash;
        for (String currentMember : members) {
            try {
                AspectNodeMember newMember = this.saveMember(reportRoleId, currentDomension, currentMember, curentHash, null);
                currentDomension = newMember.getDimension();
                curentHash = newMember.getHash();
            }
            catch (NotFoundException e) {
                return;
            }
        }
    }

    public void readMembersFromCsv(String csvFile, Consumer<List<String>> rowConsumer) throws ReadFileException {
        try {
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(csvFile), Charset.forName("cp1251"));
            CSVParser records = null;
            records = CSVFormat.EXCEL.withFirstRecordAsHeader().withDelimiter(';').parse((Reader)in);
            for (CSVRecord record : records) {
                ArrayList<String> row = new ArrayList<String>();
                for (int i = 0; i < record.size(); ++i) {
                    row.add(record.get(i));
                }
                rowConsumer.accept(row);
            }
        }
        catch (FileNotFoundException e) {
            throw new ReadFileException();
        }
        catch (IOException e) {
            throw new ReadFileException();
        }
    }

    @ConstructorProperties(value={"filterOpenAxisService", "xbrlReportCrudService", "xbrlReportService", "xbrlFilterOpenAxisMemberService", "xbrlDimensionRepository", "openAxisValidationRulesService"})
    public AspectNodeService(XbrlFilterOpenAxisService filterOpenAxisService, XbrlReportCrudService xbrlReportCrudService, XbrlReportService xbrlReportService, XbrlFilterOpenAxisMemberService xbrlFilterOpenAxisMemberService, XbrlDimensionRepository xbrlDimensionRepository, OpenAxisValidationRulesService openAxisValidationRulesService) {
        this.filterOpenAxisService = filterOpenAxisService;
        this.xbrlReportCrudService = xbrlReportCrudService;
        this.xbrlReportService = xbrlReportService;
        this.xbrlFilterOpenAxisMemberService = xbrlFilterOpenAxisMemberService;
        this.xbrlDimensionRepository = xbrlDimensionRepository;
        this.openAxisValidationRulesService = openAxisValidationRulesService;
    }
}

