/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.repository;

import java.util.Date;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;

@Repository
public interface XbrlPeriodRepository
extends CrudRepository<XbrlPeriod, Long>,
JpaRepository<XbrlPeriod, Long> {
    public List<XbrlPeriod> findAllByStartAndEnd(String var1, String var2);

    public XbrlPeriod findOneByTypeAndStartAndEnd(PeriodType var1, Date var2, Date var3);

    public XbrlPeriod findOneByIsDefaultPeriodTrue();

    @Query(value="FROM XbrlPeriod p where trunc(p.start) = trunc(:startDate) and trunc(p.end) = trunc(:endDate)")
    public XbrlPeriod findOneByDuration(@Param(value="startDate") Date var1, @Param(value="endDate") Date var2);

    @Query(value="FROM XbrlPeriod p where trunc(p.start) = trunc(:startDate) and p.end is null")
    public XbrlPeriod findOneByInstantDate(@Param(value="startDate") Date var1);

    @Query(value="FROM XbrlPeriod p where trunc(p.start) = trunc(:startDate) and p.end is null and p.isEditablePeriod = (:isEditablePeriod)")
    public XbrlPeriod findOneByInstantDateAndIsEditablePeriod(@Param(value="startDate") Date var1, @Param(value="isEditablePeriod") Boolean var2);

    @Query(value="FROM XbrlPeriod p where trunc(p.start) = trunc(:startDate) and trunc(p.end) = trunc(:endDate) and p.isEditablePeriod = (:isEditablePeriod)")
    public XbrlPeriod findOneByDurationAndIsEditablePeriod(@Param(value="startDate") Date var1, @Param(value="endDate") Date var2, @Param(value="isEditablePeriod") Boolean var3);
}

