/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.repository;

import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import ru.cbr.xbrl.converter.model.XbrlContextPDRole;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextId;

@Repository
public interface XbrlContextRepository
extends PagingAndSortingRepository<XbrlContext, XbrlContextId>,
JpaRepository<XbrlContext, XbrlContextId> {
    @Query(value="select c from XbrlContext c")
    public Stream<XbrlContext> streamAll();

    public List<XbrlContext> findByInstantDateAndDimensionsHash(Date var1, String var2);

    public List<XbrlContext> findByStartDateAndEndDateAndDimensionsHash(Date var1, Date var2, String var3);

    public XbrlContext findOneByPeriodTypeAndInstantDateAndDimensionsHash(PeriodType var1, Date var2, String var3);

    public XbrlContext findOneByPeriodTypeAndStartDateAndEndDateAndDimensionsHash(PeriodType var1, Date var2, Date var3, String var4);

    @Query(value="SELECT c.xbrlContextId.contextId FROM XbrlContext c WHERE c.periodType = ?1 AND c.instantDate = ?2 AND c.dimensionsHash = ?3")
    public List<String> findContextIdByPeriodTypeAndInstantDateAndDimensionsHash(PeriodType var1, Date var2, String var3);

    @Query(value="SELECT c.xbrlContextId.contextId FROM XbrlContext c WHERE c.periodType = ?1 AND c.startDate = ?2 AND c.endDate = ?3 AND c.dimensionsHash = ?4")
    public List<String> findContextIdByPeriodTypeAndStartDateAndEndDateAndDimensionsHash(PeriodType var1, Date var2, Date var3, String var4);

    @Query(value="SELECT c.xbrlContextId.contextId FROM XbrlContext c WHERE c.periodType = ?1 AND c.instantDate = ?2")
    public List<String> findContextIdByPeriodTypeAndInstantDate(PeriodType var1, Date var2);

    @Query(value="SELECT c.xbrlContextId.contextId FROM XbrlContext c WHERE c.periodType = ?1 AND c.startDate = ?2 AND c.endDate = ?3")
    public List<String> findContextIdByPeriodTypeAndStartDateAndEndDate(PeriodType var1, Date var2, Date var3);

    @Query(value="SELECT c FROM XbrlContext c WHERE c.periodType = ?1 AND c.instantDate = ?2")
    public List<XbrlContext> findContextByPeriodTypeAndInstantDate(PeriodType var1, Date var2);

    @Query(value="SELECT c FROM XbrlContext c WHERE c.periodType = ?1 AND c.startDate = ?2 AND c.endDate = ?3")
    public List<XbrlContext> findContextByPeriodTypeAndStartDateAndEndDate(PeriodType var1, Date var2, Date var3);

    public List<XbrlContext> findByIdentifier(String var1);

    public List<XbrlContext> findByXbrlContextId_ContextId(List<String> var1);

    @Query(value="SELECT COUNT (v) FROM XbrlContext c, XbrlValue v WHERE c.xbrlContextId.contextId = v.xbrlValueId.xbrlContextId and c.periodType = 'DURATION' and c.startDate = :startDate and c.endDate = :endDate ")
    public Long countDurationValue(@Param(value="startDate") Date var1, @Param(value="endDate") Date var2);

    @Query(value="select c from XbrlContext c where exists\n(select 1 from XbrlValue xv where c.xbrlContextId.contextId = xv.xbrlValueId.xbrlContextId and exists(select 1 from XbrlValueRole xvr where xvr.guid = xv.guid and xvr.roleSystemId = ?1))")
    public List<XbrlContext> findByPDRoleSystemId(String var1);

    @Query(value="select distinct xvr.rolesystemid, c.contextid from xbrlcontext c inner join xbrlvalue xv on c.contextid = xv.xbrlcontextid inner join xbrlvaluerole xvr on xvr.guid = xv.guid", nativeQuery=true)
    public List<XbrlContextPDRole> findContextPDRole();
}

