/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model.xbrl_content;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextId;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.utils.GzipUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

@Entity
@Table(indexes={@Index(name="idx_dimensions_hash", columnList="dimensionsHash"), @Index(name="idx_dimensions_hash_instant", columnList="dimensionsHash,instantDate"), @Index(name="idx_dimensions_hash_duration", columnList="dimensionsHash,startDate,endDate"), @Index(name="idx_periodtype_dimensionshash_instant", columnList="periodType,dimensionsHash,instantDate"), @Index(name="idx_periodtype_dimensionshash_duration", columnList="periodType,dimensionsHash,startDate,endDate"), @Index(name="idx_periodtype_instant", columnList="periodType,instantDate"), @Index(name="idx_periodtype_duration", columnList="periodType,startDate,endDate"), @Index(name="idx_xbrlcontext_contextid", columnList="contextId")})
public class XbrlContext {
    private static final Logger log = LoggerFactory.getLogger(XbrlContext.class);
    private static final int ROW_LENGTH = 6;
    private static DateTimeFormatter periodDateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    @EmbeddedId
    private XbrlContextId xbrlContextId = new XbrlContextId();
    @Enumerated(value=EnumType.STRING)
    private PeriodType periodType;
    private Date instantDate;
    private Date startDate;
    private Date endDate;
    private String identifier;
    private String scheme;
    @Lob
    private String segment;
    @Lob
    private String scenario;
    @XmlTransient
    @Transient
    private List<XbrlContextDimension> xbrlContextDimensions = new ArrayList();
    @Lob
    private String dimensions;
    private String dimensionsHash;
    private String dimensionsOpenHash;
    @Lob
    @JsonIgnore
    @XmlTransient
    private byte[] aspectDataJson;
    @Transient
    private List<AspectData> aspectDataList;

    public XbrlContext(XbrlContext that) {
        this.xbrlContextId = new XbrlContextId("a" + UUID.randomUUID().toString(), that.getXbrlContextId().getXbrlReportId());
        this.periodType = that.periodType;
        this.instantDate = that.instantDate;
        this.startDate = that.startDate;
        this.endDate = that.endDate;
        this.identifier = that.identifier;
        this.scheme = that.scheme;
        this.segment = that.segment;
        this.scenario = that.scenario;
        this.dimensions = that.dimensions;
        this.dimensionsHash = that.dimensionsHash;
        this.dimensionsOpenHash = that.dimensionsOpenHash;
        this.aspectDataJson = that.aspectDataJson;
    }

    public XbrlContext(XbrlContext that, PeriodDates newPeriodDates) {
        this(that);
        this.setPeriod(newPeriodDates);
    }

    public void unpackAspectDataList() {
        try {
            String json = GzipUtils.decompressString((byte[])this.aspectDataJson);
            ObjectMapper objectMapper = new ObjectMapper();
            List aspectDataList = (List)objectMapper.readValue((Reader)new StringReader(json), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            this.setAspectDataList(aspectDataList);
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new RuntimeException("Unpack value aspectData error");
        }
    }

    public void packAspectDataList() {
        ObjectMapper objectMapper = new ObjectMapper();
        String aspectDataList = null;
        try {
            aspectDataList = objectMapper.writeValueAsString((Object)this.getAspectDataList());
            this.setAspectDataJson(GzipUtils.compressString((String)aspectDataList));
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new RuntimeException("Unpack value aspectData error");
        }
    }

    public void rebuildDimensions(Set<String> explicitAspectNodeSet) {
        this.dimensions = XbrlContextDimension.dimensionsToString((List)this.xbrlContextDimensions);
        this.dimensionsHash = XbrlContextDimension.dimensionToHash((List)this.xbrlContextDimensions);
        this.dimensionsOpenHash = XbrlContextDimension.dimensionsOpenToHash((List)this.xbrlContextDimensions, explicitAspectNodeSet);
    }

    @Transient
    public String getPeriod() {
        if (this.periodType == null) {
            return null;
        }
        if (this.periodType.equals((Object)PeriodType.INSTANT)) {
            return periodDateFormatter.print(this.instantDate.getTime());
        }
        return periodDateFormatter.print(this.startDate.getTime()) + ", " + periodDateFormatter.print(this.endDate.getTime());
    }

    @Transient
    public void setPeriod(String periodStr) throws XbrlImportException {
        if (!StringUtils.isBlank((CharSequence)periodStr)) {
            if (periodStr.contains(",")) {
                String[] splitted = periodStr.split("\\s*,\\s*");
                this.startDate = this.parseDate(splitted[0]);
                this.endDate = this.parseDate(splitted[1]);
                this.periodType = PeriodType.DURATION;
            } else {
                this.instantDate = this.parseDate(periodStr);
                this.periodType = PeriodType.INSTANT;
            }
        }
    }

    public Date parseDate(String stringDate) throws XbrlImportException {
        if (StringUtils.isBlank((CharSequence)stringDate)) {
            return null;
        }
        DateTime dt = periodDateFormatter.parseDateTime(stringDate);
        return dt.toDate();
    }

    @Transient
    public PeriodDates getPeriodDates() {
        if (this.periodType.equals((Object)PeriodType.INSTANT)) {
            return PeriodDates.buildInstant((Date)this.instantDate);
        }
        if (this.periodType.equals((Object)PeriodType.DURATION)) {
            return PeriodDates.buildDuration((Date)this.startDate, (Date)this.endDate);
        }
        throw new IllegalArgumentException("Unsupported periodType: " + this.periodType);
    }

    public void buildAspectData() {
        AspectData periodAspect = new AspectData();
        periodAspect.setAspect("period");
        periodAspect.setAspectValue(this.getPeriodDates().formatDate());
        periodAspect.setType(AspectType.PERIOD);
        periodAspect.setConceptPeriodType(this.getPeriodType());
        this.aspectDataList = new ArrayList();
        this.aspectDataList.add(periodAspect);
        this.xbrlContextDimensions.forEach(xbrlContextDimension -> {
            AspectData dimAspect = new AspectData();
            dimAspect.setAspect(xbrlContextDimension.getDimension());
            DimensionType dimensionType = xbrlContextDimension.getDimensionType();
            if (dimensionType.equals((Object)DimensionType.TYPED_MEMBER)) {
                dimAspect.setAspectValue(xbrlContextDimension.getDomainValue());
            } else if (dimensionType.equals((Object)DimensionType.EXPLICIT_MEMBER)) {
                dimAspect.setAspectValue(xbrlContextDimension.getMember());
            }
            dimAspect.setType(AspectType.DIMENSION);
            dimAspect.setDomain(xbrlContextDimension.getDomain());
            dimAspect.setDimensionType(dimensionType);
            dimAspect.setLabel(xbrlContextDimension.getLabel());
            this.aspectDataList.add(dimAspect);
        });
        this.packAspectDataList();
    }

    public boolean hasEmptyDomainMember() {
        return this.xbrlContextDimensions.stream().filter(d -> d.getDimensionType().equals((Object)DimensionType.TYPED_MEMBER)).anyMatch(d -> StringUtils.isBlank((CharSequence)d.getDomainValue()));
    }

    public void setPeriod(PeriodDates periodDates) {
        if (periodDates.getPeriodType() == PeriodType.DURATION) {
            this.setStartDate(periodDates.getStartDate());
            this.setEndDate(periodDates.getEndDate());
        } else if (periodDates.getPeriodType() == PeriodType.INSTANT) {
            this.setInstantDate(periodDates.getInstantDate());
        }
    }

    @JsonIgnore
    public Set<String> getDimensionsSet() {
        return XbrlContextDimension.dimensionsFromString((String)this.getDimensions()).stream().map(XbrlContextDimension::getDimension).collect(Collectors.toSet());
    }

    @JsonIgnore
    public String buildPeriodAndDimensionsHash() {
        return this.getPeriodDates().formatDate() + ";" + this.dimensionsHash;
    }

    @JsonIgnore
    public String getXbrlContextIdContextId() {
        return this.xbrlContextId != null ? this.xbrlContextId.getContextId() : null;
    }

    public XbrlContextId getXbrlContextId() {
        return this.xbrlContextId;
    }

    public PeriodType getPeriodType() {
        return this.periodType;
    }

    public Date getInstantDate() {
        return this.instantDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getSegment() {
        return this.segment;
    }

    public String getScenario() {
        return this.scenario;
    }

    public List<XbrlContextDimension> getXbrlContextDimensions() {
        return this.xbrlContextDimensions;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public String getDimensionsHash() {
        return this.dimensionsHash;
    }

    public String getDimensionsOpenHash() {
        return this.dimensionsOpenHash;
    }

    public byte[] getAspectDataJson() {
        return this.aspectDataJson;
    }

    public List<AspectData> getAspectDataList() {
        return this.aspectDataList;
    }

    public void setXbrlContextId(XbrlContextId xbrlContextId) {
        this.xbrlContextId = xbrlContextId;
    }

    public void setPeriodType(PeriodType periodType) {
        this.periodType = periodType;
    }

    public void setInstantDate(Date instantDate) {
        this.instantDate = instantDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setSegment(String segment) {
        this.segment = segment;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    public void setXbrlContextDimensions(List<XbrlContextDimension> xbrlContextDimensions) {
        this.xbrlContextDimensions = xbrlContextDimensions;
    }

    public void setDimensions(String dimensions) {
        this.dimensions = dimensions;
    }

    public void setDimensionsHash(String dimensionsHash) {
        this.dimensionsHash = dimensionsHash;
    }

    public void setDimensionsOpenHash(String dimensionsOpenHash) {
        this.dimensionsOpenHash = dimensionsOpenHash;
    }

    public void setAspectDataJson(byte[] aspectDataJson) {
        this.aspectDataJson = aspectDataJson;
    }

    public void setAspectDataList(List<AspectData> aspectDataList) {
        this.aspectDataList = aspectDataList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XbrlContext)) {
            return false;
        }
        XbrlContext other = (XbrlContext)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        XbrlContextId this$xbrlContextId = this.getXbrlContextId();
        XbrlContextId other$xbrlContextId = other.getXbrlContextId();
        if (this$xbrlContextId == null ? other$xbrlContextId != null : !this$xbrlContextId.equals(other$xbrlContextId)) {
            return false;
        }
        PeriodType this$periodType = this.getPeriodType();
        PeriodType other$periodType = other.getPeriodType();
        if (this$periodType == null ? other$periodType != null : !this$periodType.equals(other$periodType)) {
            return false;
        }
        Date this$instantDate = this.getInstantDate();
        Date other$instantDate = other.getInstantDate();
        if (this$instantDate == null ? other$instantDate != null : !((Object)this$instantDate).equals(other$instantDate)) {
            return false;
        }
        Date this$startDate = this.getStartDate();
        Date other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Date this$endDate = this.getEndDate();
        Date other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        String this$segment = this.getSegment();
        String other$segment = other.getSegment();
        if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
            return false;
        }
        String this$scenario = this.getScenario();
        String other$scenario = other.getScenario();
        if (this$scenario == null ? other$scenario != null : !this$scenario.equals(other$scenario)) {
            return false;
        }
        List this$xbrlContextDimensions = this.getXbrlContextDimensions();
        List other$xbrlContextDimensions = other.getXbrlContextDimensions();
        if (this$xbrlContextDimensions == null ? other$xbrlContextDimensions != null : !((Object)this$xbrlContextDimensions).equals(other$xbrlContextDimensions)) {
            return false;
        }
        String this$dimensions = this.getDimensions();
        String other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !this$dimensions.equals(other$dimensions)) {
            return false;
        }
        String this$dimensionsHash = this.getDimensionsHash();
        String other$dimensionsHash = other.getDimensionsHash();
        if (this$dimensionsHash == null ? other$dimensionsHash != null : !this$dimensionsHash.equals(other$dimensionsHash)) {
            return false;
        }
        String this$dimensionsOpenHash = this.getDimensionsOpenHash();
        String other$dimensionsOpenHash = other.getDimensionsOpenHash();
        if (this$dimensionsOpenHash == null ? other$dimensionsOpenHash != null : !this$dimensionsOpenHash.equals(other$dimensionsOpenHash)) {
            return false;
        }
        if (!Arrays.equals(this.getAspectDataJson(), other.getAspectDataJson())) {
            return false;
        }
        List this$aspectDataList = this.getAspectDataList();
        List other$aspectDataList = other.getAspectDataList();
        return !(this$aspectDataList == null ? other$aspectDataList != null : !((Object)this$aspectDataList).equals(other$aspectDataList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XbrlContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XbrlContextId $xbrlContextId = this.getXbrlContextId();
        result = result * 59 + ($xbrlContextId == null ? 43 : $xbrlContextId.hashCode());
        PeriodType $periodType = this.getPeriodType();
        result = result * 59 + ($periodType == null ? 43 : $periodType.hashCode());
        Date $instantDate = this.getInstantDate();
        result = result * 59 + ($instantDate == null ? 43 : ((Object)$instantDate).hashCode());
        Date $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Date $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        String $segment = this.getSegment();
        result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
        String $scenario = this.getScenario();
        result = result * 59 + ($scenario == null ? 43 : $scenario.hashCode());
        List $xbrlContextDimensions = this.getXbrlContextDimensions();
        result = result * 59 + ($xbrlContextDimensions == null ? 43 : ((Object)$xbrlContextDimensions).hashCode());
        String $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : $dimensions.hashCode());
        String $dimensionsHash = this.getDimensionsHash();
        result = result * 59 + ($dimensionsHash == null ? 43 : $dimensionsHash.hashCode());
        String $dimensionsOpenHash = this.getDimensionsOpenHash();
        result = result * 59 + ($dimensionsOpenHash == null ? 43 : $dimensionsOpenHash.hashCode());
        result = result * 59 + Arrays.hashCode(this.getAspectDataJson());
        List $aspectDataList = this.getAspectDataList();
        result = result * 59 + ($aspectDataList == null ? 43 : ((Object)$aspectDataList).hashCode());
        return result;
    }

    public String toString() {
        return "XbrlContext(xbrlContextId=" + this.getXbrlContextId() + ", periodType=" + this.getPeriodType() + ", instantDate=" + this.getInstantDate() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", identifier=" + this.getIdentifier() + ", scheme=" + this.getScheme() + ", segment=" + this.getSegment() + ", scenario=" + this.getScenario() + ", xbrlContextDimensions=" + this.getXbrlContextDimensions() + ", dimensions=" + this.getDimensions() + ", dimensionsHash=" + this.getDimensionsHash() + ", dimensionsOpenHash=" + this.getDimensionsOpenHash() + ", aspectDataJson=" + Arrays.toString(this.getAspectDataJson()) + ", aspectDataList=" + this.getAspectDataList() + ")";
    }

    public XbrlContext() {
    }
}

