/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model.tableLinkBase;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TableLinkBaseStructure {
    private AxisMemberHierarchy xAxis;
    private AxisMemberHierarchy yAxis;
    private AxisMemberHierarchy zAxis;
    private Set<String> periods;
    private String periodAxis;
    private Map<String, String> dimensionsDefault = new HashMap();
    private Map<String, List<EnumerateItem>> enumerations = new HashMap();
    private String label;
    private String name;
    private Set<String> dimensionsOfAspectNodes;
    private Map<String, String> dimensionPattens = new HashMap();

    public AxisMemberHierarchy findAxis(TableAxis tableAxis) {
        switch (1.$SwitchMap$ru$cbr$xbrl$converter$model$tableLinkBase$TableLinkBaseStructure$TableAxis[tableAxis.ordinal()]) {
            case 1: {
                return this.xAxis;
            }
            case 2: {
                return this.yAxis;
            }
            case 3: {
                return this.zAxis;
            }
        }
        return null;
    }

    public void iterateAllAspects(Consumer<List<AspectData>> aspectDataListConsumer) {
        TableLinkBaseStructure tableLinkBaseStructure = this;
        tableLinkBaseStructure.getZAxis().iterate((zAxisMemberHierarchy, zParents) -> tableLinkBaseStructure.getYAxis().iterate((yAxisMemberHierarchy, yParents) -> tableLinkBaseStructure.getXAxis().iterate((xAxisMemberHierarchy, xParents) -> {
            if (!(zParents.isEmpty() || yParents.isEmpty() || xParents.isEmpty())) {
                ArrayList fullAspectDataList = new ArrayList();
                this.addAspects(fullAspectDataList, zAxisMemberHierarchy.getAspectDataList(), zParents);
                this.addAspects(fullAspectDataList, yAxisMemberHierarchy.getAspectDataList(), yParents);
                this.addAspects(fullAspectDataList, xAxisMemberHierarchy.getAspectDataList(), xParents);
                aspectDataListConsumer.accept(fullAspectDataList);
            }
        })));
    }

    public void iterateYAxisMemberHierarchy(Consumer<AxisMemberHierarchy> axisMemberHierarchyConsumer) {
        TableLinkBaseStructure tableLinkBaseStructure = this;
        tableLinkBaseStructure.getYAxis().iterate((yAxisMemberHierarchy, yParents) -> axisMemberHierarchyConsumer.accept((AxisMemberHierarchy)yAxisMemberHierarchy));
    }

    public void iterateAllAxisMemberHierarchy(Consumer<AxisMemberHierarchy> axisMemberHierarchyConsumer) {
        TableLinkBaseStructure tableLinkBaseStructure = this;
        tableLinkBaseStructure.getZAxis().iterate((zAxisMemberHierarchy, zParents) -> axisMemberHierarchyConsumer.accept((AxisMemberHierarchy)zAxisMemberHierarchy));
        tableLinkBaseStructure.getYAxis().iterate((yAxisMemberHierarchy, yParents) -> axisMemberHierarchyConsumer.accept((AxisMemberHierarchy)yAxisMemberHierarchy));
        tableLinkBaseStructure.getXAxis().iterate((xAxisMemberHierarchy, xParents) -> axisMemberHierarchyConsumer.accept((AxisMemberHierarchy)xAxisMemberHierarchy));
    }

    private void addAspects(List<AspectData> result, List<AspectData> aspectDataList, List<AxisMemberHierarchy> parents) {
        result.addAll(aspectDataList);
        parents.forEach(p -> result.addAll(p.getAspectDataList()));
    }

    public Set<String> findDimensionsOfAspectNodes() {
        HashSet<String> aspectNodesDimensions = new HashSet<String>();
        aspectNodesDimensions.addAll(this.getZAxis().findDimensionsOfAspectNodes());
        aspectNodesDimensions.addAll(this.getYAxis().findDimensionsOfAspectNodes());
        aspectNodesDimensions.addAll(this.getXAxis().findDimensionsOfAspectNodes());
        return aspectNodesDimensions;
    }

    public boolean containsAspectNodes() {
        return !this.findDimensionsOfAspectNodes().isEmpty();
    }

    public Map<String, String> findDimensionPatterns() {
        HashMap<String, String> aspectNodesDimensions = new HashMap<String, String>();
        aspectNodesDimensions.putAll(this.getZAxis().findDimensionPatterns());
        aspectNodesDimensions.putAll(this.getYAxis().findDimensionPatterns());
        aspectNodesDimensions.putAll(this.getXAxis().findDimensionPatterns());
        return aspectNodesDimensions;
    }

    @JsonIgnore
    public Set<AspectData> findTypedDimensions() {
        HashSet<AspectData> typedDimensions = new HashSet<AspectData>();
        this.fillTypedDimensions(this.getXAxis(), typedDimensions);
        this.fillTypedDimensions(this.getYAxis(), typedDimensions);
        this.fillTypedDimensions(this.getZAxis(), typedDimensions);
        return typedDimensions;
    }

    private void fillTypedDimensions(AxisMemberHierarchy xAxis, Set<AspectData> typedDimensions) {
        for (AxisMemberHierarchy axisMemberHierarchy : xAxis.getAxisMemberHierarchyList()) {
            for (AspectData aspectData : axisMemberHierarchy.getAspectDataList()) {
                if (aspectData.getType() != AspectType.DIMENSION || aspectData.getDimensionType() != DimensionType.TYPED_MEMBER) continue;
                typedDimensions.add(aspectData);
            }
            this.fillTypedDimensions(axisMemberHierarchy, typedDimensions);
        }
    }

    @JsonIgnore
    public Set<String> getDimensionsSet() {
        HashSet<String> stringHashSet = new HashSet<String>();
        this.iterateAllAspects(a -> a.forEach(aspectData -> {
            if (aspectData.getType().equals((Object)AspectType.DIMENSION)) {
                stringHashSet.add(aspectData.getAspect());
            }
        }));
        return stringHashSet;
    }

    public AxisMemberHierarchy getXAxis() {
        return this.xAxis;
    }

    public AxisMemberHierarchy getYAxis() {
        return this.yAxis;
    }

    public AxisMemberHierarchy getZAxis() {
        return this.zAxis;
    }

    public Set<String> getPeriods() {
        return this.periods;
    }

    public String getPeriodAxis() {
        return this.periodAxis;
    }

    public Map<String, String> getDimensionsDefault() {
        return this.dimensionsDefault;
    }

    public Map<String, List<EnumerateItem>> getEnumerations() {
        return this.enumerations;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getDimensionsOfAspectNodes() {
        return this.dimensionsOfAspectNodes;
    }

    public Map<String, String> getDimensionPattens() {
        return this.dimensionPattens;
    }

    public void setXAxis(AxisMemberHierarchy xAxis) {
        this.xAxis = xAxis;
    }

    public void setYAxis(AxisMemberHierarchy yAxis) {
        this.yAxis = yAxis;
    }

    public void setZAxis(AxisMemberHierarchy zAxis) {
        this.zAxis = zAxis;
    }

    public void setPeriods(Set<String> periods) {
        this.periods = periods;
    }

    public void setPeriodAxis(String periodAxis) {
        this.periodAxis = periodAxis;
    }

    public void setDimensionsDefault(Map<String, String> dimensionsDefault) {
        this.dimensionsDefault = dimensionsDefault;
    }

    public void setEnumerations(Map<String, List<EnumerateItem>> enumerations) {
        this.enumerations = enumerations;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDimensionsOfAspectNodes(Set<String> dimensionsOfAspectNodes) {
        this.dimensionsOfAspectNodes = dimensionsOfAspectNodes;
    }

    public void setDimensionPattens(Map<String, String> dimensionPattens) {
        this.dimensionPattens = dimensionPattens;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableLinkBaseStructure)) {
            return false;
        }
        TableLinkBaseStructure other = (TableLinkBaseStructure)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        AxisMemberHierarchy this$xAxis = this.getXAxis();
        AxisMemberHierarchy other$xAxis = other.getXAxis();
        if (this$xAxis == null ? other$xAxis != null : !this$xAxis.equals(other$xAxis)) {
            return false;
        }
        AxisMemberHierarchy this$yAxis = this.getYAxis();
        AxisMemberHierarchy other$yAxis = other.getYAxis();
        if (this$yAxis == null ? other$yAxis != null : !this$yAxis.equals(other$yAxis)) {
            return false;
        }
        AxisMemberHierarchy this$zAxis = this.getZAxis();
        AxisMemberHierarchy other$zAxis = other.getZAxis();
        if (this$zAxis == null ? other$zAxis != null : !this$zAxis.equals(other$zAxis)) {
            return false;
        }
        Set this$periods = this.getPeriods();
        Set other$periods = other.getPeriods();
        if (this$periods == null ? other$periods != null : !((Object)this$periods).equals(other$periods)) {
            return false;
        }
        String this$periodAxis = this.getPeriodAxis();
        String other$periodAxis = other.getPeriodAxis();
        if (this$periodAxis == null ? other$periodAxis != null : !this$periodAxis.equals(other$periodAxis)) {
            return false;
        }
        Map this$dimensionsDefault = this.getDimensionsDefault();
        Map other$dimensionsDefault = other.getDimensionsDefault();
        if (this$dimensionsDefault == null ? other$dimensionsDefault != null : !((Object)this$dimensionsDefault).equals(other$dimensionsDefault)) {
            return false;
        }
        Map this$enumerations = this.getEnumerations();
        Map other$enumerations = other.getEnumerations();
        if (this$enumerations == null ? other$enumerations != null : !((Object)this$enumerations).equals(other$enumerations)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Set this$dimensionsOfAspectNodes = this.getDimensionsOfAspectNodes();
        Set other$dimensionsOfAspectNodes = other.getDimensionsOfAspectNodes();
        if (this$dimensionsOfAspectNodes == null ? other$dimensionsOfAspectNodes != null : !((Object)this$dimensionsOfAspectNodes).equals(other$dimensionsOfAspectNodes)) {
            return false;
        }
        Map this$dimensionPattens = this.getDimensionPattens();
        Map other$dimensionPattens = other.getDimensionPattens();
        return !(this$dimensionPattens == null ? other$dimensionPattens != null : !((Object)this$dimensionPattens).equals(other$dimensionPattens));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableLinkBaseStructure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AxisMemberHierarchy $xAxis = this.getXAxis();
        result = result * 59 + ($xAxis == null ? 43 : $xAxis.hashCode());
        AxisMemberHierarchy $yAxis = this.getYAxis();
        result = result * 59 + ($yAxis == null ? 43 : $yAxis.hashCode());
        AxisMemberHierarchy $zAxis = this.getZAxis();
        result = result * 59 + ($zAxis == null ? 43 : $zAxis.hashCode());
        Set $periods = this.getPeriods();
        result = result * 59 + ($periods == null ? 43 : ((Object)$periods).hashCode());
        String $periodAxis = this.getPeriodAxis();
        result = result * 59 + ($periodAxis == null ? 43 : $periodAxis.hashCode());
        Map $dimensionsDefault = this.getDimensionsDefault();
        result = result * 59 + ($dimensionsDefault == null ? 43 : ((Object)$dimensionsDefault).hashCode());
        Map $enumerations = this.getEnumerations();
        result = result * 59 + ($enumerations == null ? 43 : ((Object)$enumerations).hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Set $dimensionsOfAspectNodes = this.getDimensionsOfAspectNodes();
        result = result * 59 + ($dimensionsOfAspectNodes == null ? 43 : ((Object)$dimensionsOfAspectNodes).hashCode());
        Map $dimensionPattens = this.getDimensionPattens();
        result = result * 59 + ($dimensionPattens == null ? 43 : ((Object)$dimensionPattens).hashCode());
        return result;
    }

    public String toString() {
        return "TableLinkBaseStructure(xAxis=" + this.getXAxis() + ", yAxis=" + this.getYAxis() + ", zAxis=" + this.getZAxis() + ", periods=" + this.getPeriods() + ", periodAxis=" + this.getPeriodAxis() + ", dimensionsDefault=" + this.getDimensionsDefault() + ", enumerations=" + this.getEnumerations() + ", label=" + this.getLabel() + ", name=" + this.getName() + ", dimensionsOfAspectNodes=" + this.getDimensionsOfAspectNodes() + ", dimensionPattens=" + this.getDimensionPattens() + ")";
    }
}

