/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model.presentation_definition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;

public class StructuredViewValue {
    private final String value;
    @JsonIgnore
    private final Map<String, String> memberValues;
    @JsonIgnore
    private final List<AspectData> dimensions;
    @JsonIgnore
    private final AspectData period;
    @JsonIgnore
    private final AspectData concept;
    private final String precision;
    private final String decimals;
    private final String unitId;
    private final Integer footnoteCount;

    public StructuredViewValue(String value, Map<String, String> memberValues, List<AspectData> dimensions, AspectData period, AspectData concept, AspectCellData aspectCellData) {
        this.value = value;
        this.memberValues = memberValues;
        this.dimensions = dimensions;
        this.period = period;
        this.concept = concept;
        this.precision = aspectCellData.getPrecision();
        this.decimals = aspectCellData.getDecimals();
        this.unitId = aspectCellData.getUnitId();
        this.footnoteCount = aspectCellData.getFootnoteCount();
    }

    public String getXHash() {
        if (CollectionUtils.isEmpty((Collection)this.dimensions)) {
            return DigestUtils.md5Hex((String)this.period.getAspectValue());
        }
        this.dimensions.sort(Comparator.comparing(AspectData::getAspect));
        List collect = this.dimensions.stream().map(a -> String.format("%s%s", a.getAspect(), this.memberValues.containsKey(a.getAspectValue()) ? this.memberValues.get(a.getAspectValue()) : a.getAspectValue())).collect(Collectors.toList());
        return DigestUtils.md5Hex((String)String.join((CharSequence)"", collect));
    }

    public String getYHash() {
        return DigestUtils.md5Hex((String)(this.period.getAspectValue() + this.concept.getAspectValue()));
    }

    public String getValue() {
        return this.value;
    }

    public Map<String, String> getMemberValues() {
        return this.memberValues;
    }

    public List<AspectData> getDimensions() {
        return this.dimensions;
    }

    public AspectData getPeriod() {
        return this.period;
    }

    public AspectData getConcept() {
        return this.concept;
    }

    public String getPrecision() {
        return this.precision;
    }

    public String getDecimals() {
        return this.decimals;
    }

    public String getUnitId() {
        return this.unitId;
    }

    public Integer getFootnoteCount() {
        return this.footnoteCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructuredViewValue)) {
            return false;
        }
        StructuredViewValue other = (StructuredViewValue)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Map this$memberValues = this.getMemberValues();
        Map other$memberValues = other.getMemberValues();
        if (this$memberValues == null ? other$memberValues != null : !((Object)this$memberValues).equals(other$memberValues)) {
            return false;
        }
        List this$dimensions = this.getDimensions();
        List other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
            return false;
        }
        AspectData this$period = this.getPeriod();
        AspectData other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !this$period.equals(other$period)) {
            return false;
        }
        AspectData this$concept = this.getConcept();
        AspectData other$concept = other.getConcept();
        if (this$concept == null ? other$concept != null : !this$concept.equals(other$concept)) {
            return false;
        }
        String this$precision = this.getPrecision();
        String other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !this$precision.equals(other$precision)) {
            return false;
        }
        String this$decimals = this.getDecimals();
        String other$decimals = other.getDecimals();
        if (this$decimals == null ? other$decimals != null : !this$decimals.equals(other$decimals)) {
            return false;
        }
        String this$unitId = this.getUnitId();
        String other$unitId = other.getUnitId();
        if (this$unitId == null ? other$unitId != null : !this$unitId.equals(other$unitId)) {
            return false;
        }
        Integer this$footnoteCount = this.getFootnoteCount();
        Integer other$footnoteCount = other.getFootnoteCount();
        return !(this$footnoteCount == null ? other$footnoteCount != null : !((Object)this$footnoteCount).equals(other$footnoteCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StructuredViewValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Map $memberValues = this.getMemberValues();
        result = result * 59 + ($memberValues == null ? 43 : ((Object)$memberValues).hashCode());
        List $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        AspectData $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : $period.hashCode());
        AspectData $concept = this.getConcept();
        result = result * 59 + ($concept == null ? 43 : $concept.hashCode());
        String $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : $precision.hashCode());
        String $decimals = this.getDecimals();
        result = result * 59 + ($decimals == null ? 43 : $decimals.hashCode());
        String $unitId = this.getUnitId();
        result = result * 59 + ($unitId == null ? 43 : $unitId.hashCode());
        Integer $footnoteCount = this.getFootnoteCount();
        result = result * 59 + ($footnoteCount == null ? 43 : ((Object)$footnoteCount).hashCode());
        return result;
    }

    public String toString() {
        return "StructuredViewValue(value=" + this.getValue() + ", memberValues=" + this.getMemberValues() + ", dimensions=" + this.getDimensions() + ", period=" + this.getPeriod() + ", concept=" + this.getConcept() + ", precision=" + this.getPrecision() + ", decimals=" + this.getDecimals() + ", unitId=" + this.getUnitId() + ", footnoteCount=" + this.getFootnoteCount() + ")";
    }
}

