/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model.presentation_definition;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ConceptGroup {
    public static Predicate<ConceptGroup> hasOnlyAbstractConcept = ConceptGroup::hasOnlyAbstractConcept;
    private final List<String> abstractConceptsList;
    private List<Pair<String, String>> concepts = new LinkedList();
    private Pair<String, String> abstractConcept;

    public ConceptGroup(List<String> abstractConcepts) {
        this.abstractConceptsList = abstractConcepts;
    }

    public void add(Pair<String, String> concept) {
        if (concept == null) {
            return;
        }
        if (this.abstractConceptsList.contains(concept.getKey())) {
            this.abstractConcept = concept;
        } else {
            this.concepts.add(concept);
        }
    }

    private boolean hasOnlyAbstractConcept() {
        return this.abstractConcept != null && CollectionUtils.isEmpty((Collection)this.concepts);
    }

    public List<Pair<String, String>> toList() {
        LinkedList<Pair<String, String>> result = new LinkedList<Pair<String, String>>();
        if (this.abstractConcept != null) {
            result.add(this.abstractConcept);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.concepts)) {
            result.addAll(this.concepts);
        }
        return result;
    }

    public List<String> getAbstractConceptsList() {
        return this.abstractConceptsList;
    }

    public List<Pair<String, String>> getConcepts() {
        return this.concepts;
    }

    public Pair<String, String> getAbstractConcept() {
        return this.abstractConcept;
    }

    public void setConcepts(List<Pair<String, String>> concepts) {
        this.concepts = concepts;
    }

    public void setAbstractConcept(Pair<String, String> abstractConcept) {
        this.abstractConcept = abstractConcept;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConceptGroup)) {
            return false;
        }
        ConceptGroup other = (ConceptGroup)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$abstractConceptsList = this.getAbstractConceptsList();
        List other$abstractConceptsList = other.getAbstractConceptsList();
        if (this$abstractConceptsList == null ? other$abstractConceptsList != null : !((Object)this$abstractConceptsList).equals(other$abstractConceptsList)) {
            return false;
        }
        List this$concepts = this.getConcepts();
        List other$concepts = other.getConcepts();
        if (this$concepts == null ? other$concepts != null : !((Object)this$concepts).equals(other$concepts)) {
            return false;
        }
        Pair this$abstractConcept = this.getAbstractConcept();
        Pair other$abstractConcept = other.getAbstractConcept();
        return !(this$abstractConcept == null ? other$abstractConcept != null : !this$abstractConcept.equals(other$abstractConcept));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConceptGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $abstractConceptsList = this.getAbstractConceptsList();
        result = result * 59 + ($abstractConceptsList == null ? 43 : ((Object)$abstractConceptsList).hashCode());
        List $concepts = this.getConcepts();
        result = result * 59 + ($concepts == null ? 43 : ((Object)$concepts).hashCode());
        Pair $abstractConcept = this.getAbstractConcept();
        result = result * 59 + ($abstractConcept == null ? 43 : $abstractConcept.hashCode());
        return result;
    }

    public String toString() {
        return "ConceptGroup(abstractConceptsList=" + this.getAbstractConceptsList() + ", concepts=" + this.getConcepts() + ", abstractConcept=" + this.getAbstractConcept() + ")";
    }
}

