/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlRolePeriod;
import ru.cbr.xbrl.converter.model.tableLinkBase.AspectNodeMember;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlRoleDimension;

@Entity
@Table(indexes={@Index(name="idx_systemid", columnList="systemId")})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XbrlReportRole {
    @Id
    @GeneratedValue
    private Long id;
    @Column(length=4096)
    private String title;
    private String systemId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(foreignKey=@ForeignKey(name="FK_XBRL_REPORT_ROLE"))
    @JsonBackReference
    @XmlTransient
    private XbrlReport xbrlReport;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="xbrlReportRole")
    private List<XbrlRolePeriod> periodList = new ArrayList();
    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY, mappedBy="xbrlReportRole", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<XbrlRoleDimension> xbrlRoleDimensionList = new ArrayList();
    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY, mappedBy="xbrlReportRole", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AspectNodeMember> aspectNodeMembers = new ArrayList();
    @Lob
    private String json;
    @Lob
    private String staticStructureJson;
    @Lob
    private String roleCellsJson;
    @JsonProperty(value="filterAxisList")
    @Transient
    public List<FilterAxis> filterAxisList = new ArrayList();

    public XbrlReportRole() {
    }

    public XbrlReportRole(Long id) {
        this.id = id;
    }

    public String getCompareString() {
        return this.getTitle() + " " + this.getSystemId();
    }

    public TableLinkBaseStructure unpackTableLinkBaseStructure() {
        ObjectMapper mapper = new ObjectMapper();
        TableLinkBaseStructure tableLinkBaseStructure = null;
        try {
            tableLinkBaseStructure = (TableLinkBaseStructure)mapper.readValue(this.getStaticStructureJson(), TableLinkBaseStructure.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tableLinkBaseStructure;
    }

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public XbrlReport getXbrlReport() {
        return this.xbrlReport;
    }

    public List<XbrlRolePeriod> getPeriodList() {
        return this.periodList;
    }

    public List<XbrlRoleDimension> getXbrlRoleDimensionList() {
        return this.xbrlRoleDimensionList;
    }

    public List<AspectNodeMember> getAspectNodeMembers() {
        return this.aspectNodeMembers;
    }

    public String getJson() {
        return this.json;
    }

    public String getStaticStructureJson() {
        return this.staticStructureJson;
    }

    public String getRoleCellsJson() {
        return this.roleCellsJson;
    }

    public List<FilterAxis> getFilterAxisList() {
        return this.filterAxisList;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setXbrlReport(XbrlReport xbrlReport) {
        this.xbrlReport = xbrlReport;
    }

    public void setPeriodList(List<XbrlRolePeriod> periodList) {
        this.periodList = periodList;
    }

    public void setXbrlRoleDimensionList(List<XbrlRoleDimension> xbrlRoleDimensionList) {
        this.xbrlRoleDimensionList = xbrlRoleDimensionList;
    }

    public void setAspectNodeMembers(List<AspectNodeMember> aspectNodeMembers) {
        this.aspectNodeMembers = aspectNodeMembers;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public void setStaticStructureJson(String staticStructureJson) {
        this.staticStructureJson = staticStructureJson;
    }

    public void setRoleCellsJson(String roleCellsJson) {
        this.roleCellsJson = roleCellsJson;
    }

    public void setFilterAxisList(List<FilterAxis> filterAxisList) {
        this.filterAxisList = filterAxisList;
    }

    public String toString() {
        return "XbrlReportRole(id=" + this.getId() + ", title=" + this.getTitle() + ", systemId=" + this.getSystemId() + ", periodList=" + this.getPeriodList() + ", xbrlRoleDimensionList=" + this.getXbrlRoleDimensionList() + ", aspectNodeMembers=" + this.getAspectNodeMembers() + ", json=" + this.getJson() + ", staticStructureJson=" + this.getStaticStructureJson() + ", roleCellsJson=" + this.getRoleCellsJson() + ", filterAxisList=" + this.getFilterAxisList() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XbrlReportRole)) {
            return false;
        }
        XbrlReportRole other = (XbrlReportRole)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$systemId = this.getSystemId();
        String other$systemId = other.getSystemId();
        if (this$systemId == null ? other$systemId != null : !this$systemId.equals(other$systemId)) {
            return false;
        }
        XbrlReport this$xbrlReport = this.getXbrlReport();
        XbrlReport other$xbrlReport = other.getXbrlReport();
        if (this$xbrlReport == null ? other$xbrlReport != null : !this$xbrlReport.equals(other$xbrlReport)) {
            return false;
        }
        List this$periodList = this.getPeriodList();
        List other$periodList = other.getPeriodList();
        if (this$periodList == null ? other$periodList != null : !((Object)this$periodList).equals(other$periodList)) {
            return false;
        }
        List this$xbrlRoleDimensionList = this.getXbrlRoleDimensionList();
        List other$xbrlRoleDimensionList = other.getXbrlRoleDimensionList();
        if (this$xbrlRoleDimensionList == null ? other$xbrlRoleDimensionList != null : !((Object)this$xbrlRoleDimensionList).equals(other$xbrlRoleDimensionList)) {
            return false;
        }
        List this$aspectNodeMembers = this.getAspectNodeMembers();
        List other$aspectNodeMembers = other.getAspectNodeMembers();
        if (this$aspectNodeMembers == null ? other$aspectNodeMembers != null : !((Object)this$aspectNodeMembers).equals(other$aspectNodeMembers)) {
            return false;
        }
        String this$json = this.getJson();
        String other$json = other.getJson();
        if (this$json == null ? other$json != null : !this$json.equals(other$json)) {
            return false;
        }
        String this$staticStructureJson = this.getStaticStructureJson();
        String other$staticStructureJson = other.getStaticStructureJson();
        if (this$staticStructureJson == null ? other$staticStructureJson != null : !this$staticStructureJson.equals(other$staticStructureJson)) {
            return false;
        }
        String this$roleCellsJson = this.getRoleCellsJson();
        String other$roleCellsJson = other.getRoleCellsJson();
        if (this$roleCellsJson == null ? other$roleCellsJson != null : !this$roleCellsJson.equals(other$roleCellsJson)) {
            return false;
        }
        List this$filterAxisList = this.getFilterAxisList();
        List other$filterAxisList = other.getFilterAxisList();
        return !(this$filterAxisList == null ? other$filterAxisList != null : !((Object)this$filterAxisList).equals(other$filterAxisList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XbrlReportRole;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $systemId = this.getSystemId();
        result = result * 59 + ($systemId == null ? 43 : $systemId.hashCode());
        XbrlReport $xbrlReport = this.getXbrlReport();
        result = result * 59 + ($xbrlReport == null ? 43 : $xbrlReport.hashCode());
        List $periodList = this.getPeriodList();
        result = result * 59 + ($periodList == null ? 43 : ((Object)$periodList).hashCode());
        List $xbrlRoleDimensionList = this.getXbrlRoleDimensionList();
        result = result * 59 + ($xbrlRoleDimensionList == null ? 43 : ((Object)$xbrlRoleDimensionList).hashCode());
        List $aspectNodeMembers = this.getAspectNodeMembers();
        result = result * 59 + ($aspectNodeMembers == null ? 43 : ((Object)$aspectNodeMembers).hashCode());
        String $json = this.getJson();
        result = result * 59 + ($json == null ? 43 : $json.hashCode());
        String $staticStructureJson = this.getStaticStructureJson();
        result = result * 59 + ($staticStructureJson == null ? 43 : $staticStructureJson.hashCode());
        String $roleCellsJson = this.getRoleCellsJson();
        result = result * 59 + ($roleCellsJson == null ? 43 : $roleCellsJson.hashCode());
        List $filterAxisList = this.getFilterAxisList();
        result = result * 59 + ($filterAxisList == null ? 43 : ((Object)$filterAxisList).hashCode());
        return result;
    }
}

