/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller.import_export;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.cbr.xbrl.converter.arelle.ArelleOutputParser;
import ru.cbr.xbrl.converter.controller.import_export.ExportXslxStruct;
import ru.cbr.xbrl.converter.controller.import_export.ImportXlsxResponse;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.CommandExecutionException;
import ru.cbr.xbrl.converter.exception.ContextCsvDuplicateException;
import ru.cbr.xbrl.converter.exception.CsvDataNotValidException;
import ru.cbr.xbrl.converter.exception.CsvValidateHeaderIncorrectOrderException;
import ru.cbr.xbrl.converter.exception.CsvValidateHeaderNotContainFieldsException;
import ru.cbr.xbrl.converter.exception.CsvValidateHeadersException;
import ru.cbr.xbrl.converter.exception.FileAlreadyExistsException;
import ru.cbr.xbrl.converter.exception.IncompatibleSchemaRefException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.RewritableFileOpenException;
import ru.cbr.xbrl.converter.exception.SchemaValidationException;
import ru.cbr.xbrl.converter.exception.TaxonomyNotFoundException;
import ru.cbr.xbrl.converter.exception.UnitCsvDuplicateException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.exception.WriteFileException;
import ru.cbr.xbrl.converter.exception.XbrlDataNotValidException;
import ru.cbr.xbrl.converter.exception.XbrlExportException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.exception.XlsxDataNotValidRuntimeException;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.import_export.ExportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.ImportXbrlService;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvFileSet;

@RestController
@RequestMapping(value={"xbrl-import-export"})
public class ImportExportController {
    private static final Logger log = LoggerFactory.getLogger(ImportExportController.class);
    public static final String HTM_EXTENSION = "htm";
    public static final String HTML_EXTENSION = "html";
    @Autowired
    private ImportXbrlService importXbrlService;
    @Autowired
    private ExportXbrlService exportXbrlService;
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private XbrlReportService xbrlReportService;

    @PostMapping(value={"/import-csv"})
    public XbrlPackage importCsv(@RequestParam(value="xbrlReportId") Long xbrlReportId, @RequestParam(value="contextsCsvPath") String contextsCsvPath, @RequestParam(value="unitsCsvPath") String unitsCsvPath, @RequestParam(value="valuesCsvPath") String valuesCsvPath, @RequestParam(value="footnotesCsvPath") String footnotesCsvPath, @RequestParam(value="isOverwriteData") Boolean isOverwriteData, @RequestParam(value="isCreateLog") Boolean isCreateLog) throws XbrlImportException, IOException, NotFoundException, CancelledException, TaxonomyNotFoundException, XbrlExportException, UploadException, FileAlreadyExistsException, WriteFileException, IncompatibleSchemaRefException, XbrlDataNotValidException, CommandExecutionException, CsvDataNotValidException, ContextCsvDuplicateException, UnitCsvDuplicateException, CsvValidateHeaderNotContainFieldsException, CsvValidateHeadersException, CsvValidateHeaderIncorrectOrderException {
        this.xbrlReportService.setLastActionCanceled(false);
        ArelleOutputParser.setIsLastActionCancelled((Boolean)false);
        CsvFileSet csvFileSet = new CsvFileSet(contextsCsvPath, unitsCsvPath, valuesCsvPath, footnotesCsvPath, CsvFileSet.CsvFileSetDataType.FULL_FILE_NAMES);
        XbrlPackage xbrlPackage = this.importXbrlService.importCsvAndRefreshView(xbrlReportId, csvFileSet, isOverwriteData, isCreateLog);
        if (xbrlPackage.getXbrlReport() != null) {
            xbrlPackage.getXbrlReport().prepareForJson();
        }
        return xbrlPackage;
    }

    @PostMapping(value={"/import-xml"})
    public XbrlPackage importXml(@RequestParam(value="xbrlReportId") Long xbrlReportId, @RequestParam(value="localPath") String localPath, @RequestParam(value="isOverwriteData") Boolean isOverwriteData, @RequestParam(value="isCreateLog") Boolean isCreateLog, @RequestParam(value="isRepairTagselectors", required=false) Boolean isRepairTagselectors) throws XbrlImportException, IOException, NotFoundException, CancelledException, TaxonomyNotFoundException, XbrlExportException, UploadException, FileAlreadyExistsException, WriteFileException, IncompatibleSchemaRefException, CommandExecutionException, XbrlDataNotValidException, CsvDataNotValidException {
        String extension = FilenameUtils.getExtension((String)localPath);
        if (StringUtils.equals((CharSequence)extension, (CharSequence)HTM_EXTENSION) || StringUtils.equals((CharSequence)extension, (CharSequence)HTML_EXTENSION)) {
            localPath = this.importXbrlService.convertIxbrlToXml(localPath);
        }
        XbrlPackage currentPackage = this.xbrlPackageService.findLastPackage();
        EventLog.EventLogType eventType = EventLog.EventLogType.IMPORT_XML;
        XbrlPackage xbrlPackage = this.importXbrlService.importXmlAndRefreshView(xbrlReportId, localPath, isOverwriteData, isCreateLog, isRepairTagselectors, eventType);
        if (xbrlPackage.getXbrlReport() != null) {
            xbrlPackage.getXbrlReport().prepareForJson();
        }
        return xbrlPackage;
    }

    @PostMapping(value={"/import-xlsx"})
    public ImportXlsxResponse importXlsx(@RequestParam(value="xbrlReportId") Long xbrlReportId, @RequestParam(value="localPath") String localPath, @RequestParam(value="isOverwriteData") Boolean isOverwriteData, @RequestParam(value="isCreateLog") Boolean isCreateLog, @RequestParam(value="isAlternativeFormat") Boolean isAlternativeFormat) throws NotFoundException, UploadException, TaxonomyNotFoundException, IOException, CancelledException, XbrlImportException, XbrlExportException, XlsxDataNotValidRuntimeException, SchemaValidationException {
        this.xbrlReportService.setLastActionCanceled(false);
        ImportXlsxResponse xlsxResponse = this.importXbrlService.importXlsxAndRefreshView(xbrlReportId, localPath, isOverwriteData, isCreateLog, isAlternativeFormat);
        if (xlsxResponse.getXbrlPackage().getXbrlReport() != null) {
            xlsxResponse.getXbrlPackage().getXbrlReport().prepareForJson();
        }
        return xlsxResponse;
    }

    @PostMapping(value={"/import-definitionxlsx"})
    public ImportXlsxResponse importDefinitionXlsx(@RequestParam(value="xbrlReportId") Long xbrlReportId, @RequestParam(value="localPath") String localPath, @RequestParam(value="isOverwriteData") Boolean isOverwriteData, @RequestParam(value="isCreateLog") Boolean isCreateLog) throws NotFoundException, XbrlImportException {
        this.xbrlReportService.setLastActionCanceled(false);
        XbrlPackage xbrlPackage = this.importXbrlService.importXlsxDefAndRefreshView(xbrlReportId, localPath, isOverwriteData, isCreateLog);
        if (xbrlPackage.getXbrlReport() != null) {
            xbrlPackage.getXbrlReport().prepareForJson();
        }
        return new ImportXlsxResponse(xbrlPackage, Collections.emptyList());
    }

    @PostMapping(value={"/export-xlsx"})
    public List<String> exportXlsx(@RequestBody ExportXslxStruct exportXslxStruct) throws XbrlImportException, IOException, NotFoundException, CancelledException, TaxonomyNotFoundException, XbrlExportException, UploadException, FileAlreadyExistsException, WriteFileException {
        return this.exportXbrlService.exportXslx(exportXslxStruct);
    }

    @PostMapping(value={"/export-csv"})
    public void exportCsv(@RequestParam(value="xbrlReportId") Long xbrlReportId, @RequestParam(value="contextsCsvPath") String contextsCsvPath, @RequestParam(value="unitsCsvPath") String unitsCsvPath, @RequestParam(value="valuesCsvPath") String valuesCsvPath, @RequestParam(value="footnotesCsvPath") String footnotesCsvPath, @RequestParam(value="isIncludeDataToTemplate") Boolean isIncludeDataToTemplate, @RequestParam(value="allowOverwriteFile") Boolean allowOverwriteFile) throws XbrlExportException, FileAlreadyExistsException, WriteFileException {
        this.xbrlReportService.setLastActionCanceled(false);
        CsvFileSet csvFileSet = new CsvFileSet(contextsCsvPath, unitsCsvPath, valuesCsvPath, footnotesCsvPath, CsvFileSet.CsvFileSetDataType.FULL_FILE_NAMES);
        this.exportXbrlService.exportCsv(xbrlReportId, csvFileSet, isIncludeDataToTemplate, allowOverwriteFile);
    }

    @PostMapping(value={"/export-xml"})
    public void exportXml(@RequestParam(value="xbrlReportId") Long xbrlReportId, @RequestParam(value="localPath") String localPath, @RequestParam(value="isIncludeDataToTemplate") Boolean isIncludeDataToTemplate, @RequestParam(value="allowOverwriteFile") Boolean allowOverwriteFile) throws XbrlExportException, NotFoundException, FileAlreadyExistsException, WriteFileException {
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        String fullPath = FilenameUtils.concat((String)localPath, (String)xbrlPackage.generateXbrlZipName("XBRL", "xml"));
        this.exportXbrlService.exportXbrlXml(xbrlReportId, fullPath, isIncludeDataToTemplate, allowOverwriteFile);
    }

    @PostMapping(value={"/export-definition-xlsx"})
    public void exportDefinitionXlsx(@RequestBody ExportXslxStruct exportXslxStruct) throws IOException, NotFoundException, FileAlreadyExistsException, WriteFileException, RewritableFileOpenException {
        this.exportXbrlService.exportPresentationDefinitionXslx(exportXslxStruct);
    }
}

