/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import ru.cbr.xbrl.converter.model.interaction.ConverterResponseData;
import ru.cbr.xbrl.converter.model.interaction.IntegrationServiceResponse;
import ru.cbr.xbrl.converter.service.import_export.XbrlManagerService;

@RestController
@RequestMapping(value={"xbrl-convert"})
public class XbrlManagerController {
    private static final Logger log = LoggerFactory.getLogger(XbrlManagerController.class);
    private final XbrlManagerService xbrlManagerService;

    @PostMapping(value={"/"})
    public Long createProcess(@RequestParam(value="file") MultipartFile file, @RequestParam(value="taxonomyVersion") String taxonomyVersion, @RequestParam(value="fileName") String fileName) {
        return this.xbrlManagerService.createProcess(file, taxonomyVersion, fileName);
    }

    @GetMapping(value={"process-info/{importProcessId}"})
    public List<IntegrationServiceResponse> processInfo(@PathVariable(value="importProcessId") Long importProcessid) {
        return this.xbrlManagerService.processInfo(importProcessid);
    }

    @GetMapping(value={"download-report/{importProcessId}"})
    public ConverterResponseData downloadReport(@PathVariable(value="importProcessId") Long importProcessId) throws IOException {
        return this.xbrlManagerService.downloadReport(importProcessId);
    }

    @DeleteMapping(value={"delete-process/{importProcessId}"})
    public ResponseEntity deleteProcess(@PathVariable(value="importProcessId") Long importProcessId) throws IOException {
        this.xbrlManagerService.deleteProcess(importProcessId);
        return new ResponseEntity(HttpStatus.OK);
    }

    @ConstructorProperties(value={"xbrlManagerService"})
    public XbrlManagerController(XbrlManagerService xbrlManagerService) {
        this.xbrlManagerService = xbrlManagerService;
    }
}

