/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.controller;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.List;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.cbr.xbrl.converter.exception.FileNameIsEmptyException;
import ru.cbr.xbrl.converter.exception.FileNameIsNotUnique;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.Attachment;
import ru.cbr.xbrl.converter.service.AttachmentService;

@RestController
@RequestMapping(value={"attachment"})
public class AttachmentController {
    private static final Logger log = LoggerFactory.getLogger(AttachmentController.class);
    private final AttachmentService attachmentService;

    @GetMapping
    public List<Attachment> getAttachments() throws NotFoundException {
        return this.attachmentService.getList();
    }

    @PostMapping(value={"/create"})
    public ResponseEntity createAttachment(@RequestParam(value="xbrlPackageId") Long xbrlPackageId, @RequestParam(value="localPath") String localPath, @RequestParam(value="description") String description) throws NotFoundException, IOException, FileNameIsNotUnique, FileNameIsEmptyException {
        this.attachmentService.createAttachment(xbrlPackageId, localPath, description);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/update"})
    public ResponseEntity updateAttachment(@RequestParam(value="attachmentId") Long attachmentId, @RequestParam(value="xbrlPackageId") Long xbrlPackageId, @RequestParam(value="localPath") String localPath, @RequestParam(value="description") String description) throws NotFoundException, IOException, FileNameIsNotUnique, FileNameIsEmptyException {
        this.attachmentService.updateAttachment(xbrlPackageId, attachmentId, localPath, description);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/{xbrlPackageId}/{attachmentId}"})
    public ResponseEntity deleteAttachment(@PathVariable(value="attachmentId") Long attachmentId, @PathVariable(value="xbrlPackageId") Long xbrlPackageId) throws NotFoundException, IOException, NotFound {
        this.attachmentService.deleteAttachment(attachmentId, xbrlPackageId);
        return ResponseEntity.ok().build();
    }

    @ConstructorProperties(value={"attachmentService"})
    public AttachmentController(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }
}

