/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.config;

import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.boot.autoconfigure.web.DefaultErrorAttributes;
import org.springframework.web.context.request.RequestAttributes;
import ru.cbr.xbrl.converter.config.CustomErrorAttributes;

public class CustomErrorAttributes
extends DefaultErrorAttributes {
    public Map<String, Object> getErrorAttributes(RequestAttributes requestAttributes, boolean includeStackTrace) {
        Throwable throwable = this.getError(requestAttributes);
        Map errorAttributes = super.getErrorAttributes(requestAttributes, includeStackTrace);
        errorAttributes.put("supportData", this.getErrorDescription(throwable));
        return errorAttributes;
    }

    private ErrorSupportData getErrorDescription(Throwable throwable) {
        String osVersion = System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
        String softwareVersion = null;
        String message = throwable != null ? throwable.getMessage() : null;
        return new ErrorSupportData(this, softwareVersion, osVersion, message, ExceptionUtils.getStackTrace((Throwable)throwable));
    }
}

