/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle.parse.definition_hypercube.dto;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import ru.cbr.xbrl.converter.arelle.parse.HypercubeType;
import ru.cbr.xbrl.converter.arelle.parse.definition_hypercube.dto.DefinitionHypercubeDimension;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

public class DefinitionHypercube
implements Serializable {
    private HypercubeType hypercubeType;
    private String containerConcept;
    private Integer level;
    private Set<String> concepts = new HashSet();
    private Map<String, DefinitionHypercubeDimension> dimensions = new HashMap();
    private List<DefinitionHypercube> children = new ArrayList();

    public void iterate(Consumer<DefinitionHypercube> consumer) {
        consumer.accept(this);
        this.children.forEach(childCube -> childCube.iterate(consumer));
    }

    public boolean containsDimensions(List<AspectData> dimensionAspects) {
        if (this.dimensions.size() != dimensionAspects.size()) {
            return false;
        }
        return dimensionAspects.stream().filter(AspectData::isDimension).allMatch(aspectData -> {
            String dimension = aspectData.getAspect();
            if (aspectData.getDimensionType().equals((Object)DimensionType.TYPED_MEMBER)) {
                return this.dimensions.containsKey(dimension);
            }
            if (aspectData.getDimensionType().equals((Object)DimensionType.EXPLICIT_MEMBER)) {
                String member = aspectData.getAspectValue();
                return this.dimensions.containsKey(dimension) && ((DefinitionHypercubeDimension)this.dimensions.get(dimension)).getMembers().contains(member);
            }
            throw new IllegalArgumentException("Empty aspectData.dimensionType");
        });
    }

    public boolean containsConcept(String concept) {
        return this.concepts.contains(concept);
    }

    public boolean containsAspectCellData(AspectCellData aspectCellData) {
        AspectData conceptAspect = aspectCellData.getConcept();
        if (conceptAspect == null || StringUtils.isBlank((CharSequence)conceptAspect.getAspectValue())) {
            return false;
        }
        return this.containsConcept(conceptAspect.getAspectValue()) && this.containsDimensions(aspectCellData.getDimensions());
    }

    public boolean containsAspectCellDataRecursively(AspectCellData aspectCellData) {
        AtomicBoolean exists = new AtomicBoolean(false);
        this.iterate(currentHc -> {
            if (currentHc.containsAspectCellData(aspectCellData)) {
                exists.set(currentHc.getHypercubeType() == HypercubeType.ALL);
            }
        });
        return exists.get();
    }

    public void clearUnusedChildrenDimensions() {
        Set allowedDimensions = this.getDimensions().keySet();
        this.iterate(hc -> {
            Iterator it = hc.getDimensions().keySet().iterator();
            while (it.hasNext()) {
                String dimension = (String)it.next();
                if (allowedDimensions.contains(dimension)) continue;
                it.remove();
            }
        });
    }

    public HypercubeType getHypercubeType() {
        return this.hypercubeType;
    }

    public String getContainerConcept() {
        return this.containerConcept;
    }

    public Integer getLevel() {
        return this.level;
    }

    public Set<String> getConcepts() {
        return this.concepts;
    }

    public Map<String, DefinitionHypercubeDimension> getDimensions() {
        return this.dimensions;
    }

    public List<DefinitionHypercube> getChildren() {
        return this.children;
    }

    public void setHypercubeType(HypercubeType hypercubeType) {
        this.hypercubeType = hypercubeType;
    }

    public void setContainerConcept(String containerConcept) {
        this.containerConcept = containerConcept;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public void setConcepts(Set<String> concepts) {
        this.concepts = concepts;
    }

    public void setDimensions(Map<String, DefinitionHypercubeDimension> dimensions) {
        this.dimensions = dimensions;
    }

    public void setChildren(List<DefinitionHypercube> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefinitionHypercube)) {
            return false;
        }
        DefinitionHypercube other = (DefinitionHypercube)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        HypercubeType this$hypercubeType = this.getHypercubeType();
        HypercubeType other$hypercubeType = other.getHypercubeType();
        if (this$hypercubeType == null ? other$hypercubeType != null : !this$hypercubeType.equals(other$hypercubeType)) {
            return false;
        }
        String this$containerConcept = this.getContainerConcept();
        String other$containerConcept = other.getContainerConcept();
        if (this$containerConcept == null ? other$containerConcept != null : !this$containerConcept.equals(other$containerConcept)) {
            return false;
        }
        Integer this$level = this.getLevel();
        Integer other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
            return false;
        }
        Set this$concepts = this.getConcepts();
        Set other$concepts = other.getConcepts();
        if (this$concepts == null ? other$concepts != null : !((Object)this$concepts).equals(other$concepts)) {
            return false;
        }
        Map this$dimensions = this.getDimensions();
        Map other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
            return false;
        }
        List this$children = this.getChildren();
        List other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefinitionHypercube;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HypercubeType $hypercubeType = this.getHypercubeType();
        result = result * 59 + ($hypercubeType == null ? 43 : $hypercubeType.hashCode());
        String $containerConcept = this.getContainerConcept();
        result = result * 59 + ($containerConcept == null ? 43 : $containerConcept.hashCode());
        Integer $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        Set $concepts = this.getConcepts();
        result = result * 59 + ($concepts == null ? 43 : ((Object)$concepts).hashCode());
        Map $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        List $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    @ConstructorProperties(value={"hypercubeType", "containerConcept", "level", "concepts", "dimensions", "children"})
    public DefinitionHypercube(HypercubeType hypercubeType, String containerConcept, Integer level, Set<String> concepts, Map<String, DefinitionHypercubeDimension> dimensions, List<DefinitionHypercube> children) {
        this.hypercubeType = hypercubeType;
        this.containerConcept = containerConcept;
        this.level = level;
        this.concepts = concepts;
        this.dimensions = dimensions;
        this.children = children;
    }

    public DefinitionHypercube() {
    }

    public String toString() {
        return "DefinitionHypercube(hypercubeType=" + this.getHypercubeType() + ", containerConcept=" + this.getContainerConcept() + ", level=" + this.getLevel() + ", concepts=" + this.getConcepts() + ", dimensions=" + this.getDimensions() + ")";
    }
}

