/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle.parse.definition_hypercube;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.SerializationUtils;
import ru.cbr.xbrl.converter.arelle.parse.DimConcept;
import ru.cbr.xbrl.converter.arelle.parse.HypercubeType;
import ru.cbr.xbrl.converter.arelle.parse.definition_hypercube.dto.DefinitionHypercube;
import ru.cbr.xbrl.converter.arelle.parse.definition_hypercube.dto.DefinitionHypercubeDimension;
import ru.cbr.xbrl.converter.utils.MathUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefinitionHypercubeFinder {
    public static List<DefinitionHypercube> findHypercubes(List<DimConcept> dimConcepts) {
        DefinitionHypercube parent = new DefinitionHypercube();
        DefinitionHypercubeFinder.findHypercubes(dimConcepts, (DefinitionHypercube)parent, (int)0);
        return parent.getChildren();
    }

    public static List<DefinitionHypercube> findHypercubesPowerSet(List<DimConcept> dimConcepts, Map<String, String> dimensionsDefault) {
        return DefinitionHypercubeFinder.findHypercubesPowerSet(dimConcepts, (int)0, dimensionsDefault);
    }

    private static List<DefinitionHypercube> findHypercubesPowerSet(List<DimConcept> dimConcepts, int level, Map<String, String> dimensionsDefault) {
        ArrayList<DefinitionHypercube> hypercubesPowerSet = new ArrayList<DefinitionHypercube>();
        List hypercubes = DefinitionHypercubeFinder.findHypercubes(dimConcepts);
        hypercubes.forEach(parentDefinitionHypercube -> {
            Map dimensions = parentDefinitionHypercube.getDimensions();
            ArrayList allDimensions = new ArrayList(dimensions.values());
            List withDefaults = allDimensions.stream().filter(d -> d.getDimensionType() == DimensionType.EXPLICIT_MEMBER).collect(Collectors.toList());
            List withoutDefaults = allDimensions.stream().filter(d -> d.getDimensionType() == DimensionType.TYPED_MEMBER).collect(Collectors.toList());
            Map dimensionsWithoutDefaultValueMap = withoutDefaults.stream().collect(Collectors.toMap(o -> o.getDimension(), Function.identity()));
            Set powerSet = MathUtils.powerSet(new HashSet(withDefaults));
            powerSet.forEach(dims -> {
                DefinitionHypercube definitionHypercube = new DefinitionHypercube();
                List clone = (List)((Object)SerializationUtils.clone(new ArrayList(parentDefinitionHypercube.getChildren())));
                definitionHypercube.setChildren(clone);
                definitionHypercube.setConcepts(parentDefinitionHypercube.getConcepts());
                definitionHypercube.setDimensions(new HashMap());
                definitionHypercube.getDimensions().putAll(dimensionsWithoutDefaultValueMap);
                Map newDimensions = dims.stream().collect(Collectors.toMap(o -> o.getDimension(), Function.identity()));
                definitionHypercube.getDimensions().putAll(newDimensions);
                definitionHypercube.setHypercubeType(parentDefinitionHypercube.getHypercubeType());
                definitionHypercube.setLevel(parentDefinitionHypercube.getLevel());
                definitionHypercube.setContainerConcept(parentDefinitionHypercube.getContainerConcept());
                definitionHypercube.clearUnusedChildrenDimensions();
                hypercubesPowerSet.add(definitionHypercube);
            });
        });
        return hypercubesPowerSet;
    }

    private static void findHypercubes(List<DimConcept> dimConcepts, DefinitionHypercube parentDefinitionHypercube, int level) {
        for (DimConcept childConcept : dimConcepts) {
            if (childConcept.hasHypercube()) {
                HypercubeType hypercubeType = childConcept.findHypercube().getHypercubeTypeByArcrole();
                DefinitionHypercube newDefinitionHypercube = DefinitionHypercubeFinder.addHypercube((DimConcept)childConcept, (DimConcept)childConcept.findHypercube(), (HypercubeType)hypercubeType);
                DefinitionHypercubeFinder.findHypercubes((List)childConcept.getChildren(), (DefinitionHypercube)newDefinitionHypercube, (int)(level + 1));
                parentDefinitionHypercube.getChildren().add(newDefinitionHypercube);
                continue;
            }
            DefinitionHypercubeFinder.findHypercubes((List)childConcept.getChildren(), (DefinitionHypercube)parentDefinitionHypercube, (int)(level + 1));
        }
    }

    private static DefinitionHypercube addHypercube(DimConcept rootHcConcept, DimConcept hcConcept, HypercubeType hypercubeType) {
        Set concepts = DefinitionHypercubeFinder.findConcepts((DimConcept)rootHcConcept);
        Map dimensionsWithMembers = DefinitionHypercubeFinder.findDimensionsAndMembers((DimConcept)hcConcept);
        return new DefinitionHypercube(hypercubeType, hcConcept.getName(), Integer.valueOf(hcConcept.getLevel()), concepts, dimensionsWithMembers, new ArrayList());
    }

    public static Set<String> findConcepts(DimConcept rootConcept) {
        HashSet<String> concepts = new HashSet<String>();
        if (BooleanUtils.isNotTrue((Boolean)rootConcept.getAbstractNode())) {
            concepts.add(rootConcept.getName());
        }
        rootConcept.iterateChildren(dimConcept -> {
            if (BooleanUtils.isNotTrue((Boolean)dimConcept.getAbstractNode())) {
                concepts.add(dimConcept.getName());
            }
        });
        return concepts;
    }

    public static Map<String, DefinitionHypercubeDimension> findDimensionsAndMembers(DimConcept hypercube) {
        List dimNodes = hypercube.getChildren().stream().filter(dimConcept -> dimConcept.getArcrole().equals("hypercube-dimension")).collect(Collectors.toList());
        Map<String, DefinitionHypercubeDimension> membersSetMap = dimNodes.stream().collect(Collectors.toMap(DimConcept::getName, DimConcept::buldHypercubeDimension));
        return membersSetMap;
    }
}

